/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var RTL="false"; //select true if right to left
         var gnYear=2015;//2015
         var gn=32552;//31261 32552
         var screenArr=['driverchampMc','teamChampMc','driversMc'];
         var teamArr=['MER','RBR','WIL','FER','MLA','FOR','TOR','LOT','SAU','MAN'];
         //ASSIGN TEXT ELEMENTS TO ARRAY
         var menuText=[];
         for (var i=0; i<4; i++){
         	menuText[i]= sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("menuTxt").css("pointer-events","none");
         	sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         }
         var menuTxtArr=[];
         var capsText= sym.getSymbol("driversMc").$("detailstxt").css("pointer-events","none");
         sym.getSymbol("driverchampMc").$("driversTxt0").css("pointer-events","none");
         var teamText=[];
         for (var tt=0;tt<teamArr.length;tt++){
         	teamText[tt]=sym.getSymbol("driversMc").$("teamTxt"+tt).css("pointer-events","none");
         }
         //ARRAY FOR CAPTIONS FROM XML			
         var months;
         var champHead=[];
         var gpDate=[];
         var teamTxtArr=[];
         var driverID=[];
         var caps=[];
         for (var t=0;t<teamArr.length; t++){
         	teamTxtArr[t]=[];
         	driverID[t]=[];
         }
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         $.ajax({	
         type: "GET",
         url: "GN32808.xml",
         dataType: "xml",
         success: function(xml) {
         	var headline=$(xml).find('headline').text();
         	var source=$(xml).find('source').text();
         	sym.getSymbol('styleMc').$('headlinetxt').html(headline);
         	sym.getSymbol('styleMc').getSymbol('styleBase').$('sourceTxt').html(source);
         	for (var i=0;i<menuText.length;i++){ //get menu labels
         	 menuTxtArr[i]= $(xml).find('menu'+i).text();
         	 menuText[i].html(menuTxtArr[i]);
         	}
         
         	for (var h=0;h<3;h++){
         		champHead[h]=$(xml).find('head'+h).text();
         	}
         	sym.getSymbol("driverchampMc").$("driversTxt0").html(champHead[1]);
         	caps[0]=$(xml).find('cap0').text(); //fixed text captions
         	caps[1]= $(xml).find('cap1').text();
         	caps[2]= $(xml).find('cap2').text();
         	capsText.html(caps[0]);
         	for (var t=0;t<teamArr.length;t++){	
         		$(xml).find("team"+t).each(function(){
         			var $teams = $(this);
         			for (var m=0; m<12; m++){
         				teamTxtArr[t][m] = $teams.find('teamCap'+m).text(); 	//get details for each team
         			}	
         			for (var d=0;d<2;d++){
         				driverID[t][d] =	$teams.find('driverid'+(d+1)).text(); //get driver ID numbers
         			}
         		});
         	}	
         		getStats('MER',2);
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("mainCar").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("reflection").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("driverHead").attr("src","drivers/"+teamArr[0]+".png");
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("bkwheel").attr("src","cars/"+teamArr[0]+"bk.png");
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("frwheel").attr("src","cars/"+teamArr[0]+"fr.png");
            }
         }); // END XML
         //REFRESH RATE
         var seasonInterval;
         var conInterval;
         var driverInterval;
         var gpInterval;
         var phaseInterval;
         var latestGP;
         var latestGPno;
         // MENU BUTTONS --------------------------------------------	
         menuArray = []; //the array that will hold references to the buttons.
         for (var m = 0; m < 4; m++){
         	var menuBtnSymbols = sym.getSymbol("menuButtons").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         	sym.getSymbol("menuButtons").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
         	var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         	menuBtnElement.off ("click",menuBtnClick);
         	menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
         });
         
         function resetmenu(){
         	sym.getSymbol("menuButtons").$("menuBtn0xtra").stop().animate({'top':'-55px'},400);
         	sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-500px'},400);
         	for (var i=0; i<menuArray.length; i++){
                  menuArray[i].$("menuBg").fadeIn(0);
                 sym.getSymbol(screenArr[1]).$("carPic").animate ({'left':'-800px'}, 0);
         			sym.getSymbol(screenArr[2]).$("carPic").animate ({'left':'-800px'}, 0);
                 sym.$(screenArr[i]).fadeOut(200);       
         		}
         }
         //resetmenu();
         var raceIDno; //number to select live race
         var raceNo =0;
         var clicked;
         function menuBtnClick (e){
         		e.preventDefault();
         		e.stopPropagation();
         		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         		console.log(clicked);
         		if(menuMenu_id==0){//standings
         			if (clicked==0){
         				sym.getSymbol("menuButtons").$("menuBtn0xtra").stop().animate({'top':'-55px'},400);
         				clicked=1;
         			}else{
         				sym.getSymbol("menuButtons").$("menuBtn0xtra").stop().animate({'top':'40px'},400);
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-500px'},400);
         				clicked=0;
         			}
         		}else if(menuMenu_id==3){ //teams
         			if (clicked==3){
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-500px'},400);
         				clicked=1;
         			}else{
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'40px'},400);
         				sym.getSymbol("menuButtons").$("menuBtn0xtra").stop().animate({'top':'-55px'},400);
         				clicked=3;
         			}
         		}else{
         			resetmenu(); //set them all back to normal state
         			clicked=menuMenu_id;
         			for (i=1;i<4;i++){
         				if (i==menuMenu_id){
         					if(menuMenu_id>0){
         						sym.$(screenArr[menuMenu_id-1]).fadeIn(200);
         						menuArray[i].$("menuBg").fadeOut(0);
         					}
         					if (menuMenu_id==1){ //drivers champs
         						getDriverStandings();
         					}
         					if (menuMenu_id==2){ //team champs
         						getConsStandings();
         						sym.getSymbol(screenArr[1]).$("carPic").delay(200).stop().animate ({left:60}, 800, 'easeOutCirc');	
         						sym.getSymbol(screenArr[1]).getSymbol("carPic").play();
         					}	
         				}else{
         					if (menuMenu_id!=0){
         						sym.$(screenArr[i]).fadeOut(400);
         					}
         				}														
         			}
         
         		}
         }
         menuArray[3].$("menuBg").fadeOut(0);
         //TEAM STRIP BUTTONS	
         var carPos=0;//for showTeam
         var hidden=1;
         var showTeam = function(teamdetails,longteam){ //to handle lexical scope
         	return function (e) {
         resetmenu();
         sym.$(screenArr[2]).fadeIn(200);
         menuArray[3].$("menuBg").fadeOut(0);
         	clicked=4;
         	getStats(teamdetails,2);
         		if (carPos==0){
                  carPos=1;
                  hidden=0;
               }else{
                  carPos=0;
                  hidden=1;
               }
         		sym.getSymbol("driversMc").$("driveCar"+carPos).css({'left':-800});	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("mainCar").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("reflection").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("driverHead").attr("src","drivers/"+teamdetails+".png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("bkwheel").attr("src","cars/"+teamdetails+"bk.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("frwheel").attr("src","cars/"+teamdetails+"fr.png");
         		sym.getSymbol("driversMc").$("driveCar"+carPos).delay(1600).stop().animate ({left:60}, 1100);	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).play();
         		sym.getSymbol("driversMc").$("driveCar"+hidden).stop().animate ({left:815}, 800);
         		sym.getSymbol("driversMc").getSymbol("driveCar"+hidden).play();
         		var team=teamdetails;
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         for (var j=0;j<teamArr.length;j++){ //Create team buttons
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).css({"cursor":'pointer'});
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).click(showTeam(teamArr[j],teamTxtArr[j][0]));
         }
         //GET GP SEASON
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         //GET Start list if race hasn't started
         function getStartList(){
         $.ajax({ type: "GET", 
         						url: dataURL,
                         data: "gn="+gn+"&yr="+gnYear+"&q=startlist&race=",
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
         						var startData=data;
         						 if (startData.length>20){
         							barHeight = ((500/startData.length)-2);
         						 }else{
         							barHeight = 23;
         						 }
         						for (var i=0; i<startData.length; i++){
         							if(i==0){ //show lead driver details
         								var drivershort = startData[i].c_PersonShort;
         								var driverID = startData[i].n_PersonID;
         								var imgCar = startData[i].c_TeamShort;
         								var leadDriver = '<b>' +startData[i].c_Person+ '</b> ' +startData[i].c_NOCShort+ '</span>';
         								sym.getSymbol("driverchampMc").$("driversTxt").html(leadDriver);
         								sym.getSymbol("driverchampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         							}	
         							var tableText ="<div class='driverschamp'>";
         							tableText += "<div id='driverdata"+i+"'>";
         							tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         							tableText += "<td id='driverrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         							tableText += "<td id='driverNm"+i+"'width='150px'></td>";
         							tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         							tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         							tableText += "</tr></table>";
         							tableText += "</div></div>";
         							sym.getSymbol("driverchampMc").$("graph").append(tableText);
                  $('#driverrnk' + i).text(startData[i].c_ShirtNr);		
         			$('#driverNm' + i).text(startData[i].c_Person);
                  $('#driverteam' + i).text(startData[i].c_Team);
                  if (i==0){
         				$('#driverpts' + i).text("0"+caps[1]);
         			}else{
         				$('#driverpts' + i).text("0");
         			}
                  $(".driverschamp").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         			$("#driverdata" + i).css({'height':barHeight+'px','width':'65%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px','box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         			$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         			$("#driverdata" + i).animate({width:scale+'%'},1500);
                 }
         		}
         	});
         }
         var barHeight;
         var nRaceDrivers;
         var maxPoints;
         var scale;
         function getDriverStandings(){
         	$.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&q=champdrivers&yr="+gnYear+"&race=",
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         				var rankData = data;
         					sym.getSymbol("driverchampMc").$("loading").hide();
         					sym.getSymbol("driverchampMc").$("graph").empty();
         					if (rankData.length<1){
         						getStartList();
         					}else{
         					//Ensure all drivers will fit in graph
         					nRaceDrivers = rankData.length;
         					if (rankData.length>20){
         					barHeight = ((500/rankData.length)-2);
         					}else{
         					barHeight = 23;
         					}
         					//calculate relative length of each bar
         					maxPoints = rankData[0].n_PointsSort;
         					var min = (maxPoints!=null) ? maxPoints : 0;
         					for (var n=0; n<rankData.length; n++) {
         						if (rankData[n].n_PointsSort!=null && rankData[n].n_PointsSort<min) {
         							min = rankData[n].n_PointsSort;									
         						}
         					}					
         					for (var i = 0; i < rankData.length; i++) {
         						if(i==0){ //show lead driver details
         							var drivershort = rankData[i].c_PersonShort;
         							var driverID = rankData[i].n_PersonID;
         							var imgCar = rankData[i].c_TeamShort;
         							var leadDriver = '<b>' +rankData[i].c_Person+ '</b> ' +rankData[i].c_NOCShort+ '</span>';
         							sym.getSymbol("driverchampMc").$("driversTxt").html(leadDriver);
         							sym.getSymbol("driverchampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         						}
         						var tableText ="<div class='driverschamp'>";
         						tableText += "<div id='driverdata"+i+"'>";
         						tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         						tableText += "<td id='driverrnk"+i+"' width='25px' style='font-weight:bold'></td>";
         						tableText += "<td id='driverNm"+i+"'width='125px'></td>";
         						tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         						tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         						tableText += "</tr></table>";
         						tableText += "</div></div>";
         						sym.getSymbol("driverchampMc").$("graph").append(tableText);
         						if (rankData[i].n_Rank!=null){
         							$('#driverrnk' + i).text(rankData[i].n_Rank);
         						}else{
         						 $('#driverrnk' + i).text(i+1);
         						}         	
         						$('#driverNm' + i).text(rankData[i].c_PersonShort);
         						$('#driverteam' + i).text(rankData[i].c_TeamShort);
         						if (rankData[i].c_Points!=null){
         							if (i==0&&caps[12]!=undefined){
         								$('#driverpts' + i).text(rankData[i].c_Points+caps[1]);
         							}else{
         								$('#driverpts' + i).text(rankData[i].c_Points);
         							}	
         						}else{
         							$('#driverpts' + i).text("0");
         						}          		
         						if (maxPoints==min && rankData[i].n_PointsSort==maxPoints) {
         							scale=100;
         						}else if(rankData[i].n_PointsSort==null){
         							scale=50;
         						}else{
         							scale = 100-((maxPoints-rankData[i].n_PointsSort)*45/(maxPoints-min));
         						}
         						$(".driverschamp").css({'font-size':'14px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         						$("#driverdata" + i).css({'height':barHeight+'px','width':'50%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         						$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         						$("#driverdata" + i).animate({width:scale+'%'},400);
         					}
         			}
         		}
         	});
         	setTimeout(getDriverStandings,600000);
         }
         getDriverStandings();
         var nTeams;
         var teamBar;
         function getConsStandings(){
         	$.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&q=champteams&yr="+gnYear+"&race=",
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         			var teamData = data;
         			sym.getSymbol("menuButtons").$("menuBtn2").off('click',menuBtnClick);//disable button
         			if (teamData.length<1){//if championship hasn't started
         				sym.getSymbol("menuButtons").$("menuBtn2").on ("click", {menuId:3}, menuBtnClick);
         			}else{
         				sym.getSymbol("menuButtons").$("menuBtn2").on ("click", {menuId:2}, menuBtnClick);
         			sym.getSymbol("teamChampMc").$("loading").css({'display':'none'});
         			sym.getSymbol("teamChampMc").$("graph").empty();
         			//Ensure all teams will fit in graph
         			nTeams = teamData.length;
         			if (teamData.length>=10){
         				teamBar = ((260/teamData.length)-2);
         			}else{
         				teamBar = 25;
         			}
         			//calculate relative length of each bar
         			teamPoints = teamData[0].n_PointsSort;
         			var minpts = (teamPoints!=null) ? teamPoints : 0;
         			for (var n=0; n<teamData.length; n++) {
         						if (teamData[n].n_PointsSort!=null && teamData[n].n_PointsSort<minpts) {
         							minpts = teamData[n].n_PointsSort;									
         						}
         			}	
         			for (var i = 0; i < teamData.length; i++) {
         			teamname=teamData[i].c_TeamShort;
         			longname=teamData[i].c_Team;
         			if(i==0){ //show lead team details
         						var imgCar = teamData[i].c_TeamShort;
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("mainCar").attr("src","cars/"+imgCar+"big.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("reflection").attr("src","cars/"+imgCar+"big.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("driverHead").attr("src","drivers/"+imgCar+".png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("bkwheel").attr("src","cars/"+imgCar+"bk.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("frwheel").attr("src","cars/"+imgCar+"fr.png");
         						getStats(teamname,1);
         			}
         			var constructorsText ="<div class='teamchamp'>";
         			constructorsText += "<div id='teamdata"+i+"'>";
         			constructorsText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         			constructorsText += "<td id='teamrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         			constructorsText += "<td id='teamNm"+i+"'></td>";
         			constructorsText += "<td id='teampts"+i+"' style='font-weight:bold'></td>";
         			constructorsText += "</tr></table>";
         			constructorsText += "</div></div>";
         			sym.getSymbol("teamChampMc").$("graph").append(constructorsText);
                  if (teamData[i].n_Rank!=null){
                  $('#teamrnk' + i).text(teamData[i].n_Rank);
                  }else{
                   $('#teamrnk' + i).text(i+1);
         			} 		
         			$('#teamNm' + i).text(teamData[i].c_Team);
                  if(teamData[i].c_Points!=null){
         				if (i==0){
         					$('#teampts' + i).text(teamData[i].c_Points+caps[1]);
         				}else{
         					$('#teampts' + i).text(teamData[i].c_Points);
         				}
         			}else{
         				$('#teampts' + i).text("0");
         			}				                                   
         						if (teamPoints==minpts && teamData[i].n_PointsSort==teamPoints) {
         						scale=100;
         						}else if(teamData[i].n_PointsSort==null){
         						scale=56;
         						}else{
         						scale = 100-((teamPoints-teamData[i].n_PointsSort)*44/(teamPoints-minpts));
         						}
                  $(".teamchamp").css({'font-size':'14px', 'font-family':'pragmatica-web, sans-serif', 'width':'99%','margin-bottom':'2px'});
         			$("#teamdata" + i).css({'height':teamBar+'px','width':scale+'%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         			$("#teamdata" + i + " table").css({'height':teamBar+'px'});
         			$("#teampts" + i).css({'text-align':'right', 'padding-right':'3px'});
         						}
         			}
         		}
         	});
         	setTimeout(getConsStandings,600000);
         }
         getConsStandings();
         var flag1txt;
         var flag2txt;
         function getStats(teamdetails,view){
         	sym.getSymbol(screenArr[view]).$("teamTxt0").css({'font-weight':700});	//team name	
         	for (var i=0;i<teamArr.length;i++){
         		if (teamdetails==teamArr[i]){
         			for (var t=0;t<12;t++){
         				sym.getSymbol(screenArr[view]).$("teamTxt"+t).html(teamTxtArr[i][t]);
         			}
         			sym.getSymbol(screenArr[view]).$("teamTxt10").html(caps[2]+": <b>"+teamTxtArr[i][10]+"</b>");
         			for (var x=0;x<2;x++){
         				if(driverID[i][x]>0){
         					sym.getSymbol(screenArr[view]).$("driverflag"+(x+1)).attr("src","images/"+teamTxtArr[i][(x+1)*4]+".gif");
         					sym.getSymbol(screenArr[view]).$("driverpic"+(x+1)).attr("src","drivers/"+driverID[i][x]+".jpg");//driver ID
         					sym.getSymbol(screenArr[view]).$("driverHelmet"+(x+1)).attr("src","drivers/"+driverID[i][x]+".png");//driver ID
         				}else{
         					sym.getSymbol(screenArr[view]).$("driverflag"+(x+1)).attr("src","images/blank.png");
         					sym.getSymbol(screenArr[view]).$("driverpic"+(x+1)).attr("src","images/blank.jpg");//driver ID
         					sym.getSymbol(screenArr[view]).$("driverHelmet"+(x+1)).attr("src","images/blank.png");//driver ID				
         				}						
         			}
         		}
         	}
         }
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Bg'
   (function(symbolName) {   
   
   })("Bg");
   //Edge symbol end:'Bg'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'ChampionshipMc'
   (function(symbolName) {   
   
   })("DriverChampMc");
   //Edge symbol end:'DriverChampMc'

   //=========================================================
   
   //Edge symbol: 'MenuButtonsMc'
   (function(symbolName) {   
   
   })("MenuButtonsMc");
   //Edge symbol end:'MenuButtonsMc'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtn_1'
   (function(symbolName) {   
   
   })("RaceBtn");
   //Edge symbol end:'RaceBtn'

   //=========================================================
   
   //Edge symbol: 'DriveCar'
   (function(symbolName) {   
   
   })("DriveCar");
   //Edge symbol end:'DriveCar'

   //=========================================================
   
   //Edge symbol: 'TeamChampMc'
   (function(symbolName) {   
   
   })("TeamChampMc");
   //Edge symbol end:'TeamChampMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'TeamButtonStrip'
   (function(symbolName) {   
   
   })("TeamButtonStrip");
   //Edge symbol end:'TeamButtonStrip'

   //=========================================================
   
   //Edge symbol: 'TeamBtns'
   (function(symbolName) {   
   
   })("TeamBtns");
   //Edge symbol end:'TeamBtns'

   //=========================================================
   
   //Edge symbol: 'DriversMc'
   (function(symbolName) {   
   
   })("DriversMc");
   //Edge symbol end:'DriversMc'

   //=========================================================
   
   //Edge symbol: 'Home'
   (function(symbolName) {   
   
   })("Home");
   //Edge symbol end:'Home'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32808");