/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	var source2;
	var source2txt = sym.getSymbol("styleBase").$("source2Txt").css("pointer-events","none");
	
	var txt=[];
	for (var i=0; i<11; i++){
	txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
	}
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32768.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
			source2 = $(xml).find('source2').text();
			source2txt.html(source2);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<11; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}
		}
	}); // END XML
	
	var counter = 1; // SET COUNTER
	
	// MAKE ELEMENTS INVISIBLE
	sym.getSymbol("btnBackMc").$("btnBack").fadeOut(0);
	sym.$("btnBackMc").fadeOut(0);
	sym.getSymbol("btnNextMc").$("btnBack").fadeOut(0);
	
	function hideDots() {
		for (var d = 0; d < 11; d++){
		sym.$("dot"+d).fadeOut(0);
		}
		sym.$("dot"+counter).fadeIn(0);
	}
	hideDots();	
	
	function showcounters() {
		for (var s = 0; s < 11; s++){
		sym.$("car" + (counter - s)).stop().animate ({opacity:0, left:0, top:420, width:150, height:88}, 600, 'easeInOutCubic');
		}
		for (var t = 0; t < 11; t++){
		sym.$("car" + (counter + t)).stop().animate ({opacity:0, left:650, top:420, width:150, height:88}, 600, 'easeInOutCubic');
		}
	
		sym.$("car" + counter).stop().animate ({opacity:1, left:0, top:15, width:800, height:470}, 800, 'easeInOutCubic');
	
		sym.$("txt0").empty();
		sym.$("txt0").append(txtArr[counter -1]);
	
		if (counter == 1) {
			sym.getSymbol("btnBackMc").$("btnBack").fadeOut(0);
			sym.$("btnBackMc").fadeOut(0);
		}else{
			sym.$("btnBackMc").fadeIn(0);
		}
		if (counter == 11) {
			sym.getSymbol("btnNextMc").$("btnBack").fadeOut(0);
			sym.$("btnNextMc").fadeOut(0);
		}else{
			sym.$("btnNextMc").fadeIn(0);
		}
		hideDots();
		resetmenu();
		sym.getSymbol("btnsMc").getSymbol("dot" + (counter - 1)).$("btnClick").fadeIn(0);
		}
	
	// GLASS BUTTON
	sym.$("btnNextMc").on(clickEventType, function(e){
	counter++;
	showcounters();
	e.stopPropagation(); e.preventDefault();
	});
	sym.$("btnNextMc").mouseover(function(){
	sym.getSymbol("btnNextMc").$("btnBack").fadeIn(100);
	e.stopPropagation(); e.preventDefault();
	});
	sym.$("btnNextMc").mouseout(function(){
	sym.getSymbol("btnNextMc").$("btnBack").fadeOut(100);
	e.stopPropagation(); e.preventDefault();
	});
	
	sym.$("btnBackMc").on(clickEventType, function(e){
	counter--;
	showcounters();
	e.stopPropagation(); e.preventDefault();
	});
	sym.$("btnBackMc").mouseover(function(){
	sym.getSymbol("btnBackMc").$("btnBack").fadeIn(100);
	e.stopPropagation(); e.preventDefault();
	});
	sym.$("btnBackMc").mouseout(function(){
	sym.getSymbol("btnBackMc").$("btnBack").fadeOut(100);
	e.stopPropagation(); e.preventDefault();
	});
	
	
	// MENU BUTTONS --------------------------------------------	
         menuArray = []; //the array that will hold references to the buttons.

         for (var h = 0; h < 11; h++){
         	 // Create an instance element of a symbol as a child of the given parent element
         	 var menuBtnSymbols = sym.getSymbol("btnsMc").getSymbol("dot" +h);
         	 //set the value of a Symbol variable
         	 menuBtnSymbols.setVariable("menuId", h);
         	 //push it into the array
         	 menuArray.push(menuBtnSymbols);
         }

         //a 'for each' loop through the newly populated array.
         $.each(menuArray, function( count, menuInTheArray ){
         	 var menuBtnItem = $(menuInTheArray); 
         	 var menuBtnElement = menuInTheArray.getSymbolElement();
         	 menuBtnElement.bind (clickEventType, {menuId:count}, menuBtnClick);
         	 menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
         	 menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
         	}
         )

	function resetmenu(){
		for (var h=0; h<menuArray.length; h++){
         	menuArray[h].$("btnClick").fadeOut(0);
         	menuArray[h].$("btnOver").fadeOut(0);
		}
	}
	resetmenu();

	function menuBtnClick (e){
		var menuMenu_id = (e.data.menuId + 1); //get the id of the clicked item
		sym.getSymbol("btnsMc").getSymbol("dot" + (menuMenu_id - 1)).$("btnClick").stop().fadeIn(0);
		counter = menuMenu_id;
		showcounters();
		e.preventDefault(); e.stopPropagation();
	}

	function menuShow (e){
         	var menuMenu_id = (e.data.menuId); //get the id of the over button
				sym.getSymbol("btnsMc").getSymbol("dot" + menuMenu_id).$("btnOver").stop().fadeIn(0);
				e.preventDefault(); e.stopPropagation();
	}
	function menuHide (e){
         	var menuMenu_id = (e.data.menuId); //get the id of the out button
				sym.getSymbol("btnsMc").getSymbol("dot" + menuMenu_id).$("btnOver").stop().fadeOut(0);
				e.preventDefault(); e.stopPropagation();
	}

sym.getSymbol("btnsMc").getSymbol("dot0").$("btnClick").fadeIn(0);

sym.$("swipe").swipeleft(function(){
		if (counter == 11) {
		}else{
			counter++;
			showcounters();
		}
		e.stopPropagation(); e.preventDefault();
      });
sym.$("swipe").swiperight(function(){
		if (counter == 1) {
		}else{
			counter--;
			showcounters();
		}
		e.stopPropagation(); e.preventDefault();
      });

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'dot0'
   (function(symbolName) {   
   
   })("dot0");
   //Edge symbol end:'dot0'

   //=========================================================
   
   //Edge symbol: 'btnBackMc'
   (function(symbolName) {   
   
   })("btnBackMc");
   //Edge symbol end:'btnBackMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32768");