/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var statIn = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	for (var b=0;b<3; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuIcon" + b + ".png");
         	} // MENU TEXT END
         	
         	var outBtn  = {"background-color":"black"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("interiorMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("interiorMc").$("txt8").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32762.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<9; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         		}
         	}); // END XML
         	
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.$("statsMc").stop().animate({left:800}, 200);
         	}
         }
         var waiting = 500;
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.$("videoMc").fadeOut(500);
         		sym.$("interiorMc").fadeOut(500);
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		if (menuNo==0) {
         			car = 0;
         			waiting = 500;
         		}
         		if (menuNo==1) {
         			car = 1;
         			sym.$("interiorMc").stop().delay(waiting).fadeIn(500);
         			waiting = 0;
         		}
         		if (menuNo==2) {
         			car = 1;
         			sym.$("videoMc").stop().delay(waiting).fadeIn(500);
         			waiting = 0;
         		}
         		carMove();
         	};
         	e.preventDefault(); e.stopPropagation();
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         	};
         	e.preventDefault(); e.stopPropagation();
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         	};
         	e.preventDefault(); e.stopPropagation();
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //   ************************************************************************************************************************* 
         //   ****************************************************  CAR START  ****************************************************
         //   ************************************************************************************************************************* 
         $.fn.animateRotate = function(angle, duration, easing, complete) {
             return this.each(function() {
                 var $elem = $(this);
                 $({deg: 0}).animate({deg: angle}, {
                     duration: duration,
                     easing: easing,
                     step: function(now) {
                         $elem.css({
                           '-moz-transform':'rotate('+now+'deg)',
                           '-webkit-transform':'rotate('+now+'deg)',
                           '-o-transform':'rotate('+now+'deg)',
                           '-ms-transform':'rotate('+now+'deg)',
                           'transform':'rotate('+now+'deg)'
                         });
                     },
                     complete: complete || $.noop
                 });
             });
         };
         
         	var car = 0;
         	var speed = 0;
         	var ease = 0;
         	var spin = 0;
         
         	function carMove() {
         	statIn = 0;
         	if (car == 0){
         			sym.getSymbol("carMainMc").$("carMc").stop().animate ({opacity:1}, 0);
         			ease = 'easeOutCubic';
         			speed = 1500;
         			sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:0}, speed, 'easeOutCubic', function(){
         			sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:1}, 500);
         			sym.getSymbol("carMainMc").$("wheelbase").stop().animate ({opacity:1}, 500);
         			});
         			if (spin == 0){
         				for (var b=0;b<4; b++){
         					sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel"+b).animateRotate(-720, speed, ease);
         				}
         				spin = 1;
         			}else{
         				spin = 0;
         			}
         			car = 1;
         		}else{
         			ease = 'easeInCubic';
         			speed = 500;
         			sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:0}, 0);
         			sym.getSymbol("carMainMc").$("wheelbase").stop().animate ({opacity:0}, 0);
         			sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:-800}, speed, 'easeInCubic', function(){
         				sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:800}, 0 , function(){
         				sym.getSymbol("carMainMc").$("carMc").stop().animate ({opacity:0}, 0);
         				});
         				});
         
         			for (var b=0;b<4; b++){
         			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel"+b).animateRotate(0,0);
         			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel"+b).animateRotate(-720, speed, ease);
         		}
         		car = 0;
         		spin = 0;
         		}
         	}
         
         	sym.$("interiorMc").stop().fadeOut(0);
         	sym.getSymbol("carMainMc").$("wheelbase").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:800}, 0);
         	carMove();
         
         
         	// GALLERY BUTTONS --------------------------------------------	
         	var galNo = 0;
         	for (var b=0;b<7; b++){
         		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn"+b).$("btnIcon").attr("src", "images/gal" + b + ".jpg");
         	}
         
         	galArray = []; //the array that will hold references to the buttons.
         
         	for (var a = 0; a < 7; a++){
         		var galBtnSymbols = sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn" +a); // Create an instance element of a symbol as a child of the given parent element
         		galBtnSymbols.setVariable("galId", a); //set the value of a Symbol variable
         		galArray.push(galBtnSymbols); //push it into the array
         	}
         
         	$.each(galArray, function( count, galInTheArray ){ //a 'for each' loop through the newly populated array
         		var galBtnItem = $(galInTheArray); //create jQuery reference to the item
         		var galBtnElement = galInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         		galBtnElement.bind (clickEventType, {galId:count}, galBtnClick);
         		galBtnElement.bind ("mouseover", {galId:count}, galBtnShow);
         		galBtnElement.bind ("mouseout", {galId:count}, galBtnHide);
         	})
         
         	var btnNo = 0;
         
         	function resetGal(){
         	for (var k=0;k<7; k++){
         		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn"+k).$("btnClick").fadeOut(0);
         		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn"+k).$("btnOver").fadeOut(0);
         	}
         	}
         	resetGal();
         
         	function galBtnClick (e){
         		var gal_id = (e.data.galId); //get the id of the clicked item
         		galNo = gal_id;
         		resetGal();
         		galleryShow();
         		e.stopPropagation(); e.preventDefault();
         		}
         
         	function galBtnShow (e){
         		var gal_id = (e.data.galId); //get the id of the over button
         		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn" + gal_id).$("btnOver").fadeIn(0);
         		e.stopPropagation(); e.preventDefault();
         	}
         	function galBtnHide (e){
         		var gal_id = (e.data.galId); //get the id of the out button
         		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn" + gal_id).$("btnOver").fadeOut(0);
         		e.stopPropagation(); e.preventDefault();
         	}
         
         // MAKE gal0 VISIBLE
         	sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn0").$("btnClick").fadeIn(0);
         
         
         // BUTTONS COUNT
         var galNo = 0;
         
         sym.getSymbol("videoMc").$("imgSwipe").on('swipeleft', function(e){
         	resetGal();
         	galNo++;
         	if (galNo >= 6){
         		galNo = 6;
         	}
         		galleryShow();
         	});
         
         sym.getSymbol("videoMc").$("imgSwipe").on('swiperight', function(e){
         	resetGal();
         	galNo--;
         	if (galNo <= 0){
         		galNo = 0;
         	}
         		galleryShow();
         	});
         
         function galleryShow(){
         	sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn" + galNo).$("btnClick").fadeIn(0);
         	sym.getSymbol("videoMc").$("imgHolder").fadeOut(150, function() {
         	sym.getSymbol("videoMc").$("imgHolder").attr("src", "images/gal" + galNo + ".jpg");
             sym.getSymbol("videoMc").$("imgHolder").fadeIn(200);
           	});
         }
         
         	sym.$("videoMc").fadeOut(0);
         

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'carTxtMc'
   (function(symbolName) {   
   
   })("carTxtMc");
   //Edge symbol end:'carTxtMc'

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================
   
   //Edge symbol: 'carMainMc'
   (function(symbolName) {   
   
   })("carMainMc");
   //Edge symbol end:'carMainMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("menuBtn_1");
   //Edge symbol end:'menuBtn_1'

   //=========================================================
   
   //Edge symbol: 'interiorMc'
   (function(symbolName) {   
   
   })("interiorMc");
   //Edge symbol end:'interiorMc'

   //=========================================================
   
   //Edge symbol: 'statsMc'
   (function(symbolName) {   
   
   })("statsMc");
   //Edge symbol end:'statsMc'

   //=========================================================
   
   //Edge symbol: 'videoMc'
   (function(symbolName) {   
   
   })("videoMc");
   //Edge symbol end:'videoMc'

   //=========================================================
   
   //Edge symbol: 'galBtn'
   (function(symbolName) {   
   
   })("galBtn");
   //Edge symbol end:'galBtn'

   //=========================================================
   
   //Edge symbol: 'galBtnsMc'
   (function(symbolName) {   
   
   })("galBtnsMc");
   //Edge symbol end:'galBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32762");