/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var statIn = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	for (var b=0;b<3; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuIcon" + b + ".png");
         	} // MENU TEXT END
         	
         	var outBtn  = {"background-color":"black"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("interiorMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("interiorMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("statsMc").$("txt6").css({"width":"auto", "padding":"10px"});
         	txt[7] = sym.getSymbol("statsMc").$("txt7").css({"width":"auto"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32757.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<25; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			sym.getSymbol("statsMc").$("txt7").empty();
         			sym.getSymbol("statsMc").$("txt7").append("<div class='blackstrap'>"+txtArr[7]+
         			"</div><div class='captionNote'>" + txtArr[8]+
         			"</div><div class='blackstrap'>"+txtArr[9]+
         			"</div><div class='captionNote'>" + txtArr[10]+
         			"</div><div class='blackstrap'>"+txtArr[11]+
         			"</div><div class='captionNote'>" + txtArr[12]+
         			"</div><div class='blackstrap'>"+txtArr[13]+
         			"</div><div class='captionNote'>" + txtArr[14]+
         			"</div><div class='blackstrap'>"+txtArr[15]+
         			"</div><div class='captionNote'>" + txtArr[16]+
         			"</div><div class='blackstrap'>"+txtArr[17]+
         			"</div><div class='captionNote'>" + txtArr[18]+
         			"</div><div class='blackstrap'>"+txtArr[19]+
         			"</div><div class='captionNote'>" + txtArr[20]+
         			"</div><div class='blackstrap'>"+txtArr[21]+
         			"</div><div class='captionNote'>" + txtArr[22]+
         			"</div><div class='blackstrap'>"+txtArr[23]+
         			"</div>");
         	
         		$('.blackstrap').css({'background-color':'rgba(200,200,200,0.1)', 'padding-right':'10px', 'padding-left':'10px', 'padding-bottom':'6px', 'padding-top':'6px'});
         		$('.captionNote').css({'background-color':'rgba(200,200,200,0.2)', 'padding-right':'10px', 'padding-left':'10px', 'padding-bottom':'6px', 'padding-top':'6px'});
         		sym.getSymbol("statsMc").$("box").animate({width:0 + sym.getSymbol("statsMc").$("txt7").width()+14}, 0);
         		sym.getSymbol("statsMc").$("txt7").css({"overflow-y":"auto"});
         		}
         	}); // END XML
         	
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.$("statsMc").stop().animate({left:800}, 200);
         	}
         }
         var waiting = 500;
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		if (menuNo==0) {
         			car = 0;
         			sym.$("interiorMc").stop().fadeOut(500);
         			waiting = 500;
         			carMove();
         		}
         		if (menuNo==1) {
         			car = 1;
         			sym.$("interiorMc").stop().delay(waiting).fadeIn(500);
         			waiting = 0;
         			carMove();
         		}
         		if (menuNo==2) {
         			if (statIn == 0){
         				sym.$("statsMc").stop().animate({left:800 - sym.getSymbol("statsMc").$("box").width()}, 400, 'easeOutCubic');
         				statIn = 1;
         			}else{
         				sym.$("statsMc").stop().animate({left:800}, 200, 'easeInCubic');
         				statIn = 0;
         			}
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //   ************************************************************************************************************************* 
         //   ****************************************************  CAR START  ****************************************************
         //   ************************************************************************************************************************* 
         $.fn.animateRotate = function(angle, duration, easing, complete) {
             return this.each(function() {
                 var $elem = $(this);
                 $({deg: 0}).animate({deg: angle}, {
                     duration: duration,
                     easing: easing,
                     step: function(now) {
                         $elem.css({
                           '-moz-transform':'rotate('+now+'deg)',
                           '-webkit-transform':'rotate('+now+'deg)',
                           '-o-transform':'rotate('+now+'deg)',
                           '-ms-transform':'rotate('+now+'deg)',
                           'transform':'rotate('+now+'deg)'
                         });
                     },
                     complete: complete || $.noop
                 });
             });
         };
         
         	var car = 0;
         	var speed = 0;
         	var ease = 0;
         	var spin = 0;
         
         	function carMove() {
         	statIn = 0;
         	if (car == 0){
         			sym.getSymbol("carMainMc").$("carMc").stop().animate ({opacity:1}, 0);
         			ease = 'easeOutCubic';
         			speed = 1500;
         			sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:0}, speed, 'easeOutCubic', function(){
         			sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:1}, 500);
         			sym.getSymbol("carMainMc").$("wheelbase").stop().animate ({opacity:1}, 500);
         			});
         			if (spin == 0){
         				for (var b=0;b<4; b++){
         					sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel"+b).animateRotate(-720, speed, ease);
         				}
         				spin = 1;
         			}else{
         				spin = 0;
         			}
         			car = 1;
         		}else{
         			ease = 'easeInCubic';
         			speed = 500;
         			sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:0}, 0);
         			sym.getSymbol("carMainMc").$("wheelbase").stop().animate ({opacity:0}, 0);
         			sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:-800}, speed, 'easeInCubic', function(){
         				sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:800}, 0 , function(){
         				sym.getSymbol("carMainMc").$("carMc").stop().animate ({opacity:0}, 0);
         				});
         				});
         
         			for (var b=0;b<4; b++){
         			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel"+b).animateRotate(0,0);
         			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel"+b).animateRotate(-720, speed, ease);
         		}
         		car = 0;
         		spin = 0;
         		}
         	}
         
         	sym.$("interiorMc").stop().fadeOut(0);
         	sym.getSymbol("carMainMc").$("wheelbase").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:800}, 0);
         	carMove();

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'carTxtMc'
   (function(symbolName) {   
   
   })("carTxtMc");
   //Edge symbol end:'carTxtMc'

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================
   
   //Edge symbol: 'carMainMc'
   (function(symbolName) {   
   
   })("carMainMc");
   //Edge symbol end:'carMainMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("menuBtn_1");
   //Edge symbol end:'menuBtn_1'

   //=========================================================
   
   //Edge symbol: 'interiorMc'
   (function(symbolName) {   
   
   })("interiorMc");
   //Edge symbol end:'interiorMc'

   //=========================================================
   
   //Edge symbol: 'statsMc'
   (function(symbolName) {   
   
   })("statsMc");
   //Edge symbol end:'statsMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews32757");