/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css({"pointer-events":"none", "height":"auto"});
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css({"height":"auto", "padding-right":"2px", "padding-top":"2px","padding-left":"4px", "background-color":"rgba(0,0,0,1)"});
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32736.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			var headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			var stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			var source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			sym.$("textBox").empty();
         			$(xml).find("process").each(function(){
         				var $eventdate = $(this);
         				var $events = $eventdate.find('event');
         				$events.each(function(){														
         					var $event = $(this);
         					var cap2 = $event.find('date').text();                   
         					var cap3 = $event.find('cap').text();
         					var cap4 = $event.find('img').text();
         					var styleBox = "<div style='clear:both; margin-bottom:5px'>";
         					var styleDate ="<div style='float:left; font-size:30px; font-weight:600; color:rgba(215,0,18,1); padding-left:0px; padding-right:5px; padding-top:6px; padding-bottom:5px'>"
         					var styleCaption = "</div><div style='font-family:pragmatica-web, sans-serif; font-size:14px; padding-right:20px; padding-left:1px; padding-bottom:10px; padding-top:0px'>"
         					var html = styleBox + cap4 + styleDate + cap2 + styleCaption +cap3 + "</div></div><hr>";
         					sym.$("textBox").append(html);
         					sym.$("textBox").css({"height":"auto", "overflowY":"scroll"});
         				}); 
         		});
         	
         		sym.$("textBox").animate({top:75 + sym.getSymbol("styleHead").$("standTxt").height()+15}, 0);
         		sym.$("textBox").animate({height:506 - sym.getSymbol("styleHead").$("standTxt").height()+5}, 0);
         	}
         	});

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32736");