/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txt=[];
         	for(var i=0;i<10;i++){
         	txt[i] = sym.getSymbol("earthPointMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for(var i=10;i<14;i++){
         	txt[i] = sym.getSymbol("corePointMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32700.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			var headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			var stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			var source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<51; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         		}
         	}); // END XML
         	
         	sym.$("coreBar").stop().animate ({opacity:0}, 0);
         	sym.$("core").stop().animate ({opacity:0}, 0);
         	sym.$("corePointMc").stop().animate ({opacity:0}, 0);
         	sym.$("blackBox").stop().animate ({opacity:0}, 0);
         	
         // TOGGLE BUTTON
         sym.$("toggleBtn").on(clickEventType, function(e){
         	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible") ) {
         		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
         		sym.$("earthPointMc").stop().animate ({opacity:0}, 300);
         		sym.$("bg").stop().animate ({opacity:0}, 300, function(){
         			sym.$("toggleBtn").stop().animate ({left:160, top:350}, 600, 'easeOutCubic');
         			sym.$("blackBox").stop().animate ({opacity:0.8}, 600);
         			sym.$("coreWhole").stop().animate ({left:0, top:0, width:600, height:500}, 600, 'easeOutCubic', function(){
         			sym.$("core").stop().animate ({opacity:1}, 500);
         			sym.$("coreWhole").stop().delay(200).animate ({opacity:0}, 500);
         			sym.$("corePointMc").stop().animate ({opacity:1}, 500);
         			sym.$("coreBar").stop().animate ({opacity:1}, 500);
         			sym.$("blackBox").stop().animate ({opacity:0.8}, 600);
         			});
         		});
         	}else{
         		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
         		sym.$("coreWhole").stop().animate ({opacity:1}, 200);
         		sym.$("corePointMc").stop().animate ({opacity:0}, 200);
         		sym.$("coreBar").stop().animate ({opacity:0}, 200);
         		sym.$("core").stop().animate ({opacity:0}, 300, function(){
         		sym.$("toggleBtn").stop().animate ({left:341, top:348}, 600, 'easeOutCubic');
         			sym.$("blackBox").stop().animate ({opacity:0}, 600);
         			sym.$("coreWhole").stop().animate ({left:327, top:218, width:179, height:149}, 600, 'easeOutCubic', function(){
         			sym.$("bg").stop().animate ({opacity:1}, 600);
         			sym.$("earthPointMc").stop().animate ({opacity:1}, 300);
         			});
         		});
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.$("toggleBtn").mouseover(function(){
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
         });
         sym.$("toggleBtn").mouseout(function(){
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
         });

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'earthPointMc'
   (function(symbolName) {   
   
   })("earthPointMc");
   //Edge symbol end:'earthPointMc'

   //=========================================================
   
   //Edge symbol: 'corePointMc'
   (function(symbolName) {   
   
   })("corePointMc");
   //Edge symbol end:'corePointMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32700");