/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         // MENU TEXT START
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[3] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         	for (var b=0;b<4; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuIcon" + b + ".png");
         	} // MENU TEXT END
         
         	var outBtn  = {"background-color":"black"};
         	var overBtn = {"background-color":"rgba(0,112,186,1)"};
         
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("pointMc1").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("pointMc1").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("pointMc1").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("pointMc1").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("pointMc1").$("txt5").css({"pointer-events":"none", "height":"auto"});
         	txt[6] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("txt").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn1").$("txt").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn2").$("txt").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("auxBtnsMc").$("txt9").css({"pointer-events":"none", "height":"auto"});
         	txt[10] = sym.$("txt10").css({"pointer-events":"none", "height":"auto"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none", "height":"auto"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("pointMc0").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("pointMc0").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("pointMc0").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.getSymbol("pointMc0").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("pointMc0").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("pointMc0").$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.getSymbol("pointMc0").$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.getSymbol("pointMc0").$("txt23").css({"pointer-events":"none", "height":"auto"});
         	txt[24] = sym.getSymbol("pointMc0").$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol("pointMc0").$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.getSymbol("pointMc0").$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.getSymbol("pointMc0").$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.getSymbol("pointMc0").$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.getSymbol("pointMc0").$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.getSymbol("pointMc0").$("txt30").css({"pointer-events":"none"});
         	txt[31] = sym.getSymbol("pointMc0").$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.getSymbol("pointMc2").$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.getSymbol("pointMc2").$("txt33").css({"pointer-events":"none"});
         	txt[34] = sym.getSymbol("pointMc2").$("txt34").css({"pointer-events":"none"});
         	txt[35] = sym.getSymbol("pointMc2").$("txt35").css({"pointer-events":"none", "height":"auto"});
         	txt[36] = sym.$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.getSymbol("pointMc3").$("txt37").css({"pointer-events":"none", "height":"auto"});
         	txt[38] = sym.$("txt38").css({"pointer-events":"none"});
         	txt[39] = sym.$("txt39").css({"pointer-events":"none"});
         	txt[40] = sym.$("txt40").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32693.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<4; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<40; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         
         			sym.$("mask").animate({top:0 + sym.getSymbol("pointMc0").$("txt23").height() + 372}, 200);
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[24]);
         
         		}
         	}); // END XML
         
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<4; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.$("pointMc0").stop().animate({opacity:0}, 300, function(){ sym.$("pointMc0").animate({left:800}, 0); });
         		sym.$("pointMc1").stop().animate({opacity:0}, 300);
         		sym.$("pointMc2").stop().animate({opacity:0}, 300, function(){ sym.$("pointMc2").animate({left:800}, 0); });
         		sym.$("pointMc3").stop().animate({opacity:0}, 300);
         		sym.$("auxBtnsMc").stop().animate({opacity:0}, 300);
         		sym.$("carPointBot").stop().animate({opacity:1}, 300);
         		sym.$("carPointBot").stop().animate({opacity:1}, 100);
         		sym.$("txt15").stop().animate({opacity:1}, 100);
         		sym.$("aeroPoint").fadeOut(100);
         		sym.$("engineCircle").fadeOut(100);
         	}
         }
         //resetmenu();
         sym.$("pointMc0").stop().animate({opacity:1}, 0);
         sym.$("carPointBot").stop().animate({opacity:0}, 0);
         sym.$("txt15").stop().animate({opacity:0}, 0);
         sym.$("pointMc1").stop().animate({opacity:0}, 0);
         sym.$("pointMc2").stop().animate({opacity:0}, 0);
         sym.$("pointMc3").stop().animate({opacity:0}, 0);
         sym.$("auxBtnsMc").stop().animate({opacity:0}, 0);
         sym.$("aeroPoint").fadeOut(0);
         sym.$("engineCircle").fadeOut(0);
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		if (menuNo == 0){
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[24]);
         			sym.$("pointMc0").animate({left:0}, 0);
         			sym.$("pointMc0").stop().animate({opacity:1}, 300);
         			sym.$("carPointBot").stop().animate({opacity:0}, 100);
         			sym.$("mask").animate({top:0 + sym.getSymbol("pointMc0").$("txt23").height() + 352}, 200, 'easeOutCubic');
         			sym.$("carPointBot").stop().animate({opacity:0}, 0);
         			sym.$("txt15").stop().animate({opacity:0}, 0);
         		}
         		if (menuNo == 1){
         			sym.$("engineCircle").fadeIn(300);
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[0]);
         			sym.$("auxBtnsMc").stop().animate({opacity:1}, 300);
         			sym.$("pointMc1").stop().animate({opacity:1}, 300);
         			sym.$("mask").animate({top:0 + sym.getSymbol("pointMc1").$("txt5").height() + 313 + 60 + sym.getSymbol("auxBtnsMc").$("txt9").height()}, 200, 'easeOutCubic');
         			sym.$("auxBtnsMc").animate({top:313 + sym.getSymbol("pointMc1").$("txt5").height()+20}, 0);
         		}
         		if (menuNo == 2){
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[32]);
         			sym.$("pointMc2").animate({left:0}, 0);
         			sym.$("pointMc2").stop().animate({opacity:1}, 300);
         			sym.$("mask").animate({top:0 + sym.getSymbol("pointMc2").$("txt35").height() + 320}, 200, 'easeOutCubic');
         		}
         		if (menuNo == 3){
         			sym.$("aeroPoint").fadeIn(300);
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[36]);
         			sym.$("pointMc3").stop().animate({opacity:1}, 300);
         			sym.$("mask").animate({top:0 + sym.getSymbol("pointMc3").$("txt37").height() + 280}, 200, 'easeOutCubic');
         			sym.getSymbol("pointMc3").$("aero").animate({top:106 + sym.getSymbol("pointMc3").$("txt37").height() + 3}, 0);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[clicked]);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         
         // AUX BUTTONS --------------------------------------------	
         var clickAux = 0;
         var outAux  = {"background-color":"black"};
         var overAux = {"background-color":"rgba(0,112,186,1)"};
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<3; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + a).$("bg").css(outAux);
         	}
         }
         //resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		clickAux = auxNo;
         		resetAux();
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		sym.getSymbol("auxBtnsMc").$("txt9").empty();
         		sym.getSymbol("auxBtnsMc").$("txt9").append(txtArr[auxNo + 9]);
         		sym.$("mask").animate({top:0 + sym.getSymbol("pointMc1").$("txt5").height() + 313 + 60 + sym.getSymbol("auxBtnsMc").$("txt9").height()}, 200);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OVER
         var auxBtnOver = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OUT
         var auxBtnOut = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(outAux);
         		if (clickAux == auxNo){
         			sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on(clickEventType,auxBtnClick(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on('mouseover',auxBtnOver(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on('mouseout',auxBtnOut(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("bg").css(overBtn);

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtnStart");
   //Edge symbol end:'menuBtnStart'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'pointMc0'
   (function(symbolName) {   
   
   })("pointMc1");
   //Edge symbol end:'pointMc1'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("menuBtnSquare");
   //Edge symbol end:'menuBtnSquare'

   //=========================================================
   
   //Edge symbol: 'menuBtnStart_1'
   (function(symbolName) {   
   
      })("menuBtnEnd");
   //Edge symbol end:'menuBtnEnd'

   //=========================================================
   
   //Edge symbol: 'pointMc0'
   (function(symbolName) {   
   
   })("pointMc0");
   //Edge symbol end:'pointMc0'

   //=========================================================
   
   //Edge symbol: 'pointMc2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.play(1);

      });
      //Edge binding end

   })("pointMc2");
   //Edge symbol end:'pointMc2'

   //=========================================================
   
   //Edge symbol: 'pointMc3'
   (function(symbolName) {   
   
   })("pointMc3");
   //Edge symbol end:'pointMc3'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews32693");