/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gn=32860;
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "data/api.php";
         //CHECK DATE
         var pollsOpen = Date.parse("May 7, 2015, 05:59 UTC");
         var pollsClose = Date.parse("May 7, 2015, 20:59 UTC");
         var todayDate;
         var status;
         function getDate(){
         	todayDate = new Date();
         	if(todayDate<pollsOpen){
         		status=0;
         	}else if(todayDate>pollsClose){
         		status=2;
         	}else{
         		status=1;
         		sym.$('txt11').fadeOut(0);
         	}
         }
         getDate();
         sym.$("Stage").on('mouseover touchstart',function(){sym.$('txt11').fadeOut(0);});
         //GET QUERY STRING PARAMETERS TO SHOW ZOOM
         var get = [];
         location.search.replace('?', '').split('&').forEach(function (val) {
           split = val.split("=", 2);
           get[split[0]] = split[1];
         });
         var zoom=0;//Is map zoomed already?
         var targetCon=0;//Selected constituency
         var targetParty="all";//Selected party
         //SIZE CONDITIONAL
         var mob=(sym.$("Stage").width()>480)?0:1;
         var clicked;
         var graph;
         var map;
         for (var i=0;i<4;i++){
         	sym.getSymbol("styleHead").getSymbol("menuBtn"+i).$("menuIcon").attr('src',"images/icon"+i+".png");
         }
         var menuTxt=sym.getSymbol("styleHead").$("menutxt");
         var screenArr=['geographic','proportional'];
         var menuTxtArr=[];
         var partyArr, partyShortArr, regionArr, constitArr, declaredArr;
         var txtArr=[];
         txtArr[0]=sym.getSymbol("graphBtn").$('txt1').css({'pointer-events':'none'});
         txtArr[1]=sym.getSymbol("graphBtn").$('txt2').css({'pointer-events':'none'});
         txtArr[2]=sym.getSymbol("partyBtnMc").$('txt3').css({'pointer-events':'none'});
         txtArr[3]=sym.$('txt4').css({'pointer-events':'none'});
         txtArr[4]=sym.$('txt5').css({'pointer-events':'none'});
         txtArr[5]=sym.$('txt6').css({'pointer-events':'none'});
         txtArr[6]=sym.$('txt7').css({'pointer-events':'none'});
         txtArr[7]=sym.$('txt8').css({'pointer-events':'none'});
         txtArr[8]=sym.$('txt9').css({'pointer-events':'none'});
         txtArr[9]=sym.getSymbol("zoomoutBtn").$('txt10').css({'pointer-events':'none'});
         txtArr[10]=sym.$('txt10').css({'pointer-events':'none'});
         txtArr[11]=sym.$('txt11').css({'pointer-events':'none'});
         var txt=[];
         //AJAX retrieves data, captions from xml source
         $.ajax({	
         	type: "GET",
         	url: "GN"+gn+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		var headline=$(xml).find('headline').text();
         		var source=$(xml).find('source').text();
         		sym.getSymbol('styleHead').$('headlinetxt').html(headline);
         		sym.getSymbol('styleBase').$('sourceTxt').html(source);
         		for (var i=0;i<4;i++){ //get menu labels
         			menuTxtArr[i]= $(xml).find('menu'+i).text();
         		}
         		for (var i=0;i<13;i++){
         			txt[i]=$(xml).find('txt'+i).text();
         			if(i<txtArr.length){
         				txtArr[i].html(txt[i]);
         			}
         		}
         		status==0?sym.$('txt11').fadeIn(0):sym.$('txt11').fadeOut(0);
         		var regiontxt=$(xml).find('regions').text();
         		regionArr=regiontxt.split(';');	
         		for (var i=0;i<regionArr.length-1;i++){
         			sym.getSymbol("geographic").getSymbol("zoomBtnMc").$('zoomTxt'+i).html(regionArr[i+1]);
         			sym.getSymbol("proportional").$('cartoTxt'+i).html(regionArr[i]);
         		}
         		var partytxt=$(xml).find('parties').text();
         		partyArr=partytxt.split(';');
         		var partyShort=$(xml).find('partyShort').text();
         		partyShortArr=partyShort.split(';');
         		for (var p=0;p<partyArr.length;p++){
         			sym.getSymbol("partyBtnMc").$('btnTxt'+p).html(partyArr[p]);
         			if(p>0){
         			sym.getSymbol("proportional").getSymbol("keyMc").$('keyTxt').append(partyShortArr[p]+"<br>");
         			}
         		}
         		sym.getSymbol("proportional").getSymbol("keyMc").$('keyTxt').css({'font-family':'pragmatica-web,sans-serif','font-size':'13px','text-align':'right'})
         		var declared=$(xml).find('declared').text();
         		declaredArr=declared.split(';');
         		var constits=$(xml).find('constituencies').text();
         		constitArr=constits.split(';');
         		var constitJSON=[];
         		var htmlTable="<div class='conTable'>";
         		for (var c=0;c<constitArr.length;c++){	
         			htmlTable+="<div id='c"+c+"' class='constit'><table class='conTable'><tr><td class='name'>"+constitArr[c]+"</td><td id='win"+c+"' class='winner'></td></td><td class='col'><div class='blob' id='col"+c+"'></div></td></tr></table></div>"
         			constitJSON[c]={ value: constitArr[c], data: 'c'+c };
         		}
         		htmlTable+="</div>";		
         		sym.$("constituencies").append(htmlTable);
         		sym.$("constituencies").css({'overflow-y':'auto'});
         		sym.$(".conTable").css({'width':'100%'});
         		$('.constit').css({'font-family':'pragmatica-web, sans-serif','font-size':'13px','border-top':'solid 1px rgb(255,255,255)','border-bottom':'solid 1px rgb(150,150,150)','width':'100%'});
         		$('.col').css({'width':'5%'});
         		$('.blob').css({'height':'16px','width':'16px','border-radius':'8px','background-color':'rgb(200,200,200)','right':'5px','vertical-align':'middle'});
         		mob==0?($('.winner').css({'display':'none'}),$('.name').css({'width':'95%'})):($('.winner').css({'width':'45%','font-style':'italic','text-align':'right'}),$('.name').css({'width':'50%','font-weight':700}));
         		//AUTO-COMPLETE
         		var acDiv="<input type='text' name='constituency' placeholder='"+txt[12]+"' id='autocomplete' style='width:98%;font-size:14px;font-family:pragmatica-web,sans-serif;border:solid 1px rgb(150,150,150)'>";
         		sym.$("autocomp").append(acDiv);
         		sym.$("autocomp").css({'padding':0});
         		$("#autocomplete").css({'margin':0});
         		$('#autocomplete').autocomplete({
         			lookup: constitJSON,
         			onSelect: function (suggestion) {
         				for (var i=1;i<constits.length+1;i++){
         					$('#c'+i).css({'background-color':'rgba(255,200,150,0)'});
         				}
         				sym.$('constituencies').animate({scrollTop:$('#c0').position().top}, 0,
         						function(){sym.$('constituencies').animate({scrollTop:$('#'+suggestion.data).position().top}, 200);
         				});
         				$('#'+suggestion.data).css({'background-color':'rgba(255,200,150,0.3)'});
         			}
         		});
         		$(".autocomplete-suggestions").css({'padding-left':'2px',
         		'font-family':'pragmatica-web, sans-serif',
         		'font-size':'13px','color':'rgb(50,75,150)',
         		'background-color':'rgb(255,255,255)',
         		'box-shadow':'3px 3px 3px rgba(150,150,150,0.5)',
         		'max-height':'140px','overflow':'hidden'});
         		$(".autocomplete-suggestion").css({});
         		$(".autocomplete-selected").css({});
         		$(".autocomplete-group").css({});
         		$(".autocomplete-group strong").css({});
            },
            complete:function(){
         		initSize();
            }
         }); // END XML
         //MOBILE
         function initSize(){
         	if(sym.$("Stage").width()<800){
         		graph=0;map=0;
         	}else{
         		graph=1;map=1;
         	}
         	if(sym.$("Stage").width()<640){
         		sym.$("notes").fadeOut(0);sym.$("txt4").fadeOut(0);
         	}else{
         		sym.$("notes").fadeIn(0);
         		if (clicked==1){
         				sym.$("txt4").fadeIn(0);
         			}
         	}
         	if (sym.$("Stage").width()<480){
         		mob=1;
         		menuTxt.html(menuTxtArr[1]);
         		sym.getSymbol('styleHead').$('headlinetxt').css({'font-size':'20px'});
         		sym.$("geographic").css({'opacity':0});
         		sym.getSymbol("styleHead").$("menuBtn0").fadeOut(0);
         		sym.$("txt5").css({'right':'5%','width':'50%','left':'auto'});
         		$(".hr").css({'width':'100%'});
         		sym.$("graph").css({'width':'95%'});
         		sym.$("autocomp").css({'top':'83px','left':'2%','width':'96%'});
         		sym.$("constituencies").css({'top':'110px','left':'2%','width':'96%','height':'465px'});
         		menuTxt.css({'top':'53px','right':'5px','color':'rgb(0,0,0)'});
         		txtArr[10].css({'top':'53px'});
         		$(".autocomplete-suggestions").css({'max-height':'150px'});
         		sym.$("voteCounter").css({'right':'15%'});
         		sym.$("partyBtnMc").fadeOut(0);
         		sym.$("proportional").css({'right':'-12px','bottom':'20px'});
         		clicked=1;
         		for (var i=0;i<4;i++){
         			sym.getSymbol("styleHead").$("menuBtn"+i).css({'right':90-((i-1)*45)+'px'});
         			sym.getSymbol("proportional").$("cartoTxt"+i).fadeOut(0);
         			if (clicked==i){
         				sym.getSymbol("styleHead").getSymbol("menuBtn" +i).$("menuBg").fadeOut(0);
         			}else{
         				sym.getSymbol("styleHead").getSymbol("menuBtn" +i).$("menuBg").fadeIn(0);
         			}
         		}
         		sym.$("graphBtn").fadeOut(0);
         		sym.$("zoomoutBtn").fadeOut(0);
         		sym.$("voteCounter").fadeOut(0);
         		sym.$("constituencies").fadeOut(0);
         		sym.$("autocomp").fadeOut(0);
         		sym.getSymbol("proportional").$("keyMc").fadeIn(0);
         		txtArr[10].fadeIn(400);
         		sym.$('graph').off('click');
         		sym.getSymbol("proportional").$("prop").css({'right':'3%','left':'auto'});
         		if(sym.$("Stage").width()<400){
         			sym.getSymbol("proportional").$("prop").css({'right':0,'-webkit-transform':'scale(0.8,0.9)',
         			'-ms-transform':'scale(0.8,0.9)',
         			'-moz-transform':'scale(0.8,0.9)',
         			'transform':'scale(0.8,0.9)',
         			'-webkit-transform-origin-x':'100%',
         			'-ms-transform-origin-x':'100%',
         			'-moz-transform-origin-x':'100%',
         			'transform-origin-x':'100%'
         			});
         		}else{
         			sym.getSymbol("proportional").$("prop").css({'-webkit-transform':'scale(1,1)',
         			'-ms-transform':'scale(1,1)',
         			'-moz-transform':'scale(1,1)',
         			'transform':'scale(1,1)',
         			'-webkit-transform-origin-x':'50%',
         			'-ms-transform-origin-x':'50%',
         			'-moz-transform-origin-x':'50%',
         			'transform-origin-x':'50%'
         			})
         		}
         	}else{
         			mob=0;
         		sym.getSymbol('styleHead').$('headlinetxt').css({'font-size':'24px'});
         			sym.getSymbol("styleHead").$("menuBtn0").fadeIn(0);
         			sym.$("geographic").css({'opacity':1});
         			sym.$("partyBtnMc").fadeIn(0);
         			sym.$("txt5").css({'left':'0.8%','width':'117px','right':'auto'});
         			txtArr[10].css({'top':'84px','width':'35%'});
         			$(".hr").css({'width':'22%'});
         			sym.$("graph").css({'width':'68%'});
         			sym.$("autocomp").css({'top':'414px','right':'0.8%','width':'30%','left':'auto'});
         			sym.$("constituencies").css({'top':'441px','right':'0.6%','width':'30%','height':'136px','left':'auto'});
         			menuTxt.css({'top':'19px','right':'95px','color':'rgb(255,255,255)'});
         			$(".autocomplete-suggestions").css({'max-height':'140px'});
         			sym.$("voteCounter").css({'right':'35%'});
         			for (var i=0;i<4;i++){
         				sym.getSymbol("styleHead").$("menuBtn"+i).css({'right':45-(i*45)+'px'});
         				sym.getSymbol("proportional").$("cartoTxt"+i).fadeIn(0);
         				sym.getSymbol("styleHead").getSymbol("menuBtn" +i).$("menuBg").fadeIn(0);
         			}
         			if (clicked!=1){
         				sym.$("proportional").css({'bottom':'600px'});
         				sym.$("geographic").css({'bottom':'20px'});
         				sym.$("graphBtn").fadeIn(0);
         				txtArr[10].fadeIn(400);
         				clicked=0;
         			}else{
         				sym.$("proportional").css({'bottom':'20px'});
         				sym.$("geographic").css({'bottom':'600px'});
         				txtArr[10].fadeOut(0);
         				clicked=1;
         				graph=0;
         			}
         			sym.$("proportional").css({'right':'30.6%','left':'auto'});
         					sym.getSymbol("proportional").$("prop").css({'right':'auto','left':0});
         			sym.getSymbol("styleHead").getSymbol("menuBtn"+clicked).$("menuBg").fadeOut(0);
         			menuTxt.html(menuTxtArr[clicked]);
         			sym.$("voteCounter").fadeOut(0);
         			sym.$("constituencies").fadeIn(0);
         			sym.$("autocomp").fadeIn(0);
         			sym.getSymbol("proportional").$("keyMc").fadeOut(0);
         			sym.$('graph').on('click',showGraph);
         	}
         	showGraph();
         }
         // MENU BUTTONS --------------------------------------------	
         menuArray = []; //the array that will hold references to the buttons.
         for (var m = 0; m < 4; m++){
         	var menuBtnSymbols = sym.getSymbol("styleHead").getSymbol("menuBtn" +m); 
         	menuBtnSymbols.setVariable("menuId", m);
         	menuArray.push(menuBtnSymbols);
         	sym.getSymbol("styleHead").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         $.each(menuArray, function( count, menuInTheArray ){
         				var menuBtnElement = menuInTheArray.getSymbolElement();
         				menuBtnElement.off ("click",menuBtnClick);
         					menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
         					menuBtnElement.on ("mouseover", {menuId:count}, menuBtnOver);
         					menuBtnElement.on ("mouseout", {menuId:count}, menuBtnOut);
         				});
         function resetmenu(){
         	for (var i=0;i<menuArray.length;i++){
         		menuArray[i].$("menuBg").fadeIn(0);
         	}
         }
         function menuBtnClick (e){
         		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         		clicked=menuMenu_id;
         		for (var i=0;i<menuArray.length;i++){
         			if(i==menuMenu_id){
         				menuArray[menuMenu_id].$("menuBg").fadeOut(0);
         				menuTxt.html(menuTxtArr[menuMenu_id]);
         				if(mob==0){
         					sym.$(screenArr[menuMenu_id]).animate({'bottom':20},0);
         					if(i==0){
         						if(zoom==0){
         							sym.$('graphBtn').fadeIn(0);
         							sym.$("zoomoutBtn").fadeOut(0);
         						}else{
         							sym.$("zoomoutBtn").fadeIn(0);
         						}
         						sym.$('txt4').fadeOut(0);
         						txtArr[10].fadeIn(400);
         						//graph=1;//show graph when viewing geo map
         					}else{
         						sym.$('graphBtn').fadeOut(0);
         						sym.$("zoomoutBtn").fadeOut(0);
         						txtArr[10].fadeOut(0);
         						if(sym.$("Stage").width()>640){
         							sym.$('txt4').fadeIn(0);
         						}
         					}
         					graph=0;
         					showGraph();
         				}else{
         					switch (i){
         						case 1:
         						sym.$(screenArr[1]).animate({'bottom':20},0);
         						sym.$("constituencies").fadeOut(400);
         						sym.$("autocomp").fadeOut(400);
         						graph=0;showGraph();
         						txtArr[10].css({'width':'35%'});
         						break;
         						case 2:
         						sym.$("constituencies").fadeIn(400);
         						sym.$("autocomp").fadeIn(400);
         						graph=0;showGraph();
         						sym.$(screenArr[1]).animate({'bottom':600},0);
         						txtArr[10].css({'width':'50%'});
         						break;
         						case 3:
         						graph=1;showGraph();
         						sym.$("constituencies").fadeOut(400);
         						sym.$("autocomp").fadeOut(400);
         						sym.$(screenArr[1]).animate({'bottom':600},0);
         						txtArr[10].css({'width':'35%'});
         						break;
         					}
         				}
         			}else{
         				sym.$(screenArr[i]).animate({'bottom':600},0);
         				menuArray[i].$("menuBg").fadeIn(0);
         			}
         		}
         		e.preventDefault();
         		e.stopPropagation();
         }
         function menuBtnOver(e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId);
         	menuArray[menuMenu_id].$("menuBg").fadeOut(0);
         	menuTxt.html(menuTxtArr[menuMenu_id]);
         }
         function menuBtnOut(e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId);
         	for (var i=0;i<menuArray.length;i++){
         		if(menuMenu_id!=clicked){
         			menuArray[menuMenu_id].$("menuBg").fadeIn(0);
         			menuTxt.html(menuTxtArr[clicked]);
         		}
         	}
         }
         //PARTY COLOURS
         function partyColors(){
         $(".lab").css({'background-color':'#FF3049'});$(".con").css({'background-color':'#0077C0'});$(".lib").css({'background-color':'#FFD520'});
         $(".snp").css({'background-color':'#FF903D'});$(".pc").css({'background-color':'#A92958'});$(".grn").css({'background-color':'#009700'});
         $(".ukip").css({'background-color':'#90278F'});$(".uup").css({'background-color':'#5AC5C3'});$(".dup").css({'background-color':'#7E9DD2'});
         $(".sdlp").css({'background-color':'#F37574'});$(".sf").css({'background-color':'#89C53F'});$(".other").css({'background-color':'#CCCCFF'});
         }
         //SHOW HIDE GRAPH
         sym.$('graphBtn').on('click',showGraph);
         function showGraph(){ 
         		if(graph==0){ 
         			sym.$('graph').fadeOut(400);sym.$('txt5').fadeOut(400);sym.getSymbol('graphBtn').$('txt1').fadeOut(0);sym.getSymbol('graphBtn').$('txt2').fadeIn(0);graph=1;
         			if (map==0){
         				sym.$("voteCounter").fadeOut(0);
         			}
         			if(clicked==0){
         			sym.$("geographic").css({'bottom':'20px'});
         			}
         		}else{
         			sym.$('graph').fadeIn(400);sym.$('txt5').fadeIn(400);sym.getSymbol('graphBtn').$('txt1').fadeIn(0);sym.getSymbol('graphBtn').$('txt2').fadeOut(0);graph=0;
         			if (map==0){
         				sym.$("voteCounter").fadeIn(0);
         				sym.$("geographic").css({'bottom':'600px'});
         			}else{
         				sym.$("geographic").css({'bottom':'20px'});
         			}//show-hide map
         		}
         }
         sym.$('graphBtn').css({'cursor':'pointer'});
         //ZOOM MAP
         var regX=[260,203,285,375,365,365,440,425,275,425,0];
         var regY=[68,240,350,240,305,365,421,405,435,340,0];
         var regWidth=[125,50,65,35,45,30,18,55,75,55,555];
         var regHeight=[125,50,65,35,45,30,18,55,75,55,535];
         var tran;
         var conWidth;
         var conHeight;
         var conX;
         var conY;
         var zoomMap = function(number,svgDocument){ //to handle lexical scope
         	return function (e) {
         		conWidth=regWidth[number];
         		conHeight=regHeight[number];
         		conX=regX[number];
         		conY=regY[number];
         		var tranX=regX[number]+regWidth[number]/2;
         		var tranY=regY[number]+regHeight[number]/2;
         		var scale=0.5/Math.max(regWidth[number]/555,regHeight[number]/535);
         		tran=[555/2-scale*tranX,535/2-scale*tranY];	
         		if(number==10){
         			$("#UKwrapper",svgDocument).attr({'transform':''});
         			$(".lab, .con, .lib, .ukip, .grn, .snp, .pc, .dup, .sf, .sdlp, .other, .none", svgDocument).css({'stroke':'#aeaeae','stroke-width':"1px"});
         			sym.getSymbol("geographic").$("zoomBtnMc").fadeIn(0);sym.$("zoomoutBtn").fadeOut(0);sym.$('regionTxt').fadeOut(0);
         			sym.$("rollTxt").fadeOut(0);
         			zoom=0; graph=1;
         			showGraph;
         			targetParty="all";
         			//targetCon=0;
         			sym.$('graphBtn').fadeIn(0);
         		}else{
         			$("#UKwrapper",svgDocument).attr({'transform':'translate('+tran+')scale('+scale+')'});
         			$(".lab, .con, .lib, .ukip, .grn, .snp, .pc, .dup, .sf, .sdlp, .other, .none", svgDocument).css({'stroke':'#aeaeae','stroke-width':1/scale+"px"});
         			sym.getSymbol("geographic").$("zoomBtnMc").fadeOut(0);sym.$("zoomoutBtn").fadeIn(0);sym.$('regionTxt').fadeIn(0);
         			sym.$('regionTxt').html(regionArr[number+1]);
         			var capWidth=sym.$('regionTxt').width();
         			var symWidth=sym.$("styleHead").width()*35/100;
         			sym.$('regionTxt').css({'left':symWidth-capWidth/2});
         			sym.$('graphBtn').fadeOut(0);
         			zoom=1;
         		}
         		targetCon=0;
         		sym.getSymbol("geographic").$('constitTxt').fadeOut(0);
         		for(var i=0;i<constitArr.length;i++){
         			$('#temp'+i,svgDocument).remove();
         			$("#UK"+(i+1), svgDocument).animate({opacity:1.0},300);
         			$("#c"+i).css({'background-color':'rgba(255,200,150,0)','font-weight':400});
         		}
         		e.preventDefault();
               e.stopPropagation(); 
         	};
         };
         //SELECT CONSTITUENCY
         var selectName = function(number,svgDocument){ //to handle lexical scope
                  	return function (e) {
                  		for (var n=0;n<constitArr.length;n++){
                  			if (number==n){
                  				targetCon=number+1;
                  				$("#UK"+(number+1), svgDocument).animate({'opacity':1.0},0);
                  				$("#c"+number).css({'background-color':'rgba(255,200,150,0.3)','font-weight':700});
                  				sym.$('constituencies').animate({scrollTop:$('#c0').position().top}, 0,
         								function(){sym.$('constituencies').animate({scrollTop:$('#c'+number).position().top}, 200);
         							});
                  			}else{
                  				$("#UK"+(n+1), svgDocument).animate({opacity:0.45},300);
                  				$("#c"+n).css({'background-color':'rgba(255,200,150,0)','font-weight':400});
                  			}
                  		}
                  	targetParty="all";
                  	e.preventDefault();
                  	e.stopPropagation();
                  	};
                  };
         //SEARCH BY PARTY
         var showParty = function(party,svgDocument){ //to handle lexical scope
                  	return function (e) {
         				var partyClass=partyShortArr[party].toLowerCase();
         				targetParty=partyClass;
         				targetCon=0;
         				console.log(party);
         				for (var n=0;n<constitArr.length;n++){
                  			if(party>0){
         							if ($("#UK"+(n+1), svgDocument).attr('class')!=partyClass){
         								$("#UK"+(n+1), svgDocument).css({'opacity':0.45},0);
         							}else{
         								$("#UK"+(n+1), svgDocument).css({'opacity':1.0},300);
         							}
         						}else{
         								$("#UK"+(n+1), svgDocument).css({'opacity':1.0},300);
         						}
                  		}
                  	e.preventDefault();
                  	e.stopPropagation();
                  	};
                  };	
         //LIVE GRAPH
         function getSum(){
         	getDate();
         	$.ajax({ type: "GET", 
         				url: dataURL,
                     data: "gn="+gn+"&q=sum&yr=2015",
                     contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                     async: true,
                     crossDomain: true,
                     success: function (data) {         
         			var voteCount = data;
         			sym.$("graph").empty();
         			var totalVote=[];var colors=[];var parties=[];
         			if(voteCount){
         				for (var i = 0; i < voteCount.length; i++) {
         					colors[i]=(voteCount[i].name=="libdem")?"lib":voteCount[i].name;
         					totalVote[i]=voteCount[i].total;
         					var index=(partyShortArr.indexOf(colors[i].toUpperCase())>=0)?partyShortArr.indexOf(colors[i].toUpperCase()):11;
         					parties[i]=partyShortArr[index];
         				}
         				var highest=Math.max.apply(null,totalVote);
         				var max=(Math.max.apply(null,totalVote)<326)?325:Math.ceil(Math.max.apply(null,totalVote)/50)*50;
         				var maxHeight = 450;//100%
         				var majority=490-Math.round(326*maxHeight/max);
         				var barWidth=(totalVote.length>=11)?100*(sym.$("graph").width()/totalVote.length)/sym.$("graph").width()+"%":"10%";
         				var graph="<div class='hr'></div><div id='voteTable'>";
         				for (var v=0;v<totalVote.length;v++){
         					var votes=(totalVote[v]==highest)?"<b>"+totalVote[v]+"</b>":totalVote[v];
         					graph+="<div class='col' id='party"+v+"'>";
         					graph+="<div class='number' id='num"+v+"'>"+votes+"</div><div class='bar "+colors[v]+"' id='count"+v+"'></div><div class='nm' id='name"+v+"'>"+parties[v]+"</div>";
         					graph+="</div>";
         				}
         				graph+="</div>";
         				sym.$("graph").append(graph);
         				var marginTop=490-Math.round(highest*maxHeight/max)-33;//height-highest bar-name+number-border
         				$("#voteTable").css({'font-family':'pragmatica-web,sans-serif','height':'490px','margin-top':marginTop+'px'});
         				$(".col").css({'display':'inline-block','width':barWidth,'text-align':'center','vertical-align':'baseline','position':'relative'});
         				$(".bar").css({'height':0,'box-shadow':'2px 2px 3px rgba(150,150,150,0.65)','border':'solid 1px rgb(255,255,255)','margin':'0 4px'});
         				$(".number").css({'font-size':'15px','height':'20px'});
         				$(".hr").css({'height':'1px','position':'absolute','margin-top':majority+'px','background-color':'rgba(218,57,57,0.3)'});
         				mob==0?($(".nm").css({'font-size':'13px','font-weight':700,'height':'15px'}),$(".hr").css({'width':'22%'})):($(".nm").css({'font-size':'11px','font-weight':400,'height':'15px'}),$(".hr").css({'width':'100%'}));
         				partyColors();
         				for (var v=0;v<totalVote.length;v++){
         					$('#count'+v).css({'height':Math.round(totalVote[v]*maxHeight/max)});
         				}
         				//Angle per vote:
         				var cumulative=0;
         				for(var i=0;i<totalVote.length;i++) { cumulative += parseInt(totalVote[i]); }
         				var declared= (cumulative==0)?declaredArr[0]:declaredArr[1]+" <b>"+cumulative+"</b>";
         				var voteAngle = 360*cumulative/650;
         				sym.getSymbol("voteCounter").$("voteTxt").html(declared);
         				status>0?txtArr[10].html(declared):txtArr[10].html(txt[10]);
         				if (cumulative/650<0.5){
         					sym.getSymbol("voteCounter").$("laps1").animate({rotate:voteAngle},{
         					step: function(now,fx) {
         						$(this).css({'-webkit-transform':'rotate('+now+'deg)','-moz-transform':'rotate('+now+'deg)','-ms-transform':'rotate('+now+'deg)','-op-transform':'rotate('+now+'deg)','transform':'rotate('+now+'deg)'});
         					},duration:'fast'},'linear');
         				}else if (cumulative/650>=0.5){
         					sym.getSymbol("voteCounter").$("laps1").animate({rotate:180},{
         					step: function(now,fx) {
         						$(this).css({'-webkit-transform':'rotate(180deg)','-moz-transform':'rotate(180deg)','-ms-transform':'rotate(180deg)','-op-transform':'rotate(180deg)','transform':'rotate(180deg)'});
         					},duration:'fast'},'linear');
         					sym.getSymbol("voteCounter").$("laps2").show();
         					sym.getSymbol("voteCounter").$("laps2").animate({rotate:voteAngle},{
         					step: function(now,fx) {
         						$(this).css({'-webkit-transform':'rotate('+now+'deg)','-moz-transform':'rotate('+now+'deg)','-ms-transform':'rotate('+now+'deg)','-op-transform':'rotate('+now+'deg)','transform':'rotate('+now+'deg)'});
         					},duration:'fast'},'linear');
         				}
         			}else{
         				sym.$('graphBtn').css({'top':'8px'});
         			}
         		}
         	});
         	setTimeout(function(){getSum()}, 30000);
         }	
         getSum();
         //BUILD SVG MAP
         var regionVote=[];var regionWin=[];
         sym.$('regionTxt').css({'width':'auto','height':'auto','max-width':'300px','background-color':'rgba(0,0,0,0.5)','padding':'3px 5px','border-radius':'5px','pointer-events':'none'});
         sym.getSymbol("geographic").$('constitTxt').css({'width':'auto','height':'auto','max-width':'300px','background-color':'rgba(0,0,0,0.5)','padding':'3px 5px','border-radius':'5px','pointer-events':'none'});
         sym.$('rollTxt').css({'width':'auto','height':'auto','max-width':'555px','background-color':'rgba(255,255,255,0.5)','padding':'3px 5px','border-radius':'5px','pointer-events':'none'});
         sym.$('zoomoutBtn').css({'background-color':'rgba(255,255,255,0.5)','border-radius':'5px'});
         //----------------------------------------------
         EC.SVG.accessSVG(sym.getSymbol("geographic").$("uk")).done(
         	function(svgDocument){
         		//LIVE DATA
         		function getData(){
         			$.ajax({ type: "GET", 
         				url: dataURL,
                     data: "gn="+gn+"&q=data&yr=2015",
                     contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                     async: true,
                     crossDomain: true,
                     success: function (data) {         
         					var mapData = data;
                        regionVote=[];
         					if(mapData){
         						for (var i = 0; i < mapData.length; i++) {
         							regionVote[i]=(mapData[i].party=="libdem")?"lib":mapData[i].party;
         							var cno=mapData[i].index;
         							$("#"+(cno), svgDocument).attr({'class':regionVote[i]});
         							regionWin[i]=mapData[i].cap;
         							$('#win'+i).text(mapData[i].cap);
         						}
         					}
         				}
         			});
         			setTimeout(function(){getData()}, 60000);
         		}
         		getData();
         	//REGIONAL ZOOM
         		for (var c=0;c<10;c++){
         			sym.getSymbol('geographic').getSymbol('zoomBtnMc').$("zoomBtn"+c).on('click',zoomMap(c,svgDocument));
         			sym.getSymbol('geographic').getSymbol('zoomBtnMc').$("zoomBtn"+c).css({'cursor':'pointer'});
         		}
         		sym.$("zoomoutBtn").on('click',zoomMap(10,svgDocument));
         		sym.$("zoomoutBtn").css({'cursor':'pointer'});
         		//SELECT BY PARTY
         		for (var p=0;p<partyArr.length;p++){
         					sym.getSymbol("partyBtnMc").$('partyBtn'+p).on('click',showParty(p,svgDocument));
         		}
         		//SHOW CONSTITUENCY
         		for (var i=0;i<constitArr.length;i++){
         			$("#c"+i).on("click",selectName(i,svgDocument));//selectName
         			$('#c'+i).css({'cursor':'pointer'});
         			$("#UK"+i, svgDocument).on("click",clickConstit);
         			$("#UK"+i, svgDocument).on("mouseover",overConstit);
         			$("#UK"+i, svgDocument).on("mouseout",outConstit);
         		}
         		function clickConstit(event){
         			sym.setVariable("selectedPart", event.target);
         			var constitSelect = sym.getVariable("selectedPart");
         			for (var i=0; i<constitArr.length; i++){
         				if (event.target.id=="UK"+(i+1)){
         					if (zoom==0||targetCon!=i+1){//
         						var bBox=constitSelect.getBBox();
         						conWidth=bBox.width;
         						conHeight=bBox.height;
         						conX=bBox.x;
         						conY=bBox.y;
         						var tranX=conX+conWidth/2;
         						var tranY=conY+conHeight/2;
         						var scale=0.5/Math.max(conWidth/555,conHeight/535);
         						tran=[555/2-scale*tranX,535/2-scale*tranY];
         						$("#c"+i).css({'background-color':'rgba(255,200,150,0.3)','font-weight':700});
         						$(".lab, .con, .lib, .ukip, .grn, .snp, .pc, .dup, .sf, .sdlp, .other, .none", svgDocument).css({'stroke':'#aeaeae','stroke-width':1/scale+"px"});
         						sym.$('constituencies').animate({scrollTop:$('#c0').position().top}, 0,
         						function(){sym.$('constituencies').animate({scrollTop:$('#c'+i).position().top}, 200);
         						});
         						sym.getSymbol("geographic").$("zoomBtnMc").fadeOut(0);sym.$("zoomoutBtn").fadeIn(0);
         						graph=0;
         						showGraph;
         						sym.$('graphBtn').fadeOut(0);
         						sym.getSymbol("geographic").$('constitTxt').html("<b>"+constitArr[i]+"</b><br><i>"+regionWin[i]+"</i>");
         						var capWidth=sym.getSymbol("geographic").$('constitTxt').width();
         						sym.getSymbol("geographic").$('constitTxt').css({'left':277-capWidth/2});
         						sym.getSymbol("geographic").$('constitTxt').fadeIn(0);
         						sym.$('regionTxt').fadeOut(0);
         						$("#UKwrapper",svgDocument).attr({'transform':'translate('+tran+')scale('+scale+')'});
         						constitSelect.style.opacity=1.0;
         						constitSelect.style.stroke="#FFFFFF";
         						constitSelect.style['stroke-width']=4/scale+"px";
         						zoom=1;
         						targetCon=i+1;
         					}else{
         						$("#UKwrapper",svgDocument).attr({'transform':''});
         						$(".lab, .con, .lib, .ukip, .grn, .snp, .pc, .dup, .sf, .sdlp, .other, .none", svgDocument).css({'stroke':'#aeaeae','stroke-width':"1px"});
         						sym.getSymbol("geographic").$("zoomBtnMc").fadeIn(0);sym.$("zoomoutBtn").fadeOut(0);
         						sym.getSymbol("geographic").$('constitTxt').fadeOut(0);sym.$("rollTxt").fadeOut(0);
         						sym.$('graphBtn').fadeIn(0);
         						zoom=0;
         					}
         				}else{
         					$("#c"+i).css({'background-color':'rgba(255,200,150,0)','font-weight':400});
         					$("#UK"+(i+1), svgDocument).animate({opacity:0.45},300);
         				}
         				$('#temp'+i,svgDocument).remove();
         			}
         						targetParty="all";
         		}
         		function overConstit(event){
         			sym.setVariable("overPart", event.target);
         			var constitOver = sym.getVariable("overPart");
         			if(constitOver.getAttribute('class')==targetParty||targetParty=="all"){//targetCon!=i+1
         				if(targetCon!=parseInt(event.target.id.substr(2),10)){
         					if(targetCon<1||targetParty!="all"){
         						constitOver.style.opacity=0.45;
         					}else{
         						constitOver.style.opacity=1.0;
         					}
         				}
         				for (var i=0; i<constitArr.length; i++){
         					if(zoom==1){
         						if(event.target.id=="UK"+(i+1)){
         							if(targetCon!=i+1){
         								sym.$("rollTxt").html(constitArr[i]);
         								var capWidth=sym.$('rollTxt').width();
         								var symWidth=sym.$("styleHead").width()*35/100;
         								sym.$('rollTxt').css({'left':symWidth-capWidth/2});
         								sym.$("rollTxt").fadeIn(0);
         							}
         						}
         					}
         				}
         			}
         		}
         		function outConstit(event){
         			sym.setVariable("outPart", event.target);
         			var constitOut = sym.getVariable("outPart");
         					if(constitOut.getAttribute('class')==targetParty||targetParty=="all"){
         						if(targetCon!=parseInt(event.target.id.substr(2),10)){
         							if(targetCon<1||targetParty!="all"){
         								constitOut.style.opacity=1.0;
         							}else{
         								constitOut.style.opacity=0.45;
         							}
         						}
         						if(zoom==1){
         							for (var i=0; i<constitArr.length; i++){
         								$('#temp'+i,svgDocument).remove();
         								sym.$("rollTxt").fadeOut(0);
         							}
         						}
         					}
         		}
         	function autoZoom(){
         		if (get["z"] + "" != "undefined"){// Check if there is a zoomID
         			var zoomIn=parseInt(get["z"],10);
         			sym.$('graphBtn').fadeOut(0);
         			sym.$("graph").fadeOut(0);
         			sym.$("txt5").fadeOut(0);
         			sym.getSymbol('graphBtn').$('txt1').fadeOut(0);sym.getSymbol('graphBtn').$('txt2').fadeIn(0);graph=1
         			$(document).ready(zoomMap(zoomIn,svgDocument));
         		}
         	}
         	autoZoom();
         });
         EC.SVG.accessSVG(sym.getSymbol("proportional").$("prop")).done(
         	function(svgDocument){
         		function getProportional(){
         			for(var i=0;i<constitArr.length;i++){
         				$("#UK"+(i+1), svgDocument).attr({'class':regionVote[i]});
         				$("#col"+i).attr('class','blob '+regionVote[i]);
         			}
         		partyColors()
         		setTimeout(function(){getProportional()}, 30000);
         		}
         		setTimeout(function(){getProportional()}, 2500);
         		//SELECT BY PARTY
         		for (var p=0;p<partyArr.length;p++){
         					sym.getSymbol("partyBtnMc").$('partyBtn'+p).on('click',showParty(p,svgDocument));
         		}
         		//SHOW CONSTITUENCY
         		for (var i=0;i<constitArr.length;i++){
         			$("#c"+i).on("click",selectName(i,svgDocument));
         		}
         	});
         sym.play();
         $(window).on('resize',initSize);

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleHead");
   //Edge symbol end:'StyleHead'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'zoom'
   (function(symbolName) {   
   
   })("zoom");
   //Edge symbol end:'zoom'

   //=========================================================
   
   //Edge symbol: 'zoomBtnMc'
   (function(symbolName) {   
   
   })("zoomBtnMc");
   //Edge symbol end:'zoomBtnMc'

   //=========================================================
   
   //Edge symbol: 'partyBtnMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.$("partylines0").css({'border-top':'dotted 2px rgb(150,150,150)'});

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 650, function(sym, e) {
         sym.$("partylines0").css({'border-bottom':'dotted 2px rgb(150,150,150)'});

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.$("partylines1").css({'border-top':'dotted 2px rgb(150,150,150)'});

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 850, function(sym, e) {
         sym.$("partylines1").css({'border-bottom':'dotted 2px rgb(150,150,150)'});

      });
      //Edge binding end

   })("partyBtnMc");
   //Edge symbol end:'partyBtnMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'StyleHead_1'
   (function(symbolName) {   
   
   })("Base");
   //Edge symbol end:'Base'

   //=========================================================
   
   //Edge symbol: 'proportional'
   (function(symbolName) {   
   
   })("proportional");
   //Edge symbol end:'proportional'

   //=========================================================
   
   //Edge symbol: 'geographic'
   (function(symbolName) {   
   
   })("geographic");
   //Edge symbol end:'geographic'

   //=========================================================
   
   //Edge symbol: 'graphBtn'
   (function(symbolName) {   
   
   })("graphBtn");
   //Edge symbol end:'graphBtn'

   //=========================================================
   
   //Edge symbol: 'zoomBtn'
   (function(symbolName) {   
   
   })("zoomBtn");
   //Edge symbol end:'zoomBtn'

   //=========================================================
   
   //Edge symbol: 'zoomOutBtn'
   (function(symbolName) {   
   
   })("zoomOutBtn");
   //Edge symbol end:'zoomOutBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'lapCounter'
   (function(symbolName) {   
   
   })("lapCounter");
   //Edge symbol end:'lapCounter'

   //=========================================================
   
   //Edge symbol: 'Key'
   (function(symbolName) {   
   
   })("Key");
   //Edge symbol end:'Key'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32860");