/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 20;
         	var btnNo = 0;
         	var budge = 5;
         	var menuNo2 = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var whiteBoxWidth = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "width":"auto", "padding":"6px", "padding-left":"25px"};
         	
         	var yellowBoxWidth = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white",
         	"background-color":"rgba(250,175,25,1)", "width":"auto", "padding":"6px"};
         	
         	var yellowBoxHeight = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white",
         	"background-color":"rgba(250,175,25,1)", "height":"auto", "padding":"6px"};
         	
         	var blueBoxHeight2 = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white",
         	"background-color":"rgba(0,0,0,1)", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         	//rgba(205,210,220,1)
         	var whiteBoxHeight = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto", "padding":"6px"};
         	
         	var blueBoxHeight = {"background-color":"rgba(205,210,220,1)", "height":"auto", "padding":"6px", "padding-right":"110px"};
         	
         	var txt=[];
         	txt[0] = sym.getSymbol("scene1Mc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("scene1Mc").$("txt1").css(yellowBoxWidth);
         	txt[2] = sym.getSymbol("scene1Mc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("scene1Mc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("scene1Mc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("scene1Mc").$("txt5").css(whiteBoxWidth);
         	txt[6] = sym.getSymbol("scene1Mc").$("txt6").css(whiteBoxHeight);
         	txt[7] = sym.getSymbol("cryptMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("cryptMc").$("txt8").css(yellowBoxHeight);
         	txt[9] = sym.getSymbol("cryptMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("cryptMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("cryptMc").$("txt11").css(blueBoxHeight);
         	txt[12] = sym.getSymbol("cryptMc").$("txt12").css({"pointer-events":"none", "height":"auto"});
         	txt[13] = sym.getSymbol("menuBtnsMc").$("txt13").css(blueBoxHeight2);
         	txt[14] = sym.getSymbol("menuBtnsMc").$("txt14").css(blueBoxHeight2);
         	txt[15] = sym.getSymbol("menuBtnsMc").$("txt15").css(blueBoxHeight2);
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32655.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<16; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			sym.getSymbol("scene1Mc").$("txt1").animate({left:100 - sym.getSymbol("scene1Mc").$("txt1").width()-0}, 0);
         			sym.getSymbol("scene1Mc").$("txt6").animate({top:540 - sym.getSymbol("scene1Mc").$("txt6").height()-0}, 0);
         			sym.getSymbol("cryptMc").$("txt8").animate({top:565 - sym.getSymbol("cryptMc").$("txt8").height()-0}, 0);
         			sym.getSymbol("cryptMc").$("txt12").animate({top:343 - sym.getSymbol("cryptMc").$("txt12").height()-0}, 0);
         			sym.getSymbol("cryptMc").$("scene2Point").animate({top:565 - sym.getSymbol("cryptMc").$("txt8").height()-43}, 0);
         	
         		}
         	}); // END XML
         	
         	sym.$("crypt").stop().delay(0).animate ({opacity:0}, 0);
         	sym.$("cryptMc").stop().delay(0).animate ({opacity:0}, 0);
         	sym.$("menuBtnsMc").stop().delay(0).animate ({opacity:0}, 0);
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 0);
         	
         // BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("btnPlus").fadeIn(0);
         		sym.getSymbol("menuBtnsMc").$("txt13").stop().animate ({opacity:0}, 100);
         		sym.getSymbol("menuBtnsMc").$("txt14").stop().animate ({opacity:0}, 100);
         		sym.getSymbol("menuBtnsMc").$("txt15").stop().animate ({opacity:0}, 100);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		menuNo2 = menuNo;
         		buttonClicked();
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnOver").stop().animate ({opacity:0.3}, 200);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnOver").stop().animate ({opacity:0.0}, 200);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         
         function buttonClicked() {
         	resetmenu();
         		btnNo = menuNo2;
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo2).$("btnPlus").fadeOut(0);
         		sym.getSymbol("menuBtnsMc").$("txt"+(menuNo2 + 13)).stop().animate ({opacity:1}, 0);
         
         		if (clicked == btnNo){
         			resetmenu();
         			clicked = 20;
         		}else{
         			clicked = menuNo2;
         		}
         }
         
         
         // TOGGLE BUTTON
         sym.$("toggleBtn").on(clickEventType, function(e){
         	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible")) {
         		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
         		sym.$("crypt").stop().delay(0).animate ({opacity:1}, 300, 'easeOutCubic', function(){
         			sym.$("scene1Mc").stop().delay(0).animate ({opacity:0}, 500);
         			sym.$("crypt").stop().delay(0).animate ({left:0, top:0, width:600, height:600}, 1000, 'easeOutCubic', function(){
         				sym.$("cryptMc").stop().delay(0).animate ({opacity:1}, 500, 'easeInCubic');
         				sym.getSymbol("cryptMc").$("wood").stop().delay(0).animate ({top:0}, 700, 'easeOutCubic');
         				sym.$("toggleBtn").stop().delay(0).animate ({left:10, top:455}, 600, 'easeOutCubic');
         				sym.$("skeleton").stop().delay(0).animate ({left:0}, 700, 'easeOutCubic', function(){
         					sym.$("menuBtnsMc").stop().delay(0).animate ({opacity:1}, 500);
         				});
         			});
         		});
         	}else{
         		resetmenu();
         		clicked = 20;
         		sym.$("cryptMc").stop().delay(0).animate ({opacity:0}, 200);
         		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
         		sym.$("toggleBtn").stop().animate ({left:70, top:508}, 600, 'easeOutCubic');
         		sym.$("menuBtnsMc").stop().delay(0).animate ({opacity:0}, 200);
         		sym.$("skeleton").stop().delay(0).animate ({left:190}, 300, 'easeInCubic');
         		sym.getSymbol("cryptMc").$("wood").stop().delay(0).animate ({top:240}, 300, 'easeInCubic');
         		sym.$("scene1Mc").stop().delay(0).animate ({opacity:1}, 800, 'easeInCubic');
         		sym.$("crypt").stop().delay(0).animate ({left:85, top:405, width:80, height:107}, 600, 'easeOutCubic', function(){
         			sym.$("crypt").stop().delay(0).animate ({opacity:0}, 300, 'easeInCubic');
         		});
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         
         sym.$("toggleBtn").mouseover(function(){
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
         	e.stopPropagation(); e.preventDefault();
         });
         sym.$("toggleBtn").mouseout(function(){
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
         	e.stopPropagation(); e.preventDefault();
         });

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'scene1Mc'
   (function(symbolName) {   
   
   })("scene1Mc");
   //Edge symbol end:'scene1Mc'

   //=========================================================
   
   //Edge symbol: 'cryptMc'
   (function(symbolName) {   
   
   })("cryptMc");
   //Edge symbol end:'cryptMc'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews32655");