/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var hot = 0;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var strap1 = "<div style='float:left; margin-right:5px; margin-left:0px; background-color:#da0000; padding:6px'></div>";
         	
         	var txtBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var outBtn  = {"background-color":"rgba(255,255,255,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	for(var i=0;i<22;i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[10] = sym.$("txt10").css(txtBox);
         	txt[11] = sym.$("txt11").css(txtBox);
         	txt[12] = sym.$("txt12").css(txtBox);
         	txt[14] = sym.$("txt14").css({"height":"auto"});
         	txt[17] = sym.$("txt17").css({"height":"auto", "background-color":"rgba(255,255,255,1)", "padding":"10px", "padding-bottom":"70px", "box-shadow":"0px 0px 8px rgba(0,0,0,0.7)"});
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32651.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			var headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			var headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			var stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			var stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			var source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<22; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			sym.$("txt14").animate({top:196 - sym.$("txt14").height()+10}, 0);
         	
         			sym.$("txt17").empty();		
         			var capTxt = strap1 + txtArr[17] +"<hr>"+ strap1 + txtArr[18] +"<hr>"+ strap1 + txtArr[19]  + "<hr>" + strap1 + txtArr[20] +"<hr>"+ strap1 + txtArr[21];
         			sym.$("txt17").html(capTxt);
         	
         		}
         	}); // END XML
         	
         	sym.getSymbol("hotBtn").$("arrowDn").fadeOut(0);
         	sym.$("hot").animate({opacity:0}, 0);
         	sym.$("txt14").animate({opacity:0}, 0);
         	sym.$("txt15").animate({opacity:0}, 0);
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("txt").html("2015");
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn1").$("txt").html("2090");
         	
         sym.$("hotBtn").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	btnClick();
         	});
         sym.$("hotBtn").mouseover(function(){
         	sym.getSymbol("hotBtn").$("btnBg").css({"background-color":"#da0000"});
         	});
         sym.$("hotBtn").mouseout(function(){
         	sym.getSymbol("hotBtn").$("btnBg").css({"background-color":"#000000"});
         	});
         
         // START CLICK FUNCTION
         function btnClick(){
         	if (hot == 0) {
         		sym.getSymbol("hotBtn").$("arrowUp").fadeOut(0);
         		sym.getSymbol("hotBtn").$("arrowDn").fadeIn(0);
         		sym.$("txt17").animate({top:460 - sym.$("txt17").height()-60}, 300);
         		hot=1;
         	}else{
         		sym.getSymbol("hotBtn").$("arrowUp").fadeIn(0);
         		sym.getSymbol("hotBtn").$("arrowDn").fadeOut(0);
         		sym.$("txt17").animate({top:460}, 300);
         		hot=0;
         	}
         } // END CLICK FUNCTION
         
         
         
         
         
         
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<2; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("btnBg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("txt").css({"color":"#000000"});
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.$("txt0").empty();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnBg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("txt").css({"color":"#ffffff"});
         		if (menuNo == 0){
         			hot=1;
         			btnClick();
         			sym.$("hot").stop().animate({opacity:0}, 500);
         			sym.$("txt14").stop().animate({opacity:0}, 300);
         			sym.$("txt15").stop().animate({opacity:0}, 300);
         			sym.$("hotBtn").stop().delay(0).animate ({top:460}, 300, 'easeOutCubic');
         			sym.$("txt12").stop().delay(0).animate ({top:344}, 100, 'easeOutCubic');
         			sym.$("txt0").append(txtArr[0]);
         		}else{
         			sym.$("hot").stop().animate({opacity:1}, 500);
         			sym.$("txt14").stop().animate({opacity:1}, 300);
         			sym.$("txt15").stop().animate({opacity:1}, 300);
         			sym.$("hotBtn").stop().delay(0).animate ({top:420}, 300, 'easeOutCubic');
         			sym.$("txt12").stop().delay(0).animate ({top:390}, 100, 'easeOutCubic');
         			sym.$("txt0").append(txtArr[13]);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnBg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("txt").css({"color":"#ffffff"});
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnBg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("txt").css({"color":"#000000"});
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnBg").css(overBtn);
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("txt").css({"color":"#ffffff"});
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("btnBg").css(overBtn);
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("txt").css({"color":"#ffffff"});

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'hotBtn'
   (function(symbolName) {   
   
   })("hotBtn");
   //Edge symbol end:'hotBtn'

   //=========================================================
   
   //Edge symbol: 'btn'
   (function(symbolName) {   
   
   })("btn");
   //Edge symbol end:'btn'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32651");