/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 20;
         	var btnNo = 0;
         	var budge = 5;
         	var menuNo2 = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txtBoxWidth = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(255,255,255,1)",
         	"background-color":"rgba(250,170,25,1)", "width":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         
         	var txtBoxHeight = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(255,255,255,1)",
         	"background-color":"rgba(250,170,25,1)", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         
         	var txtBoxWidthHeight = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(255,255,255,1)",
         	"background-color":"rgba(250,170,25,1)", "width":"auto", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         
         	var txtBoxWhiteHeight = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(250,170,25,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         
         	var txt=[];
         	txt[0] = sym.getSymbol("txtMc").$("txt0").css(txtBoxWidth);
         	txt[1] = sym.getSymbol("txtMc").$("txt1").css(txtBoxWidthHeight);
         	txt[2] = sym.getSymbol("txtMc").$("txt2").css(txtBoxHeight);
         	txt[3] = sym.getSymbol("txtMc").$("txt3").css(txtBoxWidthHeight);
         	txt[4] = sym.getSymbol("txtMc").$("txt4").css(txtBoxWidthHeight);
         	txt[5] = sym.getSymbol("txtMc").$("txt5").css(txtBoxHeight);
         	txt[6] = sym.getSymbol("txtMc").$("txt6").css(txtBoxWidth);
         	txt[7] = sym.getSymbol("txtMc").$("txt7").css(txtBoxHeight);
         	txt[8] = sym.getSymbol("txtMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("txtMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("txtMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("txtMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("txtMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("txtMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("chamberMc").$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.getSymbol("chamberMc").$("txt22").css(txtBoxHeight);
         	txt[23] = sym.getSymbol("chamberMc").$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.getSymbol("chamberMc").$("txt24").css(txtBoxHeight);
         	txt[25] = sym.getSymbol("chamberMc").$("txt25").css(txtBoxHeight);
         	txt[26] = sym.getSymbol("chamberMc").$("txt26").css(txtBoxHeight);
         	txt[27] = sym.getSymbol("txtMc").$("txt27").css(txtBoxWidth);
         	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         	txt[31] = sym.$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.$("txt33").css(txtBoxWhiteHeight);
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32635.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<28; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         
         			sym.getSymbol("txtMc").$("txt2").animate({top:229 - sym.getSymbol("txtMc").$("txt2").height()+10}, 0);
         			sym.getSymbol("txtMc").$("txt6").animate({left:460 - sym.getSymbol("txtMc").$("txt6").width()+10}, 0);
         			sym.getSymbol("chamberMc").$("txt22").animate({top:361 - sym.getSymbol("chamberMc").$("txt22").height()+0}, 0);
         			sym.getSymbol("chamberMc").$("txt26").animate({top:520 - sym.getSymbol("chamberMc").$("txt26").height()+0}, 0);
         
         		}
         	}); // END XML
         
         // BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<8; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("plus").fadeIn(0);
         		sym.$("txt33").stop().animate ({opacity:0}, 0);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		menuNo2 = menuNo;
         		buttonClicked();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("plus").fadeOut(0);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("plus").fadeIn(0);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("plus").fadeOut(0);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         
         //CLOSE BTN
         sym.getSymbol("chamberMc").$("closeBtnMc").on(clickEventType, function(e){
         	resetmenu();
         	sym.$("chamberMc").stop().delay(0).animate ({opacity:0}, 200);
         	sym.$("chamberZoom").stop().delay(0).animate ({opacity:1}, 200, function(){
         		sym.$("bg").stop().delay(0).animate ({opacity:1}, 500);
         		sym.$("chamberZoom").stop().delay(0).animate ({opacity:0, left:165, top:250, width:53, height:40}, 1000, 'easeOutCubic', function(){
         			sym.$("menuBtnsMc").fadeIn(300);
         			sym.$("txtMc").stop().delay(0).animate ({opacity:1}, 200);
         		});
         	});
         	e.stopPropagation(); e.preventDefault();
         	});
         
         function buttonClicked() {
         	resetmenu();
         		btnNo = menuNo2;
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo2).$("plus").fadeOut(0);
         		sym.$("txt33").empty();
         		sym.$("txt33").append(txtArr[menuNo2 + 13]);
         		sym.$("txt33").animate({top:552 - sym.$("txt33").height()+10}, 0);
         		sym.$("txt33").stop().animate ({opacity:1}, 200);
         
         		if (menuNo2 == 0){
         			sym.$("txt33").stop().animate ({opacity:0}, 0);
         			sym.$("menuBtnsMc").fadeOut(0);
         			sym.$("bg").stop().delay(0).animate ({opacity:0}, 200);
         			sym.$("txtMc").stop().delay(0).animate ({opacity:0}, 50);
         			sym.$("chamberZoom").animate ({opacity:1}, 0);
         			sym.$("chamberZoom").stop().delay(0).animate ({left:0, top:70, width:800, height:600}, 1000, 'easeOutCubic', function(){
         				sym.$("chamberZoom").animate ({opacity:0}, 100);
         				sym.$("chamberMc").stop().delay(0).animate ({opacity:1}, 0);
         				sym.getSymbol("chamberMc").play(1);
         			});
         		}
         		if (clicked == btnNo){
         			resetmenu();
         			clicked = 20;
         		}else{
         			clicked = menuNo2;
         		}
         		e.preventDefault(); e.stopPropagation();
         }
         
         sym.$("chamberZoom").animate ({opacity:0}, 0);
         sym.$("chamberMc").animate ({opacity:0}, 0);

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'chamberMc'
   (function(symbolName) {   
   
   })("chamberMc");
   //Edge symbol end:'chamberMc'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'closeBtnMc'
   (function(symbolName) {   
   
   })("closeBtnMc");
   //Edge symbol end:'closeBtnMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32635");