/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 20;
         	var btnNo = 0;
         	var budge = 5;
         	var menuNo2 = 0;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txtBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.9)", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         	
         	var txt=[];
         	for (var i=0;i<33;i++){
         		txt[i] = sym.getSymbol("txtMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[33] = sym.$("txt33").css(txtBox);
         	for (var i=34;i<52;i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32604.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			var headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			var stand = $(xml).find('stand').text();
         			var standSize= $(xml).find('standSize').text();
         			standtxt.html(stand);
         			standtxt.css({'font-size':standSize});
         			var source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<52; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.$("closeBtnMc").animate({top:313 + sym.$("txt33").height()+budge}, 0);
         
         		}
         	}); // END XML
         	
         // BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<19; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("Rectangle").fadeOut(0);
         		sym.$("txt33").stop().animate ({opacity:0}, 0);
         		sym.$("closeBtnMc").stop().animate ({opacity:0}, 0);
         		sym.$("closeBtnMc").stop().animate ({left:800}, 0);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		menuNo2 = menuNo;
         		buttonClicked();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("Rectangle").fadeIn(0);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("Rectangle").fadeOut(0);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("Rectangle").fadeIn(0);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         
         //CLOSE BTN
         sym.$("closeBtnMc").on(clickEventType, function(e){
         	buttonClicked();
         	e.stopPropagation(); e.preventDefault();
         	});
         
         function buttonClicked() {
         	resetmenu();
         		btnNo = menuNo2;
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo2).$("Rectangle").fadeIn(0);
         		sym.$("txt33").empty();
         		sym.$("txt33").append(txtArr[menuNo2 + 33]);
         		sym.$("txt33").stop().animate ({opacity:1}, 200);
         		sym.$("closeBtnMc").animate({top:313 + sym.$("txt33").height()+budge}, 0);
         		sym.$("closeBtnMc").stop().animate ({left:445}, 0);
         		sym.$("closeBtnMc").stop().animate ({opacity:1}, 200);
         
         		if (clicked == btnNo){
         			resetmenu();
         			clicked = 20;
         		}else{
         		clicked = menuNo2;
         		}
         		e.preventDefault(); e.stopPropagation();
         }
         buttonClicked();

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtn1_1'
   (function(symbolName) {   
   
      })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn3");
   //Edge symbol end:'menuBtn3'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn4");
   //Edge symbol end:'menuBtn4'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn5");
   //Edge symbol end:'menuBtn5'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn6");
   //Edge symbol end:'menuBtn6'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'closeBtnMc'
   (function(symbolName) {   
   
   })("closeBtnMc");
   //Edge symbol end:'closeBtnMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32604");