/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	var datSty = "<div style='clear:both; margin-bottom:2px'><div style='float:left; margin-right:5px; margin-left:0px; border-radius:5px; font-size:18px; font-weight:600; background-color:#da0000; color:rgba(255,255,255,1); padding-left:6px; padding-right:6px; padding-top:6px; padding-bottom:6px'>";
         	var capSty = "</div><div style='padding-right:5px; padding-left:0px; padding-bottom:1px'>";
         	var endSty = "</div></div>";
         	
         	var boxTxt  = {"background-color":"rgba(251,174,23,1)", "height":"auto", "border-width":"1px", "border-color":"rgba(255,255,255,1)",
         	"border-style":"solid", "border-radius":"5px", "padding":"5px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         	
         	var boxTxt2  = {"background-color":"rgba(255,255,255,1)", "width":"auto", "height":"auto", "padding":"5px"};
         	
         	var txt=[];
         	for (var i=0;i<38;i++){
         	txt[i] = sym.getSymbol("txtMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[6] = sym.getSymbol("txtMc").$("txt6").css(boxTxt2);
         	txt[7] = sym.getSymbol("graphMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("graphMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("graphMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("graphMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("graphMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("graphMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("txtMc").$("txt13").css({"pointer-events":"none", "width":"auto"});
         	txt[22] = sym.getSymbol("txtMc").$("txt22").css(boxTxt);
         	txt[31] = sym.getSymbol("txtMc").$("txt31").css(boxTxt);
         	txt[34] = sym.getSymbol("txtMc").$("txt34").css(boxTxt);
         	txt[36] = sym.getSymbol("txtMc").$("txt36").css(boxTxt2);
         	for (var i=38;i<51;i++){
         	txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32594.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			var headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			var stand = $(xml).find('stand').text();
         			var standSize= $(xml).find('standsize').text();
         			standtxt.html(stand);
         			standtxt.css({'font-size':standSize});
         			var source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<51; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			txtArr[13]=$(xml).find('txt13').text();
         			txt[13].html(txtArr[13] + txtArr[14]);
         			var capTxt = capSty + txtArr[38] + datSty + txtArr[39] + capSty + txtArr[40]  + "<hr>" + datSty + txtArr[41] + capSty + txtArr[42]  + "<hr>" + datSty + txtArr[43] + capSty + txtArr[44]  + "<hr>" + datSty + txtArr[45] + capSty + txtArr[46]  + "<hr>" + datSty + txtArr[47] + capSty + txtArr[48]  + "<hr>"+  endSty;
         			sym.$("capTxt").html(capTxt);
         	
         			sym.getSymbol("txtMc").$("keyBg").animate({width:40 + sym.getSymbol("txtMc").$("txt13").width()+15}, 0);
         	
         		}
         	}); // END XML
         	
         sym.getSymbol("graphMc").play();
         
         

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'graphMc'
   (function(symbolName) {   
   
   })("graphMc");
   //Edge symbol end:'graphMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32594");