/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txt=[];
         	for (var i=0;i<18; i++){
         		txt[i] = sym.getSymbol("hillMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("tombMc").getSymbol("scenePoint1Mc").$("txt18").css({"pointer-events":"none", "height":"auto"});
         	txt[19] = sym.getSymbol("tombMc").getSymbol("scenePoint1Mc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("tombMc").getSymbol("scenePoint2Mc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("tombMc").getSymbol("scenePoint2Mc").$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.getSymbol("tombMc").getSymbol("scenePoint3Mc").$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.getSymbol("tombMc").getSymbol("scenePoint4Mc").$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.getSymbol("tombMc").getSymbol("scenePoint4Mc").$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol("tombMc").getSymbol("scenePoint5Mc").$("txt25").css({"pointer-events":"none", "height":"auto"});
         	txt[26] = sym.getSymbol("tombMc").getSymbol("scenePoint5Mc").$("txt26").css({"pointer-events":"none", "height":"auto"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32583.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			var headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			var stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			var source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<27; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			sym.getSymbol("tombMc").getSymbol("scenePoint1Mc").$("txt18").animate({top:180 - sym.getSymbol("tombMc").getSymbol("scenePoint1Mc").$("txt18").height()+10}, 0);
         			sym.getSymbol("tombMc").getSymbol("scenePoint5Mc").$("txt25").animate({top:-19 - sym.getSymbol("tombMc").getSymbol("scenePoint5Mc").$("txt25").height()+10}, 0);
         			sym.getSymbol("tombMc").getSymbol("scenePoint5Mc").$("txt26").animate({top:83 - sym.getSymbol("tombMc").getSymbol("scenePoint5Mc").$("txt26").height()+10}, 0);
         			}
         	}); // END XML
         var clicked = 0;
         // BUTTONS COUNT
         sym.$("nextBtn").on(clickEventType, function(e){
         	clicked++;
         	btnClick();
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.$("nextBtn").mouseover(function(){
         	sym.getSymbol("nextBtn").stop();
         	sym.getSymbol("nextBtn").$("Ellipse").css({"background-color":"rgba(0,0,0,1.00)"});
         	});
         sym.$("nextBtn").mouseout(function(){
         	sym.getSymbol("nextBtn").$("Ellipse").css({"background-color":"rgba(218,0,0,1.00)"});
         	});
         
         // START CLICK FUNCTION
         sym.$("nextBtn").stop().delay(0).animate ({opacity:0, left:726, top:375}, 200);
         sym.$("nextBtn").stop().delay(1000).animate ({opacity:1, left:582, top:302}, 600);
         sym.$("txt5").stop().delay(2000).animate ({opacity:1}, 600);
         
         function btnClick(){
         	sym.$("txt5").stop().delay(0).animate ({opacity:0}, 100);
         	sym.getSymbol("nextBtn").$("btnArrow").fadeIn(0);
         	sym.getSymbol("nextBtn").$("btnReplay").fadeOut(0);
         	sym.$("nextBtn").stop().delay(0).animate ({opacity:1, left:800, top:589}, 0);
         	if (clicked == 1) {
         		sym.$("nextBtn").stop().delay(2000).animate ({opacity:1, left:714, top:522}, 400);
         		sym.$("hillMc").stop().delay(0).animate ({opacity:0}, 500);
         		sym.$("hillArt").stop().delay(500).animate ({opacity:0, left:-2700, top:-1260, width:4650, height:3500}, 1000, function(){
         			sym.getSymbol("tombMc").play();
         			});
         		sym.getSymbol("nextBtn").stop();
         		}
         	if (clicked == 2) {
         		sym.$("nextBtn").stop().delay(2800).animate ({opacity:1, left:714, top:522}, 400);
         		sym.getSymbol("tombMc").play();
         		}
         	if (clicked == 3) {
         		sym.$("nextBtn").stop().delay(3000).animate ({opacity:1, left:714, top:522}, 400);
         		sym.getSymbol("tombMc").play();
         		}
         	if (clicked == 4) {
         		sym.$("nextBtn").stop().delay(4000).animate ({opacity:1, left:714, top:522}, 400);
         		sym.getSymbol("tombMc").play();
         		}
         	if (clicked == 5) {
         		sym.getSymbol("nextBtn").$("btnArrow").fadeOut(0);
         		sym.getSymbol("nextBtn").$("btnReplay").fadeIn(0);
         		sym.$("nextBtn").stop().delay(4000).animate ({opacity:1, left:714, top:522}, 400);
         		sym.getSymbol("tombMc").play();
         	}
         	if (clicked == 6) {
         		sym.$("hillArt").stop().delay(0).animate ({opacity:1, left:0, top:0, width:800, height:600}, 500);
         		sym.$("hillMc").stop().delay(0).animate ({opacity:1}, 500);
         		sym.$("nextBtn").stop().delay(0).animate ({opacity:0, left:726, top:375}, 200);
         		sym.$("nextBtn").stop().delay(1000).animate ({opacity:1, left:582, top:302}, 600);
         		sym.getSymbol("tombMc").play();
         		sym.$("txt5").stop().delay(2000).animate ({opacity:1}, 100);
         		clicked = 0;
         	}
         } // END CLICK FUNCTION
         
         sym.getSymbol("nextBtn").$("btnReplay").fadeOut(0);

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'wallMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getSymbol("brickLayers0").play(1);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 400, function(sym, e) {
         sym.getSymbol("brickLayers1").play(1);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 800, function(sym, e) {
         sym.getSymbol("brickLayers2").play(1);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1200, function(sym, e) {
         sym.getSymbol("brickLayers3").play(1);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1600, function(sym, e) {
         sym.getSymbol("brickLayers4").play(1);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getSymbol("brickLayers5").play(1);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2400, function(sym, e) {
         sym.getSymbol("brickLayers6").play(1);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2800, function(sym, e) {
         sym.getSymbol("brickLayers7").play(1);

      });
      //Edge binding end

   })("wallMc");
   //Edge symbol end:'wallMc'

   //=========================================================
   
   //Edge symbol: 'brickLayers'
   (function(symbolName) {   
   
   })("brickLayers");
   //Edge symbol end:'brickLayers'

   //=========================================================
   
   //Edge symbol: 'brickLayers_1'
   (function(symbolName) {   
   
   })("brickLayers2");
   //Edge symbol end:'brickLayers2'

   //=========================================================
   
   //Edge symbol: 'brickLayers2_1'
   (function(symbolName) {   
   
   })("brickLayers1");
   //Edge symbol end:'brickLayers1'

   //=========================================================
   
   //Edge symbol: 'wallMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getSymbol("brickLayers0").play(1);

      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 400, function(sym, e) {
         sym.stop();
         sym.getSymbol("brickLayers1").play(1);
         

      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 800, function(sym, e) {
         sym.getSymbol("brickLayers2").play(1);

      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1200, function(sym, e) {
         sym.getSymbol("brickLayers3").play(1);

      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1600, function(sym, e) {
         sym.getSymbol("brickLayers4").play(1);

      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getSymbol("brickLayers5").play(1);

      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2400, function(sym, e) {
         sym.getSymbol("brickLayers6").play(1);

      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2800, function(sym, e) {
         sym.getSymbol("brickLayers7").play(1);

      });
         //Edge binding end

      })("wall2Mc");
   //Edge symbol end:'wall2Mc'

   //=========================================================
   
   //Edge symbol: 'tombMc'
   (function(symbolName) {   
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.stop();
      
      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 520, function(sym, e) {
         sym.getSymbol("wallMc").play(0);
         sym.getSymbol("wall2Mc").play(0);

      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.stop();
      
      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6051, function(sym, e) {
         sym.getSymbol("wall2Mc").play();
      
      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 45, function(sym, e) {
         sym.stop();
         sym.getSymbol("wallMc").getSymbol("brickLayers0").stop(1);
         sym.getSymbol("wallMc").getSymbol("brickLayers1").stop(1);
         sym.getSymbol("wallMc").getSymbol("brickLayers2").stop(1);
         sym.getSymbol("wallMc").getSymbol("brickLayers3").stop(1);
         sym.getSymbol("wallMc").getSymbol("brickLayers4").stop(1);
         sym.getSymbol("wallMc").getSymbol("brickLayers5").stop(1);
         sym.getSymbol("wallMc").getSymbol("brickLayers6").stop(1);
         sym.getSymbol("wall2Mc").getSymbol("brickLayers0").stop(1);
         sym.getSymbol("wall2Mc").getSymbol("brickLayers1").stop(1);
         sym.getSymbol("wall2Mc").getSymbol("brickLayers2").stop(1);
         sym.getSymbol("wall2Mc").getSymbol("brickLayers3").stop(1);
         sym.getSymbol("wall2Mc").getSymbol("brickLayers4").stop(1);
         sym.getSymbol("wall2Mc").getSymbol("brickLayers5").stop(1);
         sym.getSymbol("wall2Mc").getSymbol("brickLayers6").stop(1);

      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.stop();
      
      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.stop();
      
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13679, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13907, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("tombMc");
   //Edge symbol end:'tombMc'

   //=========================================================
   
   //Edge symbol: 'nextBtn'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("nextBtn");
   //Edge symbol end:'nextBtn'

   //=========================================================
   
   //Edge symbol: 'hillMc'
   (function(symbolName) {   
   
   })("hillMc");
   //Edge symbol end:'hillMc'

   //=========================================================
   
   //Edge symbol: 'locoMc'
   (function(symbolName) {   
   
   })("locoMc");
   //Edge symbol end:'locoMc'

   //=========================================================
   
   //Edge symbol: 'scenePoint1Mc'
   (function(symbolName) {   
   
   })("scenePoint1Mc");
   //Edge symbol end:'scenePoint1Mc'

   //=========================================================
   
   //Edge symbol: 'scenePoint2Mc'
   (function(symbolName) {   
   
   })("scenePoint2Mc");
   //Edge symbol end:'scenePoint2Mc'

   //=========================================================
   
   //Edge symbol: 'scenePoint3Mc'
   (function(symbolName) {   
   
   })("scenePoint3Mc");
   //Edge symbol end:'scenePoint3Mc'

   //=========================================================
   
   //Edge symbol: 'scenePoint4Mc'
   (function(symbolName) {   
   
   })("scenePoint4Mc");
   //Edge symbol end:'scenePoint4Mc'

   //=========================================================
   
   //Edge symbol: 'scenePoint5Mc'
   (function(symbolName) {   
   
   })("scenePoint5Mc");
   //Edge symbol end:'scenePoint5Mc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32583");