/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	var RTL=false;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txtBox0  = {"background-color":"rgba(250,170,5,1)","border-style":"solid", "border-color":"rgba(80,80,80,1)", "border-width":"1px", "border-radius":"4px", "height":"auto","width":"auto", "padding":"4px"};
	var txtBox1  = {"background-color":"rgba(250,170,5,1)","border-style":"solid", "border-color":"rgba(80,80,80,1)", "border-width":"1px", "border-radius":"4px", "height":"auto", "padding":"4px"};
	
	var txt=[];
	for (var i=0;i<26;i++){
	txt[i] = sym.getSymbol("txtMc").$("txt"+i).css({"pointer-events":"none"});
	}
	txt[8] = sym.getSymbol("txtMc").$("txt8").css(txtBox0);
	txt[22] = sym.getSymbol("txtMc").$("txt22").css(txtBox1);
	txt[25] = sym.getSymbol("txtMc").$("txt25").css(txtBox1);
	txt[26] = sym.getSymbol("cameraMc").$("txt26").css({"pointer-events":"none"});
	txt[27] = sym.getSymbol("cameraMc").$("txt27").css({"pointer-events":"none"});
	txt[28] = sym.getSymbol("cameraMc").$("txt28").css({"pointer-events":"none"});
	txt[29] = sym.getSymbol("cameraMc").$("txt29").css({"pointer-events":"none"});
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32572.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			var headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			var stand = $(xml).find('stand').text();
			standtxt.html(stand);
			var source = $(xml).find('source').text();
			sourcetxt.html(source);
			var fontSize= $(xml).find('fontSize').text();
			if(RTL==true){
			var align="right"; var d="rtl"; var dir="direction:rtl;";
			}else{
			var align="left"; var d="auto"; var dir="";
			}
			for (var i=0; i<30; i++){
				txtArr[i]=$(xml).find('txt'+i).text();
				txt[i].html(txtArr[i]);
				txt[i].css({'font-size':fontSize,'direction':d});
			}
			sym.getSymbol("txtMc").$("txt8").animate({left:200 - sym.getSymbol("txtMc").$("txt8").width()}, 0);
		}
	}); // END XML
	
	// TOGGLE BUTTON
	sym.$("toggleBtn").on(clickEventType, function(e){
	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible") ) { 
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.getSymbol("cameraMc").play();
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		sym.getSymbol("cameraMc").playReverse();
	}
	e.stopPropagation(); e.preventDefault();
	}); 
	sym.$("toggleBtn").mouseover(function(){
		sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	sym.$("toggleBtn").mouseout(function(){
		sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
	});
	
	// TOGGLE BUTTON 1
	sym.$("toggleBtn1").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn1").$("btnPlus").is(":visible") ) { 
		sym.getSymbol("toggleBtn1").$("btnPlus").fadeOut(0);
		sym.getSymbol("txtMc").play();
	}else{
		sym.getSymbol("toggleBtn1").$("btnPlus").fadeIn(0);
		sym.getSymbol("txtMc").playReverse();
	}
	}); 
	sym.$("toggleBtn1").mouseover(function(){
		sym.getSymbol("toggleBtn1").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	sym.$("toggleBtn1").mouseout(function(){
		sym.getSymbol("toggleBtn1").$("btnOver").stop().animate ({opacity:0}, 200);
	});

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cutBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'rotateMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 78, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("rotateMc");
   //Edge symbol end:'rotateMc'

   //=========================================================
   
   //Edge symbol: 'chopperMc'
   (function(symbolName) {   
   
   })("chopperMc");
   //Edge symbol end:'chopperMc'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'radiateMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("radiateMc");
   //Edge symbol end:'radiateMc'

   //=========================================================
   
   //Edge symbol: 'cameraMc'
   (function(symbolName) {   
   
   })("cameraMc");
   //Edge symbol end:'cameraMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32572");