/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "click" : "click");
	var RTL=false;
	var clicked = 0;
	var tar = 0;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css({"height":"auto", "padding-right":"2px", "padding-top":"2px","padding-left":"4px", "background-color":"rgba(0,0,0,1)"});
	
	var outBtn  = {"background-color":"rgba(0,0,0,1)"};
	var overBtn = {"background-color":"rgba(218,0,0,1)"};
	
	var txt=[];
	txt[0] = sym.$("txt0");
	for (var i=1;i<43;i++){
	txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
	}
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32567.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			var headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			var source = $(xml).find('source').text();
			sourcetxt.html(source);
			var fontSize= $(xml).find('fontSize').text();
			if(RTL==true){
			var align="right"; var d="rtl"; var dir="direction:rtl;";
			sym.$("nav").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
			}else{
			var align="left"; var d="auto"; var dir="";
			}
			for (var i=0; i<42; i++){
				txtArr[i]=$(xml).find('txt'+i).text();
				txt[i].html(txtArr[i]);
				txt[i].css({'font-size':fontSize,'direction':d});
			}
			headlinetxt.css({'text-align':align,'direction':d});
			var st1 = "<div style='float:"+align+";text-align:"+align+";"+dir+"font-size:13px; font-weight:700; background-color:rgba(218,0,0,1); color:rgba(255,255,255,1); padding-left:4px; padding-right:4px; padding-top:2px; padding-bottom:1px'>"+txtArr[2*clicked] +"</div>"; 
			var st2="<div style='float:"+align+";text-align:"+align+";"+dir+"font-size:13px; font-weight:700; background-color:rgba(0,0,0,1); color:rgba(255,255,255,1); padding-left:4px; padding-right:4px; padding-top:2px; padding-bottom:1px'>"+txtArr[(2*clicked)+1]+"</div>";
			var st3="<div style='float:"+align+";text-align:"+align+";"+dir+"color:rgba(0,0,0,0);'>"+ "l" + "</div>";
			var st4="<div style= 'font-size:13px;text-align:"+align+";"+dir+"padding-right:0px; padding-left:0px; padding-bottom:0px; padding-top:3px'>" + txtArr[(2*clicked)+2]+"</div>";
			sym.$("txt0").html(st1+st2+st3+st4);
	
		}
	}); // END XML
	
	sym.getSymbol("navBtnNext").$("txt").html(">");
	sym.getSymbol("navBtnBack").$("txt").html("<");
	sym.getSymbol("navBtnNext").$("txt").css("pointer-events","none");
	sym.getSymbol("navBtnBack").$("txt").css("pointer-events","none");
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = [];//the array that will hold references to the buttons.
	
	for (var h=0; h<17; h++){
		menuArray.push(h);
		sym.getSymbol("btnsMc").getSymbol("btnDot" + h).$("txt").html(h+1);
	}
	
	function resetmenu(){
	for (var h=0; h<menuArray.length; h++){
		sym.getSymbol("btnsMc").getSymbol("btnDot" + h).$("btnBg").css(outBtn);
		sym.$("txt0").empty();
	}
	}
	//resetmenu();
	
	// MENU CLICK
	var menuBtnClick = function(menuNo){ //to handle lexical scope
	return function (e) {
		clicked = menuNo;
		btnClick();
		e.preventDefault(); e.stopPropagation();
	};
	};
	// MENU OVER
	var menuBtnOver = function(menuNo){ //to handle lexical scope
	return function (e) {
		sym.getSymbol("btnsMc").getSymbol("btnDot" + menuNo).$("btnBg").css(overBtn);
		e.preventDefault(); e.stopPropagation();
	};
	};
	// MENU OUT
	var menuBtnOut = function(menuNo){ //to handle lexical scope
		return function (e) {
			sym.getSymbol("btnsMc").getSymbol("btnDot" + menuNo).$("btnBg").css(outBtn);
			if (clicked == menuNo){
			sym.getSymbol("btnsMc").getSymbol("btnDot" + menuNo).$("btnBg").css(overBtn);
			}
		e.preventDefault(); e.stopPropagation();
	};
	};
	for (var b=0;b<menuArray.length;b++){
	sym.getSymbol("btnsMc").$("btnDot"+b).on(clickEventType,menuBtnClick(b));
	sym.getSymbol("btnsMc").$("btnDot"+b).on('mouseover',menuBtnOver(b));
	sym.getSymbol("btnsMc").$("btnDot"+b).on('mouseout',menuBtnOut(b));
	sym.getSymbol("btnsMc").$("btnDot"+b).css({'cursor':'pointer'});
	}
	sym.getSymbol("btnsMc").getSymbol("btnDot0").$("btnBg").css(overBtn);
	
	// BUTTONS NEXT
	sym.$("navBtnNext").on(clickEventType, function(e){
		clicked++;
		btnClick();
		e.stopPropagation(); e.preventDefault();
	});
	sym.$("navBtnNext").mouseover(function(){
		sym.getSymbol("navBtnNext").$("navBtnBg").css(outBtn);
	});
	sym.$("navBtnNext").mouseout(function(){
		sym.getSymbol("navBtnNext").$("navBtnBg").css(overBtn);
	});
	
	// BUTTONS BACK
	sym.$("navBtnBack").on(clickEventType, function(e){
		clicked--;
		btnClick();
		e.stopPropagation(); e.preventDefault();
	});
	sym.$("navBtnBack").mouseover(function(){
		sym.getSymbol("navBtnBack").$("navBtnBg").css(outBtn);
	});
	sym.$("navBtnBack").mouseout(function(){
		sym.getSymbol("navBtnBack").$("navBtnBg").css(overBtn);
	});
	
	
	
	// START CLICK FUNCTION
	function btnClick(){
		resetmenu();
		sym.$("navBtnBack").fadeIn(0);
		sym.$("navBtnNext").fadeIn(0);
		sym.getSymbol("btnsMc").getSymbol("btnDot" + clicked).$("btnBg").css(overBtn);
		sym.$("txt0").empty();
		if (clicked == 0){ tar = 0; sym.$("navBtnBack").fadeOut(0);}
		if (clicked == 1){ tar = 1; }
		if (clicked == 2||clicked == 3||clicked == 4||clicked == 5){
			tar = 2;
		}
		if (clicked == 6){ tar = 3; }
		if (clicked == 7){ tar = 4; }
		if (clicked == 8){ tar = 5; }
		if (clicked == 9||clicked == 10||clicked == 11){
			tar = 6;
		}
		if (clicked == 12||clicked == 13){
			tar = 7;
		}
		if (clicked == 14){
			tar = 8;
		}
		if (clicked == 15){
			tar = 9;
		}
		if (clicked == 16){
			tar = 10;
			sym.$("navBtnNext").fadeOut(0);
		}
	
			var align=(RTL==true)?"right":"left";
			var dir=(RTL==true)?"direction:rtl;":"";
			var st1 = "<div style='float:"+align+";text-align:"+align+";"+dir+"font-size:13px; font-weight:700; background-color:rgba(218,0,0,1); color:rgba(255,255,255,1); padding-left:4px; padding-right:4px; padding-top:2px; padding-bottom:1px'>"+txtArr[3*tar] +"</div>"; 
			var st2="<div style='float:"+align+";text-align:"+align+";"+dir+"font-size:13px; font-weight:700; background-color:rgba(0,0,0,1); color:rgba(255,255,255,1); padding-left:4px; padding-right:4px; padding-top:2px; padding-bottom:1px'>"+txtArr[(3*tar)+1]+"</div>";
			var st3="<div style='float:"+align+";text-align:"+align+";"+dir+"color:rgba(0,0,0,0);'>"+ "l" + "</div>";
			var st4="<div style= 'font-size:13px;text-align:"+align+";"+dir+"padding-right:0px; padding-left:0px; padding-bottom:0px; padding-top:3px'>" + txtArr[(3*tar)+2]+"</div>";
			sym.$("txt0").html(st1+st2+st3+st4);
	
	} // END CLICK FUNCTION
	btnClick();
	
	var toggle = 0;
	// TOGGLE BUTTON
	sym.getSymbol("styleBase").$("sourceTxt").on(clickEventType, function(e){
		if (toggle == 0) { 
			sym.getSymbol("styleBase").$("btnPlus").fadeOut(0);
			sym.getSymbol("styleBase").$("sourceTxt").animate({top:0 - sym.getSymbol("styleBase").$("sourceTxt").height()+10}, 200);
			toggle = 1;
		}else{
			sym.getSymbol("styleBase").$("btnPlus").fadeIn(0);
			sym.getSymbol("styleBase").$("sourceTxt").animate({top:0}, 200);
			toggle = 0;
		}
		e.stopPropagation(); e.preventDefault();
	}); 
	sym.$("styleBase").mouseover(function(){
		sym.getSymbol("styleBase").$("box").css(overBtn);
		e.stopPropagation(); e.preventDefault();
	});
	sym.$("styleBase").mouseout(function(){
		if (toggle == 1) { 
			sym.getSymbol("styleBase").$("box").css(overBtn);
		}else{
			sym.getSymbol("styleBase").$("box").css({"background-color":"rgba(61,61,61,1)"});
		}
		e.stopPropagation(); e.preventDefault();
	});

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'btnDot'
   (function(symbolName) {   
   
   })("btnDot");
   //Edge symbol end:'btnDot'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32567");