/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var RTL="false"; 
         var gnYear=2015;
         var gn=32552;
         var screenArr=['mapIntro','driverchampMc','teamChampMc','driversMc','liveMc','circuitMc','timingMc','resultMc'];
         var teamArr=['MER','RBR','WIL','FER','MLA','FOR','TOR','LOT','SAU','MAN'];
         var countryArr=['aus','mas','chn','brn','esp','mon','can','aut','eng','hun','bel','ita','sin','jpn','rus','usa','mex','bra','uae'];
         for (var m=0;m<countryArr.length;m++){
         	//sym.getSymbol("mapIntro").getSymbol("mapBtn"+m).$("btnTxt").text(m+1);//Mar23
         	sym.getSymbol("mapIntro").$("mapBtn"+m).on('mouseover',{'count':m},showButton);
         	sym.getSymbol("mapIntro").$("mapBtn"+m).on('mouseout',{'count':m},hideButton);
         }
         function showButton(e){
         	var btn_id = (e.data.count);
         	sym.getSymbol("mapIntro").getSymbol("mapBtn"+btn_id).$("btnBg").css({'background-color':'rgb(255,0,0)'});
         }
         function hideButton(e){
         	var btn_id = (e.data.count);
         	sym.getSymbol("mapIntro").getSymbol("mapBtn"+btn_id).$("btnBg").css({'background-color':'rgb(0,0,0)'});
         }
         //ASSIGN TEXT ELEMENTS TO ARRAY
         var menuText=[];
         for (var i=0; i<9; i++){
         	menuText[i]= sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("menuTxt").css("pointer-events","none");
         	sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         }
         var menuTxtArr=[];
         var phaseBtnTxt=[];
         for (var p=0;p<8;p++){
          phaseBtnTxt[p] = sym.getSymbol("menuButtons").getSymbol("phaseBtn"+p).$("phaseTxt").css("pointer-events","none");
         }
         var phaseTxtArr=[];
         var capsText=[];
         	capsText[0]=sym.getSymbol("circuitMc").$("weatherTxt").css("pointer-events","none");
         	capsText[1]=sym.getSymbol("circuitMc").$("gearTxt").css("pointer-events","none");
         	capsText[2]=sym.getSymbol("circuitMc").$("speedTxt").css("pointer-events","none");
         	capsText[3]=sym.getSymbol("circuitMc").$("key1").css("pointer-events","none");
         	capsText[4]=sym.getSymbol("circuitMc").$("key2").css("pointer-events","none");
         	capsText[5]=sym.getSymbol("circuitMc").$("key3").css("pointer-events","none");
         	capsText[6]= sym.getSymbol("driversMc").$("detailstxt").css("pointer-events","none");
         	capsText[7]= sym.getSymbol("liveMc").$("lapTxt").css("pointer-events","none");
         	capsText[8]= sym.getSymbol("liveMc").$("timeTxt").css("pointer-events","none");
         	capsText[9]= sym.getSymbol("resultMc").$("resultTxt").css("pointer-events","none");
         var caps=[];
         var raceText =[];
         	raceText[0]=sym.getSymbol("circuitMc").$("gpTxt").css("pointer-events","none");
         	raceText[1]=sym.getSymbol("circuitMc").$("venueTxt").css("pointer-events","none");
         	raceText[2]=sym.getSymbol("circuitMc").$("distanceTxt").css("pointer-events","none");
         	raceText[3]=sym.getSymbol("circuitMc").$("lapTxt").css("pointer-events","none");
         
         	sym.getSymbol("timingMc").$("gpTxt").css("pointer-events","none");
         	sym.getSymbol("liveMc").$("gpTxt").css("pointer-events","none");
         	sym.getSymbol("resultMc").$("gpTxt").css("pointer-events","none");
         	sym.getSymbol("driverchampMc").$("driversTxt0").css("pointer-events","none");
         var teamText=[];
         for (var tt=0;tt<teamArr.length;tt++){
         	teamText[tt]=sym.getSymbol("driversMc").$("teamTxt"+tt).css("pointer-events","none");
         }
         sym.getSymbol("circuitMc").$("statusTxt").css({'right':'10px','left':'auto','padding':'3px 5px',"box-shadow":"2px 2px 3px 1px rgba(0,0,0,0.2)"});
         sym.getSymbol("liveMc").$("statusTxt").css({'left':'auto','text-align':'right','padding':'3px 5px'});//Mar13
         sym.getSymbol("timingMc").$("statusTxt").css({'left':'auto','text-align':'right','padding':'3px 5px'});//Mar13
         sym.getSymbol("resultMc").$("resultTxt").css({'right':'8px','left':'auto','text-align':'right','padding':'3px 5px'});//Mar16
         //ARRAY FOR CAPTIONS FROM XML			
         var months;
         var champHead=[];
         var raceArr=[];
         var raceCorners=[];
         for (var r=0;r<countryArr.length; r++){
         	raceArr[r]=[];
         	raceCorners[r]=[];
         }
         var gpDate=[];
         var teamTxtArr=[];
         var driverID=[];
         for (var t=0;t<teamArr.length; t++){
         	teamTxtArr[t]=[];
         	driverID[t]=[];
         }
         var keyWidth;
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         $.ajax({	
         type: "GET",
         url: "GN"+gn+".xml",
         dataType: "xml",
         success: function(xml) {
         	var headline=$(xml).find('headline').text();
         	var source=$(xml).find('source').text();
         	sym.getSymbol('styleMc').$('headlinetxt').html(headline);
         	sym.getSymbol('styleMc').getSymbol('styleBase').$('sourceTxt').html(source);
         	for (var i=0;i<menuText.length;i++){ //get menu labels
         	 menuTxtArr[i]= $(xml).find('menu'+i).text();
         	 menuText[i].html(menuTxtArr[i]);
         	}
         	var phaseString=$(xml).find('phasebuttons').text(); //get phase button labels
         	phaseTxtArr = phaseString.split(";");
         	for (var p=0;p<8;p++){
         		phaseBtnTxt[p].html(phaseTxtArr[p]);
         	}
         	for (var h=0;h<3;h++){
         		champHead[h]=$(xml).find('head'+h).text();
         	}
         	sym.getSymbol("mapIntro").$("headTxt").html(champHead[0]);
         	sym.getSymbol("driverchampMc").$("driversTxt0").html(champHead[1]);
         	var monthstring = $(xml).find('months').text(); //get month names
         	months=monthstring.split(";");
         	var statCapString=$(xml).find('statusCap').text();
         	statCap= statCapString.split(";");
         	for (var c=0;c<capsText.length;c++){
         		caps[c]= $(xml).find('cap'+c).text(); //fixed text captions
         		capsText[c].html(caps[c]);
         	}
         	caps[10]= $(xml).find('cap10').text();
         	caps[11]= $(xml).find('cap11').text();
         	caps[12]= $(xml).find('cap12').text();
         	sym.getSymbol("timingMc").$("timeTxt").html(caps[8]);
         	for (var r=0;r<raceArr.length;r++){			//get details for each race
         		$(xml).find("race"+r).each(function(){
         			var $races = $(this);
         			for (var n=0; n<5; n++){
         				raceArr[r][n] = $races.find('raceCap'+n).text();
         			}
         			gpDate[r]=$races.find('raceDate').text();
         			var cornerString=$races.find('corners').text();
         			raceCorners[r]=cornerString.split(";");	
         		});
         	}				
         	for (var i=0; i<raceText.length; i++){ //add labels for first race circuit
         	 	raceText[i].html(raceArr[0][i]);
         	}
         	for (var t=0;t<teamArr.length;t++){	
         		$(xml).find("team"+t).each(function(){
         			var $teams = $(this);
         			for (var m=0; m<10; m++){
         				teamTxtArr[t][m] = $teams.find('teamCap'+m).text(); 	//get details for each team
         			}	
         			for (var d=0;d<2;d++){
         				driverID[t][d] =	$teams.find('driverid'+(d+1)).text(); //get driver ID numbers
         			}
         		});
         	}	
         		getStats('MER',3);
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("mainCar").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("reflection").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("driverHead").attr("src","drivers/"+teamArr[0]+".png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("bkwheel").attr("src","cars/"+teamArr[0]+"bk.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("frwheel").attr("src","cars/"+teamArr[0]+"fr.png");
         
            }
         }); // END XML
         //REFRESH RATE
         var seasonInterval;
         var conInterval;
         var driverInterval;
         var gpInterval;
         var phaseInterval;
         var latestGP;
         var latestGPno;
         // MENU BUTTONS --------------------------------------------	
         menuArray = []; //the array that will hold references to the buttons.
         for (var m = 0; m < 9; m++){
         	var menuBtnSymbols = sym.getSymbol("menuButtons").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         	sym.getSymbol("menuButtons").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         function resetmenu(){
         	sym.getSymbol("menuButtons").$("menuBtn5xtra").stop().animate({'top':'-245px'},400);
         	sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'-55px'},400);
         	sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-500px'},400);
         	for (var i=0; i<menuArray.length; i++){
                  menuArray[i].$("menuBg").fadeIn(0);
                 sym.getSymbol(screenArr[2]).$("carPic").animate ({'left':'-800px'}, 0);
                 sym.$(screenArr[i]).fadeOut(200);       
         		}
         	clicked=0;
         }
         //resetmenu();
         var raceIDno; //number to select live race
         var raceNo =0;
         var clicked=0;
         function menuBtnClick (e){
         		e.preventDefault();
         		e.stopPropagation();
         		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         		if(menuMenu_id<=4){
         			sym.$("menuButtons").stop().animate({'left':'560px'},400);
         			for(var n=0;n<raceArr.length;n++){
         				$("#gp"+n).css({'background-color':'rgba(230,225,215,0)'});
         				sym.getSymbol("mapIntro").getSymbol("mapBtn"+n).$("btnBg").css({'background-color':'rgb(0,0,0)'});
         				sym.getSymbol("mapIntro").$("mapBtn"+n).off('click');
         			}
         		}else{
         			sym.$("menuButtons").stop().animate({'left':'380px'},400);
         		}
         		if(menuMenu_id==1){//standings
         			if (clicked==1){
         				sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'-55px'},400);
         				clicked=0;
         			}else{
         				sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'40px'},400);
         				sym.getSymbol("menuButtons").$("menuBtn5xtra").stop().animate({'top':'-245px'},400);
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-500px'},400);
         				clicked=1;
         			}
         		}else if(menuMenu_id==4){ //teams
         			if (clicked==4){
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-500px'},400);
         				clicked=0;
         			}else{
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'40px'},400);
         				sym.getSymbol("menuButtons").$("menuBtn5xtra").stop().animate({'top':'-245px'},400);
         				sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'-55px'},400);
         				clicked=4;
         			}
         		}else if(menuMenu_id==7){
         			if (clicked==7){
         				sym.getSymbol("menuButtons").$("menuBtn5xtra").stop().animate({'top':'-245px'},400);
         				clicked=0;
         			}else{
         				sym.getSymbol("menuButtons").$("menuBtn5xtra").stop().animate({'top':'40px'},400);			
         				sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'-55px'},400);
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-500px'},400);
         				clicked=7;
         			}
         		}else{
         			resetmenu(); //set them all back to normal state
         			for (i=0;i<9;i++){
         				if (i==menuMenu_id){
         					if(menuMenu_id==0){//On calendar, buttons must clear seasonInterval (except live race)
         						getSeason();
         						clearInterval(seasonInterval);
         						seasonInterval=setInterval(getSeason,900000);
         						getRace(latestGP);
         					}
         					if(menuMenu_id<=1){ 
         						sym.$(screenArr[menuMenu_id]).fadeIn(200);
         						menuArray[i].$("menuBg").delay(400).fadeOut(0);
         					}else if(menuMenu_id>1){
         						sym.$(screenArr[menuMenu_id-1]).fadeIn(200);
         						menuArray[i].$("menuBg").fadeOut(0);
         					}
         					if (menuMenu_id==2){ //drivers champs
         						getDriverStandings();
         					}
         					if (menuMenu_id==3){ //team champs
         						getConsStandings();
         						sym.getSymbol(screenArr[2]).$("carPic").delay(200).stop().animate ({left:0}, 800, 'easeOutCirc');	
         						sym.getSymbol(screenArr[2]).getSymbol("carPic").play();
         					}	
         					if(menuMenu_id==5){  //live
         						sym.$("menuButtons").stop().animate({'left':'380px'},400);
         					}
         					if (menuMenu_id==6){
         						playIt(latestGPno);
         						captionShift();
         					}
         				}else{
         					if (menuMenu_id!=1){
         						sym.$(screenArr[i]).fadeOut(400);
         					}
         				}														
         			}
         		}
         }
         menuArray[0].$("menuBg").fadeOut(0);
         //TEAM STRIP BUTTONS	
         var carPos=0;//for showTeam
         var hidden=1;
         var showTeam = function(teamdetails,longteam){ //to handle lexical scope
         	return function (e) {
         resetmenu();
         sym.$(screenArr[3]).fadeIn(200);
         menuArray[4].$("menuBg").fadeOut(0);
         	getStats(teamdetails,3);
         		if (carPos==0){
                  carPos=1;
                  hidden=0;
               }else{
                  carPos=0;
                  hidden=1;
               }
         		sym.getSymbol("driversMc").$("driveCar"+carPos).css({'left':-800});	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("mainCar").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("reflection").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("driverHead").attr("src","drivers/"+teamdetails+".png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("bkwheel").attr("src","cars/"+teamdetails+"bk.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("frwheel").attr("src","cars/"+teamdetails+"fr.png");
         		sym.getSymbol("driversMc").$("driveCar"+carPos).delay(1600).stop().animate ({left:0}, 1100);	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).play();
         		sym.getSymbol("driversMc").$("driveCar"+hidden).stop().animate ({left:815}, 800);
         		sym.getSymbol("driversMc").getSymbol("driveCar"+hidden).play();
         		var team=teamdetails;
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         for (var j=0;j<teamArr.length;j++){ //Create team buttons
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).css({"cursor":'pointer'});
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).click(showTeam(teamArr[j],teamTxtArr[j][0]));
         }
         //DATE FUNCTIONS
         var d=new Date();
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     var thisDate = new Date(parseInt(dateTxt, 10));
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate()+1;
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate()+1;
         	return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         }
         //GET GP SEASON
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var raceFinished = 0;
         function captionShift(){
         					capsText[4].animate({left:5 + capsText[3].width() + 20}, 0);
         					capsText[5].animate({left:5 + capsText[3].width() + capsText[4].width() + 40}, 0);
         					raceText[2].animate({left:5 + raceText[3].width() + 20}, 0);
         }
         function raceDetails(gp,gpNo){
         	getRace(gp);
         	latestGP=gp;
         	for (var i=0; i<raceText.length; i++){ //add labels for race circuit
         		raceText[i].html(raceArr[gpNo][i]);
         	}
         	for (var r=0; r<raceCorners[gpNo].length;r++){
         		sym.getSymbol("circuitMc").getSymbol(countryArr[gpNo]+"Mc").$("corner"+r).html(raceCorners[gpNo][r]);
         		sym.getSymbol("circuitMc").getSymbol(countryArr[gpNo]+"Mc").$("corner"+r).css({'font-size':'15px','line-height':'16px'});
         		sym.getSymbol("circuitMc").getSymbol(countryArr[gpNo]+"Mc").$("pit").html(raceCorners[gpNo][raceCorners[gpNo].length-1]);
         		sym.getSymbol("circuitMc").getSymbol(countryArr[gpNo]+"Mc").$("pit").css({'font-size':'15px'});
         	}
         	sym.getSymbol("resultMc").$("gpTxt").html(raceArr[gpNo][0]+" "+statCap[7]);
         	sym.getSymbol("liveMc").$("gpTxt").html(raceArr[gpNo][0]);
         	sym.getSymbol("timingMc").$("gpTxt").html(raceArr[gpNo][0]);
         		for (var n=0;n<countryArr.length; n++){
         			if (n==gpNo){
         				sym.getSymbol("circuitMc").$(countryArr[gpNo]+"Mc").show();
         			}else{
         				sym.getSymbol("circuitMc").$(countryArr[n]+"Mc").hide();
         			}						
         		}
         	}
         var showGP = function(gp,status,gpNo){ //to handle lexical scope
         	return function (e) {
         		resetmenu();
         		for(var r=0;r<raceArr.length;r++){
         			sym.getSymbol("circuitMc").getSymbol(countryArr[r]+"Mc").getSymbol("carMc").stop();
         			sym.getSymbol("circuitMc").getSymbol(countryArr[r]+"Mc").stop();
               }
               sym.getSymbol("circuitMc").$("circuitImg").attr('src','images/'+countryArr[gpNo]+'circuit.jpg');
         		sym.getSymbol("menuButtons").$("menuBtn8").off('click');
               sym.getSymbol("circuitMc").$("weather").attr('src','images/weather0.png');						
               sym.getSymbol("circuitMc").$("weatherTxt").hide();
               sym.getSymbol("circuitMc").$("statusTxt").html(statCap[4]);
               sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
               sym.getSymbol("liveMc").$("statusTxt").html(statCap[4]);
         		for (var n=0;n<8; n++){
         			sym.getSymbol("menuButtons").getSymbol("phaseBtn"+n).$("btnBg").css({'background-color':'rgb(93,93,93)','border':'solid 1px rgb(255,255,255)'});
                  sym.getSymbol("menuButtons").$("phaseBtn"+n).off('click');
         		}
         		raceDetails(gp,gpNo);
         		sym.getSymbol("timingMc").$("loading").fadeIn(0);
         		sym.getSymbol("liveMc").$("loading").fadeIn(0);
         		sym.getSymbol("resultMc").$("loading").fadeIn(0);
         		sym.getSymbol("timingMc").$("graph").empty();
         		sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt").empty();
         		for (var i = 0; i < (teamArr.length*2); i++) {
         						sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).stop().animate({'top':781}, 0);								
         						sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).empty();
         		}
         
         		sym.getSymbol("timingMc").$("gridSlider").fadeOut(0);
         		sym.getSymbol("timingMc").$("graph").fadeOut(0);
         		sym.getSymbol("timingMc").$("timeTxt").fadeOut(0);
         		clearInterval(seasonInterval);
         		if (status==0){//Pre-race
         			menuArray[6].$("menuBg").fadeOut(0);
         			sym.$(screenArr[5]).fadeIn(200);
         			captionShift();
         			playIt(gpNo);
         		}else if(status==2){//Live
         			menuArray[7].$("menuBg").fadeOut(0);
         			sym.$(screenArr[4]).fadeIn(200);
         		}else if(status==4){//Finished
         			menuArray[8].$("menuBg").fadeOut(0);
         			sym.$(screenArr[7]).fadeIn(200);
         		}
         		sym.$("menuButtons").animate({'left':'380px'},400);	
         		if(gpNo<8){
         			sym.getSymbol('calendarMc').$('graph').stop().animate({scrollTop:gpNo*45+'px'},400);
         		}else{
         			sym.getSymbol('calendarMc').$('graph').stop().animate({scrollTop:'549px'},400)
         		}
         		for(var n=0;n<raceArr.length;n++){
         			if(gpNo==n){
         				$("#gp"+gpNo).css({'background-color':'rgba(255,225,215,0.6)'});
         				sym.getSymbol("mapIntro").getSymbol("mapBtn"+gpNo).$("btnBg").css({'background-color':'rgb(255,0,0)'});
         			}else{
         				$("#gp"+n).css({'background-color':'rgba(230,225,215,0)'});
         				sym.getSymbol("mapIntro").getSymbol("mapBtn"+n).$("btnBg").css({'background-color':'rgb(0,0,0)'});
         			}
         		}
         		latestGPno=gpNo;
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         function playIt(number){ //play circuit animation
         	sym.getSymbol("circuitMc").getSymbol(countryArr[number]+"Mc").getSymbol("carMc").play();	
         	setTimeout(function(){ sym.getSymbol("circuitMc").getSymbol(countryArr[number]+"Mc").play(0); },500);
         }
         var showPhase = function(phaseNo,stage,session){
         				return function(e){
         		resetmenu();
         				if (stage<6){
         					getPhases(phaseNo);
         					if(stage>2){
         						sym.getSymbol("timingMc").$("statusTxt").html(statCap[1]+" "+session);
         					}else{
         						sym.getSymbol("timingMc").$("statusTxt").html(statCap[0]+" "+session);
         					}
         					sym.getSymbol("timingMc").$("statusTxt").css({'background-color':'rgb(255,45,0)'});
         					sym.$("timingMc").fadeIn(200);
         					sym.getSymbol("timingMc").$("gridSlider"). fadeOut(0);
         					sym.getSymbol("timingMc").$("graph"). fadeIn(0);
         					sym.getSymbol("timingMc").$("timeTxt"). fadeIn(0);
         				}else if(stage==6){
         					getGrid(phaseNo);
         					sym.getSymbol("timingMc").$("statusTxt").html(statCap[2]);
         					sym.getSymbol("timingMc").$("statusTxt").css({'background-color':'rgb(255,45,0)'});
         					sym.$("timingMc").fadeIn(200);
         					sym.getSymbol("timingMc").$("gridSlider"). fadeIn(0);
         					sym.getSymbol("timingMc").$("graph"). fadeOut(0);
         					sym.getSymbol("timingMc").$("timeTxt"). fadeOut(0);
         				}else{
         					getLive(phaseNo);
         					sym.$(screenArr[6]).fadeOut(0);
         					sym.$(screenArr[4]).fadeIn(0);
         				}
         				var liveWidth=sym.getSymbol("timingMc").$("timeTxt").width();//Mar13
         				sym.getSymbol("timingMc").$("statusTxt").css({'right':liveWidth+25+"px"});//Mar13
         				menuArray[7].$("menuBg").fadeOut(0);
         				sym.getSymbol("menuButtons").$("menuBtn5xtra").stop().animate({'top':'-245px'},400);
         				for (var i=0; i<8;i++){
         					if(i==stage){
         						sym.getSymbol('menuButtons').getSymbol('phaseBtn'+i).$('btnBg').css({'background-color':'rgb(0,0,0)'});
         					}else{
         						sym.getSymbol('menuButtons').getSymbol('phaseBtn'+i).$('btnBg').css({'background-color':'rgb(93,93,93)'});
         					}
         				}
         			e.preventDefault();
         			e.stopPropagation();
         		}
         };
         function showFinished(){//Elements if race finished
         							raceFinished=1;
         							sym.getSymbol("menuButtons").$("menuBtn8").on ("click", {menuId:8}, menuBtnClick);
         }
         function sessLiveOrFin(latest,number,status){//Mar13
         	var stat=(number>0)?number+" "+status:status;
         	sym.getSymbol("circuitMc").$("statusTxt").html(latest+" "+stat);
         	sym.getSymbol("liveMc").$("statusTxt").html(latest+" "+stat);
         	var liveWidth=sym.getSymbol("liveMc").$("timeTxt").width();
         	sym.getSymbol("liveMc").$("statusTxt").css({'right':liveWidth+25+"px"});
         }
         function getSeason(){
         	$.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&q=season&yr="+gnYear+"&race=",
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         				sym.getSymbol("calendarMc").$('loading').fadeOut(0);
         				sym.getSymbol("calendarMc").$("graph").empty();
         				var seasondata=data;
         				var raceFinished;
         				var raceLive;
         				var gpflag;
         				var flagHTML;
         				var gpstatusHTML;
         				for (var i = 0; i < seasondata.length; i++) {
                  		var gpID = seasondata[i].n_EventPhaseID;
                  		var gpStatus=seasondata[i].n_StatusCode;
         					var countryShort = seasondata[i].c_CountryShort;
         					var orderNo;//Mar23
         					if(i==0){
         						orderNo=i;
         					}
         					if(gpStatus>512){
         						orderNo=i;
         					}else{
         						orderNo++;
         						if(seasondata[i].b_Current==true){
         							if(gpStatus>=128){
         								racestatus = 4;
         							}else if(gpStatus>=8&&gpStatus<128){
         								racestatus = 2;
         							}else{
         								racestatus = 0;
         							}
         							latestGP=gpID; //create function to fetch latest race data by default
         							latestGPno=i;
         							sym.getSymbol("menuButtons").$('menuBtn5').off('click',raceDetails);
         							sym.getSymbol("menuButtons").$('menuBtn5').on('click',raceDetails(gpID,i));
         							sym.getSymbol("menuButtons").$('menuBtn6').off('click',playIt);
         							sym.getSymbol("menuButtons").$('menuBtn6').on('click',playIt(i));
         							if(i<8){
         								sym.getSymbol('calendarMc').$('graph').stop().animate({scrollTop:i*45+'px'},400);
         							}else{
         								sym.getSymbol('calendarMc').$('graph').stop().animate({scrollTop:'549px'},400)
         							}
         						}else if(seasondata[i].b_Finished==true){
         							racestatus = 4;
         						}else{
         							racestatus = 0;
         						}
         						var seasonText="<div class='gpseason'>";
         						seasonText +="<table class='gpweekend' id='gp"+i+"'><tr>";
         						seasonText +="<td class='gpno' id='gpno"+i+"'></td>";
         						seasonText +="<td class='gpflag' id='gpflag"+i+"'></td>";
         						seasonText +="<td class='gpname' id='gpname"+i+"'></td>";
         						seasonText +="<td class='gpdate' id='gpdate"+i+"'></td>";
         						seasonText +="<td class='gpstat' id='gpstatus"+i+"'></td>";
         						seasonText +="</tr></table>";
         						seasonText +="</div>";	
         						sym.getSymbol("calendarMc").$("graph").append(seasonText);
         						gpflag =  seasondata[i].c_CountryShort.toLowerCase();
         						//gpflag =  countryArr[i];
         						flagHTML = "<img src='images/" +gpflag+ "Flag.png' height='35px' width='30px'>"
         						gpstatusHTML = "<img src='images/flag" +racestatus+ ".png' height='26px' width='26px'>";
         						var gpdate=getDDmonthYY(seasondata[i].d_DateEnd);
         						//$('#gpno' + i).text(i+1);
         						$('#gpno' + i).text(orderNo);//Mar23
         						sym.getSymbol("mapIntro").getSymbol("mapBtn"+i).$("btnTxt").text(orderNo);//Mar23
         						$('#gpflag' + i).html(flagHTML);
         						$('#gpflag' + i).css({'cursor':'pointer'});
         						$('#gpflag' + i).on('click',showGP(gpID,racestatus,i));	
         						$('#gpname' + i).text(raceArr[i][0]);
         						$('#gpname' + i).css({'cursor':'pointer'});
         						$('#gpname' + i).on('click',showGP(gpID,racestatus,i));
         						//$('#gpdate' + i).text(gpdate);
         						$('#gpdate' + i).html(gpDate[i]);
         						$('#gpstatus' + i).html(gpstatusHTML);
         						$('#gpstatus' + i).on('click',showGP(gpID,racestatus,i));
         						$('.gpseason').css({'width':'100%','height':'42px','border-top':'solid 1px rgb(255,255,255)','border-bottom':'solid 1px rgb(150,150,150)','font-family':'pragmatica-web, sans-serif','font-size':'13px'});
         						$('.gpweekend').css({'width':'100%'});
         						$('.gpno').css({'width':'8%','font-weight':700});
         						$('.gpflag').css({'width':'12%','text-align':'center'});
         						$('.gpname').css({'width':'38%','font-weight':700,'font-size':'14px'});
         						$('.gpdate').css({'width':'32%', 'font-style':'oblique','text-align':'left'});
         						$('.gpstat').css({'width':'10%','padding':'3px'});
         						sym.getSymbol("mapIntro").$("mapBtn"+i).on('click',showGP(gpID,racestatus,i));
         						sym.getSymbol("mapIntro").$("mapBtn"+i).css({'cursor':'pointer'});
         					}	
         				}
         				$("#gp"+latestGPno).css({'background-color':'rgba(255,225,215,0.6)'});
         				sym.getSymbol("mapIntro").getSymbol("mapBtn"+latestGPno).$("btnBg").css({'background-color':'rgb(255,0,0)'});		
         //LOAD BUTTONS WHEN SEASON IS AJAX SUCCESS
         				$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
         				var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         				menuBtnElement.off ("click",menuBtnClick);
         					menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
         				});
                  }
         	});
         }
         getSeason();
         seasonInterval = setInterval(getSeason,900000);
         //GET Start list if race hasn't started
         function getStartList(){
         $.ajax({ type: "GET", 
         						url: dataURL,
                         data: "gn="+gn+"&yr="+gnYear+"&q=startlist&race=",
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
         						var startData=data;
         						 if (startData.length>20){
         							barHeight = ((500/startData.length)-2);
         						 }else{
         							barHeight = 23;
         						 }
         						for (var i=0; i<startData.length; i++){
         							if(i==0){ //show lead driver details
         								var drivershort = startData[i].c_PersonShort;
         								var driverID = startData[i].n_PersonID;
         								var imgCar = startData[i].c_TeamShort;
         								var leadDriver = '<b>' +startData[i].c_Person+ '</b> ' +startData[i].c_NOCShort+ '</span>';
         								sym.getSymbol("driverchampMc").$("driversTxt").html(leadDriver);
         								sym.getSymbol("driverchampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         							}	
         							var tableText ="<div class='driverschamp'>";
         							tableText += "<div id='driverdata"+i+"'>";
         							tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         							tableText += "<td id='driverrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         							tableText += "<td id='driverNm"+i+"'width='150px'></td>";
         							tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         							tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         							tableText += "</tr></table>";
         							tableText += "</div></div>";
         							sym.getSymbol("driverchampMc").$("graph").append(tableText);
                  $('#driverrnk' + i).text(startData[i].c_ShirtNr);		
         			$('#driverNm' + i).text(startData[i].c_Person);
                  $('#driverteam' + i).text(startData[i].c_Team);
                  if (i==0){
         				$('#driverpts' + i).text("0"+caps[12]);
         			}else{
         				$('#driverpts' + i).text("0");
         			}
                  $(".driverschamp").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         			$("#driverdata" + i).css({'height':barHeight+'px','width':'65%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px','box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         			$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         			$("#driverdata" + i).animate({width:scale+'%'},1500);
                 }
         		}
         	});
         }
         var barHeight;
         var nRaceDrivers;
         var maxPoints;
         var scale;
         function getDriverStandings(){
         	$.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&q=champdrivers&yr="+gnYear+"&race=",
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         				var rankData = data;
         					sym.getSymbol("driverchampMc").$("loading").hide();
         					sym.getSymbol("driverchampMc").$("graph").empty();
         					if (rankData.length<1){
         						getStartList();
         					}else{
         					//Ensure all drivers will fit in graph
         					nRaceDrivers = rankData.length;
         					if (rankData.length>20){
         					barHeight = ((500/rankData.length)-2);
         					}else{
         					barHeight = 23;
         					}
         					//calculate relative length of each bar
         					maxPoints = rankData[0].n_PointsSort;
         					var min = (maxPoints!=null) ? maxPoints : 0;
         					for (var n=0; n<rankData.length; n++) {
         						if (rankData[n].n_PointsSort!=null && rankData[n].n_PointsSort<min) {
         							min = rankData[n].n_PointsSort;									
         						}
         					}					
         					for (var i = 0; i < rankData.length; i++) {
         						if(i==0){ //show lead driver details
         							var drivershort = rankData[i].c_PersonShort;
         							var driverID = rankData[i].n_PersonID;
         							var imgCar = rankData[i].c_TeamShort;
         							var leadDriver = '<b>' +rankData[i].c_Person+ '</b> ' +rankData[i].c_NOCShort+ '</span>';
         							sym.getSymbol("driverchampMc").$("driversTxt").html(leadDriver);
         							sym.getSymbol("driverchampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         						}
         						var tableText ="<div class='driverschamp'>";
         						tableText += "<div id='driverdata"+i+"'>";
         						tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         						tableText += "<td id='driverrnk"+i+"' width='30px' style='font-weight:bold'></td>";
         						tableText += "<td id='driverNm"+i+"'width='125px'></td>";
         						tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         						tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         						tableText += "</tr></table>";
         						tableText += "</div></div>";
         						sym.getSymbol("driverchampMc").$("graph").append(tableText);
         						if (rankData[i].n_Rank!=null){
         							$('#driverrnk' + i).text(rankData[i].n_Rank);
         						}else{
         						 $('#driverrnk' + i).text(i+1);
         						}         	
         						$('#driverNm' + i).text(rankData[i].c_PersonShort);
         						$('#driverteam' + i).text(rankData[i].c_TeamShort);
         						if (rankData[i].c_Points!=null){
         							if (i==0&&caps[12]!=undefined){
         								$('#driverpts' + i).text(rankData[i].c_Points+caps[12]);
         							}else{
         								$('#driverpts' + i).text(rankData[i].c_Points);
         							}	
         						}else{
         							$('#driverpts' + i).text("0");
         						}          		
         						if (maxPoints==min && rankData[i].n_PointsSort==maxPoints) {
         							scale=100;
         						}else if(rankData[i].n_PointsSort==null){
         							scale=50;
         						}else{
         							scale = 100-((maxPoints-rankData[i].n_PointsSort)*45/(maxPoints-min));
         						}
         						$(".driverschamp").css({'font-size':'14px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         						$("#driverdata" + i).css({'height':barHeight+'px','width':'50%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         						$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         						$("#driverdata" + i).animate({width:scale+'%'},400);
         					}
         			}
         		}
         	});
         }
         getDriverStandings();
         var nTeams;
         var teamBar;
         function getConsStandings(){
         	$.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&q=champteams&yr="+gnYear+"&race=",
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         			var teamData = data;
         			sym.getSymbol("menuButtons").$("menuBtn3").off('click',menuBtnClick);//disable button
         			if (teamData.length<1){//if championship hasn't started
         				sym.getSymbol("menuButtons").$("menuBtn3").on ("click", {menuId:4}, menuBtnClick);
         			}else{
         				sym.getSymbol("menuButtons").$("menuBtn3").on ("click", {menuId:3}, menuBtnClick);
         			//if (teamData.length>0){
         			sym.getSymbol("teamChampMc").$("loading").css({'display':'none'});
         			sym.getSymbol("teamChampMc").$("graph").empty();
         			//Ensure all teams will fit in graph
         			nTeams = teamData.length;
         			if (teamData.length>=10){
         				teamBar = ((260/teamData.length)-2);
         			}else{
         				teamBar = 25;
         			}
         			//calculate relative length of each bar
         			teamPoints = teamData[0].n_PointsSort;
         			var minpts = (teamPoints!=null) ? teamPoints : 0;
         			for (var n=0; n<teamData.length; n++) {
         						if (teamData[n].n_PointsSort!=null && teamData[n].n_PointsSort<minpts) {
         							minpts = teamData[n].n_PointsSort;									
         						}
         			}	
         			for (var i = 0; i < teamData.length; i++) {
         			teamname=teamData[i].c_TeamShort;
         			longname=teamData[i].c_Team;
         			if(i==0){ //show lead team details
         						var imgCar = teamData[i].c_TeamShort;
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("mainCar").attr("src","cars/"+imgCar+"big.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("reflection").attr("src","cars/"+imgCar+"big.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("driverHead").attr("src","drivers/"+imgCar+".png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("bkwheel").attr("src","cars/"+imgCar+"bk.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("frwheel").attr("src","cars/"+imgCar+"fr.png");
         						getStats(teamname,2);
         			}
         			var constructorsText ="<div class='teamchamp'>";
         			constructorsText += "<div id='teamdata"+i+"'>";
         			constructorsText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         			constructorsText += "<td id='teamrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         			constructorsText += "<td id='teamNm"+i+"'></td>";
         			constructorsText += "<td id='teampts"+i+"' style='font-weight:bold'></td>";
         			constructorsText += "</tr></table>";
         			constructorsText += "</div></div>";
         			sym.getSymbol("teamChampMc").$("graph").append(constructorsText);
                  if (teamData[i].n_Rank!=null){
                  $('#teamrnk' + i).text(teamData[i].n_Rank);
                  }else{
                   $('#teamrnk' + i).text(i+1);
         			} 		
         			$('#teamNm' + i).text(teamData[i].c_Team);
                  if(teamData[i].c_Points!=null){
         				if (i==0){
         					$('#teampts' + i).text(teamData[i].c_Points+caps[12]);
         				}else{
         					$('#teampts' + i).text(teamData[i].c_Points);
         				}
         			}else{
         				$('#teampts' + i).text("0");
         			}				                                   
         						if (teamPoints==minpts && teamData[i].n_PointsSort==teamPoints) {
         						scale=100;
         						}else if(teamData[i].n_PointsSort==null){
         						scale=56;
         						}else{
         						scale = 100-((teamPoints-teamData[i].n_PointsSort)*44/(teamPoints-minpts));
         						}
                  $(".teamchamp").css({'font-size':'14px', 'font-family':'pragmatica-web, sans-serif', 'width':'99%','margin-bottom':'2px'});
         			$("#teamdata" + i).css({'height':teamBar+'px','width':scale+'%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         			$("#teamdata" + i + " table").css({'height':teamBar+'px'});
         			$("#teampts" + i).css({'text-align':'right', 'padding-right':'3px'});
         						}
         			}
         		}
         	});
         }
         getConsStandings();
         var flag1txt;
         var flag2txt;
         function getStats(teamdetails,view){
         	sym.getSymbol(screenArr[view]).$("teamTxt0").css({'font-weight':700});	//team name	
         	for (var i=0;i<teamArr.length;i++){
         		if (teamdetails==teamArr[i]){
         			for (var t=0;t<10;t++){
         				sym.getSymbol(screenArr[view]).$("teamTxt"+t).html(teamTxtArr[i][t]);
         			}
         			if(view==2){
         				sym.getSymbol(screenArr[view]).$("teamTxt0").html(champHead[2]+" "+teamTxtArr[i][0]);
         			}else{
         				sym.getSymbol(screenArr[view]).$("teamTxt0").html(teamTxtArr[i][0]);
         			}
         			for (var x=0;x<2;x++){
         				if(driverID[i][x]>0){
         					sym.getSymbol(screenArr[view]).$("driverflag"+(x+1)).attr("src","images/"+teamTxtArr[i][(x+1)*4]+".gif");
         					sym.getSymbol(screenArr[view]).$("driverpic"+(x+1)).attr("src","drivers/"+driverID[i][x]+".jpg");//driver ID
         					sym.getSymbol(screenArr[view]).$("driverHelmet"+(x+1)).attr("src","drivers/"+driverID[i][x]+".png");//driver ID
         				}else{
         					sym.getSymbol(screenArr[view]).$("driverflag"+(x+1)).attr("src","images/blank.png");
         					sym.getSymbol(screenArr[view]).$("driverpic"+(x+1)).attr("src","images/blank.jpg");//driver ID
         					sym.getSymbol(screenArr[view]).$("driverHelmet"+(x+1)).attr("src","images/blank.png");//driver ID				
         				}						
         			}
         		}
         	}
         }
         //GET race weekend data
         var raceStage;
         function getRace(raceID){
         	$.ajax({ type: "GET", 
         				url: dataURL,
                     data: "gn="+gn+"&yr="+gnYear+"&q=race&race="+raceID,
                     contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                     async: true,
                     crossDomain: true,
                     success: function (data) {                	
         				var racePhases = data;
         				var n;
         				var latestPhase;
         				var getFunction;
         				var phaseBtnNo;
         				var sessionTxt;
         				for (var i = 0; i < racePhases.length; i++) {
         					phase=racePhases[i].n_PhaseID;
         					var sessionNo=(racePhases[i].n_SessionNr>0)?racePhases[i].n_SessionNr:"";
         					var sessLive=(racePhases[i].b_Current==true)?1:0;
         					var sessStarted=(racePhases[i].b_Started==true)?1:0;
         					var sessFin=(racePhases[i].b_Finished==true)?1:0;
         					var nullSession=0;
         					if (racePhases[i].b_FreePractice==true){
         						n = racePhases[i].n_Phase1Nr;						
         						phaseBtnNo=sessionNo-1;
         						raceStage = "FP";
         						if(racePhases[i].b_Started==true){
         							latestPhase = statCap[0];
         						}else{
         							if(n==1){//Mar6
                  					sessLive=0;
                  				}
                  				latestPhase = statCap[4];
                  				sessionNo="";
         						}
         					}else if (racePhases[i].b_Qualifying==true&&racePhases[i].n_Phase2Nr==null){//show nothing
         						sessLive=0;
         						sessFin=0;
         						sessStarted=0;	
         						nullSession=1;													
         					}else if (racePhases[i].b_Qualifying==true&&racePhases[i].n_Phase2Nr>0){						
         						n = racePhases[i].n_Phase2Nr;
         						phaseBtnNo=sessionNo+2;						
         						raceStage = "Q";
         						latestPhase = statCap[1];
         					}else if (racePhases[i].b_StartingGrid==true){	
         						n="0";
         						phaseBtnNo="6";
         						raceStage ="Q";
         						latestPhase = statCap[2];
         					}else if (racePhases[i].b_Race==true){
         						n="1";
         						phaseBtnNo="7";
         						raceStage ="R";
         						latestPhase = statCap[3];
         					}
                  		var lC=0;//Mar13
         					if(nullSession<1){
         						sym.getSymbol("menuButtons").$("phaseBtn"+phaseBtnNo).off("click");
         						clearInterval(gpInterval);
         						sessionTxt=sessionNo;
         						if(sessLive==1){											
         							if(sessStarted==1){
         								getInfo(phase);
         								getLive(phase);
         								if(racePhases[i].b_Race==true){
         									sessionTxt=" "+statCap[5];
         									getFunction=showPhase(phase,phaseBtnNo,sessionNo);
         								}else if(racePhases[i].b_StartingGrid==true){
         									getFunction=showPhase(phase,phaseBtnNo,sessionNo);
         								}else{
         									getFunction=showPhase(phase,phaseBtnNo,sessionNo);
         								}
         								if(sessFin==1){	
         									sym.getSymbol("menuButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(255,45,0)"}); 
         									if(racePhases[i].b_Race==true){
         										sessionTxt=" "+statCap[6];
         										showFinished();
         									}else if(racePhases[i].b_StartingGrid==true){
         										getFunction=showPhase(phase,phaseBtnNo,sessionNo);
         									}else{
         										sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(255,45,0)"});
         									}
         									lC=2;//Mar13
         								}else{
         									sym.getSymbol("menuButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(85,192,40)"});
         									sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(85,192,40)"});
         									lC=1;//Mar13
         								}
         							}else{
         								sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
         								sym.getSymbol("menuButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 1px rgb(100,100,100)"});
         								sym.getSymbol("menuButtons").$("menuBtn5").off('click');
         								sym.getSymbol("menuButtons").$("menuBtn8").off('click');
         								sessionTxt="";
         								lC=0;//Mar13
         							}
                           	sessLiveOrFin(latestPhase,sessionNo,statCap[4+lC]);//Mar13
         						}else if(sessFin==1){	
         							sym.getSymbol("menuButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(255,45,0)"});
         							sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(255,45,0)"});
         							if (racePhases[i].b_Race==true){
         								showFinished();
         								getInfo(phase);
         								getLive(phase);
         								getFunction=showPhase(phase,phaseBtnNo,sessionNo);
         							}else if(racePhases[i].b_StartingGrid==true){
         								getFunction=showPhase(phase,phaseBtnNo,sessionNo);
         							}else{
         								getFunction=showPhase(phase,phaseBtnNo,sessionNo);
         							}
         							lC=2;//Mar13
                  				sessLiveOrFin(latestPhase,sessionNo,statCap[4+lC]);//Mar13
         						}						
         					sym.getSymbol("menuButtons").$("phaseBtn"+phaseBtnNo).css({"cursor":"pointer"});
         					sym.getSymbol("menuButtons").$("phaseBtn"+phaseBtnNo).click(getFunction);
         				}
         			}//end for
         			phaseNo=phaseBtnNo;
         		},
         		error:function(){//Mar16
         		         		grid=false;
         		}
         	});
         }
         
         //GET individual phase info for laps/live race conditions
         function getInfo(phaseID){
         $.ajax({ type: "GET", 
         						url: dataURL,
                         data: "gn="+gn+"&yr="+gnYear+"&q=info&race="+phaseID,
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
         					var latestPhase;
         					var capHeight=364;
         					sym.getSymbol("liveMc").$("lapCounter").fadeOut(0);	
         					capsText[7].fadeOut(0);																				
         					if (data[0].n_WeatherConditionType!=null){
         						sym.getSymbol("circuitMc").$("weatherTxt").show();
         						sym.getSymbol("circuitMc").$("weather").attr('src','images/weather'+ data[0].n_WeatherConditionType +'.png');						
         					}
         					var sessionNo=(data[0].n_SessionNr>0)?data[0].n_SessionNr:"";
         					if (data[0].b_FreePractice==true){
         						pitstoptxt="";	
         					}else if(data[0].b_Qualifying==true){
         						pitstoptxt="";
         					}else if(data[0].b_StartingGrid==true){
         						sym.getSymbol("timingMc").$("statusTxt").css({'background-color':'rgb(85,192,40)'});
         						pitstoptxt="";
         					}else if(data[0].b_Race==true){
         						capHeight=312;
         						capsText[8].html(caps[11]);
         //Angle per lap
         						var laps = data[0].n_LapsScheduled;
         						var lapsDriven = data[0].n_LapsDriven;
         						var lapsAngle = 360*lapsDriven/laps;						
         						capsText[7].html(caps[7] +":<br><b>"+ lapsDriven+"/"+laps); //lap text
         						capsText[7].fadeIn(400);
         						sym.getSymbol("liveMc").$("pitstop").fadeIn(0);
         						sym.getSymbol("liveMc").$("lapCounter").fadeIn(400);																						
         						if (lapsDriven/laps<0.5){
         						sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps2").hide();
         						sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps1").animate({rotate:lapsAngle},{
         								step: function(now,fx) {
         								$(this).css('-webkit-transform','rotate('+now+'deg)');
         								$(this).css('-moz-transform','rotate('+now+'deg)'); 
         								$(this).css('-ms-transform','rotate('+now+'deg)'); 
         								$(this).css('-op-transform','rotate('+now+'deg)'); 
         								$(this).css('transform','rotate('+now+'deg)');
         								},duration:'fast'},'linear');
         						}else{
         						sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps1").animate({rotate:180},{
         								step: function(now,fx) {
         								$(this).css('-webkit-transform','rotate(180deg)');
         								$(this).css('-moz-transform','rotate(180deg)'); 
         								$(this).css('-moz-transform','rotate(180deg)'); 
         								$(this).css('-ms-transform','rotate(180deg)');
         								$(this).css('-op-transform','rotate(180deg)');
         								$(this).css('transform','rotate(180deg)');
         								},duration:'fast'},'linear');
         						sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps2").show();
         						sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps2").animate({rotate:lapsAngle},{
         								step: function(now,fx) {
         								$(this).css('-webkit-transform','rotate('+now+'deg)');
         								$(this).css('-moz-transform','rotate('+now+'deg)'); 
         								$(this).css('-ms-transform','rotate('+now+'deg)'); 
         								$(this).css('-op-transform','rotate('+now+'deg)'); 
         								$(this).css('transform','rotate('+now+'deg)');
         								},duration:'fast'},'linear');
         						}
         					}
         						if (data[0].b_Finished==true){
         							sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(255,45,0)"});
         							gpInterval=setInterval(liveGP,300000);
         						}else if (data[0].b_Started==true){
         							sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(85,192,40)"});
         							gpInterval=setInterval(liveGP,45000);
         						}else{
         							sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
         							gpInterval=setInterval(liveGP,300000);
         						}
         		}
         	});
         }
         //GET individual phase data for live and final result
         function getLive(phaseID) { 
          $.ajax({ type: "GET", 
         					 url: dataURL,
                         data: "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
                           raceData = data;
         					 //Ensure all drivers will fit in graph
         					 var nDrivers = raceData.length;
         					 var barHeightr;
         					 var minTime;
         					 var resultScale;
         					 if (raceData.length>20){
         					 barHeightr = ((500/raceData.length)-2);
         					 }else{
         					 barHeightr = 23;
         					 }
         					 //calculate relative length of each bar
         					 if (raceStage =="R"){
         					minTime = raceData[0].n_TimeRel;
         					var mxm = (minTime!=null) ? minTime : 0;
         					var timeRel = 0;							
         								for (var n=0; n<raceData.length; n++) {
         									if (raceData[n].n_TimeRel!=null && raceData[n].n_TimeRel>mxm) {
         									mxm = raceData[n].n_TimeRel;
         									}
         								}
         					}else if (raceData[0].n_TimeAbs!=undefined){//during other phases	
         					minTime = raceData[0].n_TimeAbs; 
         					var mxm = (minTime!=null) ? minTime : 0;
         					var timeRel = 1;							
         								for (var n=0; n<raceData.length; n++) {
         									if (raceData[n].n_TimeAbs!=null && raceData[n].n_TimeAbs>mxm) {
         									mxm = raceData[n].n_TimeAbs;									
         									}
         								}
         					}				
         					sym.getSymbol("resultMc").$("graph").empty();
                        sym.getSymbol("resultMc").$("loading").fadeOut(0);
         					sym.getSymbol("liveMc").$("graph").empty();					
                        sym.getSymbol("liveMc").$("loading").fadeOut(0);
                        for (var i = 0; i < raceData.length; i++) {
         						if(i==0){ //show lead drivers
         							var imgDriver1 = raceData[i].n_PersonID;
         							var leadDriver1 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         							sym.getSymbol("resultMc").$("driverPic1").attr("src", "drivers/"+imgDriver1+".jpg");
         							sym.getSymbol("resultMc").$("drivertxt1").html(leadDriver1);
         						}
         						if(i==1){ //show lead drivers
         							var imgDriver2 = raceData[i].n_PersonID;
         							var leadDriver2 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         							sym.getSymbol("resultMc").$("driverPic2").attr("src", "drivers/"+imgDriver2+".jpg");
         							sym.getSymbol("resultMc").$("drivertxt2").html(leadDriver2);
         						}
         						if(i==2){ //show lead drivers
         							var imgDriver3 = raceData[i].n_PersonID;
         							var leadDriver3 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         							sym.getSymbol("resultMc").$("driverPic3").attr("src", "drivers/"+imgDriver3+".jpg");
         							sym.getSymbol("resultMc").$("drivertxt3").html(leadDriver3);
         						}
         					//create graph for each driver and for final results
         					var tableText ="<div class='liverace'>";
         					tableText += "<div id='livedriverdata"+i+"'>";
         					tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					tableText += "<td id='driver"+i+"'width='125px'></td>";
         					tableText += "<td id='team"+i+"' style='font-style:italic' width='30px'></td>";
         					tableText += "<td id='pitstops"+i+"' style='font-weight:bold' width='15px'></td>";
         
         					tableText += "<td id='pitCap"+i+"'></td>";
         					tableText += "<td id='time"+i+"'></td>";
         					tableText += "</tr></table>";
         					tableText += "</div>";
         					tableText += "</div>";
         					var resultsText ="<div class='resultrace'>";
         					resultsText +="<div id='resultdata"+i+"'>";
         					resultsText +="<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					resultsText +="<td id='resultorder"+i+"' width='20px'></td>";
         					resultsText +="<td id='resultdriver"+i+"' width='125px'></td>";
         					resultsText +="<td id='resultteam"+i+"' style='font-style:italic' width='30px'></td>";
         					resultsText +="<td id='points"+i+"'></td>";
         					resultsText +="</tr></table>";
         					resultsText +="</div>";
         					resultsText +="</div>";					
         					sym.getSymbol("liveMc").$("graph").append(tableText);
         					 $('#driver' + i).text(raceData[i].c_PersonShort);
                         $('#team' + i).text(raceData[i].c_TeamShort);
                         if (raceData[i].n_PitStops){					
         					 $('#pitstops' + i).text(raceData[i].n_PitStops);
                         $('#pitstops' + i).css({'font-weight':'bold','text-align':'center','color':'rgb(255,255,255)','background-color':'rgba(0,0,0,0.15)'});
         						if (i==0){
         						$('#pitCap' + i).text(caps[10]);
         						$('#pitCap' + i).css({'font-weight':'bold', 'color':'rgba(0,0,0,0.30)'});
         						}
                         }
         			if (timeRel==1){
         					var hrs =(raceData[i].n_TimeAbs>3600000)?Math.floor(raceData[i].n_TimeAbs/3600000)+":":"";
         					var mins=(raceData[i].n_TimeAbs>3600000)?Math.floor((raceData[i].n_TimeAbs%3600000)/60000):Math.floor(raceData[i].n_TimeAbs/60000);
         					if (mins<10){
         						mins="0"+mins+":";
         					}else if(mins<1){
         						mins="00:";
         					}else{
         						mins=mins+":";
         					}
         					var secs=(raceData[i].n_TimeAbs>3600000)?(raceData[i].n_TimeAbs%3600000%60000)/1000:(raceData[i].n_TimeAbs%60000%60000)/1000;
         					if (secs<10){
         						secs="0"+secs;
         					}
         					var timing = hrs+mins+secs;
         					$('#time' + i).text(timing);
         					if (minTime==mxm && raceData[i].n_TimeAbs==mxm) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
         						scale=100;
         					}else if(raceData[i].n_TimeAbs==null){
         						scale=59;
         					}else{
         						scale = 100-((raceData[i].n_TimeAbs-minTime)*39/(mxm-minTime));
         					}	
         			}else if (timeRel==0){
         			//			var txt11lc= txt11.toLowerCase();					
         						if(raceData[i].n_RankSort==1&&raceData[i].n_TimeAbs==null){
         							scale=100;
         							$('#time' + i).text();
         						}else if(raceData[i].n_TimeRel==null){						
         						scale=59;
         							if (raceData[i].c_ResultSuffix==null){
         			//					$('#time' + i).text("+"+raceData[i].n_LapsRel+" "+txt11lc.substr(0,4));
         							}else{
         								$('#time' + i).text(raceData[i].c_ResultSuffix);
         							}
         						}else{
         						scale = 100-(raceData[i].n_TimeRel*39/mxm);
         						$('#time' + i).text(raceData[i].c_Result);
         						}
         			}
         					$(".liverace").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         					$("#livedriverdata" + i).css({'height':barHeightr+'px','width':scale+'%','background-color':'rgb(230,225,215)','padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         					$("#time" + i).css({'text-align':'right', 'padding-right':'5px'});
         //final results
         					if (raceFinished==1){ 
         					sym.getSymbol("resultMc").$("graph").append(resultsText);					
         					order = raceData[i].n_RankSort;
         					if (raceData[i].c_ChampionshipPoints!=undefined){
         					points = raceData[i].c_ChampionshipPoints;
         					}else{
         					points="";
         					}
         					//calculate relative length of each bar
         					maxPoints = raceData[0].c_ChampionshipPoints;
         					var min = (maxPoints!=null) ? maxPoints : 0;
         					for (var n=0; n<raceData.length; n++) {
         						if (raceData[n].c_ChampionshipPoints!=null && raceData[n].c_ChampionshipPoints<min) {
         							min = raceData[n].c_ChampionshipPoints;									
         						}					
         					}
         					if (maxPoints==min && raceData[i].c_ChampionshipPoints==maxPoints) {
         						resultScale=100;
         					}else if(raceData[i].c_ChampionshipPoints==null||raceData[i].c_ChampionshipPoints==undefined){
         						resultScale=50;
         					}else{
         						resultScale = 100-((maxPoints-raceData[i].c_ChampionshipPoints)*45/(maxPoints-min));
         					}
         					$('#resultorder' + i).html("<b>"+order+"</b>");
         					$('#resultdriver' + i).text(raceData[i].c_PersonShort);
                        $('#resultteam' + i).text(raceData[i].c_TeamShort);
         					if (i==0){
         					$('#points' + i).html("<b>"+points+caps[12]+"</b>");
         					}else{
         					$('#points' + i).html("<b>"+points+"</b>");
         					}
         					$(".resultrace").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         					$("#resultdata"+i).css({'height':barHeightr+'px','width':'50%','padding-left':'3px','background-color':'rgb(230,225,215)', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         					$("#points" + i).css({'text-align':'right', 'padding-right':'5px'});
         					$("#resultdata" + i).animate({'width':resultScale+'%'},400);
         					}
                      }
                   }	
         		});
         }
         
         var scalePhase;
         function getPhases(phaseID){
         $.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         					var phaseData = data;
         					var barHeight;
         					var minTime;
                        sym.getSymbol("timingMc").$("loading").fadeOut(0);
         					sym.getSymbol("timingMc").$("graph").empty();
         						//Ensure all drivers will fit in graph
         					 if (phaseData.length>20){
         					 barHeight = (500/phaseData.length)-2;
         					 }else{
         					 barHeight = 23;
         					 }
         					 minTime = phaseData[0].n_TimeAbs;
         					 var max = (minTime!=null) ? minTime : 0;
         								for (var n=0; n<phaseData.length; n++) {
         									if (phaseData[n].n_TimeAbs!=null && phaseData[n].n_TimeAbs>max) {
         									max = phaseData[n].n_TimeAbs;									
         									}
         									if (phaseData[n].n_TimeAbs!=null && phaseData[n].n_TimeAbs<minTime) {
         									minTime = phaseData[n].n_TimeAbs;									
         									}
         								}
                        for (var i = 0; i < phaseData.length; i++) {
         					var phaseText ="<div class='phaserace'>";
         					phaseText +="<div id='phasedriverdata"+i+"'>";
         					phaseText +="<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					phaseText +="<td id='phasedriver"+i+"'width='125px'></td>";
         					phaseText +="<td id='phaseteam"+i+"' style='font-style:italic' width='30px'></td>";
         					phaseText +="<td id='phasetime"+i+"'></td>";
         					phaseText +="</tr></table>";
         					phaseText +="</div>";
         					phaseText +="</div>";
         					sym.getSymbol("timingMc").$("graph").append(phaseText);
         					$('#phasedriver' + i).text(phaseData[i].c_PersonShort);
                        $('#phaseteam' + i).text(phaseData[i].c_TeamShort);
         					var mins=Math.floor(phaseData[i].n_TimeAbs/60000)+":";
         					var secs=(phaseData[i].n_TimeAbs%60000%60000)/1000;
         					if (secs<10){
         						secs="0"+secs;
         					}
         					$('#phasetime' + i).text(mins+secs);
         
         					if (minTime==max && phaseData[i].n_TimeAbs==max) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
         						scalePhase=100;
         					}else if(phaseData[i].n_TimeAbs==null){
         						scalePhase=59;
         					}else{
         						scalePhase = 100-((phaseData[i].n_TimeAbs-minTime)*41/(max-minTime));
         					}
         					$(".phaserace").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         					$("#phasedriverdata" + i).css({'height':barHeight+'px', 'width':'59%','padding-left':'3px','background-color':'rgb(230,225,215)', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         					$("#phasetime" + i).css({'text-align':'right', 'padding-right':'5px'});
         					$("#phasedriverdata" + i).animate({'width':scalePhase+'%'},400);
         					}
                     }
         		});
         }
         
         // GRID BUTTON
         function getGrid(phaseID){
         $.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
                  var gridData = data;
         				sym.getSymbol("timingMc").$("gridSlider"). fadeIn(500);
         				sym.getSymbol("timingMc").$("graph"). fadeOut(500);
         				sym.getSymbol("timingMc").$("timeTxt"). fadeOut(500);
         				if(gridData.length>0){//Mar14
         				sym.getSymbol("timingMc").$("loading").fadeOut(0);
         				}
         				var gridMove;
         				var go;
         				for (var i = 0; i < gridData.length; i++) {
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).empty();												
         					var gridText ="<div class='gridlist'>";
         					gridText +="<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					gridText +="<td class='gridorder' id='gridorder"+i+"'></td>";
         					gridText +="<td class='griddriver' id='griddriver"+i+"'></td>";
         					gridText +="<td class='gridteam' id='gridteam"+i+"'></td>";
         					gridText +="</tr></table>";
         					gridText +="</div>";
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt").append(gridText);
         					var gridCar = '<img src="cars/'+ gridData[i].c_TeamShort +'o.png" width="24px">';
         					var order = gridData[i].n_RankSort;
         					$('#gridorder' + i).html("<b>"+order+"</b>");
         					$('#griddriver' + i).text(gridData[i].c_Person);
         					$('#gridteam' + i).text(gridData[i].c_Team);
         					$(".gridlist").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'height':'35px'});
         					$(".gridorder").css({'width':'8%'});
         					$(".griddriver").css({'width':'52%'});
         					$(".gridteam").css({'width':'40%','font-style':'italic'});
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).append(gridCar);		
         					if (i%2==0){
         					gridMove=5+i*35;
         					}else{
         					gridMove=-16+i*35;
         					}
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).delay(i*400).animate({'top':gridMove}, 1000);	
         					sym.getSymbol("timingMc").$("gridSlider").css({'overflow-y':'auto'});						
         				}
                  }
               });
         }
         function liveGP(){
         				getRace(latestGP);
         }
         gpInterval=setInterval(liveGP,60000);
         // CIRCUIT BUTTONS & TIMELINE FUNCTIONS
         sym.gearChange = function(gearIn,gearOut,duration) {
         	sym.$({countNum: gearIn}).animate({countNum: gearOut}, {
         		duration: duration,
         		easeOut:'cubic',
         		step: function() {
         		 sym.getSymbol("circuitMc").$("gear").text(Math.round(this.countNum));
         		},
         	});
         }
         sym.speedChange = function(speedIn,speedOut,duration) {
         	sym.$({countNum: speedIn}).animate({countNum: speedOut}, {
         	  duration: duration,
         	  easeOut:'cubic',
         	  step: function() {
         		 sym.getSymbol("circuitMc").$("speed").html(Math.round(this.countNum));
         	  },
         	});
         }
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Bg'
   (function(symbolName) {   
   
   })("Bg");
   //Edge symbol end:'Bg'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'Calendar'
   (function(symbolName) {   
   
   })("CalendarMc");
   //Edge symbol end:'CalendarMc'

   //=========================================================
   
   //Edge symbol: 'ChampionshipMc'
   (function(symbolName) {   
   
   })("DriverChampMc");
   //Edge symbol end:'DriverChampMc'

   //=========================================================
   
   //Edge symbol: 'MenuButtonsMc'
   (function(symbolName) {   
   
   })("MenuButtonsMc");
   //Edge symbol end:'MenuButtonsMc'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtn_1'
   (function(symbolName) {   
   
   })("RaceBtn");
   //Edge symbol end:'RaceBtn'

   //=========================================================
   
   //Edge symbol: 'DriveCar'
   (function(symbolName) {   
   
   })("DriveCar");
   //Edge symbol end:'DriveCar'

   //=========================================================
   
   //Edge symbol: 'TeamChampMc'
   (function(symbolName) {   
   
   })("TeamChampMc");
   //Edge symbol end:'TeamChampMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'TeamButtonStrip'
   (function(symbolName) {   
   
   })("TeamButtonStrip");
   //Edge symbol end:'TeamButtonStrip'

   //=========================================================
   
   //Edge symbol: 'TeamBtns'
   (function(symbolName) {   
   
   })("TeamBtns");
   //Edge symbol end:'TeamBtns'

   //=========================================================
   
   //Edge symbol: 'DriversMc'
   (function(symbolName) {   
   
   })("DriversMc");
   //Edge symbol end:'DriversMc'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
   })("CircuitMc");
   //Edge symbol end:'CircuitMc'

   //=========================================================
   
   //Edge symbol: 'Phase'
   (function(symbolName) {   
   
   })("Phase");
   //Edge symbol end:'Phase'

   //=========================================================
   
   //Edge symbol: 'playPause'
   (function(symbolName) {   
   
   })("playPause");
   //Edge symbol end:'playPause'

   //=========================================================
   
   //Edge symbol: 'status'
   (function(symbolName) {   
   
   })("Status");
   //Edge symbol end:'Status'

   //=========================================================
   
   //Edge symbol: 'LiveMc'
   (function(symbolName) {   
   
   })("LiveMc");
   //Edge symbol end:'LiveMc'

   //=========================================================
   
   //Edge symbol: 'lapCounter'
   (function(symbolName) {   
   
   })("lapCounter");
   //Edge symbol end:'lapCounter'

   //=========================================================
   
   //Edge symbol: 'GridSlider'
   (function(symbolName) {   
   
   })("GridSlider");
   //Edge symbol end:'GridSlider'

   //=========================================================
   
   //Edge symbol: 'Grid'
   (function(symbolName) {   
   
   })("Grid");
   //Edge symbol end:'Grid'

   //=========================================================
   
   //Edge symbol: 'TimingMc'
   (function(symbolName) {   
   
   })("TimingMc");
   //Edge symbol end:'TimingMc'

   //=========================================================
   
   //Edge symbol: 'ResultMc'
   (function(symbolName) {   
   
   })("ResultMc");
   //Edge symbol end:'ResultMc'

   //=========================================================
   
   //Edge symbol: 'PhaseBtn'
   (function(symbolName) {   
   
   })("PhaseBtn");
   //Edge symbol end:'PhaseBtn'

   //=========================================================
   
   //Edge symbol: 'Home'
   (function(symbolName) {   
   
   })("Home");
   //Edge symbol end:'Home'

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("CarMc");
   //Edge symbol end:'CarMc'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'MapIntro'
   (function(symbolName) {   
   
   })("MapIntro");
   //Edge symbol end:'MapIntro'

   //=========================================================
   
   //Edge symbol: 'MapButton'
   (function(symbolName) {   
   
   })("MapButton");
   //Edge symbol end:'MapButton'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,299,1500);
         sym.getComposition().getStage().gearChange(1,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2150, function(sym, e) {
         sym.getComposition().getStage().speedChange(70,242,850);
         sym.getComposition().getStage().gearChange(2,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(287,110,400);
         sym.getComposition().getStage().gearChange(7,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(299,76,300);
         sym.getComposition().getStage().gearChange(7,2,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(242,287,1000);
         sym.getComposition().getStage().gearChange(5,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4400, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,252,850);
         sym.getComposition().getStage().gearChange(2,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(252,248,750);
         sym.getComposition().getStage().gearChange(6,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(248,191,1000);
         sym.getComposition().getStage().gearChange(6,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(191,203,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(203,281,500);
         sym.getComposition().getStage().gearChange(4,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(281,183,250);
         sym.getComposition().getStage().gearChange(7,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8895, function(sym, e) {
         sym.getComposition().getStage().speedChange(183,225,450);
         sym.getComposition().getStage().gearChange(4,5,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9606, function(sym, e) {
         sym.getComposition().getStage().speedChange(152,251,650);
         sym.getComposition().getStage().gearChange(3,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9359, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,152,250);
         sym.getComposition().getStage().gearChange(5,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(251,257,350);
         sym.getComposition().getStage().gearChange(6,6,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(257,269,500);
         sym.getComposition().getStage().gearChange(6,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1800, function(sym, e) {
         sym.getComposition().getStage().speedChange(76,70,350);
         sym.getComposition().getStage().gearChange(2,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11450, function(sym, e) {
         sym.getComposition().getStage().speedChange(122,300,1000);
         sym.getComposition().getStage().gearChange(2,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,84,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(84,299,1000);
         sym.getComposition().getStage().gearChange(2,7,1000);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11100, function(sym, e) {
         sym.getComposition().getStage().speedChange(269,122,350);
         sym.getComposition().getStage().gearChange(6,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("MASMc");
   //Edge symbol end:'MASMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,311,750);
         sym.getComposition().getStage().gearChange(1,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,295,850);
         sym.getComposition().getStage().gearChange(2,6,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3550, function(sym, e) {
         sym.getComposition().getStage().speedChange(76,270,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(311,95,750);
         sym.getComposition().getStage().gearChange(7,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,76,300);
         sym.getComposition().getStage().gearChange(6,2,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5150, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,108,1200);
         sym.getComposition().getStage().gearChange(6,3,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6350, function(sym, e) {
         sym.getComposition().getStage().speedChange(108,261,1400);
         sym.getComposition().getStage().gearChange(3,6,1400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(261,85,500);
         sym.getComposition().getStage().gearChange(6,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,250,1250);
         sym.getComposition().getStage().gearChange(2,6,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,326,1000);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,85,250);
         sym.getComposition().getStage().gearChange(2,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(326,73,150);
         sym.getComposition().getStage().gearChange(7,2,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12900, function(sym, e) {
         sym.getComposition().getStage().speedChange(73,159,850);
         sym.getComposition().getStage().gearChange(2,4,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(159,300,1250);
         sym.getComposition().getStage().gearChange(4,7,1250);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("CHNMc");
   //Edge symbol end:'CHNMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,300,1000);
         sym.getComposition().getStage().gearChange(2,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2150, function(sym, e) {
         sym.getComposition().getStage().speedChange(63,158,350);
         sym.getComposition().getStage().gearChange(1,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(221,300,1000);
         sym.getComposition().getStage().gearChange(5,7,1000);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(158,221,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,111,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(111,190,1000);
         sym.getComposition().getStage().gearChange(2,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,253,750);
         sym.getComposition().getStage().gearChange(4,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(253,79,250);
         sym.getComposition().getStage().gearChange(6,1,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(79,205,900);
         sym.getComposition().getStage().gearChange(1,5,900);

      });
      //Edge binding end

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,63,650);
         sym.getComposition().getStage().gearChange(7,1,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7400, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,63,350);
         sym.getComposition().getStage().gearChange(5,1,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(63,284,1250);
         sym.getComposition().getStage().gearChange(1,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(284,255,1250);
         sym.getComposition().getStage().gearChange(7,6,1250);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,126,900);
         sym.getComposition().getStage().gearChange(6,3,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11650, function(sym, e) {
         sym.getComposition().getStage().speedChange(126,300,1200);
         sym.getComposition().getStage().gearChange(3,7,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,128,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(128,300,1250);
         sym.getComposition().getStage().gearChange(3,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("BRNMc");
   //Edge symbol end:'BRNMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,309,1700);
         sym.getComposition().getStage().gearChange(1,7,1700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(309,141,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(286,142,400);
         sym.getComposition().getStage().gearChange(7,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(188,235,850);
         sym.getComposition().getStage().gearChange(4,5,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3100, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,286,1500);
         sym.getComposition().getStage().gearChange(5,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(142,248,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(248,102,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(102,262,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(262,145,250);
         sym.getComposition().getStage().gearChange(6,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,185,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(141,188,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,246,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(246,230,350);
         sym.getComposition().getStage().gearChange(5,5,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8600, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,291,1250);
         sym.getComposition().getStage().gearChange(5,7,1250);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(291,74,350);
         sym.getComposition().getStage().gearChange(7,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(74,125,1000);
         sym.getComposition().getStage().gearChange(2,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11600, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,128,500);
         sym.getComposition().getStage().gearChange(3,3,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(128,171,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(171,95,150);
         sym.getComposition().getStage().gearChange(3,2,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12900, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,212,600);
         sym.getComposition().getStage().gearChange(2,4,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(212,300,1250);
         sym.getComposition().getStage().gearChange(4,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("ESPMc");
   //Edge symbol end:'ESPMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,309,1700);
         sym.getComposition().getStage().gearChange(1,7,1700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(309,141,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(286,142,400);
         sym.getComposition().getStage().gearChange(7,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(188,235,850);
         sym.getComposition().getStage().gearChange(4,5,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3100, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,286,1500);
         sym.getComposition().getStage().gearChange(5,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(142,248,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(248,102,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(102,262,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(262,145,250);
         sym.getComposition().getStage().gearChange(6,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,185,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(141,188,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,246,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(246,230,350);
         sym.getComposition().getStage().gearChange(5,5,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8600, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,291,1250);
         sym.getComposition().getStage().gearChange(5,7,1250);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(291,74,350);
         sym.getComposition().getStage().gearChange(7,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(74,125,1000);
         sym.getComposition().getStage().gearChange(2,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11600, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,128,500);
         sym.getComposition().getStage().gearChange(3,3,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(128,171,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(171,95,150);
         sym.getComposition().getStage().gearChange(3,2,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12900, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,212,600);
         sym.getComposition().getStage().gearChange(2,4,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(212,300,1250);
         sym.getComposition().getStage().gearChange(4,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("MONMc");
   //Edge symbol end:'MONMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,136,700);
         sym.getComposition().getStage().gearChange(1,2,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(136,77,750);
         sym.getComposition().getStage().gearChange(2,1,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,254,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(253,130,500);
         sym.getComposition().getStage().gearChange(5,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2750, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,155,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(254,93,750);
         sym.getComposition().getStage().gearChange(5,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(93,155,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,294,1500);
         sym.getComposition().getStage().gearChange(2,6,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(294,120,350);
         sym.getComposition().getStage().gearChange(6,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6850, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,160,400);
         sym.getComposition().getStage().gearChange(2,2,400);

      });
      //Edge binding end

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(77,253,750);
         sym.getComposition().getStage().gearChange(1,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,297,1500);
         sym.getComposition().getStage().gearChange(2,6,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(297,56,750);
         sym.getComposition().getStage().gearChange(6,1,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(56,310,1250);
         sym.getComposition().getStage().gearChange(1,7,1250);

      });
      //Edge binding end

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,135,1250);
         sym.getComposition().getStage().gearChange(7,2,1250);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,294,600);
         sym.getComposition().getStage().gearChange(2,6,600);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("CANMc");
   //Edge symbol end:'CANMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,950);
         sym.getComposition().getStage().gearChange(1,6,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,120,400);
         sym.getComposition().getStage().gearChange(6,2,400);

      });
      //Edge binding end

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,65,600);
         sym.getComposition().getStage().gearChange(6,1,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(65,290,1000);
         sym.getComposition().getStage().gearChange(1,7,1000);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,100,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,210,1000);
         sym.getComposition().getStage().gearChange(2,5,1000);

      });
      //Edge binding end

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1400, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,285,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,175,1000);
         sym.getComposition().getStage().gearChange(5,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(175,195,1000);
         sym.getComposition().getStage().gearChange(4,5,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,195,500);
         sym.getComposition().getStage().gearChange(6,4,500);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(195,270,1000);
         sym.getComposition().getStage().gearChange(5,6,1000);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(195,145,1000);
         sym.getComposition().getStage().gearChange(4,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,295,1250);
         sym.getComposition().getStage().gearChange(3,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("AUTMc");
   //Edge symbol end:'AUTMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,295,700);
         sym.getComposition().getStage().gearChange(1,6,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,120,250);
         sym.getComposition().getStage().gearChange(6,2,250);

      });
      //Edge binding end

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,95,500);
         sym.getComposition().getStage().gearChange(4,2,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2750, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,300,1750);
         sym.getComposition().getStage().gearChange(2,7,1750);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,96,500);
         sym.getComposition().getStage().gearChange(7,2,1000);

      });
      //Edge binding end

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,185,750);
         sym.getComposition().getStage().gearChange(2,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(96,111,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(111,154,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,287,1250);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(154,265,500);
         sym.getComposition().getStage().gearChange(2,6,500);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(287,297,1650);
         sym.getComposition().getStage().gearChange(7,7,1650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9400, function(sym, e) {
         sym.getComposition().getStage().speedChange(291,241,350);
         sym.getComposition().getStage().gearChange(7,6,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(249,211,450);
         sym.getComposition().getStage().gearChange(6,5,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10200, function(sym, e) {
         sym.getComposition().getStage().speedChange(211,252,400);
         sym.getComposition().getStage().gearChange(5,5,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(252,300,1250);
         sym.getComposition().getStage().gearChange(5,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,199,250);
         sym.getComposition().getStage().gearChange(7,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(199,275,1000);
         sym.getComposition().getStage().gearChange(4,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,95,500);
         sym.getComposition().getStage().gearChange(6,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,226,500);
         sym.getComposition().getStage().gearChange(2,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(226,290,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("ENGMc");
   //Edge symbol end:'ENGMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,700);
         sym.getComposition().getStage().gearChange(1,6,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,240,250);
         sym.getComposition().getStage().gearChange(6,5,250);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2750, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,100,250);
         sym.getComposition().getStage().gearChange(6,3,250);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,295,1000);
         sym.getComposition().getStage().gearChange(5,6,1000);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,200,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,280,1250);
         sym.getComposition().getStage().gearChange(4,6,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,65,750);
         sym.getComposition().getStage().gearChange(7,2,750);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,305,1750);
         sym.getComposition().getStage().gearChange(6,7,1750);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(65,270,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,285,350);
         sym.getComposition().getStage().gearChange(6,6,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8600, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,105,1000);
         sym.getComposition().getStage().gearChange(6,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9600, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,210,650);
         sym.getComposition().getStage().gearChange(3,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,285,1000);
         sym.getComposition().getStage().gearChange(5,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,170,1500);
         sym.getComposition().getStage().gearChange(6,4,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,170,1000);
         sym.getComposition().getStage().gearChange(4,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13905, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,220,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,290,500);
         sym.getComposition().getStage().gearChange(5,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("GERMc");
   //Edge symbol end:'GERMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,291,1450);
         sym.getComposition().getStage().gearChange(1,7,1450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(291,93,250);
         sym.getComposition().getStage().gearChange(7,2,250);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,108,1250);
         sym.getComposition().getStage().gearChange(5,2,1250);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(93,230,750);
         sym.getComposition().getStage().gearChange(2,5,750);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(224,281,1000);
         sym.getComposition().getStage().gearChange(5,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(108,224,500);
         sym.getComposition().getStage().gearChange(2,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5900, function(sym, e) {
         sym.getComposition().getStage().speedChange(209,240,450);
         sym.getComposition().getStage().gearChange(5,5,450);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(281,209,650);
         sym.getComposition().getStage().gearChange(7,5,650);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6350, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,148,250);
         sym.getComposition().getStage().gearChange(5,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6600, function(sym, e) {
         sym.getComposition().getStage().speedChange(148,241,650);
         sym.getComposition().getStage().gearChange(3,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(241,105,150);
         sym.getComposition().getStage().gearChange(5,2,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7400, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,139,350);
         sym.getComposition().getStage().gearChange(2,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(139,171,500);
         sym.getComposition().getStage().gearChange(2,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(171,151,500);
         sym.getComposition().getStage().gearChange(4,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(151,243,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(243,249,500);
         sym.getComposition().getStage().gearChange(5,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(249,271,1000);
         sym.getComposition().getStage().gearChange(6,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11000, function(sym, e) {
         sym.getComposition().getStage().speedChange(271,113,250);
         sym.getComposition().getStage().gearChange(6,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(113,100,1250);
         sym.getComposition().getStage().gearChange(2,2,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,198,900);
         sym.getComposition().getStage().gearChange(2,4,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13400, function(sym, e) {
         sym.getComposition().getStage().speedChange(198,132,350);
         sym.getComposition().getStage().gearChange(4,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(132,290,1250);
         sym.getComposition().getStage().gearChange(3,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("HUNMc");
   //Edge symbol end:'HUNMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,64,450);
         sym.getComposition().getStage().gearChange(1,1,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.getComposition().getStage().speedChange(64,290,750);
         sym.getComposition().getStage().gearChange(1,6,750);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2750, function(sym, e) {
         sym.getComposition().getStage().speedChange(297,330,1500);
         sym.getComposition().getStage().gearChange(6,7,1500);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,294,1500);
         sym.getComposition().getStage().gearChange(6,6,1500);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,170,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4650, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,140,350);
         sym.getComposition().getStage().gearChange(7,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,177,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(177,265,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,152,750);
         sym.getComposition().getStage().gearChange(6,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(152,290,1000);
         sym.getComposition().getStage().gearChange(3,5,1000);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,140,1250);
         sym.getComposition().getStage().gearChange(5,3,1250);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,170,600);
         sym.getComposition().getStage().gearChange(3,3,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9850, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,250,650);
         sym.getComposition().getStage().gearChange(3,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10500, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,245,500);
         sym.getComposition().getStage().gearChange(5,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11000, function(sym, e) {
         sym.getComposition().getStage().speedChange(245,305,1500);
         sym.getComposition().getStage().gearChange(5,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,297,500);
         sym.getComposition().getStage().gearChange(7,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(297,80,1150);
         sym.getComposition().getStage().gearChange(6,1,1150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14150, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,290,850);
         sym.getComposition().getStage().gearChange(1,6,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("BELMc");
   //Edge symbol end:'BELMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,335,1750);
         sym.getComposition().getStage().gearChange(1,7,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,86,250);
         sym.getComposition().getStage().gearChange(7,1,250);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(74,260,750);
         sym.getComposition().getStage().gearChange(1,5,750);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(86,74,250);
         sym.getComposition().getStage().gearChange(1,1,250);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,330,850);
         sym.getComposition().getStage().gearChange(6,7,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,305,750);
         sym.getComposition().getStage().gearChange(5,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,120,400);
         sym.getComposition().getStage().gearChange(7,2,400);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,133,250);
         sym.getComposition().getStage().gearChange(2,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(133,264,750);
         sym.getComposition().getStage().gearChange(2,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(264,193,250);
         sym.getComposition().getStage().gearChange(5,4,250);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(193,260,750);
         sym.getComposition().getStage().gearChange(4,5,750);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,178,250);
         sym.getComposition().getStage().gearChange(5,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(178,304,1500);
         sym.getComposition().getStage().gearChange(3,6,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(304,332,750);
         sym.getComposition().getStage().gearChange(6,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(332,169,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(169,212,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(212,235,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10500, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,335,1500);
         sym.getComposition().getStage().gearChange(4,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,215,500);
         sym.getComposition().getStage().gearChange(7,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,285,750);
         sym.getComposition().getStage().gearChange(4,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,300,1000);
         sym.getComposition().getStage().gearChange(5,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("ITAMc");
   //Edge symbol end:'ITAMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,950);
         sym.getComposition().getStage().gearChange(1,6,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,90,650);
         sym.getComposition().getStage().gearChange(6,2,650);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,135,750);
         sym.getComposition().getStage().gearChange(4,3,750);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1650, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,200,600);
         sym.getComposition().getStage().gearChange(2,4,600);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,298,750);
         sym.getComposition().getStage().gearChange(7,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,280,1250);
         sym.getComposition().getStage().gearChange(3,7,1250);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(298,110,400);
         sym.getComposition().getStage().gearChange(7,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5400, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,94,600);
         sym.getComposition().getStage().gearChange(3,2,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(94,126,650);
         sym.getComposition().getStage().gearChange(2,6,650);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6650, function(sym, e) {
         sym.getComposition().getStage().speedChange(126,255,850);
         sym.getComposition().getStage().gearChange(3,6,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,140,1000);
         sym.getComposition().getStage().gearChange(6,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,80,750);
         sym.getComposition().getStage().gearChange(3,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,250,1100);
         sym.getComposition().getStage().gearChange(2,6,1100);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,225,750);
         sym.getComposition().getStage().gearChange(2,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10350, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,80,400);
         sym.getComposition().getStage().gearChange(6,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11500, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,85,250);
         sym.getComposition().getStage().gearChange(5,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,130,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,80,500);
         sym.getComposition().getStage().gearChange(3,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,126,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(126,80,250);
         sym.getComposition().getStage().gearChange(3,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,118,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(118,150,1000);
         sym.getComposition().getStage().gearChange(3,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,200,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,290,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("SINMc");
   //Edge symbol end:'SINMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,950);
         sym.getComposition().getStage().gearChange(1,6,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,260,650);
         sym.getComposition().getStage().gearChange(6,6,650);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,245,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1650, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,140,600);
         sym.getComposition().getStage().gearChange(6,3,600);

      });
      //Edge binding end

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,185,500);
         sym.getComposition().getStage().gearChange(4,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(245,200,250);
         sym.getComposition().getStage().gearChange(5,4,250);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,185,2250);
         sym.getComposition().getStage().gearChange(4,4,400);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,123,500);
         sym.getComposition().getStage().gearChange(4,2,500);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(123,64,1500);
         sym.getComposition().getStage().gearChange(2,1,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(64,285,750);
         sym.getComposition().getStage().gearChange(1,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,297,750);
         sym.getComposition().getStage().gearChange(7,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(297,180,750);
         sym.getComposition().getStage().gearChange(7,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,312,1250);
         sym.getComposition().getStage().gearChange(3,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,140,750);
         sym.getComposition().getStage().gearChange(4,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(312,90,1250);
         sym.getComposition().getStage().gearChange(7,2,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,290,750);
         sym.getComposition().getStage().gearChange(2,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("JPNMc");
   //Edge symbol end:'JPNMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,310,1400);
         sym.getComposition().getStage().gearChange(1,8,1400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,325,1500);
         sym.getComposition().getStage().gearChange(7,7,1500);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,275,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,125,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,165,1000);
         sym.getComposition().getStage().gearChange(7,4,1000);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,125,1000);
         sym.getComposition().getStage().gearChange(4,3,1000);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,265,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,165,1250);
         sym.getComposition().getStage().gearChange(6,4,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,215,1250);
         sym.getComposition().getStage().gearChange(4,5,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,330,1250);
         sym.getComposition().getStage().gearChange(5,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,110,1250);
         sym.getComposition().getStage().gearChange(2,3,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,90,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,260,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,115,500);
         sym.getComposition().getStage().gearChange(6,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14750, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,250,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("RUSMc");
   //Edge symbol end:'RUSMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,300,1450);
         sym.getComposition().getStage().gearChange(1,7,1450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,99,150);
         sym.getComposition().getStage().gearChange(7,2,150);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,280,750);
         sym.getComposition().getStage().gearChange(5,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1650, function(sym, e) {
         sym.getComposition().getStage().speedChange(99,250,600);
         sym.getComposition().getStage().gearChange(2,5,600);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,210,1500);
         sym.getComposition().getStage().gearChange(6,5,1500);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,120,500);
         sym.getComposition().getStage().gearChange(5,3,500);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,255,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,99,1150);
         sym.getComposition().getStage().gearChange(6,2,1150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6900, function(sym, e) {
         sym.getComposition().getStage().speedChange(99,290,1350);
         sym.getComposition().getStage().gearChange(2,6,1350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,308,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,94,1250);
         sym.getComposition().getStage().gearChange(2,2,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(308,110,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11500, function(sym, e) {
         sym.getComposition().getStage().speedChange(94,175,2000);
         sym.getComposition().getStage().gearChange(2,4,2000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13600, function(sym, e) {
         sym.getComposition().getStage().speedChange(175,99,900);
         sym.getComposition().getStage().gearChange(4,2,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(99,300,250);
         sym.getComposition().getStage().gearChange(2,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("USAMc");
   //Edge symbol end:'USAMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("315");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,315,450);
         sym.getComposition().getStage().gearChange(1,7,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,106,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(166,257,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(106,166,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(257,323,1200);
         sym.getComposition().getStage().gearChange(5,7,1200);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(323,154,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         sym.getComposition().getStage().speedChange(154,251,600);
         sym.getComposition().getStage().gearChange(3,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5350, function(sym, e) {
         sym.getComposition().getStage().speedChange(251,293,1100);
         sym.getComposition().getStage().gearChange(5,6,1100);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(293,218,250);
         sym.getComposition().getStage().gearChange(6,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(218,231,500);
         sym.getComposition().getStage().gearChange(5,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(76,104,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(231,76,750);
         sym.getComposition().getStage().gearChange(5,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(104,72,900);
         sym.getComposition().getStage().gearChange(2,2,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9400, function(sym, e) {
         sym.getComposition().getStage().speedChange(72,235,850);
         sym.getComposition().getStage().gearChange(2,5,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,130,850);
         sym.getComposition().getStage().gearChange(5,3,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11151, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,276,1350);
         sym.getComposition().getStage().gearChange(3,6,1350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(276,309,1000);
         sym.getComposition().getStage().gearChange(6,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(309,315,1250);
         sym.getComposition().getStage().gearChange(7,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("BRAMc");
   //Edge symbol end:'BRAMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,700);
         sym.getComposition().getStage().gearChange(1,6,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,127,400);
         sym.getComposition().getStage().gearChange(6,3,400);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,254,650);
         sym.getComposition().getStage().gearChange(6,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1150, function(sym, e) {
         sym.getComposition().getStage().speedChange(127,260,600);
         sym.getComposition().getStage().gearChange(3,6,600);

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2400, function(sym, e) {
         sym.getComposition().getStage().speedChange(254,300,850);
         sym.getComposition().getStage().gearChange(5,7,850);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,70,1000);
         sym.getComposition().getStage().gearChange(7,2,1000);

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(70,260,750);
         sym.getComposition().getStage().gearChange(2,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,315,800);
         sym.getComposition().getStage().gearChange(6,7,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,81,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(81,125,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(312,128,850);
         sym.getComposition().getStage().gearChange(7,3,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,312,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(128,110,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11109, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,275,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,113,1500);
         sym.getComposition().getStage().gearChange(6,3,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(113,125,1500);
         sym.getComposition().getStage().gearChange(3,3,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,290,500);
         sym.getComposition().getStage().gearChange(3,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("UAEMc");
   //Edge symbol end:'UAEMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,305,1150);
         sym.getComposition().getStage().gearChange(1,7,1150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1856, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,282,1150);
         sym.getComposition().getStage().gearChange(4,5,1150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3425, function(sym, e) {
         sym.getComposition().getStage().speedChange(92,145,325);
         sym.getComposition().getStage().gearChange(2,3,325);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1151, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,145,200);
         sym.getComposition().getStage().gearChange(7,3,200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(282,92,425);
         sym.getComposition().getStage().gearChange(5,2,425);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.$({countNum: 220}).animate({countNum: 280}, {
           duration: 1400,
           easeOut:'cubic',
           step: function() {
             sym.$("speed").html(Math.round(this.countNum));
           },
         });
         
         sym.$({countNum: 5}).animate({countNum: 7}, {
           duration: 1400,
           easeOut:'cubic',
           step: function() {
             sym.$("gear").text(Math.round(this.countNum));
           },
         });
         sym.getComposition().getStage().speedChange(145,239,650);
         sym.getComposition().getStage().gearChange(3,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4400, function(sym, e) {
         sym.getComposition().getStage().speedChange(239,283,850);
         sym.getComposition().getStage().gearChange(6,7,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(283,186,750);
         sym.getComposition().getStage().gearChange(7,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(186,255,450);
         sym.getComposition().getStage().gearChange(4,6,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6450, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,280,800);
         sym.getComposition().getStage().gearChange(6,7,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,115,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,292,1750);
         sym.getComposition().getStage().gearChange(3,7,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(226,233,400);
         sym.getComposition().getStage().gearChange(6,5,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(292,226,500);
         sym.getComposition().getStage().gearChange(7,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10150, function(sym, e) {
         sym.getComposition().getStage().speedChange(233,284,600);
         sym.getComposition().getStage().gearChange(5,7,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(284,284,400);
         sym.getComposition().getStage().gearChange(7,7,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1350, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,200,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11938, function(sym, e) {
         sym.getComposition().getStage().speedChange(138,205,1000);
         sym.getComposition().getStage().gearChange(3,5,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12923, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,84,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(84,180,500);
         sym.getComposition().getStage().gearChange(2,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,300,1000);
         sym.getComposition().getStage().gearChange(4,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(284,138,200);
         sym.getComposition().getStage().gearChange(7,3,200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40);

      });
      //Edge binding end

   })("AUSMc");
   //Edge symbol end:'AUSMc'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("000");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(0,0,40);
         sym.getComposition().getStage().gearChange(0,0,40)

      });
      //Edge binding end

   })("MEXMc");
   //Edge symbol end:'MEXMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32552");