/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var standtxt = sym.$("standTxt").css("pointer-events","none");
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txtBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(0,0,0,1)","color":"rgba(0,0,0,1)",
	"background-color":"rgba(255,193,14,0.8)", "height":"auto", "padding":"6px"};
	
	var txt=[];
	for(var i=0;i<19;i++){
	         	txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
	         	}
	         	txt[2] = sym.$("txt2").css(txtBox);
	         	txt[15] = sym.$("txt15").css({"height":"auto"});
	         	txt[17] = sym.$("txt17").css({"height":"auto"});
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32548.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			var headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			var stand = $(xml).find('stand').text();
			standtxt.html(stand);
			var source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<19; i++){
				txtArr[i]=$(xml).find('txt'+i).text();
				txt[i].html(txtArr[i]);
				txt[i].css({'font-size':fontSize});
			}
			sym.$("txt2").animate({top:328 - sym.$("txt2").height()+0}, 0);
			sym.$("txt15").animate({top:291 - sym.$("txt15").height()+10}, 0);
			sym.$("txt17").animate({top:291 - sym.$("txt17").height()+10}, 0);
	
		}
	}); // END XML
	
	sym.$("toggleBtn").on(clickEventType, function(e){
	sym.play(0);
	e.stopPropagation(); e.preventDefault();
	});

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'recBtn'
   (function(symbolName) {   
   
   })("recBtn");
   //Edge symbol end:'recBtn'

   //=========================================================
   
   //Edge symbol: 'recBtn_1'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'navBtns'
   (function(symbolName) {   
   
   })("navBtns");
   //Edge symbol end:'navBtns'

   //=========================================================
   
   //Edge symbol: 'navBg'
   (function(symbolName) {   
   
   })("navBg");
   //Edge symbol end:'navBg'

   //=========================================================
   
   //Edge symbol: 'toggleBtn_1'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32548");