/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "click" : "click");
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"height":"auto","pointer-events":"none"});
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txtBox = {"pointer-events":"none", "border-width":"0px", "border-radius":"10px", "background-color":"rgba(78,200,242,1.00)", "height":"auto", "padding":"6px"};
         	
         	var txt=[];
         	txt[0] = sym.$("txt0").css(txtBox);
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("watchFaceMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("iconesMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("iconesMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("iconesMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("iconesMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("mapMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("mapMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("mapMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("mapMc").$("txt12").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32536.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			for (var i=0; i<13; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         			}
         	
         			sym.getSymbol("styleHead").$("headBg").animate({height:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+15}, 0);
         			sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headBg").height()+5}, 0);
         		}
         	}); // END XML
         	
         // BUTTONS COUNT
         sym.$("btnAux0").on(clickEventType, function(e){
         	sym.play();
         	sym.$("txt0").html(txtArr[1]);
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.$("btnAux1").on(clickEventType, function(e){
         	sym.play();
         	sym.$("txt0").html(txtArr[2]);
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.$("btnAux2").on(clickEventType, function(e){
         	sym.play();
         	sym.$("txt0").html(txtArr[3]);
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.$("btnAux3").on(clickEventType, function(e){
         	sym.play();
         	sym.$("txt0").html(txtArr[0]);
         	e.stopPropagation(); e.preventDefault();
         	});

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.stop(0);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop(1);

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'watchFaceMc'
   (function(symbolName) {   
   
   })("watchFaceMc");
   //Edge symbol end:'watchFaceMc'

   //=========================================================
   
   //Edge symbol: 'iconesMc'
   (function(symbolName) {   
   
   })("iconesMc");
   //Edge symbol end:'iconesMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32536");