/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
var clickEventType = ('ontouchstart' in document.documentElement ? "click" : "click");

	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");

var btnNo = 0;
for (var b=0;b<14; b++){
	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).animate ({top:b*21}, 0);
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("number").text(b+1);
	sym.getSymbol("dotsMc").getSymbol("dot"+b).$("txt").text(b+1);
}

var whiteBox = {"pointer-events":"none", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)", "border-width":"1px","border-style":"solid","border-color":"rgba(0,0,0,1)",
"border-radius":"5px", "background-color":"rgba(255,255,255,1)", "padding":"6px", "width":"auto", "height":"auto"}

var blackBox = {"pointer-events":"none", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)",
"border-radius":"5px", "background-color":"rgba(50,50,50,1)", "padding":"6px", "width":"auto"}

var redBox = {"pointer-events":"none", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)",
"border-radius":"5px", "background-color":"rgba(218,0,0,1)", "padding":"6px", "height":"auto"}

var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.$("txt8").css(whiteBox);
	txt[9] = sym.$("txt9").css(blackBox);
	txt[10] = sym.$("txt10").css(redBox);
	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.getSymbol("bouyMc").$("txt12").css({"pointer-events":"none", "height":"auto"});
	txt[13] = sym.getSymbol("waveMc").$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.getSymbol("waveMc").$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.getSymbol("waveMc").$("txt15").css({"pointer-events":"none"});
	txt[16] = sym.getSymbol("waveMc").$("txt16").css({"pointer-events":"none"});
	txt[17] = sym.getSymbol("waveMc").$("txt17").css({"pointer-events":"none"});
	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
var txtArr=[];

//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32471.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			var headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			var stand = $(xml).find('stand').text();
			standtxt.html(stand);
			var source = $(xml).find('source').text();
			sourcetxt.html(source);

		var fontSize= $(xml).find('fontSize').text();
		for (var i=0; i<21; i++){
		txtArr[i]=$(xml).find('txt'+i).text();
		txt[i].html(txtArr[i]);
		txt[i].css({'font-size':fontSize});
		}	
		sym.$("txt9").animate({left:780 - sym.$("txt9").width()+0}, 0);
		sym.$("txt10").animate({top:284 - sym.$("txt10").height()+0}, 0);
		sym.getSymbol("bouyMc").$("txt12").animate({top:186 - sym.getSymbol("bouyMc").$("txt12").height()+0}, 0);
	}
}); // END XML

// MENU BUTTONS --------------------------------------------	
menuArray = [];//the array that will hold references to the buttons.

for (var h = 0; h < 14; h++){
menuArray.push(h);
}

function resetmenu(){
for (var h=0; h<menuArray.length; h++){
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" +h).$("btnClick").fadeOut(0);
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" +h).$("btnOver").fadeOut(0);
	}
}
resetmenu();

// MENU CLICK
var menuBtnClick = function(menuNo){ //to handle lexical scope
return function (e) {
	resetmenu();
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnClick").fadeIn(0);
	sym.getSymbol("dotsMc").getSymbol("dot" + menuNo).play();
	e.preventDefault();
	e.stopPropagation();
};
};
// MENU OVER
var menuBtnOver = function(menuNo){ //to handle lexical scope
return function (e) {
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnOver").fadeIn(0);
	e.preventDefault();
	e.stopPropagation();
};
};
// MENU OUT
var menuBtnOut = function(menuNo){ //to handle lexical scope
return function (e) {
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("btnOver").fadeOut(0);
	e.preventDefault();
	e.stopPropagation();
};
};
for (var b=0;b<menuArray.length;b++){
	sym.getSymbol("menuBtnsMc").$("menuBtn" +b).on(clickEventType,menuBtnClick(b));
	sym.getSymbol("menuBtnsMc").$("menuBtn" +b).on('mouseover',menuBtnOver(b));
	sym.getSymbol("menuBtnsMc").$("menuBtn" +b).on('mouseout',menuBtnOut(b));
	sym.getSymbol("menuBtnsMc").$("menuBtn" +b).css({'cursor':'pointer'});
}

// MAP BUTTONS --------------------------------------------	
var mapBtnClick = function(mapNo){ //to handle lexical scope
return function (e) {
	resetmenu();
	sym.$("menuBtnsMc").stop().animate({scrollTop:mapNo*30+'px'},400);
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + mapNo).$("btnClick").fadeIn(0);
	sym.getSymbol("dotsMc").getSymbol("dot" + mapNo).play();
	e.preventDefault();
	e.stopPropagation();
};
};
for (var m=0;m<menuArray.length;m++){
	sym.getSymbol("dotsMc").$("dot" +m).on(clickEventType,mapBtnClick(m));
	sym.getSymbol("dotsMc").$("dot" +m).css({'cursor':'pointer'});
}

// TOGGLE BUTTON 1
sym.$("txt9").stop().animate({opacity:0}, 0);
sym.$("toggleBtn").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
		sym.$("toggleBtn").fadeOut();
		sym.getSymbol("tMc").play();
		sym.$("txt9").stop().animate({opacity:1}, 0);
}); 

// TOGGLE BUTTON2
sym.$("waveMc").stop().animate ({opacity:0}, 0);
sym.$("bouyMc").stop().animate ({opacity:1}, 1000, 'easeOutCubic');
sym.$("toggleBtn2").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn2").$("btnPlus").is(":visible") ) { 
		sym.getSymbol("toggleBtn2").$("btnPlus").fadeOut(0);
		sym.$("bouyMc").stop().animate ({opacity:0}, 100);
		sym.$("boxSlide").stop().animate ({left:250}, 500, 'easeOutCubic');
		sym.$("waveMc").stop().delay(200).animate ({opacity:1}, 500);
		sym.getSymbol("waveMc").play();
	}else{
		sym.getSymbol("toggleBtn2").$("btnPlus").fadeIn(0);
		sym.$("waveMc").stop().animate ({opacity:0}, 100);
		sym.$("boxSlide").stop().animate ({left:410}, 500, 'easeOutCubic');
		sym.$("bouyMc").stop().delay(200).animate ({opacity:1}, 500);
	}
}); 
sym.$("toggleBtn2").mouseover(function(){
	sym.getSymbol("toggleBtn2").$("btnOver").stop().animate ({opacity:0.3}, 200);
});
sym.$("toggleBtn2").mouseout(function(){
	sym.getSymbol("toggleBtn2").$("btnOver").stop().animate ({opacity:0}, 200);
});

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cutBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'dotsMc'
   (function(symbolName) {   
   
   })("dotsMc");
   //Edge symbol end:'dotsMc'

   //=========================================================
   
   //Edge symbol: 'dot0'
   (function(symbolName) {   
   
   })("dot0");
   //Edge symbol end:'dot0'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'waveMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         //sym.play(0);

      });
      //Edge binding end

   })("waveMc");
   //Edge symbol end:'waveMc'

   //=========================================================
   
   //Edge symbol: 'bouyMc'
   (function(symbolName) {   
   
   })("bouyMc");
   //Edge symbol end:'bouyMc'

   //=========================================================
   
   //Edge symbol: 'tMc'
   (function(symbolName) {   
   
   })("tMc");
   //Edge symbol end:'tMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(jQuery, AdobeEdge, "GraphicNews32471");