/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.$("txt3").css({"pointer-events":"none", "height":"auto"});
	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.$("txt6").css({"pointer-events":"none", "height":"auto"});
	txt[7] = sym.getSymbol("graphsMc").getSymbol("graph0").$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("graphsMc").getSymbol("graph0").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.getSymbol("graphsMc").getSymbol("graph0").$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.getSymbol("graphsMc").getSymbol("graph1").$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.getSymbol("graphsMc").getSymbol("graph1").$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.getSymbol("graphsMc").getSymbol("graph1").$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.getSymbol("graphsMc").getSymbol("graph2").$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.getSymbol("graphsMc").getSymbol("graph2").$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.getSymbol("graphsMc").getSymbol("graph2").$("txt15").css({"pointer-events":"none"});
	txt[16] = sym.getSymbol("graphsMc").getSymbol("graph3").$("txt16").css({"pointer-events":"none"});
	txt[17] = sym.getSymbol("graphsMc").getSymbol("graph3").$("txt17").css({"pointer-events":"none"});
	txt[18] = sym.getSymbol("graphsMc").getSymbol("graph3").$("txt18").css({"pointer-events":"none"});
	txt[19] = sym.getSymbol("graphsMc").getSymbol("graph4").$("txt19").css({"pointer-events":"none"});
	txt[20] = sym.getSymbol("graphsMc").getSymbol("graph4").$("txt20").css({"pointer-events":"none"});
	txt[21] = sym.getSymbol("graphsMc").getSymbol("graph4").$("txt21").css({"pointer-events":"none"});
	txt[22] = sym.getSymbol("graphsMc").getSymbol("graph5").$("txt22").css({"pointer-events":"none"});
	txt[23] = sym.getSymbol("graphsMc").getSymbol("graph5").$("txt23").css({"pointer-events":"none"});
	txt[24] = sym.getSymbol("graphsMc").getSymbol("graph5").$("txt24").css({"pointer-events":"none"});
	txt[25] = sym.getSymbol("graphsMc").getSymbol("graph6").$("txt25").css({"pointer-events":"none"});
	txt[26] = sym.getSymbol("graphsMc").getSymbol("graph6").$("txt26").css({"pointer-events":"none"});
	txt[27] = sym.getSymbol("graphsMc").getSymbol("graph6").$("txt27").css({"pointer-events":"none"});
	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32448.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			var headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			var stand = $(xml).find('stand').text();
			standtxt.html(stand);
			var source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<30; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}
	
			sym.$("redBox").animate({height:5 + sym.$("txt6").height()+5}, 0);
	
		}
	}); // END XML
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.
	
	for (var h = 0; h < 7; h++){
		var menuBtnSymbols = sym.getSymbol("menuBtnsMc").getSymbol("btn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}
	
	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.on (clickEventType, {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
	})
	
	function resetmenu(){
	for (var b=0;b<7; b++){
		sym.getSymbol("menuBtnsMc").getSymbol("btn"+b+"Over").$("btnClick").fadeOut(0);
		sym.getSymbol("menuBtnsMc").getSymbol("btn"+b+"Over").$("btnOver").fadeOut(0);
		sym.getSymbol("graphsMc").$("graph"+b).fadeOut(0);
		}
	}
	resetmenu();
	sym.getSymbol("graphsMc").$("graph0").fadeIn(0);
	
	function menuBtnClick (e){
		resetmenu(); //set them all back to normal state
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("menuBtnsMc").getSymbol("btn" + menuMenu_id + "Over").$("btnClick").fadeIn(0);
		sym.getSymbol("graphsMc").$("graph"+menuMenu_id).fadeIn(600);
		btnNo = menuMenu_id;
	
	}
	
	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		sym.getSymbol("menuBtnsMc").getSymbol("btn" + menuMenu_id + "Over").$("btnOver").fadeIn(0);
		btnNo = menuMenu_id;
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
		sym.getSymbol("menuBtnsMc").getSymbol("btn" + menuMenu_id + "Over").$("btnOver").fadeOut(0);
	}
	
	// MAKE MENU 0 VISIBLE
	sym.getSymbol("menuBtnsMc").getSymbol("btn0Over").$("btnClick").fadeIn(0);

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'btn1'
   (function(symbolName) {   
   
   })("btn1");
   //Edge symbol end:'btn1'

   //=========================================================
   
   //Edge symbol: 'btn0'
   (function(symbolName) {   
   
   })("btn0");
   //Edge symbol end:'btn0'

   //=========================================================
   
   //Edge symbol: 'btn2'
   (function(symbolName) {   
   
   })("btn2");
   //Edge symbol end:'btn2'

   //=========================================================
   
   //Edge symbol: 'btn3'
   (function(symbolName) {   
   
   })("btn3");
   //Edge symbol end:'btn3'

   //=========================================================
   
   //Edge symbol: 'btn4'
   (function(symbolName) {   
   
   })("btn5");
   //Edge symbol end:'btn5'

   //=========================================================
   
   //Edge symbol: 'btn4'
   (function(symbolName) {   
   
   })("btn4");
   //Edge symbol end:'btn4'

   //=========================================================
   
   //Edge symbol: 'btn6'
   (function(symbolName) {   
   
   })("btn6");
   //Edge symbol end:'btn6'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'graphsMc'
   (function(symbolName) {   
   
   })("graphsMc");
   //Edge symbol end:'graphsMc'

   //=========================================================
   
   //Edge symbol: 'graph0'
   (function(symbolName) {   
   
   })("graph0");
   //Edge symbol end:'graph0'

   //=========================================================
   
   //Edge symbol: 'graph0_1'
   (function(symbolName) {   
   
      })("graph1");
   //Edge symbol end:'graph1'

   //=========================================================
   
   //Edge symbol: 'graph0_1'
   (function(symbolName) {   
   
      })("graph2");
   //Edge symbol end:'graph2'

   //=========================================================
   
   //Edge symbol: 'graph0_2'
   (function(symbolName) {   
   
      })("graph3");
   //Edge symbol end:'graph3'

   //=========================================================
   
   //Edge symbol: 'graph0_3'
   (function(symbolName) {   
   
      })("graph4");
   //Edge symbol end:'graph4'

   //=========================================================
   
   //Edge symbol: 'graph0_4'
   (function(symbolName) {   
   
      })("graph5");
   //Edge symbol end:'graph5'

   //=========================================================
   
   //Edge symbol: 'graph0_5'
   (function(symbolName) {   
   
      })("graph6");
   //Edge symbol end:'graph6'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(jQuery, AdobeEdge, "GraphicNews32448");