/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var btnMove = 1;
	var move = 37;
	var btnNo = 0;
	
	// MENU TEXT START
	var menuTxt=[];
	for (var b=0;b<12; b++){
		menuTxt[b] = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("txt").css({"pointer-events":"none"});
	}
	var menuArr=[];
	
	var txt=[];
	txt[0] = sym.getSymbol("menuBtnsMc").$("monthTxt").css({"background-color":"rgba(230,230,230,1)", "padding":"5px"});
	for (var i=0;i<19;i++){
		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
	}
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32429.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			var headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			var stand = $(xml).find('stand').text();
			standtxt.html(stand);
			var source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			// MENU TEXT START
			for (var i=0; i<12; i++){
			menuArr[i]=$(xml).find('menuTxt'+i).text();
			menuTxt[i].html(menuArr[i]);
			} // MENU TEXT END
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<19; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}	
			btnClick();
			}
	}); // END XML
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.
	
	for (var h = 0; h < 12; h++){
		var menuBtnSymbols = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}
	
	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.on ("click touchstart", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
	})
	
	function resetmenu(){
		for (var h=0; h<menuArray.length; h++){
         menuArray[h].$("btnClick").fadeOut(0);
         menuArray[h].$("btnOver").fadeOut(0);
		}
	}
	resetmenu();

	function menuBtnClick (e){
		resetmenu(); //set them all back to normal state
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnClick").fadeIn(0);
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("txt").css({"color":"rgba(255,255,255,1)"});

		btnMove = menuMenu_id+1;
		btnClick();
	}

	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").stop().fadeIn(200);
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").stop().fadeOut(200);
	}

// MAKE MENU 0 VISIBLE
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("btnClick").fadeIn(0);

function btnClick(){
	for (var k=0;k<btnMove; k++){
		sym.getSymbol("menuBtnsMc").$("menuBtn"+k).stop().animate ({top:k*move}, 0, 'easeOutCubic');
	}
	for (var h=btnMove;h<13; h++){
		sym.getSymbol("menuBtnsMc").$("menuBtn"+h).stop().animate ({top:h*move + 101}, 400, 'easeOutCubic');
		sym.getSymbol("menuBtnsMc").$("monthTxt").stop().animate ({top:btnMove*move}, 400, 'easeOutCubic');
		sym.getSymbol("menuBtnsMc").$("monthTxt").html(txtArr[btnMove-1]);
	}
}

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(jQuery, AdobeEdge, "GraphicNews32429");