/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32424.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<17; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}	
		}
	}); // END XML
	
	sym.$("redIcons").fadeOut(0);
	sym.$("blackIcons").fadeOut(0);
	
	// TOGGLE BUTTONS
	sym.$("toggleBtn").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible") ) { 
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.$("redIcons").fadeIn(200);
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		sym.$("redIcons").fadeOut(200);
	}
	}); 
	sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
	});
	
	sym.$("toggleBtn1").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn1").$("btnPlus").is(":visible") ) { 
		sym.getSymbol("toggleBtn1").$("btnPlus").fadeOut(0);
		sym.$("blackIcons").fadeIn(200);
	}else{
		sym.getSymbol("toggleBtn1").$("btnPlus").fadeIn(0);
		sym.$("blackIcons").fadeOut(200);
	}
	}); 
	sym.$("toggleBtn1").mouseover(function(){
	sym.getSymbol("toggleBtn1").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	sym.$("toggleBtn1").mouseout(function(){
	sym.getSymbol("toggleBtn1").$("btnOver").stop().animate ({opacity:0}, 200);
	});
	

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cutBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn_1'
   (function(symbolName) {   
   
      })("toggleBtn1");
   //Edge symbol end:'toggleBtn1'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(jQuery, AdobeEdge, "GNews32424");