/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "height":"auto"});
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css({"pointer-events":"none", "height":"auto"});
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
	txt[1] = sym.getSymbol("openPointers").$("txt1").css({"pointer-events":"none", "height":"auto", "background-color":"rgba(0,0,0,1)", "padding":"6px"});
	txt[2] = sym.getSymbol("openPointers").$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.getSymbol("openPointers").$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.getSymbol("openPointers").$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.getSymbol("openPointers").$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.getSymbol("capPointers").$("txt6").css({"pointer-events":"none", "height":"auto"});
	txt[7] = sym.getSymbol("capPointers").$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("capPointers").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.$("txt9").css({"pointer-events":"none", "border-radius":"5px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"});
	txt[10] = sym.$("txt10").css({"pointer-events":"none", "border-radius":"5px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"});
	txt[11] = sym.$("txt11").css({"pointer-events":"none", "height":"auto"});
	txt[12] = sym.getSymbol("reenterMc").$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.$("txt13").css({"pointer-events":"none", "height":"auto"});
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32416.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<14; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}
	
			sym.getSymbol("openPointers").$("txt1").animate({top:100 - sym.getSymbol("openPointers").$("txt1").height()}, 0);
			sym.getSymbol("capPointers").$("txt6").animate({top:-278 - sym.getSymbol("capPointers").$("txt6").height()}, 0);
			sym.$("txt9").animate({left:336 - sym.$("txt9").width()}, 0);
			sym.$("txt11").animate({top:482 - sym.$("txt11").height()}, 0);
			sym.$("txt13").animate({top:103 - sym.$("txt13").height()}, 0);
			sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+20}, 0);
			sym.getSymbol("styleHead").$("headerBox").animate({height:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+15}, 0);
	
		}
	}); // END XML
	
	sym.$("reenterMc").stop().animate ({opacity:0}, 0);
	sym.getSymbol("navBtns").$("btnReplay").fadeOut(0);
	
	// NAV BUTTONS
	var clickCount = 0;
	
	sym.getSymbol("navBtns").$("btnNext").on(clickEventType, function() {
	e.stopPropagation(); e.preventDefault();
	clickCount++;
	btnClick();
	});
	
	sym.getSymbol("navBtns").$("btnNext").on("mouseover", function() {
	sym.getSymbol("navBtns").getSymbol("btnNext").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	
	sym.getSymbol("navBtns").$("btnNext").on("mouseout", function() {
	sym.getSymbol("navBtns").getSymbol("btnNext").$("btnOver").stop().animate ({opacity:0}, 0);
	});
	
	function btnClick(){
	sym.play();
	sym.$("reenterMc").stop().animate ({opacity:0}, 500);
	if (clickCount == 3){
		sym.getSymbol("navBtns").getSymbol("btnNext").$("arrowNext").fadeOut(0);
		sym.getSymbol("navBtns").getSymbol("btnNext").$("btnReplay").fadeIn(0);
		clickCount = -1;
	}else{
		sym.getSymbol("navBtns").getSymbol("btnNext").$("arrowNext").fadeIn(0);
		sym.getSymbol("navBtns").getSymbol("btnNext").$("btnReplay").fadeOut(0);
	}
	}
	btnClick();
	
	// TOGGLE BUTTON
	sym.$("toggleBtn").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible") ) { 
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.$("reenterMc").stop().animate ({opacity:1}, 500, 'easeOutCubic', function(){ 
			sym.getSymbol("reenterMc").play(0);
		});
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		sym.getSymbol("reenterMc").stop(0);
		sym.$("reenterMc").stop().animate ({opacity:0}, 500);
	}
	}); 
	sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
	});
	
	

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3999, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'recBtn_1'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'navBtns'
   (function(symbolName) {   
   
   })("navBtns");
   //Edge symbol end:'navBtns'

   //=========================================================
   
   //Edge symbol: 'navBg'
   (function(symbolName) {   
   
   })("navBg");
   //Edge symbol end:'navBg'

   //=========================================================
   
   //Edge symbol: 'cutBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'flamesMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1667, function(sym, e) {
         sym.play(1333);

      });
      //Edge binding end

   })("flamesMc");
   //Edge symbol end:'flamesMc'

   //=========================================================
   
   //Edge symbol: 'openPointers'
   (function(symbolName) {   
   
   })("openPointers");
   //Edge symbol end:'openPointers'

   //=========================================================
   
   //Edge symbol: 'capPointers'
   (function(symbolName) {   
   
   })("capPointers");
   //Edge symbol end:'capPointers'

   //=========================================================
   
   //Edge symbol: 'reenterMc'
   (function(symbolName) {   
   
   })("reenterMc");
   //Edge symbol end:'reenterMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(jQuery, AdobeEdge, "GNews32416");