/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "height":"auto"});
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css({"pointer-events":"none", "height":"auto"});
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var styleHeight = {"pointer-events":"none", "height":"auto", "border-width":"1px","border-style":"solid",
	"border-color":"rgba(0,0,0,1)", "border-radius":"5px", "background-color":"rgba(250,170,25,1)", "padding":"6px", "padding-bottom":"30px"};
	
	var stylePoint = {"pointer-events":"none", "height":"auto", "border-width":"1px","border-style":"solid",
	"border-color":"rgba(0,0,0,1)", "border-radius":"5px", "background-color":"rgba(250,170,25,1)", "padding":"6px"};
	
	var styleWidth = {"pointer-events":"none", "width":"auto", "height":"auto", "border-width":"1px","border-style":"solid",
	"border-color":"rgba(0,0,0,1)", "border-radius":"5px", "background-color":"rgba(250,170,25,1)", "padding":"6px"};
	
	var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
	txt[1] = sym.getSymbol("arrowsMc").$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.getSymbol("arrowsMc").$("txt2").css(styleHeight);
	txt[3] = sym.getSymbol("arrowsMc").$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.getSymbol("arrowsMc").$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.getSymbol("arrowsMc").$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.getSymbol("arrowsMc").$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.getSymbol("arrowsMc").$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("arrowsMc").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.$("txt9").css(styleWidth);
	txt[10] = sym.getSymbol("pointersMc").$("txt10").css(stylePoint);
	txt[11] = sym.getSymbol("pointersMc").$("txt11").css(stylePoint);
	txt[12] = sym.getSymbol("pointersMc").$("txt12").css(stylePoint);
	txt[13] = sym.getSymbol("pointersMc").$("txt13").css(stylePoint);
	txt[14] = sym.getSymbol("liftMc").$("txt14").css(styleWidth);
	txt[15] = sym.getSymbol("pointersMc").$("txt15").css(stylePoint);
	txt[16] = sym.getSymbol("pointersMc").$("txt16").css(stylePoint);
	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32404.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<20; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}
	
			sym.getSymbol("arrowsMc").$("txt2").animate({top:-463 - sym.getSymbol("arrowsMc").$("txt2").height()-0}, 0);
			sym.$("txt9").animate({left:450 - sym.$("txt9").width()-10}, 0);
			sym.getSymbol("liftMc").$("txt14").animate({left:290 - sym.getSymbol("liftMc").$("txt14").width()}, 0);
	
			sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+20}, 0);
			sym.getSymbol("styleHead").$("headerBox").animate({height:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+10}, 0);
	
		}
	}); // END XML
	
	sym.$("upOver").fadeOut(0);
	sym.$("downOver").fadeOut(0);
	sym.$("btnUp").fadeOut(0);
	sym.$("pointersMc").stop().animate ({opacity:0}, 0, 'easeOutCubic');
	
	// BUTTON UP
	sym.$("btnDown").on(clickEventType, function(e){
		e.stopPropagation(); e.preventDefault();
		sym.getSymbol("liftMc").playReverse();
		sym.getSymbol("pulleyFront").playReverse();
		sym.getSymbol("pulleyBack").playReverse();
		sym.$("btnUp").fadeIn(0);
		sym.$("btnDown").fadeOut(0);
		sym.$("toggleBtn").fadeOut(200);
	});
	sym.$("btnUp").mouseover(function(){
		sym.$("upOver").fadeIn(0);
	});
	sym.$("btnUp").mouseout(function(){
		sym.$("upOver").fadeOut(0);
	});
	
	// BUTTON DOWN
	sym.$("btnUp").on(clickEventType, function(e){
		e.stopPropagation(); e.preventDefault();
		sym.getSymbol("liftMc").play();
		sym.getSymbol("pulleyFront").play();
		sym.getSymbol("pulleyBack").play();
		sym.$("btnUp").fadeOut(0);
		sym.$("btnDown").fadeIn(0);
		sym.$("toggleBtn").fadeIn(200);
	});
	sym.$("btnDown").mouseover(function(){
		sym.$("downOver").fadeIn(0);
	});
	sym.$("btnDown").mouseout(function(){
		sym.$("downOver").fadeOut(0);
	});
	
	// ROTATE 1
	$.fn.animateRotate = function(angle, duration, easing, complete) {
    return this.each(function() {
        var $elem = $(this);
        $({deg: 0}).animate({deg: angle}, {
            duration: duration,
            easing: easing,
            step: function(now) {
                $elem.css({
                  '-moz-transform':'rotate('+now+'deg)',
                  '-webkit-transform':'rotate('+now+'deg)',
                  '-o-transform':'rotate('+now+'deg)',
                  '-ms-transform':'rotate('+now+'deg)',
                  'transform':'rotate('+now+'deg)'
                });
            },
            complete: complete || $.noop
        });
    });
};

// TOGGLE BUTTON
sym.$("toggleBtn").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible") ) { 
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.$("pointersMc").stop().animate ({opacity:1}, 500, 'easeOutCubic');
	
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.$("arrowsMc").stop().animate ({opacity:0}, 500, 'easeOutCubic');
		sym.$("btnDown").fadeOut(500);
		sym.$("btnUp").fadeOut(500);
		sym.$("txt0").stop().animate ({opacity:0}, 500, 'easeOutCubic');
		sym.$("btnUp").fadeOut(500);
		sym.$("bgBtn").fadeOut(500);
		
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		sym.$("pointersMc").stop().animate ({opacity:0}, 500, 'easeOutCubic');
		sym.$("arrowsMc").stop().animate ({opacity:1}, 500, 'easeOutCubic');
		sym.$("btnDown").fadeIn(500);
		sym.$("txt0").stop().animate ({opacity:1}, 500, 'easeOutCubic');
		sym.$("bgBtn").fadeIn(500);
	}
}); 
sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
});
sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
});

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'pulleyFront'
   (function(symbolName) {   
   
   })("pulleyFront");
   //Edge symbol end:'pulleyFront'

   //=========================================================
   
   //Edge symbol: 'pulleyFront_1'
   (function(symbolName) {   
   
   })("pulleyBack");
   //Edge symbol end:'pulleyBack'

   //=========================================================
   
   //Edge symbol: 'arrowsMc'
   (function(symbolName) {   
   
   })("arrowsMc");
   //Edge symbol end:'arrowsMc'

   //=========================================================
   
   //Edge symbol: 'liftMc'
   (function(symbolName) {   
   
   })("liftMc");
   //Edge symbol end:'liftMc'

   //=========================================================
   
   //Edge symbol: 'pointersMc'
   (function(symbolName) {   
   
   })("pointersMc");
   //Edge symbol end:'pointersMc'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

})(jQuery, AdobeEdge, "GNews32404");