/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.getSymbol("coldMc").$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("coldMc").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.getSymbol("coldMc").$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.getSymbol("coldMc").$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32399.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<12; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}	
		}
	}); // END XML
	
	// TOGGLE BUTTON
	sym.$("toggleBtn").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible") ) { 
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.play();
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		sym.playReverse();
	}
	}); 
	sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
	});
	
	

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cutBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'rotateMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("rotateMc");
   //Edge symbol end:'rotateMc'

   //=========================================================
   
   //Edge symbol: 'pathFirstMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(7000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play(7000);

      });
      //Edge binding end

   })("pathFirstMc");
   //Edge symbol end:'pathFirstMc'

   //=========================================================
   
   //Edge symbol: 'vortex'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("vortex");
   //Edge symbol end:'vortex'

   //=========================================================
   
   //Edge symbol: 'coldMc'
   (function(symbolName) {   
   
   })("coldMc");
   //Edge symbol end:'coldMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(jQuery, AdobeEdge, "GraphicNews32399");