/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	var txt=[];
	for (var i=0;i<17;i++){
		txt[i] = sym.getSymbol("specsMc").$("txt"+i).css({"pointer-events":"none",});
	}
	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
	for (var i=18;i<28;i++){
		txt[i] = sym.getSymbol("statsMc").$("txt"+i).css({"pointer-events":"none",});
	}
	for (var i=28;i<35;i++){
		txt[i] = sym.getSymbol("chartMc").$("txt"+i).css({"pointer-events":"none",});
	}
	txt[35] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("txt").css({"pointer-events":"none", "padding-top":"6px"});
	txt[36] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn1").$("txt").css({"pointer-events":"none"});
	txt[37] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn2").$("txt").css({"pointer-events":"none", "padding-top":"6px"});
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32325.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			var headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			var stand = $(xml).find('stand').text();
			standtxt.html(stand);
			var source = $(xml).find('source').text();
			sourcetxt.html(source);
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<38; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}
			sym.getSymbol("specsMc").$("txt0").animate({top:305 - sym.getSymbol("specsMc").$("txt0").height()+10}, 0);
			sym.getSymbol("specsMc").$("txt1").animate({top:305 - sym.getSymbol("specsMc").$("txt1").height()+10}, 0);
			sym.$("txt17").animate({top:125 - sym.$("txt17").height()+10}, 0);
			sym.getSymbol("statsMc").$("txt21").animate({top:438 - sym.getSymbol("statsMc").$("txt21").height()+10}, 0);
			sym.getSymbol("statsMc").$("txt23").animate({top:438 - sym.getSymbol("statsMc").$("txt23").height()+10}, 0);
			sym.getSymbol("statsMc").$("txt27").animate({top:438 - sym.getSymbol("statsMc").$("txt27").height()+10}, 0);
		}
	}); // END XML
	
	sym.$("statsMc").stop().animate ({opacity:0}, 0);
	sym.$("chartMc").stop().animate ({opacity:0}, 0);
	
	// AUX BUTTONS
	auxArray = []; //the array that will hold references to the buttons.
	
	for (var a = 0; a < 3; a++){
		var auxBtnSymbols = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" +a); // Create an instance element of a symbol as a child of the given parent element
		auxBtnSymbols.setVariable("auxId", a); //set the value of a Symbol variable
		auxArray.push(auxBtnSymbols); //push it into the array
	}
	
	$.each(auxArray, function( count, auxInTheArray ){ //a 'for each' loop through the newly populated array
		var auxBtnItem = $(auxInTheArray); //create jQuery reference to the item
		var auxBtnElement = auxInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		auxBtnElement.bind (clickEventType, {auxId:count}, auxBtnClick);
		auxBtnElement.bind ("mouseover", {auxId:count}, auxBtnShow);
		auxBtnElement.bind ("mouseout", {auxId:count}, auxBtnHide);
	})
	
	function resetAux(){
		for (var a=0; a<auxArray.length; a++){
        	auxArray[a].$("btnClick").fadeOut(0);
       	auxArray[a].$("btnOver").fadeOut(0);
		}
	}
	resetAux();

	function auxBtnClick (e){
		resetAux(); //set them all back to normal state
		var auxAux_id = (e.data.auxId); //get the id of the clicked item
		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxAux_id).$("btnClick").fadeIn(0);
		btnNo = auxAux_id;
		sym.$("statsMc").stop().animate ({opacity:0}, 300);
		sym.$("specsMc").stop().animate ({opacity:0}, 300);
		sym.$("chartMc").stop().animate ({opacity:0}, 300);
		if (auxAux_id==0) {
			sym.$("specsMc").stop().animate ({opacity:1}, 500);
		}
		if (auxAux_id==1) {
			sym.$("statsMc").stop().animate ({opacity:1}, 500);
		}
		if (auxAux_id==2) {
			sym.$("chartMc").stop().animate ({opacity:1}, 500);
		}
	}

	function auxBtnShow (e){
		var auxAux_id = (e.data.auxId); //get the id of the over button
		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxAux_id).$("btnOver").fadeIn(0);
	}
	function auxBtnHide (e){
		var auxAux_id = (e.data.auxId); //get the id of the out button
		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxAux_id).$("btnOver").fadeOut(0);
	}

// MAKE AUX0 VISIBLE
	sym.getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("btnClick").fadeIn(0);


         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'chartMc'
   (function(symbolName) {   
   
   })("chartMc");
   //Edge symbol end:'chartMc'

   //=========================================================
   
   //Edge symbol: 'specsMc'
   (function(symbolName) {   
   
   })("specsMc");
   //Edge symbol end:'specsMc'

   //=========================================================
   
   //Edge symbol: 'statsMc'
   (function(symbolName) {   
   
   })("statsMc");
   //Edge symbol end:'statsMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(jQuery, AdobeEdge, "GraphicNews32325");