/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var style = {"pointer-events":"none", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)", "border-radius":"6px", "border-width":"1px","border-style":"solid","border-color":"rgba(0,0,0,1)"}
	
	var txt=[];
	for (var i=0;i<21;i++){
	txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
	}
	txt[1] = sym.$("txt1").css(style);
	txt[4] = sym.$("txt4").css({"background-color":"rgba(255,255,255,0)"});
	txt[5] = sym.$("txt5").css({"background-color":"rgba(255,255,255,0)"});
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32309.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<21; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}
	
			sym.$("txt4").animate({left:766 - sym.$("txt4").width()- 0}, 0);
			sym.$("txt5").animate({left:766 - sym.$("txt4").width() - sym.$("txt5").width() - 10}, 0);
			sym.$("txt6").animate({top:558 - sym.$("txt6").height() +15}, 0);
	
			sym.$("cockpit").animate({top:50 + sym.getSymbol("styleHead").$("standTxt").height() + 0}, 0);
			sym.$("txt7").animate({top:50 + sym.getSymbol("styleHead").$("standTxt").height() + sym.$("cockpit").height()+0}, 0);
	
		}
	}); // END XML
	
	// TOGGLE BUTTON
	var toggle = 0;
	
	sym.$("toggleBtn").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible")) {
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.play();
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		sym.playReverse();
	}
	}); 
	
	sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
	});

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cutBtn'
   (function(symbolName) {   
   
   })("cutBtn");
   //Edge symbol end:'cutBtn'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(jQuery, AdobeEdge, "GraphicNews32309");