/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.getSymbol("pointersMc").$("txt0").css({"pointer-events":"none",});
	txt[1] = sym.getSymbol("pointersMc").$("txt1").css({"pointer-events":"none", "background-color":"rgba(255,255,255,1)", "padding":"6px"});
	txt[2] = sym.getSymbol("pointersMc").$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.getSymbol("pointersMc").$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.getSymbol("pointersMc").$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.getSymbol("pointersMc").$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.getSymbol("pointersMc").$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.getSymbol("pointersMc").$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("pointersMc").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.getSymbol("frontPointMc").$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.getSymbol("frontPointMc").$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.getSymbol("frontPointMc").$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.getSymbol("frontPointMc").$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.getSymbol("frontPointMc").$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.getSymbol("frontPointMc").$("txt14").css({"pointer-events":"none"});
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32295.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<15; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}	
		}
	}); // END XML
	
sym.$("pointersMc").stop().animate ({opacity:0},0);
sym.$("frontPointMc").stop().animate ({opacity:0},0);
sym.$("blur").stop().animate ({opacity:0},0);

// TOGGLE BUTTON
sym.$("toggleBtn").on(clickEventType, function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("toggleBtn").$("btnPlus").is(":visible")) { 
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		backOut();
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		frontOut();
	}
}); 
sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
});
sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
});

function backIn(){
	sym.$("backMask").stop().animate ({left:0}, 500, 'easeOutCubic');
	sym.$("backShad").stop().animate ({left:15}, 500, 'easeOutCubic');
	sym.$("watchBack").stop().animate ({left:0}, 500, 'easeOutCubic');
	sym.$("backCharger").stop().animate ({left:-69}, 500, 'easeOutCubic', function(){
		sym.$("backCharger").stop().animate ({left:-107, top:105}, 700, 'easeOutCubic');
		sym.$("backShad").stop().animate ({left:-15, top:-32},700, 'easeOutCubic', function(){
		sym.$("pointersMc").stop().animate ({opacity:1},200);
		});
	});
}
function backOut(){
	sym.$("pointersMc").stop().animate ({opacity:0},200);
	sym.$("backShad").stop().animate ({left:15, top:48}, 500, 'easeOutCubic');
	sym.$("backCharger").stop().animate ({left:-70, top:222}, 500, 'easeOutCubic', function(){
		sym.$("backCharger").stop().animate ({left:-370}, 500, 'easeOutCubic');
		sym.$("watchBack").stop().animate ({left:-300}, 500, 'easeOutCubic');
		sym.$("backMask").stop().animate ({left:-300}, 500, 'easeOutCubic');
		frontIn();
		sym.$("backShad").stop().animate ({left:-300}, 500, 'easeOutCubic', function(){

		});	
	});			
}
function frontIn(){
	sym.$("watchFull").stop().animate ({opacity:0,left:111, top:156, width:526, height:526}, 500, 'easeOutCubic');
	sym.$("watchFullBack").stop().animate ({opacity:0.5, left:111, top:156, width:526, height:526}, 500, 'easeOutCubic');
	sym.$("frontBase").stop().animate ({left:0, top:0, width:600, height:600}, 500, 'easeOutCubic', function(){
			showSec();
			sym.getSymbol("styleHead").$("standTxt").stop().animate ({opacity:0}, 200);
			sym.$("sec1").stop().animate ({left:0, top:0}, 500, 'easeOutCubic');
			sym.$("sec2").stop().animate ({left:0, top:0}, 500, 'easeOutCubic');
			sym.$("sec3").stop().animate ({left:0, top:0}, 500, 'easeOutCubic');
			sym.$("sec41").stop().animate ({left:0, top:0}, 500, 'easeOutCubic');
			sym.$("sec42").stop().animate ({left:0, top:0}, 500, 'easeOutCubic');
			sym.$("sec43").stop().animate ({left:0, top:0}, 500, 'easeOutCubic');
			sym.$("sec5").stop().animate ({left:0, top:0, width:600, height:600}, 500, 'easeOutCubic', function(){
			sym.$("blur").stop().animate ({opacity:0.5},500);
			sym.$("frontPointMc").stop().animate ({opacity:1},200);
			});
	});
}

function frontOut(){
	sym.getSymbol("styleHead").$("standTxt").stop().animate ({opacity:1}, 500);
	sym.$("frontPointMc").stop().animate ({opacity:0},50);
	sym.$("blur").stop().animate ({opacity:0},50);
	sym.$("sec1").stop().animate ({left:43, top:61}, 500, 'easeOutCubic');
	sym.$("sec2").stop().animate ({left:91, top:117}, 500, 'easeOutCubic');
	sym.$("sec3").stop().animate ({left:117, top:185}, 500, 'easeOutCubic');
	sym.$("sec41").stop().animate ({left:142, top:208}, 500, 'easeOutCubic');
	sym.$("sec42").stop().animate ({left:146, top:215}, 500, 'easeOutCubic');
	sym.$("sec43").stop().animate ({left:162, top:242}, 500, 'easeOutCubic');
	sym.$("sec5").stop().animate ({left:325, top:318, width:504, height:504}, 500, 'easeOutCubic', function(){
	hideSec();
	backIn();
	sym.$("watchFull").stop().animate ({opacity:1, left:0, top:0, width:600, height:600}, 500, 'easeOutCubic');
	sym.$("watchFullBack").stop().animate ({opacity:0.5, left:0, top:0, width:600, height:600}, 500, 'easeOutCubic');
		sym.$("frontBase").stop().animate ({left:-130, top:-181, width:688, height:688}, 500, 'easeOutCubic', function(){
		});
	});

}
backIn();

var itemArray = ["sec1","sec2","sec3","sec41","sec42","sec43","sec5","frontBaseOver"];
function hideSec(){
	$.each(itemArray, function(index, value) {
	sym.$(value).fadeOut(0);
	});
	}
function showSec(){
	$.each(itemArray, function(index, value) {
	sym.$(value).fadeIn(0);
	});
	}
hideSec();










         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cutBtn'
   (function(symbolName) {   
   
   })("cutBtn");
   //Edge symbol end:'cutBtn'

   //=========================================================
   
   //Edge symbol: 'pointersMc'
   (function(symbolName) {   
   
   })("pointersMc");
   //Edge symbol end:'pointersMc'

   //=========================================================
   
   //Edge symbol: 'frontPointMc'
   (function(symbolName) {   
   
   })("frontPointMc");
   //Edge symbol end:'frontPointMc'

})(jQuery, AdobeEdge, "GraphicNews32295");