/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	// MENU TEXT START
	var menuTxt=[];
	menuTxt[0] = sym.$("menuTxt0").css({"pointer-events":"none",});
	menuTxt[1] = sym.$("menuTxt1").css({"pointer-events":"none"});
	menuTxt[2] = sym.$("menuTxt2").css({"pointer-events":"none"});
	var menuArr=[];
	
	var btnNo = 0;
	for (var b=0;b<3; b++){
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuIcon" + b + ".png");
	} // MENU TEXT END
	
	// STYLING TEXT	
	// "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"
	// "border-width":"1px","border-style":"solid","border-color":"rgba(0,0,0,1)", "border-radius":"1px"
	// "background-color":"rgba(255,255,255,1)"
	// "padding":"6px"
	
	var txt=[];
	txt[0] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt0").css({"pointer-events":"none",});
	txt[1] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.getSymbol("carMainMc").getSymbol("carTxtMc").$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.getSymbol("interiorMc").$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.getSymbol("interiorMc").$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.getSymbol("interiorMc").$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.getSymbol("interiorMc").$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("interiorMc").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.getSymbol("interiorMc").$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.getSymbol("interiorMc").$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.getSymbol("interiorMc").$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32265.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
			var fontSize= $(xml).find('fontSize').text();
			// MENU TEXT START
			for (var i=0; i<3; i++){
			menuArr[i]=$(xml).find('menuTxt'+i).text();
			menuTxt[i].html(menuArr[i]);
			} // MENU TEXT END
	
			for (var i=0; i<15; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			txt[i].css({'font-size':fontSize});
			}
	
			//sym.getSymbol("SYMBOL").$("txt").animate({top:yNUMBER - sym.getSymbol("SYMBOL").$("txt").height()+10}, 200);
	
		}
	}); // END XML
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.
	
	for (var h = 0; h < 3; h++){
		var menuBtnSymbols = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}
	
	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.on (clickEventType, {menuId:count}, menuBtnClick);
		menuBtnElement.on ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.on ("mouseout", {menuId:count}, menuHide);
	})
	
	function resetmenu(){
		for (var h=0; h<menuArray.length; h++){
         menuArray[h].$("btnClick").fadeOut(0);
         menuArray[h].$("btnOver").fadeOut(0);
		}
	}
	resetmenu();

	var waiting = 500;

	function menuBtnClick (e){
		resetmenu(); //set them all back to normal state
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnClick").fadeIn(0);
		btnNo = menuMenu_id;
		sym.$("videoMc").fadeOut(500);
		sym.$("interiorMc").fadeOut(500);
		sym.getSymbol("styleHead").$("standTxt").fadeOut(500);
		if (menuMenu_id==0) {
			car = 0;
			sym.getSymbol("styleHead").$("standTxt").fadeIn(0);
			waiting = 500;
		}
		if (menuMenu_id==1) {
			car = 1;
			sym.$("interiorMc").stop().delay(waiting).fadeIn(500);
			waiting = 0;
		}
		if (menuMenu_id==2) {
			car = 1;
			sym.$("videoMc").stop().delay(waiting).fadeIn(500);
			waiting = 0;
		}
		carMove();
	}

	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeIn(0);
		btnNo = menuMenu_id;
		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[btnNo]);
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeOut(0);
		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
	}

// MAKE MENU 0 VISIBLE
	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("btnClick").fadeIn(0);

//   ************************************************************************************************************************* 
//   ****************************************************  CAR START  ****************************************************
//   ************************************************************************************************************************* 
$.fn.animateRotate = function(angle, duration, easing, complete) {
    return this.each(function() {
        var $elem = $(this);
        $({deg: 0}).animate({deg: angle}, {
            duration: duration,
            easing: easing,
            step: function(now) {
                $elem.css({
                  '-moz-transform':'rotate('+now+'deg)',
                  '-webkit-transform':'rotate('+now+'deg)',
                  '-o-transform':'rotate('+now+'deg)',
                  '-ms-transform':'rotate('+now+'deg)',
                  'transform':'rotate('+now+'deg)'
                });
            },
            complete: complete || $.noop
        });
    });
};

	var car = 0;
	var speed = 0;
	var ease = 0;
	var spin = 0;

	function carMove() {
	if (car == 0){
			sym.getSymbol("carMainMc").$("carMc").stop().animate ({opacity:1}, 0);
			ease = 'easeOutCubic';
			speed = 1500;
			sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:0}, speed, 'easeOutCubic', function(){
				sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:1}, 500);
				});
			if (spin == 0){
				sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel1").animateRotate(-720, speed, ease);
				sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel2").animateRotate(-720, speed, ease);
				sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel3").animateRotate(720, speed, ease);
				sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel4").animateRotate(720, speed, ease);
				spin = 1;
			}else{
				spin = 0;
			}
			car = 1;
		}else{
			ease = 'easeInCubic';
			speed = 500;
			sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:0}, 0);
			sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:-800}, speed, 'easeInCubic', function(){
				sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:800}, 0 , function(){
				sym.getSymbol("carMainMc").$("carMc").stop().animate ({opacity:0}, 0);
				});
				});

			for (var b=0;b<4; b++){
			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel"+b).animateRotate(0,0);
			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel1").animateRotate(-720, speed, ease);
			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel2").animateRotate(-720, speed, ease);
			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel3").animateRotate(720, speed, ease);
			sym.getSymbol("carMainMc").getSymbol("carMc").$("wheel4").animateRotate(720, speed, ease);
		}
		car = 0;
		spin = 0;
		}


	}

	//sym.$("videoMc").stop().fadeOut(0);
	sym.getSymbol("carMainMc").$("carTxtMc").stop().animate ({opacity:0}, 0);
	sym.getSymbol("carMainMc").$("carMc").stop().animate ({left:800}, 0);
	carMove();


	var galNo = 0;
	for (var b=0;b<7; b++){
		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn"+b).$("btnIcon").attr("src", "images/gal" + b + ".jpg");
	}
	// GALLERY BUTTONS --------------------------------------------	
	galArray = []; //the array that will hold references to the buttons.

	for (var a = 0; a < 7; a++){
		var galBtnSymbols = sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn" +a); // Create an instance element of a symbol as a child of the given parent element
		galBtnSymbols.setVariable("galId", a); //set the value of a Symbol variable
		galArray.push(galBtnSymbols); //push it into the array
	}

	$.each(galArray, function( count, galInTheArray ){ //a 'for each' loop through the newly populated array
		var galBtnItem = $(galInTheArray); //create jQuery reference to the item
		var galBtnElement = galInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		galBtnElement.on (clickEventType, {galId:count}, galBtnClick);
		galBtnElement.on ("mouseover", {galId:count}, galBtnShow);
		galBtnElement.on ("mouseout", {galId:count}, galBtnHide);
	})

	var btnNo = 0;
	function resetGal(){
	for (var k=0;k<7; k++){
		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn"+k).$("btnClick").fadeOut(0);
		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn"+k).$("btnOver").fadeOut(0);
	}
	}
	resetGal();

	function galBtnClick (e){
		var gal_id = (e.data.galId); //get the id of the clicked item
		galNo = gal_id;
		resetGal();
		galleryShow();
		}

	function galBtnShow (e){
		var gal_id = (e.data.galId); //get the id of the over button
		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn" + gal_id).$("btnOver").fadeIn(0);
	}
	function galBtnHide (e){
		var gal_id = (e.data.galId); //get the id of the out button
		sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn" + gal_id).$("btnOver").fadeOut(0);
	}

// MAKE gal0 VISIBLE
	sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn0").$("btnClick").fadeIn(0);


// BUTTONS COUNT
var galNo = 0;

sym.getSymbol("videoMc").$("imgSwipe").on('swipeleft', function(e){
	e.stopPropagation(); e.preventDefault();
	resetGal();
	galNo++;
	if (galNo <1){
		galNo=1;
		//sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn0").$("btnClick").stop().fadeIn(0);
	}
	galleryShow();

	});
sym.getSymbol("videoMc").$("imgSwipe").on('swiperight', function(e){
	e.stopPropagation(); e.preventDefault();
	resetGal();
	galNo--;
	if (galNo >5){
		galNo=5;
		//sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn6").$("btnClick").fadeIn(0);
	}
	galleryShow();
	});



function galleryShow(){
	sym.getSymbol("videoMc").getSymbol("galBtnsMc").getSymbol("galBtn" + galNo).$("btnClick").fadeIn(0);
	sym.getSymbol("videoMc").$("imgHolder").fadeOut(150, function() {
	sym.getSymbol("videoMc").$("imgHolder").attr("src", "images/gal" + galNo + ".jpg");
    sym.getSymbol("videoMc").$("imgHolder").fadeIn(200);
  	});
}

	sym.$("videoMc").fadeOut(0);
	sym.$("interiorMc").fadeOut(0);
/*

// BUTTONS COUNT
sym.$("nextBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	scene++;
	btnClick();
	//sym.getSymbol("btnsMc").getSymbol("btnNext").$("btnClick").fadeIn(200);
	});
sym.$("nextBtn").mouseover(function(){
	//sym.getSymbol("btnsMc").getSymbol("btnNext").$("btnOver").fadeIn(200);
	});
sym.$("nextBtn").mouseout(function(){
	//sym.getSymbol("btnsMc").getSymbol("btnNext").$("btnOver").fadeOut(200);
	});


// START CLICK FUNCTION
var clicked=0;
function btnClick(){ 
	if (clicked == 1) {

	}
} // END CLICK FUNCTION

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// HIDE ELEMENTS USING ARRAY
var itemArray = ["image1","image2","image3","image4","image5","image6","image7","image8","image9","image10"];
$.each(itemArray, function(index, value) {
	sym.getSymbol("NAME").$(value).fadeOut(200);
	});

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// ROTATE 1
$.fn.animateRotate = function(angle, duration, easing, complete) {
    return this.each(function() {
        var $elem = $(this);
        $({deg: 0}).animate({deg: angle}, {
            duration: duration,
            easing: easing,
            step: function(now) {
                $elem.css({
                  '-moz-transform':'rotate('+now+'deg)',
                  '-webkit-transform':'rotate('+now+'deg)',
                  '-o-transform':'rotate('+now+'deg)',
                  '-ms-transform':'rotate('+now+'deg)',
                  'transform':'rotate('+now+'deg)'
                });
            },
            complete: complete || $.noop
        });
    });
};
sym.getSymbol("MOVIE").getSymbol("MOVIE").$("DIV").animateRotate(360, 1000, 'easeOutCubic');

// ROTATE 2
$.fn.animateRotate = function(startAngle, endAngle, duration, easing, complete){
    return this.each(function(){
        var elem = $(this);

        $({deg: startAngle}).animate({deg: endAngle}, {
            duration: duration,
            easing: easing,
            step: function(now){
                elem.css({
                  '-moz-transform':'rotate('+now+'deg)',
                  '-webkit-transform':'rotate('+now+'deg)',
                  '-o-transform':'rotate('+now+'deg)',
                  '-ms-transform':'rotate('+now+'deg)',
                  'transform':'rotate('+now+'deg)'
                });
            },
            complete: complete || $.noop
        });
    });
};
sym.getSymbol("MOVIE").getSymbol("MOVIE").$("DIV").animateRotate(360, 1000, 'easeOutCubic');

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// TEXT IN BOX
sym.getSymbol("NAME").$("NAME").html(gal + "/10");

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// STYLE TEXT 
var html = "<div style='background-color:rgba(11,40,91,0.1); padding-left:10px; padding-right:5px; padding-top:5px; padding-bottom:10px'>"+txt20+"</div>";
sym.getSymbol("NAME").$("NAME").append(html);  

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// ANIMATE 
sym.getSymbol("NAME").$("NAME").stop().delay(2000).animate ({opacity:1, left:0, top:0, width:800, height:600}, 1000, 'easeOutCubic');

sym.getSymbol("NAME").$("NAME").stop().delay(2000).animate ({opacity:1, left:0, top:0, width:800, height:600}, 1000, 'easeOutCubic', function(){ sym.getSymbol("NAME").$("NAME").fadeOut(300); });

sym.getSymbol("NAME").$("NAME").stop().delay(1000).fadeIn(500); 

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// TOGGLE BUTTON
var toggle = 0;

sym.$("toggleBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	if (toggle == 0) {
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		toggle = 1;
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		toggle = 0;
	}
}); 
sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnCol").fadeOut(0);
});
sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnCol").fadeIn(0);
});

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// ADJUST POSITION RELATIVE
var pos1 = sym.$("NAME").height();
sym.getSymbol.$("NAME").animate ({top:43 + pos1 + 10}, 0); 

var pos1 = sym.$("NAME").height();
var pos2 = sym.$("NAME").height();
var pos3 = sym.$("NAME").height();
var pos4 = sym.$("NAME").height();
var pos5 = sym.$("NAME").height();

sym.$("NAME").animate ({top:43 + pos1 + 5}, 0); 
sym.$("NAME").animate ({top:43 + pos1 + pos2 + 10}, 0); 
sym.$("NAME").animate ({top:43 + pos1 + pos2 + pos3 + 15}, 0); 
sym.$("NAME").animate ({top:43 + pos1 + pos2 + pos3 + pos4 + 20}, 0); 
sym.$("NAME").animate ({top:43 + pos1 + pos2 + pos3 + pos4 + pos5 + 25}, 0); 

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// STYLE MULTIPLE TEXT IN SINGLE BOX
sym.getSymbol("txtMc").$("txt7").empty();

var st1 = "<div style='float:left; font-size:13px; font-weight:600; background-color:rgba(0,0,0,1); color:rgba(255,255,255,1); padding-left:4px; padding-right:2px; padding-top:2px; padding-bottom:2px'>"+txtArr[7] + 
"</div><div style='float:left; color:rgba(0,0,0,0);'>"+ "l" + 
"</div><div style= 'font-family:pragmatica-web, sans-serif; font-size:13px; padding-right:0px; padding-left:0px; padding-bottom:5px; padding-top:5px'>" + txtArr[8]+"</div>";
sym.getSymbol("txtMc").$("txt7").append(st1);

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// SLIDE ARRAY
var time = 0;
var slideArray = ["66","100","167","335","352","402","503","519","553","570","653"];
sym.getSymbol("timeMc").$("pointTime").stop().animate ({left:(slideArray[time])}, 600, 'easeOutCubic');

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// CHANGE TEXT
sym.$("txt0").empty();
sym.$("txt0").append(txtArr[menuMenu_id + 0]);

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// AUX BUTTONS
	auxArray = []; //the array that will hold references to the buttons.

	for (var a = 0; a < 3; a++){
		var auxBtnSymbols = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" +a); // Create an instance element of a symbol as a child of the given parent element
		auxBtnSymbols.setVariable("auxId", a); //set the value of a Symbol variable
		auxArray.push(auxBtnSymbols); //push it into the array
	}

	$.each(auxArray, function( count, auxInTheArray ){ //a 'for each' loop through the newly populated array
		var auxBtnItem = $(auxInTheArray); //create jQuery reference to the item
		var auxBtnElement = auxInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		auxBtnElement.bind ("click", {auxId:count}, auxBtnClick);
		auxBtnElement.bind ("touchstart", {auxId:count}, auxBtnClick);
		auxBtnElement.bind ("mouseover", {auxId:count}, auxBtnShow);
		auxBtnElement.bind ("mouseout", {auxId:count}, auxBtnHide);
	})

	function resetAux(){
		for (var a=0; a<auxArray.length; a++){
        	auxArray[a].$("btnClick").fadeOut(0);
       	auxArray[a].$("btnOver").fadeOut(0);
		}
	}
	resetAux();

	function auxBtnClick (e){
		resetAux(); //set them all back to normal state
		var auxAux_id = (e.data.auxId); //get the id of the clicked item
		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxAux_id).$("btnClick").fadeIn(0);
		btnNo = auxAux_id;
		if (auxAux_id==0) {
		}
		if (auxAux_id==1) {
		}
		if (auxAux_id==2) {
		}
	}

	function auxBtnShow (e){
		var auxAux_id = (e.data.auxId); //get the id of the over button
		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxAux_id).$("btnOver").fadeIn(0);
	}
	function auxBtnHide (e){
		var auxAux_id = (e.data.auxId); //get the id of the out button
		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxAux_id).$("btnOver").fadeOut(0);
	}

// MAKE AUX0 VISIBLE
	sym.getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("btnClick").fadeIn(0);

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// NAV BUTTONS
var clickCount = 0;

sym.getSymbol("navBtns").$("btnNext").on("click", function() {
	e.stopPropagation(); e.preventDefault();
	clickCount++;
	btnClick();
});

sym.getSymbol("navBtns").$("btnNext").on("mouseover", function() {
	sym.getSymbol("navBtns").getSymbol("btnNext").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});

sym.getSymbol("navBtns").$("btnNext").on("mouseout", function() {
	sym.getSymbol("navBtns").getSymbol("btnNext").$("btnOver").stop().animate ({opacity:0}, 0);
});

sym.getSymbol("navBtns").$("btnBack").on("click", function() {
	e.stopPropagation(); e.preventDefault();
	clickCount--;
	btnClick();
	});

sym.getSymbol("navBtns").$("btnBack").on("mouseover", function() {
	sym.getSymbol("navBtns").getSymbol("btnBack").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});

sym.getSymbol("navBtns").$("btnBack").on("mouseout", function() {
	sym.getSymbol("navBtns").getSymbol("btnBack").$("btnOver").stop().animate ({opacity:0}, 0);
});

function btnClick(){
	if (clickCount == 0){
		sym.getSymbol("navBtns").$("btnBack").fadeOut(0);
	}else{
		sym.getSymbol("navBtns").$("btnBack").fadeIn(0);
	}
	if (clickCount == 4){
		sym.getSymbol("navBtns").$("btnNext").fadeOut(0);
	}else{
		sym.getSymbol("navBtns").$("btnNext").fadeIn(0);
	}
}
btnClick();


// TOGGLE BUTTON
var toggle = 0;

sym.$("toggleBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	if (toggle == 0) {
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		toggle = 1;
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		toggle = 0;
	}
}); 
sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
});
sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
});


*/

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================
   
   //Edge symbol: 'carMainMc'
   (function(symbolName) {   
   
   })("carMainMc");
   //Edge symbol end:'carMainMc'

   //=========================================================
   
   //Edge symbol: 'carTxtMc'
   (function(symbolName) {   
   
   })("carTxtMc");
   //Edge symbol end:'carTxtMc'

   //=========================================================
   
   //Edge symbol: 'galBtn'
   (function(symbolName) {   
   
   })("galBtn");
   //Edge symbol end:'galBtn'

   //=========================================================
   
   //Edge symbol: 'videoMc'
   (function(symbolName) {   
   
   })("videoMc");
   //Edge symbol end:'videoMc'

   //=========================================================
   
   //Edge symbol: 'galBtnsMc'
   (function(symbolName) {   
   
   })("galBtnsMc");
   //Edge symbol end:'galBtnsMc'

   //=========================================================
   
   //Edge symbol: 'interiorMc'
   (function(symbolName) {   
   
   })("interiorMc");
   //Edge symbol end:'interiorMc'

})(jQuery, AdobeEdge, "GraphicNews32265");