/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "data/xml.php";
         //Text & other variables
         sym.$("captionTxt").css('line-height', '145%');
         var headline;
         var headlinetxt = sym.$("headlineTxt");
         var caption;
         var gn=32204;
         var captionArr=[];
         var source;
         var drag;
         var pictures;
         var countryArr=[];
         for (var c=1;c<33;c++){
         	countryArr[c]="s"+c;
         }
         //UNCOMMENT TO USE MULTIPLE CAPTIONS IN AN ARRAY 
         
         var text=[];  //array of text boxes - EDIT TO MATCH THE NUMBER OF TEXT BOXES
         for (var i = 0; i < 9; i++) {
         	text[i]=sym.$('txt'+i).css({'pointer-events':'none'});			
         }
         var txtArr=[];
         //end captions
         var regionYes=[];
         var regionNo=[];
         var regionDK=[];
         var regionVote=[];
         var selectName = function(number,svgDocument){ //to handle lexical scope
         	return function (e) {
         		sym.$("placeholder").empty();
         		sym.$("pie").fadeOut(0);
         		sym.$("captionTxt").fadeOut(0);		
         		for (var n=0;n<32;n++){
         			if (number==n){
         				$("#s"+(number+1), svgDocument).animate({'opacity':'0.2'},0);
         				$("#region"+number).css({'background-color':'rgba(100,150,200,0.2)','font-weight':700});
         				if (regionYes[number]>0&&regionNo[number]>0){
         					sym.$("captionTxt").html( captionArr[number] );
         					pieChart(regionYes[number],regionNo[number],regionDK[number],"#Stage_placeholder");
         					sym.$("pie").fadeIn(600);
         					sym.$("captionTxt").fadeIn(600);		
         					sym.$("txt9").html(Math.round(regionYes[number])+"%");
         					sym.$("txt10").html(Math.round(regionNo[number])+"%");
         				}
         			}else{
         				$("#s"+(n+1), svgDocument).animate({opacity:1.0},300);
         				$("#region"+n).css({'background-color':'rgba(100,150,200,0)','font-weight':400,'border-bottom':'groove 1px rgb(100,100,100)'});
         			}
         		}
         	e.preventDefault();
         	e.stopPropagation();
         	};
         };
         
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         $.ajax({	
         	type: "GET",
         	url: "GN"+gn+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		headline = $(xml).find('headline').text();
         		sym.$("headlineTxt").html(headline);
         		for (var i=0;i<9;i++){
         			txtArr[i]= $(xml).find('txt'+i).text();
         		}
         		for (var n=0;n<text.length;n++){
         					text[n].html(txtArr[n]);
         		}
         		source = $(xml).find('source').text();
         		sym.$("sourceTxt").html(source);
         	   var tableTxt="<table style='font-size:13px;width:100%;border-collapse:collapse;font-family:pragmatica-web, sans-serif'>";
         		for (var r=0;r<32;r++){		//get details for each team
                  			$(xml).find("region"+r).each(function(){
                  				var $regions = $(this);
                  				captionArr[r]=$regions.find('name').text();
                  			});
                  	 tableTxt+="<tr class='region'><td class='regionBtn' id='region"+r+"'>"+captionArr[r]+"</td><tr>";
                  	 $("#region"+r).on("click",selectName(r));
               }
               tableTxt+="</table>";
               sym.$("table").append(tableTxt);
               $(".region").css({'width':'100%'});
               $(".regionBtn").css({'cursor':'pointer','border-top':'solid 1px rgb(150,150,150)','border-bottom':'solid 1px rgb(150,150,150)'});
         		$(".region td").css({'padding':'2px 5px'});
         		sym.$("captionTxt").html(captionArr[0]);
         		}
         });
         //PIE CHART
         function pieChart(yes,no,dunno,placeHolder){			
                      var canvasWidth = 155, //width
                        canvasHeight = 155,   //height
                        outerRadius = 77,   //radius
                  		color = d3.scale.ordinal().range(["#e11d1b","#fac000","#0557a6","#b4c8d2"]);
                      var dataSet = [
                        {"legendLabel":"NO", "magnitude":no},  
                        {"legendLabel":"Don't know", "magnitude":dunno}, 
                        {"legendLabel":"YES", "magnitude":yes}];
                      var vis = d3.select(placeHolder)
                        .append("svg:svg") //create the SVG element inside the <body>
                          .data([dataSet]) //associate our data with the document
                          .attr("width", canvasWidth) //set the width of the canvas
                          .attr("height", canvasHeight) //set the height of the canvas
                          .append("svg:g") //make a group to hold our pie chart
                  			.attr("transform", "translate("+canvasWidth/2+","+canvasHeight/2+")") //move centre of pie chart from 0, 0 to middle of placeholder
                  			//	.attr("viewBox", +canvasWidth/2+"px",+canvasHeight/2+"px",90,90)
                  				.style("-webkit-transform", "translate("+canvasWidth/2+"px,"+canvasHeight/2+"px)");
                      // This will create <path> elements for us using arc data...
                      var arc = d3.svg.arc()
                        .outerRadius(outerRadius)
                  		.innerRadius(outerRadius-15); //donut chart
                      var pie = d3.layout.pie() //this will create arc data for us given a list of values
                        .value(function(d) { return d.magnitude; }) // Binding each value to the pie
                        .sort( function(d) { return null; } );
                      // Select all <g> elements with class slice (there aren't any yet)
                      var arcs = vis.selectAll("g.slice")  // Associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
                        .data(pie) // This will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
                        .enter() // Create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
                        .append("svg:g")
                        .attr("class", "slice");    //allow us to style things in the slices (like text)
                      arcs.append("svg:path")
                        //set the color for each slice to be chosen from the color function defined above
                        .attr("fill", function(d, i) { return color(i); } ) //this creates the actual SVG path using the associated data (pie) with the arc drawing function
                        .attr("stroke","#ffffff")
                        .attr("d", arc);
         /*					 // Add a legendLabel to each arc slice...
             arcs.append("svg:text")
               .attr("transform", function(d) { //set the label's origin to the center of the arc
                 //we have to make sure to set these before calling arc.centroid
                 d.outerRadius = outerRadius + 50; // Set Outer Coordinate
                 d.innerRadius = outerRadius + 45; // Set Inner Coordinate
                 return "translate(" + arc.centroid(d) + ")";
               })
               .attr("text-anchor", "middle") //center the text on it's origin
               .style("fill", "grey")
               .style("font", "12px Arial")
               .text(function(d, i) { return Math.round(dataSet[i].magnitude); }); //get the label from our original data array
         */
         }
         
         function getData(){
         	$.ajax({	
         		type: "GET",
               url: dataURL,
               data: "gn=32204&q=data&yr=2014",
         		dataType: "xml",
               success: function(xml) {
         			regionVote=[];
         			regionYes=[];
         			regionNo=[];
         			regionDK=[];
         			var timeStamp=$(xml).find('datetime').text();
         			text[4].html(txtArr[4]+timeStamp);
         			$(xml).find("region").each(function(){
         				var $regions = $(this);
         				var regno = $regions.attr("index");
         				var yesVote=$regions.find('yes').text();
         				var noVote=$regions.find('no').text();
         				var dkVote=$regions.find('dk').text();
         				if(yesVote==0&&noVote==0){
         						regionVote.push("other");
         					}else if(yesVote>noVote){
         						regionVote.push("yes");
         					}else if(yesVote<noVote){
         						regionVote.push("no");
         					}else{
         						regionVote.push("split");
         					}
         				regionYes.push(yesVote);
         				regionNo.push(noVote);
         				regionDK.push(dkVote);
         			});
         			var barTxt="<div class='barGraph'>";
                  barTxt+="<div id='ybar'></div>";
                  barTxt+="<div id='dkbar'></div>";
                  barTxt+="<div id='nbar'></div>";
                  barTxt+="</div>";
          			var totalYes=parseFloat(regionYes[32]);
         			var totalNo=parseFloat(regionNo[32]);
         			if(totalYes>0&&totalNo>0){
         				sym.$("barchart").append(barTxt);
         				sym.$("voteDiv").fadeIn(0);
         				sym.$("txt7").fadeOut(0);
         				sym.$("txt8").fadeOut(0);
         			}else{
         				sym.$("barchart").append(barTxt);//Sep 15
         				sym.$("voteDiv").fadeIn(0);
         				sym.$("txt7").fadeOut(0);
         				sym.$("txt8").fadeOut(0);
         				//sym.$("voteDiv").fadeOut(0);
         				//sym.$("txt7").fadeIn(0);
         				//sym.$("txt8").fadeIn(0);	//end Sep 15					
         			}
         			var yesScale=totalYes/(totalYes+totalNo);
         			var noScale=totalNo/(totalYes+totalNo);
         			var yWidth=(yesScale*100);
                  var nWidth=(noScale*100);
         			$("#ybar").text(totalYes+"%");
         			$("#nbar").text(totalNo+"%");
                  $(".barGraph").css({'font-family':'pragmatica-web,sans-serif','width':'100%','height':'100%','font-size':'18px','font-weight':700,'display':'inline-table'});
                  $("#ybar").css({'background-color':'rgba(5,55,185,0.5)','color':'#ffffff','padding':'3px 5px','text-align':'left', 'display':'table-cell','width':'0%','border-right':'solid 1px rgb(255,255,255)'});
                  $("#dkbar").css({'display':'table-cell','width':'100%'});
                  $("#nbar").css({'background-color':'rgba(255,0,0,0.5)','color':'#ffffff','padding':'3px 5px','text-align':'right','width':'0%','display':'table-cell','border-left':'solid 1px rgb(255,255,255)'});
                  $("#ybar").animate({width:yWidth+"%"},1000);
                  $("#dkbar").animate({width:'0%'},1000);
                  $("#nbar").animate({width:nWidth+"%"},1000);
         		},
         		complete: function(){
         			EC.SVG.accessSVG(sym.$("scotland")).done(
         						function(svgDocument){
         
         							for (var i=0;i<32;i++){
         								$("#region"+i).on("click",selectName(i,svgDocument));
         								var newClass=regionVote[i];
         								var newColor;
         								switch (newClass){
         									case "yes":
         									newColor="#6496c8";//6496c8 5CCAE8
         									break;
         									case "no":
         									newColor="#ff6666";//ff6666 F59EB2
         									break;
         									case "split":
         									newColor="#facf53";
         									break;
         									default:
         									newColor="#e4e4e4";
         									break;
         								}
         								$("#s"+(i+1), svgDocument).css({'fill':newColor});
         							}
         			//----------------------------------------------
         
         							svgDocument.addEventListener("select", function(event) {
         								sym.setVariable("selectedPart", event.target);
         								// get the id of the selected part
         								var countrySelect = sym.getVariable("selectedPart");
         								sym.$("placeholder").empty();
         								sym.$("captionTxt").fadeOut(0);
         								sym.$("pie").fadeOut(0);
         								for (var i=0; i<32; i++){
         									if (event.target.id==countryArr[i+1]){
         										countrySelect.style.opacity=0.25;
         										$("#region"+i).css({'background-color':'rgba(100,150,200,0.2)','font-weight':700});
         										sym.$("table").scrollTop(i*23);
         										if (regionYes[i]>0&&regionNo[i]>0){
         											sym.$("captionTxt").html( captionArr[i] );
         											sym.$("captionTxt").fadeIn(600);
         											pieChart(regionYes[i],regionNo[i],regionDK[i],"#Stage_placeholder");
         											sym.$("txt9").html(Math.round(regionYes[i])+"%");
         											sym.$("txt10").html(Math.round(regionNo[i])+"%");
         											sym.$("pie").fadeIn(600);
         
         										}
         									}else{
         										$("#region"+i).css({'background-color':'rgba(100,150,200,0)','font-weight':400});
         										$("#s"+(i+1), svgDocument).animate({opacity:1.0},300);
         									}
         								}
         							});
         			//------------------------------------------------------				
         							svgDocument.addEventListener("over", function(event) {
         								sym.setVariable("overPart", event.target);
         								var countryOver = sym.getVariable("overPart");
         								countryOver.style.opacity=0.1;
         								//countryOver.style.fill="#333333";
         								//countryOver.style.stroke_width=3;
         								//countryOver.style.stroke="#000000";
         							});
         			//----------------------------------------------
         							svgDocument.addEventListener("out", function(event) {
         								sym.setVariable("outPart", event.target);
         								var countryOut = sym.getVariable("outPart");
         								//countryOut.style.fill="";
         								countryOut.style.opacity=1.0;
         							});
         			//----------------------------------------------
         			/*
         							for (var i=0;i<32;i++){
         								$("#region"+i).on("click",selectName(i,svgDocument));
         								var newClass=regionVote[i];
         								var newColor;
         								switch (newClass){
         									case "yes":
         									newColor="#6496c8";//6496c8 5CCAE8
         									break;
         									case "no":
         									newColor="#ff6666";//ff6666 F59EB2
         									break;
         									case "split":
         									newColor="#facf53";
         									break;
         									default:
         									newColor="#e4e4e4";
         									break;
         								}
         								$("#s"+(i+1), svgDocument).css({'fill':newColor});
         							}
         							*/
         					});
         		}
         	});
         }
         getData();
         setInterval(function(){getData()}, 120000);

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "GraphicNews32204");