/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none", "background-color":"rgba(255,193,14,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.$("txt2").css({"pointer-events":"none", "background-color":"rgba(255,193,14,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[3] = sym.$("txt3").css({"pointer-events":"none", "background-color":"rgba(39,122,172,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[4] = sym.$("txt4").css({"pointer-events":"none", "background-color":"rgba(220,220,220,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[5] = sym.$("txt5").css({"pointer-events":"none", "background-color":"rgba(220,220,220,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[6] = sym.$("txt6").css({"pointer-events":"none", "background-color":"rgba(220,220,220,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.getSymbol("backTxtMc").$("txt9").css({"pointer-events":"none", "background-color":"rgba(255,193,14,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[10] = sym.getSymbol("backTxtMc").$("txt10").css({"pointer-events":"none", "background-color":"rgba(255,193,14,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[11] = sym.getSymbol("backTxtMc").$("txt11").css({"pointer-events":"none", "background-color":"rgba(255,193,14,1)", "border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)", "border-radius":"5px"});
	txt[12] = sym.getSymbol("sizeMc").$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.getSymbol("sizeMc").$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.getSymbol("sizeMc").$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.getSymbol("sizeMc").$("txt15").css({"pointer-events":"none"});
	txt[16] = sym.getSymbol("sizeMc").$("txt16").css({"pointer-events":"none"});
	txt[17] = sym.getSymbol("sizeMc").$("txt17").css({"pointer-events":"none"});
	txt[18] = sym.getSymbol("sizeMc").$("txt18").css({"pointer-events":"none"});
	txt[19] = sym.getSymbol("sizeMc").$("txt19").css({"pointer-events":"none"});
	txt[20] = sym.getSymbol("sizeMc").$("txt20").css({"pointer-events":"none"});
	txt[21] = sym.getSymbol("sizeMc").$("txt21").css({"pointer-events":"none"});
	txt[22] = sym.getSymbol("sizeMc").$("txt22").css({"pointer-events":"none"});
	txt[23] = sym.getSymbol("sizeMc").$("txt23").css({"pointer-events":"none"});
	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
	txt[27] = sym.$("txt27").css({"pointer-events":"none"});
	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN32164.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
	
			for (var i=0; i<30; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			}
	
			sym.$("txt5").animate({top:352 + sym.$("txt4").height()+20}, 0);
			sym.$("txt6").animate({top:352 + sym.$("txt4").height() + sym.$("txt5").height()+40}, 0);
	
		}
	}); // END XML
	
	// TOGGLE BUTTON
	var toggle = 0;
	
	sym.$("toggleBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	if (toggle == 0) {
		sym.getSymbol("toggleBtn").$("btnPlus").fadeOut(0);
		sym.$("backTxtMc").stop().animate ({opacity:0}, 200, function(){
			sym.$("phone5").animate ({left:571}, 500, 'easeOutCubic');
			sym.$("back").animate ({left:800}, 500, 'easeOutCubic');
			sym.$("sizeMc").animate ({opacity:1}, 500);
		});
		toggle = 1;
	}else{
		sym.getSymbol("toggleBtn").$("btnPlus").fadeIn(0);
		sym.$("sizeMc").stop().animate ({opacity:0}, 200);
		sym.$("phone5").stop().animate ({left:441}, 500, 'easeOutCubic');
		sym.$("back").stop().animate ({left:637}, 500, 'easeOutCubic', function(){
			sym.$("backTxtMc").stop().animate ({opacity:1}, 200);
		});
		toggle = 0;
	}
	}); 
	sym.$("toggleBtn").mouseover(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
	});
	sym.$("toggleBtn").mouseout(function(){
	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
	});
	


         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cutBtn'
   (function(symbolName) {   
   
   })("cutBtn");
   //Edge symbol end:'cutBtn'

   //=========================================================
   
   //Edge symbol: 'backTxtMc'
   (function(symbolName) {   
   
   })("backTxtMc");
   //Edge symbol end:'backTxtMc'

   //=========================================================
   
   //Edge symbol: 'sizeMc'
   (function(symbolName) {   
   
   })("sizeMc");
   //Edge symbol end:'sizeMc'

})(jQuery, AdobeEdge, "GraphicNews32164");