/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gnYear=2014;
         var gn=31938;
         var startWC= Date.parse("August 16, 2014, 15:59 UTC");
         var endWC = Date.parse("May 24, 2015, 23:59 UTC");
         var gmtStart = Date.parse("October 26, 2014, 01:59 UTC");
         var gmtEnd = Date.parse("March 29, 2014, 00:59 UTC");
         var oneDay = 86400000;
         var todayDate = new Date();
         var todayTime = todayDate.getTime();
         var localOffset=todayDate.getTimezoneOffset()*60000;
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         var dateFormat;
         var showLocal=0;
         var startTime;
         var teamIDs =[4007,4010,4486,4034,100094,4047,102813,4693,4075,4222,4080,4087,4098,4874,4286,4906,4908,4129,4972,4144];
         var venueID=[10438,15899,26737,35238,35239,36882,37425,49670,49671,49672,49673,49674];
         var minutes = sym.$("timeTxt").css("pointer-events","none");
         sym.$("matchTxt").css("line-height","125%");
         var screenArr=['timer','matchStats','teams','h2hMc','guide'];
         var ko;
         var cap1;
         var cap2;     
         var sources;
         var txtArr=[];
         var teamArr=[];
         var teamShortArr=[];
         var months=[];
         var key=[];
         // MENU BUTTONS --------------------------------------------
         var menuText=[];
         var menuTxtArr=[];
         var menuArray = []; //the array that will hold references to the buttons.
         var clicked=0;
         var showguide;
         
         for (var i=0; i<4; i++){
         	menuText[i]= sym.getSymbol("menuBtnMc").getSymbol("menuBtn"+i).$("menuTxt").css("pointer-events","none");
         	sym.getSymbol("menuBtnMc").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         	var menuBtnSymbols = sym.getSymbol("menuBtnMc").getSymbol("menuBtn" +i); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", i); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         }
         $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
         	var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         	menuBtnElement.on (clickEventType, {menuId:count}, menuBtnClick);
         	menuBtnElement.on ("mouseover", {menuId:count}, menuBtnOver);
         	menuBtnElement.on ("mouseout", {menuId:count}, menuBtnOut);
         });
         
         function resetmenu(){
         	for (var i=0; i<menuArray.length; i++){
         		menuArray[i].$("menuBg").fadeIn(0);
         		sym.$(screenArr[i]).fadeOut(0);
         	}
         }
         function menuBtnClick (e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         	clicked=menuMenu_id;
         	//resetmenu(); //set them all back to normal state
         	for (i=0;i<4;i++){
         		if (i==menuMenu_id){
         			if(menuMenu_id==0||menuMenu_id==1){
         				if (showguide==1){
         					sym.$(screenArr[4]).fadeIn(400);
         				}else{
         					sym.$(screenArr[menuMenu_id]).fadeIn(400);
         				}
         			}else{
         				sym.$(screenArr[menuMenu_id]).fadeIn(400);
         				sym.$(screenArr[4]).fadeOut(400);
         			}
         			menuArray[menuMenu_id].$("menuBg").fadeOut(0);
         		}else{
         			sym.$(screenArr[i]).fadeOut(400);
         			menuArray[i].$("menuBg").fadeIn(0);       					
         		}														
         	}
         }
         function menuBtnOver(e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId);
         	menuArray[menuMenu_id].$("menuBg").fadeOut(0);
         }
         function menuBtnOut(e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         	if (menuMenu_id!=clicked){
         		menuArray[menuMenu_id].$("menuBg").fadeIn(0);
         	}
         }
         $.ajax({	
                  	type: "GET",
                  	url: "GN32127.xml",
                  	dataType: "xml",
                  	success: function(xml) {
         					for (var m=0; m<4; m++){
         						menuTxtArr[m]= $(xml).find('menutxt'+m).text();
         						menuText[m].html(menuTxtArr[m]);
         					}
         					sources = $(xml).find('sources').text();
                  		sym.$("sourcesTxt").html(sources);
                  		var monthsArr = $(xml).find('months').text();
         					months=monthsArr.split(";");
         					var keyArr = $(xml).find('key').text();
                           key=keyArr.split(";");
         					var teamLongArr= $(xml).find("teams").text();
         					teamArr=teamLongArr.split(";");
         					var teamShortNameArr= $(xml).find("teamShort").text();
         					teamShortArr=teamShortNameArr.split(";");
         					for  (var i=0;i<31;i++){
         						txtArr[i]= $(xml).find('txt'+i).text();
         					}
         					for (var h=0;h<5;h++){
         						sym.getSymbol('h2hMc').$('h2hTxt'+h).html(txtArr[h+9]);
         					}
         					sym.getSymbol('matchStats').$('txt0').html(txtArr[0]);
         					sym.getSymbol('matchStats').$('txt5').html(txtArr[5]);
         					sym.getSymbol('h2hMc').$('h2hTxt4').html(txtArr[16]);
         
         					//instruction page
         					sym.getSymbol("guide").$("txt0").html(txtArr[17]);	
         					var timerTxt="<div class='action period4'>";//style by period
         					timerTxt+="<div class='personh'>"+txtArr[18]+"</div>";
         					timerTxt+="<div class='type'><img src='images/goal.png'></div>";	
         					timerTxt+="<div class='actiontime'>"+txtArr[19]+"</div>";
         					timerTxt+="<div class='type'></div>";
         					timerTxt+="<div class='persona'></div>";
         					timerTxt+="</div>";
         					timerTxt+="<div class='action period4'>";
         					timerTxt+="<div class='personh'></div>";
         					timerTxt+="<div class='type'></div>";	
         					timerTxt+="<div class='actiontime'>"+txtArr[20]+"</div>";
         					timerTxt+="<div class='type'><img src='images/sub.png'></div>";
         					timerTxt+="<div class='persona'>"+txtArr[21]+"</div>";
         					timerTxt+="</div>";
         					timerTxt+="<div class='action period4'>";
         					timerTxt+="<div class='personh'></div>";
         					timerTxt+="<div class='type'></div>";	
         					timerTxt+="<div class='actiontime'>"+txtArr[24]+"</div>";
         					timerTxt+="<div class='type'><img src='images/yellow.png'></div>";
         					timerTxt+="<div class='persona'>"+txtArr[25]+"</div>";
         					timerTxt+="</div>";
         					timerTxt+=txtArr[26];
         					timerTxt+="<img src='images/samplestats.png'>";
         					timerTxt+=txtArr[5]+", "+txtArr[6]+", "+txtArr[7]+", "+txtArr[8];
         					sym.getSymbol("guide").$("txt0").append(timerTxt);
         					$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
         					$(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
         					$('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
         					$('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
         					$('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
         					$('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
         					$(".action img").css({'width':'20px'});
         
                 }
         });
         //DATE FUNCTIONS --------------------------------------------
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     //var thisDate = new Date(parseInt(dateTxt, 10));
                     var thisDate = new Date(parseInt(dateTxt, 10)+oneDay);
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var matchDate=thisDate.getTime() +localOffset;
         	var matchTime=new Date(matchDate);
         	var mm = matchTime.getMonth();
         	var dd = matchTime.getDate();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         } 
         function getDateLocal(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	//return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         }
         function getMatchTime(thisDateStr,braziltime){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var thisTime = thisDate.getTime()+localOffset-braziltime;//localOffset to UTC - offset to Brazil
         	var matchTime = new Date(thisTime);
         	var hh = matchTime.getHours();
         	var mm = parseInt(matchTime.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         	//return hh+":00";	
         }
         function getMatchLocal(thisDateStr){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var hh = thisDate.getHours();
         	var mm = parseInt(thisDate.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	//var dDate = parseInt(matchRndDate,10);
         	var dDate = parseInt(matchRndDate,10)+localOffset;
         	return dDate;
         } 
         var offsetBrazil;//Offset between time at venue and UTC
         function getDST(thisDateStr){
         	var thisDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf('+'));
         	if(thisDate<gmtStart||thisDate>gmtEnd){
         		var offsetUTC = -3600000;
         	}else{
         		var offsetUTC = 0;
         	}
         	return offsetUTC;
         }
         var clockTime=0;
         var clockInterval;
         // --------------------------------------------
         var crest1 = sym.$("crest1");
         var crest2 = sym.$("crest2");
         //LIVE MATCH
         var h2hInterval;
         var teamInterval;
         function getMatchInfo(){
         	sym.$("penaltiesTxt").fadeOut(0);
         	var infoData;
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&match="+matchID+"&q=info",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			infoData = data;
         			var matchteam1;
         			var matchteam2;
         							clearInterval(clockInterval);
         			for(var c=0;c<20;c++){
         					if (infoData[0].n_HomeTeamID>0){
         						if (infoData[0].n_HomeTeamID==teamIDs[c]){
         							matchteam1=teamArr[c];
         						}
         					}else{
         						matchteam1=infoData[0].c_HomeTeam;
         					}
         					if (infoData[0].n_AwayTeamID>0){
         						if (infoData[0].n_AwayTeamID==teamIDs[c]){
         							matchteam2=teamArr[c];
         						}
         					}else{
         						matchteam2=infoData[0].c_AwayTeam;
         					}
         				}
         			var stadiumImg=(infoData[0].n_StadiumGeoID>0)?infoData[0].n_StadiumGeoID:null;
         			var score1;
         			var score2;					
         			if(infoData[0].b_Started==false){
         				score1="0";
         				score2="0";
         				//sym.$("clock").fadeOut(0);
         				//sym.$("timeTxt").fadeIn(0);
         				showguide=1;
         			}else{
         				score1=infoData[0].n_HomeGoals;
         				score2=infoData[0].n_AwayGoals;
         				//sym.$("clock").fadeIn(0);
         				//sym.$("timeTxt").fadeIn(0);
         				getmatchStats();
         				getMatch();
         				clearInterval(h2hInterval);
         				h2hInterval=setInterval(getH2H,600000);
         				showguide=0;	
         			}
         			var offsetBrazil = getDST(infoData[0].d_DateUTC);
         			if(infoData[0].b_Finished==true){
         				var matchTime = getDDmonthYY(infoData[0].d_DateUTC);
         			}else{
         				if(showLocal==0){
         					//var matchTime = getMatchTime(infoData[0].d_Date,offsetBrazil)+" "+getDDmonthYY(infoData[0].d_DateUTC);
         					var matchTime = getMatchLocal(infoData[0].d_Date)+" "+getDateLocal(infoData[0].d_Date);
         				}else{
         					var matchTime = getMatchLocal(infoData[0].d_Date)+" "+getDateLocal(infoData[0].d_Date);
         				}
         			}
         
         			getTeams(infoData[0].n_HomeTeamID,infoData[0].n_AwayTeamID);
         			var matchRef=(infoData[0].c_Referee==null)?"":txtArr[3] + infoData[0].c_Referee+" "+infoData[0].c_RefereeNatioShort;
         			var spectators=(infoData[0].n_Spectators==null)?"":txtArr[4] + infoData[0].n_Spectators;
         			var matchscore = score1 + "-" + score2;
         			var imgH = "crests/"+ infoData[0].n_HomeTeamID + ".png";
         			var imgA = "crests/"+ infoData[0].n_AwayTeamID + ".png";
         			var matchStatus = infoData[0].n_MatchStatusCode;
         			var tacticsH =(infoData[0].c_HomeTactics==null)?"":infoData[0].c_HomeTactics;
         			var tacticsA = (infoData[0].c_AwayTactics==null)?"":infoData[0].c_AwayTactics;
         			startTime=parsedDate(infoData[0].d_Date);
         			var matchDate = getDDmonthYY(infoData[0].d_Date);
         			//var matchInfo = infoData[0].c_Stadium + ", " + infoData[0].c_City + "<br />" + matchDate + ", 2014<br />" + matchRef + "<br />" + spectators ;
         				var matchInfo = infoData[0].c_Stadium + ", " + infoData[0].c_City + "<br />" + matchTime + ", 2014<br />" + matchRef + "<br />" + spectators ;
         			sym.$("crest1").attr("src",imgH);				
         			sym.$("crest2").attr("src",imgA);				
         			sym.$("team1Txt").text(matchteam1);
         			sym.$("team2Txt").text(matchteam2);
         			sym.$("scoreTxt").text(matchscore);
         			sym.$("matchTxt").html(matchInfo);
         			//PENALTY SHOOTOUT ONLY
         			if (infoData[0].n_PeriodSort>=10&&infoData[0].n_HomeGoalsShootout!=null){
         				var pensH=(infoData[0].n_HomeGoalsShootout>=0)?infoData[0].n_HomeGoalsShootout:"";
         				var pensA=(infoData[0].n_AwayGoalsShootout>=0)?infoData[0].n_AwayGoalsShootout:"";
         				var penalties= txtArr[15]+" (" +pensH+ "-" +pensA+ ")";
         				if (infoData[0].n_HomeGoalsShootout>=0||infoData[0].n_AwayGoalsShootout>=0){
         						sym.$("penaltiesTxt").html(penalties);
         						sym.$("penaltiesTxt").fadeIn(0);
         					}
         			}	               							
         		}
         	});
         }
         getMatchInfo();
         intervalId = setInterval(getMatchInfo,60000);
         
         var matchData;
         var lastAction;
         var lastTime;
         var lastPeriod;
         function getMatch() { 
         	minutes.text("0"); 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			matchData = data;
         				if(matchData){
         					lastAction = matchData[0].n_ActionTime;
         					lastPeriod = matchData[0].n_PeriodSort;
         					var lastTimetxt;
         					sym.getSymbol("timer").$("live").empty();
         					//create display for each action	
         					var actionTxt;
         					var penTxt;
         					var HorA;
         					var actionSet;
         					var actionType;
         					var action;
         					var actionTime;
         					var actionMs;
         					var actionPeriod;
         					var keyTxt="<div class='action'>";
                  		keyTxt+="<div class='key'><img src='images/goal.png' style='width:15px'> "+key[0]+"</div>";
                  		keyTxt+="<div class='key'>"+"<img src='images/pen.png' style='width:15px'> "+key[1]+"</div>";
                  		keyTxt+="<div class='key'>"+"<img src='images/sub.png' style='width:15px'> "+key[2]+"</div>";
                  		keyTxt+="<div class='key'>"+"<img src='images/yellow.png' style='width:15px'> "+key[3]+"</div>";
                  		keyTxt+="</div>";
                  		sym.getSymbol("timer").$("live").append(keyTxt);
         					for (var i = 0; i <= matchData.length; i++) {
         						if (matchData[i].n_ActionTime>lastAction){
         							lastAction=matchData[i].n_ActionTime;
         						}
         						if (matchData[i].n_PeriodSort>lastPeriod){
         							lastPeriod=matchData[i].n_PeriodSort;
         						}         		        
         						actionSet = matchData[i].n_ActionSet;
         						actionType = matchData[i].n_ActionCode;
                  			actionTime = (matchData[i].c_ActionMinute==null)?"":matchData[i].c_ActionMinute;
         						var HorA = (matchData[i].n_HomeOrAway==1)?"h":"a";
         						if (actionSet==1||actionSet==2||actionSet==3||actionSet==5){
         							actionMs = matchData[i].n_ActionTime;
         							actionPeriod = matchData[i].n_PeriodSort;
         							var actionTxt="<div class='action period"+actionPeriod+"' id=action"+i+"'>";//style according to period
         							actionTxt+="<div class='personh' id='person"+i+"h'></div>";
         							actionTxt+="<div class='type' id='type"+i+"h'></div>";	
         							actionTxt+="<div class='actiontime' id='actionMins"+i+"'></div>";
         							actionTxt+="<div class='type' id='type"+i+"a'></div>";
         							actionTxt+="<div class='persona' id='person"+i+"a'></div>";
         							actionTxt+="</div>";
         							//then append each action (latest at top)
         							sym.getSymbol("timer").$("live").prepend(actionTxt);
         							var player=matchData[i].c_PersonShort;     
         							if (matchData[i].n_ActionSet==5){
         								var sub=" (" + matchData[i].c_SubPersonShort + ")";
         							}else{
         								var sub="";
         							}
         							$('#person' + i + HorA).text(player+sub);
         							$('#actionMins' + i).text(actionTime);
         							//create icons for each action
         							switch (actionSet){
         								case 1:
                  								if(actionType==12){//June 30
                  									action= "pen";
                  								}else{//June 30
                  									action= "goal";
                  								}
                  								break;
         								case 2:
         								if (actionType==12){
         									action="pen";
         								}else{
         									action="miss";
         								}
         								break;
         								case 3:
         								if (actionType==2048){
         									action="yellow";
         								}else{
         									action="red";
         								}
         								break;
         								case 5:
         								action="sub";
         								break;
         							}
         							var imgHTML="<img src='images/"+action +".png' height='20px' width='20px'>";
         							$('#type' + i + HorA).html(imgHTML);
         							//style according to period
         							$('.key').css({'display':'table-cell','font-style':'italic','padding-left':'5px'});
         							$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
         							$(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
         							$(".period6, .period8").css({'background-color':'rgba(255,0,0,0.1)'});
         							$(".period10").css({'background-color':'rgba(255,40,0,0.3)'});
         							$('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
         							$('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
         							$('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
         							$('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
                  			} //close if
         						if (lastAction>7200000){					//if after 120 mins but before penalties
         							lastTime=7200000;
         						}else if ((lastAction>6300000)&&(lastPeriod<7)){					//if after 105 mins but before second period
         							lastTime=6300000;
         						}else if ((lastAction>5400000)&&(lastPeriod==11)){					//if after 90 mins match has finished
         							lastTime=5400000;
         						}else if ((lastAction>5400000)&&(lastPeriod<5)){					//if after 90 mins but before extra time
         							lastTime=5400000;
         						}else if((lastAction>2700000)&&(lastPeriod<4)){ 		// if match is in 1st half but > 45 mins
         							lastTime=2700000;
         						}else{
         							lastTime=lastAction;
         						}
         						//display latest time
         						if (lastPeriod==11){
         							lastTimetxt=Math.round(lastTime/60000);
         						}else if (lastPeriod<9){ //before penalty shootout
         							if(lastAction > 0){	
         								lastTimetxt=Math.round(lastAction/60000);
         							}
         						}else{
         							lastTimetxt="120";
         						}
                  			minutes.text(lastTimetxt); //SHOW LATEST TIME
         					} //close for 
         					if (lastPeriod>5){ //extra time draw line at ht/ft
         					}					
         				}
         		},//close success 
         		error: function(){ 
         			console.log("match not started");
         		}  	                                                  	           
         	}); //close ajax
         }
         //LINEUPS
         function getTeams(home,away) {           
                     var teamData;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gn+"&yr="+gnYear+"&q=teams&match="+matchID,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		success: function (data) {
                  			teamData = data;
                  			sym.getSymbol("teams").$("matchSquadh").empty();
         						sym.getSymbol("teams").$("matchSquada").empty();
                  			if (!teamData){
         							getSquad(home,"home");
         							getSquad(away,"away");
         							sym.getSymbol("teams").$("txt1").html(txtArr[2]);
         							sym.getSymbol("teams").$("tableHead").fadeIn(0);
         							clearInterval(teamInterval);
         							teamInterval = setInterval(function() { getTeams(home,away); }, 600000);
                  			}else{
         							var coach;
         							var teamlist;
         							var team;
         							var hORa;
         							sym.getSymbol("teams").$("txt1").html(txtArr[1]);
         							sym.getSymbol("teams").$("tableHead").fadeOut(0);
         							for (var i = 0; i < teamData.length; i++) {		
         								if (teamData[i].n_HomeOrAway==1){
         									teamlist = "matchSquadh";
         									hORa='h';
         								}else if (teamData[i].n_HomeOrAway==-1){
         									teamlist = "matchSquada";
         									hORa='a';
         								}	
         								if (teamData[i].n_ActionSet<8){
         									if (teamData[i].n_ActionSet==4){
         										var lineupTxt = "<div class='lineup' id='lineup" + i + "'>";
         									} else if (teamData[i].n_ActionSet==5||teamData[i].n_ActionSet==6){
         										var lineupTxt = "<div class='substitute' id='lineup" + i + "'>";
         									}	
         										lineupTxt += "<div class='shirtNr' id='teamShirt" + i + "'></div>";
         										lineupTxt += "<div class='playerNm' id='teamPerson" + i + "'></div>";
         										lineupTxt += "</div>";
         										sym.getSymbol("teams").$("matchSquad"+hORa).append(lineupTxt);
         								}else if (teamData[i].n_ActionSet==8){
         									coach = "<div style='padding-left:3px'><b>" + teamData[i].c_Person + "</b> <span style='text-align:right; font-style:oblique; font-size:12px'>" + teamData[i].c_PersonNatioShort + "</span></div>";
         									sym.getSymbol("teams").$("matchSquad"+hORa).prepend(coach);
         								}
         								sym.getSymbol("teams").$("matchSquad"+hORa).css({'font-family':'pragmatica-web,sans-serif','font-size':'13px'}); 
         								$('.lineup').css({'width':'100%','display':'inline-table'});
         								$('.substitute').css({'width':'100%','display':'inline-table','font-style':'oblique'});
         								$('.shirtNr').css({'width':'10%','display':'table-cell','text-align':'left','padding-left':'3px'});  
         								$('.playerNm').css({'width':'90%','display':'table-cell','text-align':'left','padding-left':'5px'});                        
         								var actionMins;	                
         								if (teamData[i].c_ActionMinute==null){
         									actionMins="";
         								}else{
         									actionMins=" ("+ teamData[i].c_ActionMinute + ")";
         								}			
         								$('#teamShirt' + i).text(teamData[i].n_ShirtNr);
         								$('#teamPerson' + i).html(teamData[i].c_Person + actionMins);
         								$('#subPerson' + i).text(teamData[i].c_SubPersonShort);
         								var posn = teamData[i].n_Position;			
         							}
         						}
                  		}
                  	});
         }
         //PRE-MATCH SQUAD
         function getSquad(team,homeOrAway){
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gn+"&yr="+gnYear+"&squad="+team,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		success: function (data) {
         						squadData=data;
                  			var hORa=(homeOrAway=="home")?"h":"a";
                  			for (var i = 0; i <squadData.length; i++) {
                  				var shirtNr = (squadData[i].n_ShirtNr!=null)?squadData[i].n_ShirtNr:"";
                  				var player = squadData[i].c_Person;
                  				var ycards = squadData[i].n_CardsYellow;
                  				var rcards = squadData[i].n_CardsRed;
                  				var cards = ycards + "/" + rcards;
                  				var goals = squadData[i].n_Goals;
                  				var position=squadData[i].n_FunctionCode;
                  				var contractEnd=(squadData[i].d_ContractEndDate==null)?endWC:parsedDate(squadData[i].d_ContractEndDate);//Jan 29
         							if(todayTime<contractEnd){
                  					if (position>0&&position<16){
                  						var squadlist = "<div id='"+hORa+"player"+i+"'>";
                  						squadlist += "<div class='squadCol1' id='"+hORa+"sqdshirt"+i+"'></div>";
                  						squadlist += "<div class='squadCol2' id='"+hORa+"sqdplayerName"+i+"'></div>";
                  						squadlist += "<div class='squadCol3' id='"+hORa+"sqdcards"+i+"'></div>";
                  						squadlist += "<div class='squadCol4' id='"+hORa+"sqdgls"+i+"'></div>";
                  						squadlist += "</div>";
                  					}
                  					sym.getSymbol("teams").$("matchSquad"+hORa).append(squadlist);  
                  					sym.getSymbol("teams").$("preloader"+hORa).fadeOut(0);
                  					sym.getSymbol("teams").$("txt1").html(txtArr[2]);              
                  					$('#'+hORa+'player'+i).css({'width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif', 'display':'inline-table'});
                  					$('.squadCol1').css({'width':'8%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
                  					$('.squadCol2').css({'width':'72%', 'padding-left':'3%','display':'table-cell'});
                  					$('#'+hORa+'sqdplayerName'+i).css({'font-weight':400});
                  					$('.squadCol3').css({'width':'10%', 'display':'table-cell', 'text-align':'center'});
                  					$('.squadCol4').css({'width':'10%', 'display':'table-cell', 'text-align':'right'});
                  					$('#'+hORa+'sqdshirt'+i).text(shirtNr);
                  					$('#'+hORa+'sqdplayerName'+i).text(player);
                  					$('#'+hORa+'sqdcards'+i).text(cards);
                  					$('#'+hORa+'sqdgls'+i).text(goals);
         						}
         			}
         		}
         	});
         }
         //PIE CHART
         function pieChart(hwins,awins,draws,placeHolder){			
              var canvasWidth = 145, //width
               canvasHeight = 90,   //height
               outerRadius = 45,   //radius
               //color = d3.scale.category20(); //builtin range of colors
         		color = d3.scale.ordinal().range(["#006666","#4e9799","#33c5cc","#FF6666"]);
             var dataSet = [
               {"legendLabel":"Won", "magnitude":awins},  
               {"legendLabel":"Drawn", "magnitude":draws}, 
               {"legendLabel":"Won", "magnitude":hwins}];
             var vis = d3.select(placeHolder)
               .append("svg:svg") //create the SVG element inside the <body>
                 .data([dataSet]) //associate our data with the document
                 .attr("width", canvasWidth) //set the width of the canvas
                 .attr("height", canvasHeight) //set the height of the canvas
                 .append("svg:g") //make a group to hold our pie chart
         			.attr("transform", "translate("+canvasWidth/2+","+canvasHeight/2+")") //move centre of pie chart from 0, 0 to middle of placeholder
         			.style("-webkit-transform", "translate("+canvasWidth/2+"px,"+canvasHeight/2+"px)");
             // This will create <path> elements for us using arc data...
             var arc = d3.svg.arc()
               .outerRadius(outerRadius)
         		.innerRadius(outerRadius-30); //donut chart
             var pie = d3.layout.pie() //this will create arc data for us given a list of values
               .value(function(d) { return d.magnitude; }) // Binding each value to the pie
               .sort( function(d) { return null; } );
             // Select all <g> elements with class slice (there aren't any yet)
             var arcs = vis.selectAll("g.slice")  // Associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
               .data(pie) // This will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
               .enter() // Create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
               .append("svg:g")
               .attr("class", "slice");    //allow us to style things in the slices (like text)
             arcs.append("svg:path")
               //set the color for each slice to be chosen from the color function defined above
               .attr("fill", function(d, i) { return color(i); } ) //this creates the actual SVG path using the associated data (pie) with the arc drawing function
               .attr("d", arc);
         }
         function getH2H(){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=h2hsum&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("h2hMc").$("h2hmatch").empty();
         			sym.getSymbol("h2hMc").$("h2hgoals").empty();
         			sym.getSymbol("h2hMc").$("h2hTxt1").empty();
         			sym.getSymbol("h2hMc").$("h2hTxt2").empty();
         			sym.getSymbol("h2hMc").$("h2hTxt3").empty();
         			sym.getSymbol("h2hMc").$("h2hTxt4").fadeIn(0);
         			h2hData = data;
         			if(h2hData.length>0){			
         				var hwins=h2hData[0].n_MatchesWonHome;
         				var awins=h2hData[0].n_MatchesWonAway;
         				var draws=h2hData[0].n_MatchesDrawn;
         				var hgoals=h2hData[0].n_GoalsForHome;
         				var agoals=h2hData[0].n_GoalsForAway;
         				var placeHolder="#Stage_h2hMc_h2hmatch";
         				pieChart(hwins,awins,draws,placeHolder);
         				sym.getSymbol("h2hMc").$("h2hTxt1").html(txtArr[10]+": <b>"+hwins+"</b>")
         				sym.getSymbol("h2hMc").$("h2hTxt2").html(txtArr[11]+": <b>"+awins+"</b>")
         				sym.getSymbol("h2hMc").$("h2hTxt3").html(txtArr[12]+": <b>"+draws+"</b>")
         				var barTxt="<div class='barGraph'>";
         					barTxt+="<div id='capGoals'></div>";
         				barTxt+="<div id='hbarGoals'></div>";
         				barTxt+="<div id='abarGoals'></div>";
         				barTxt+="</div>";
         				sym.getSymbol("h2hMc").$("h2hgoals").append(barTxt);
         				var hwidth=(hgoals/(hgoals+agoals)*100)+"%";
         				var awidth=(agoals/(hgoals+agoals)*100)+"%";
         				$("#hbarGoals").text(hgoals);
         				$("#abarGoals").text(agoals);
         				var acolor=(agoals==0)?'#33c5cc':'#006666';
         				var hcolor=(hgoals==0)?'#006666':'#33c5cc';
         				$("#capGoals").html(txtArr[13]);
         				$(".barGraph").css({'font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px','font-weight':700, 'display':'inline-table'});
         				$("#capGoals").css({'text-align':'center','width':'100%','display':'table-caption'});
         				$("#hbarGoals").css({'background-color':hcolor,'color':'#ffffff','padding-left':'5px','text-align':'left', 'display':'table-cell','width':hwidth});
         				$("#abarGoals").css({'background-color':acolor,'color':'#ffffff','padding-right':'5px','text-align':'right','width':awidth,'display':'table-cell'});
         			}else{
         				sym.getSymbol("h2hMc").$("h2hTxt4").fadeOut(0);
         				sym.getSymbol("h2hMc").$("h2hmatch").append("<div style='font-family:pragmatica-web;text-align:center;font-size:14px'>"+txtArr[29]+"</div>");
         			}
         		}
         	});
         }
         getH2H();
         function getmatchStats(){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=stats&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchStats").$("chartHolder").empty();
         			sym.getSymbol("matchStats").$("barCharts").empty();
         			matchData = data;
         			var bar;
         			var placeHolder="#Stage_matchStats_chartHolder";
         			if (matchData){
         				//sym.getSymbol("menuBtnMc").$("menuBtn1").on(clickEventType, {menuId:1}, menuBtnClick);
         				function drawBar(){//CHANGE ON MAIN GRAPHIC
         							var barTxt="<div class='barGraph'>";
         							barTxt+="<div id='cap"+bar+"'></div>";
         							barTxt+="<div id='hbar"+bar+"'></div>";
         							barTxt+="<div id='abar"+bar+"'></div>";
         							barTxt+="</div>";
         							sym.getSymbol("matchStats").$("barCharts").append(barTxt);
         				}
         				for (var i = 0; i < matchData.length; i++) {
         					if(matchData[i].n_ActionSet==13&&matchData[i].c_ActionShort=="BP"){//possession
         						var hPoss=matchData[i].n_HomePoints;
         						var aPoss=matchData[i].n_AwayPoints;
         						pieChart(hPoss,aPoss,0,placeHolder);
         						sym.getSymbol("matchStats").$("hpiTxt").text(hPoss+"%");
         						sym.getSymbol("matchStats").$("apiTxt").text(aPoss+"%");
         					}else if(matchData[i].n_ActionSet==12){
         						if(matchData[i].n_ActionSort==104){//on target
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="shots";
         							drawBar();//CHANGE ON MAIN GRAPHIC
         						}
         						if(matchData[i].n_ActionSort==106){//saves
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="saves";
         							drawBar();//CHANGE ON MAIN GRAPHIC
         						}
         						if(matchData[i].n_ActionSort==112){//fouls against
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="fouls";
         							drawBar();//CHANGE ON MAIN GRAPHIC
         						}
         						var hwidth=(hPts/(hPts+aPts)*100)+"%";
         						var awidth=(aPts/(hPts+aPts)*100)+"%";
         						$("#hbar"+bar).text(hPts);
         						$("#abar"+bar).text(aPts);
         						$(".barGraph").css({'margin':'5px 0px','font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px', 'display':'inline-table'});
         						$("#cap"+bar).css({'text-align':'center','width':'100%','display':'table-caption','font-weight':700});
         						$("#hbar"+bar).css({'background-color':'#33c5cc','color':'#ffffff','padding-left':'5px','text-align':'left', 'display':'table-cell','width':hwidth});
         						$("#abar"+bar).css({'background-color':'#006666','color':'#ffffff','padding-right':'5px','text-align':'right','width':awidth,'display':'table-cell'});
         					}
         					$("#capshots").html(txtArr[6]);
         					$("#capsaves").html(txtArr[7]);
         					$("#capfouls").html(txtArr[8]);
         				}
         			}
         		}
         	});
         }
         function startUp(){
         	if(todayTime>startTime){
         		clicked=0;
         		sym.$(screenArr[0]).fadeIn(0);
         		menuArray[0].$("menuBg").fadeOut(0);
         	}else{
         		clicked=2;
         		sym.$(screenArr[2]).fadeIn(0);
         		menuArray[2].$("menuBg").fadeOut(0);
         	}
         }
         setTimeout(startUp,1000);

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================

//=========================================================
   //Edge symbol: 'timer'
   (function(symbolName) {

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000000, function(sym, e) {
         sym.stop();
         // insert code here

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5700500, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6600000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("TimerMc");
   //Edge symbol end:'TimerMc'

   //=========================================================

//=========================================================
   //Edge symbol: 'Teams'
   (function(symbolName) {

   })("TeamsMc");
   //Edge symbol end:'TeamsMc'

   //=========================================================
   
   //Edge symbol: 'MatchStats'
   (function(symbolName) {   
   
   })("MatchStats");
   //Edge symbol end:'MatchStats'

   //=========================================================
   
   //Edge symbol: 'H2HMc'
   (function(symbolName) {   
   
   })("H2HMc");
   //Edge symbol end:'H2HMc'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuButtonsMc'
   (function(symbolName) {   
   
   })("MenuButtonsMc");
   //Edge symbol end:'MenuButtonsMc'

   //=========================================================
   
   //Edge symbol: 'TableHead'
   (function(symbolName) {   
   
   })("TableHead");
   //Edge symbol end:'TableHead'

   //=========================================================
   
   //Edge symbol: 'Guide'
   (function(symbolName) {   
   
   })("Guide");
   //Edge symbol end:'Guide'

})(jQuery, AdobeEdge, "GraphicNews32127");