/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gnYear=2014;
         var gn=32094;
         var startWC= Date.parse("August 30, 2014, 10:30 UTC");
         var startR2= Date.parse("September 5, 2014, 23:59 UTC");
         var endWC = Date.parse("September 14, 2014, 23:59 UTC");
         var oneDay = 86400000;
         var todayDate = new Date();
         var todayTime = todayDate.getTime();
         var localOffset=todayDate.getTimezoneOffset()*60000;
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var dateFormat;
         var showLocal=0;
         
         //REFRESH RATES
         var fixtureInterval;
         var groupInterval;
         var matchInterval;
         var teamInterval;
         
         var screenArr=['latest','overview','matchtracker'];
         for (var i=0; i<2; i++){
         	sym.getSymbol("menuBtns").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         }
         var menuTxtArr=[];
         var headlinetext=sym.getSymbol("styleMc").$("headlinetxt").css("pointer-events","none");
         var sourcetxt=sym.getSymbol("styleMc").getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         var menuTxt=sym.getSymbol("styleMc").$("menuTxt").css("pointer-events","none");
         var text=[];
         	text[0]=sym.getSymbol("overview").$("txt0").css("pointer-events","none");
         	text[1]=sym.getSymbol("overview").$("txt1").css("pointer-events","none");
         	for (var t=2;t<15;t++){
         		text[t]=sym.getSymbol("overview").getSymbol("knockout").$("txt"+t).css("pointer-events","none");
         	}
         	text[15]=sym.getSymbol("overview").$("txt15").css("pointer-events","none");
         var txtArr=[];
         var countryArr=[];
         var recordArr=[];
         var qualArr=[];	
         var rankArr=[];
         var tableCaps=[];
         var months=[];
         var venues=[];
         var key=[];
         var timetxt=[];
         var winner=[];
         
         var groupArray=[4,3,2,1];//Basketball group Ids are back to front
         var showstage=0;
         sym.getSymbol("overview").$("up").on('click',showStages);
         sym.getSymbol("overview").$("up").css({'cursor':'pointer'});
         $(".knockoutCaps").fadeOut(0);
         function showStages(){
         	e.preventDefault();
         	e.stopPropagation();
         	if(showstage==0){
         		$(".knockoutCaps").fadeIn(500);//show ko captions
         		$(".groupCaps").fadeOut(500);//hide grp captions
         		$(".kstage").fadeIn(500);
         		sym.getSymbol("overview").$("up").fadeOut(0);
         		sym.getSymbol("overview").getSymbol("knockout").$("ru").fadeIn(300);
         		sym.getSymbol("overview").$("down").delay(400).fadeIn(300);
         		for (var i=1; i<=4; i++){
         			var moveIt=(i%2==0)?1:0;
         			sym.getSymbol("overview").getSymbol("groupStage").$("group"+(i)).animate({'height':'70px','top':19+(moveIt*75)},500);
         		}
         		sym.getSymbol("overview").$("groupStage").animate({'height':'190px'},500);	
         		sym.getSymbol("overview").$("knockout").off('click');
         		sym.getSymbol("overview").$("groupStage").on('click',showStages);
         		sym.getSymbol("overview").$("groupStage").css({'cursor':'pointer'});
         		sym.getSymbol("overview").$("knockout").css({'cursor':'auto'});
         		sym.getSymbol("overview").play();
         		showstage=1;
         	}else if(showstage==1){
         		$(".knockoutCaps").fadeOut(500);//show ko captions
         		$(".groupCaps").fadeIn(500);//hide grp captions
         		$(".kstage").fadeOut(500);
         		sym.getSymbol("overview").$("up").delay(400).fadeIn(300);
         		sym.getSymbol("overview").getSymbol("knockout").$("ru").fadeOut(300);
         		sym.getSymbol("overview").$("down").fadeOut(0);
         		for (var i=1; i<=4; i++){
         			var moveIt=(i%2==0)?1:0;
         			sym.getSymbol("overview").getSymbol("groupStage").$("group"+(i)).animate({'height':'115px','top':19+(moveIt*140)},500, 'easeInQuad');
         			$("#gt"+groupArray[i-1]).css({'display':'none'});
         		}
         		sym.getSymbol("overview").$("groupStage").animate({'height':'415px'},500);	
         		sym.getSymbol("overview").$("knockout").on('click',showStages);
         		sym.getSymbol("overview").$("groupStage").off('click');
         		sym.getSymbol("overview").$("knockout").css({'cursor':'pointer'});
         		sym.getSymbol("overview").$("groupStage").css({'cursor':'auto'});
         		sym.getSymbol("overview").playReverse();
         		showstage=0;
         	}
         }
         if(todayTime<startR2){
         	sym.getSymbol("overview").$("down").fadeOut(0);
         }else{
         	showStages();
         }
         var showMatch = function(match,home,away){ //to handle lexical scope
         	return function (e) {
         		resetmenu();
         		clearInterval(matchInterval);
         		matchInterval = setInterval(function() { getMatchInfo(match); }, 60000);
         		getMatchInfo(match);
         		sym.getSymbol("matchtracker").$("matchSquadh").empty();
         		sym.getSymbol("matchtracker").$("matchSquada").empty();
         		getSquad(home,"home");
         		getSquad(away,"away");
         		sym.getSymbol("matchtracker").$("txt16").html(txtArr[17]);
         		sym.getSymbol("matchtracker").$("txt17").html(txtArr[17]);
         		sym.getSymbol("matchtracker").$("txt18").html(txtArr[16]);
         		sym.getSymbol("matchtracker").$("txt19").html(txtArr[16]);
         		for(var i=0; i<countryArr.length; i++){
         			if(home==countryId[i]){
         				sym.getSymbol("matchtracker").$("rank1Txt").html(rankArr[i]);
         				sym.getSymbol("matchtracker").$("qual1Txt").html(txtArr[18]+"<br/><b>"+qualArr[i]+"</b>");
         				sym.getSymbol("matchtracker").$("record1Txt").html(txtArr[19]+"<br/>"+recordArr[i]);
         			}
         			if(away==countryId[i]){
         				sym.getSymbol("matchtracker").$("rank2Txt").html(rankArr[i]);
         				sym.getSymbol("matchtracker").$("qual2Txt").html(txtArr[18]+"<br/><b>"+qualArr[i]+"</b>");
         				sym.getSymbol("matchtracker").$("record2Txt").html(txtArr[19]+"<br/>"+recordArr[i]);
         			}
         		}
         
         		sym.$("matchtracker").fadeIn(400);
         		sym.$("overview").fadeOut(400);
         		sym.$("latest").fadeOut(400);
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         
         //TOGGLE SHOWMATCHES
         var groupShow;
         var showMatches = function(group){ //to handle lexical scope
         	return function (e) {
         		if(showstage==0){		
         			if(groupShow==group){
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).animate({'height':'115px'},300);
         				$("#gt"+groupArray[group-1]).css({'display':'none'});
         				groupShow="";
         			}else{			
         				for (var i=1;i<=4;i++){
         					if (group==i){
         						$("#gt"+groupArray[group-1]).css({'display':'block'});
         						sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).animate({'height':'350px'},300);
         					}else{
         						sym.getSymbol("overview").getSymbol("groupStage").$("group"+i).animate({'height':'115px'},300);
         						$("#gt"+groupArray[i-1]).css({'display':'none'});
         					}
         				}
         				groupShow=group;
         			}
         		}
         		e.preventDefault();
         	};
         };
         var countryId=[668,303,701,222,313,241,453,763,151,305,362,259,609,567,486,324,230,17,15199,604,55,380,91,514];//ordered alphabetically (English)
         var venueID=[1102,10839,2816,10645,3477,2808]//Barcelona,Bilbao,Granada,Las Palmas,Madrid,Seville
         //AJAX gets data from xml source  --------------------------------------------
         $.ajax({	
         	type: "GET",
         	url: "GN"+gn+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		var headline=$(xml).find('headline').text();
         		headlinetext.html(headline);
         		var source=$(xml).find('source').text();
         		sourcetxt.html(source);
         		dateFormat=$(xml).find('dateformat').text();
         		for (var m=0;m<2;m++){
         			menuTxtArr[m]= $(xml).find('menuTxt'+m).text();
         		}
         		for  (var i=0;i<33;i++){
         			txtArr[i]= $(xml).find('txt'+i).text(); //fixed text captions
         			if(i<text.length){
         				text[i].html(txtArr[i]);
         			}
         		}
         		for (var t=0;t<24;t++){		//get details for each team
         				$(xml).find("team"+t).each(function(){
         					var $teams = $(this);
         					countryArr[t]=$teams.find('country').text();
         					recordArr[t]=$teams.find('record').text();
         					qualArr[t]=$teams.find('qualifier').text();	
         					rankArr[t]=$teams.find('rank').text();			
         				});
         			}	
         		sym.getSymbol("overview").getSymbol("knockout").$("txt15").html(txtArr[10]);
         		sym.getSymbol("overview").getSymbol("knockout").$("txt16").html(txtArr[11]);
         		sym.getSymbol("overview").getSymbol("knockout").$("txt17").html(txtArr[12]);
         		sym.getSymbol("matchtracker").$("txt16").html(txtArr[17]);
         		sym.getSymbol("matchtracker").$("txt17").html(txtArr[17]);
         		sym.getSymbol("latest").$("txt0").html(menuTxtArr[0]);
         		var tableHeadCaps = $(xml).find('table0').text();
               tableCaps=tableHeadCaps.split(";");
               var tableHead = "<table style='width:60%; position:left; margin-left:40%; font-family:pragmatica-web, sans-serif; font-weight:700; border:none; border-collapse:collapse; font-size:12px'>";
         		tableHead += "<tr><td width='13%'><center id='tp'></center></td><td width='13%'><center id='tw'></center></td><td width='13%'><center id='td'></center></td><td width='13%'><center id='tl'></center></td><td width='14%'><center id='tf'></center></td><td width='14%'><center id='ta'></center></td><td width='20%'><center id='tpts'></td></tr>";
         		tableHead += "</table>";
               sym.getSymbol("overview").$("tableHead").append(tableHead);
               $("#tw").text(tableCaps[0]);
               $("#td").text(tableCaps[1]);
               $("#tl").text(tableCaps[2]);
               $("#tf").text(tableCaps[3]);
               $("#ta").text(tableCaps[4]);
               $("#tpts").text(tableCaps[5]);
               var tooltipCaps = $(xml).find('table1').text();
         		sym.getSymbol("overview").$("tooltip0").html(tooltipCaps);
         		sym.getSymbol("overview").$("tooltip0").css({'background-color':'rgb(255,235,165)','border':'solid 1px rgb(0,0,0)','border-radius':'2px','display':'none'});
               var venArr = $(xml).find('venues').text();
                  venues=venArr.split(";");
               var monthsArr = $(xml).find('months').text();
                  months=monthsArr.split(";");
               var keyArr = $(xml).find('key').text();
                  key=keyArr.split(";");
               var timeArr = $(xml).find('time').text();
                  timetxt=timeArr.split(";");
               var winArr = $(xml).find('winner').text();
                  winner=winArr.split(";");
               sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]); 
         	}
         });
         sym.getSymbol("overview").$("tipBtn0").on('click',showTip);
         var showtip=0;
         function showTip(){
         	if (showtip==0){
         		sym.getSymbol("overview").$("tooltip0").fadeIn(0);
         		showtip=1;
         	}else{
         		sym.getSymbol("overview").$("tooltip0").fadeOut(0);
         		showtip=0	
         	}
         }
         // MENU BUTTONS --------------------------------------------	
                  menuArray = []; //the array that will hold references to the buttons.
                  for (var m = 0; m < 2; m++){
                  		var menuBtnSymbols = sym.getSymbol("menuBtns").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
                  		menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
                  		menuArray.push(menuBtnSymbols); //push it into the array
                  	}
                  $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
                  		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
                  		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
                  		menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("touchstart click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("mouseover", {menuId:count}, menuShow);
                  		menuBtnElement.on ("mouseout", {menuId:count}, menuHide);
                  		menuBtnElement.css({"cursor":"pointer"});
                  })
                  function resetmenu(){
                  		for (var m=0; m<menuArray.length; m++){	
                           menuArray[m].$("menuBg").fadeOut(0);
                  		}
                  		menuTxt.fadeOut(0);
                  }
                  resetmenu();
                  function menuBtnClick (e){
                  		e.preventDefault();
                  		e.stopPropagation();
                  		resetmenu(); //set them all back to normal state
                  		clearInterval(matchInterval);
                  		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         					for (var i=0;i<3;i++){
         						if (menuMenu_id==i){
         							sym.$(screenArr[i]).fadeIn(400);
         							sym.getSymbol("menuBtns").getSymbol("menuBtn" + i).$("menuBg").fadeIn(0);
         							menuTxt.html(menuTxtArr[i]);
         							menuTxt.fadeIn(0);
         						}else{
         							sym.$(screenArr[i]).fadeOut(400);
         						}						 
         					}
                  }
                  function menuShow (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the over button
                  		//sym.$('handMc').hide();
                  		menuTxt.html(menuTxtArr[menuMenu_id]);
         					menuTxt.fadeIn(0);
                  }
                  function menuHide (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the out button
                  		menuTxt.fadeOut(0);
                  }
         sym.getSymbol("menuBtns").getSymbol("menuBtn0").$("menuBg").fadeIn(0);
         
         sym.getSymbol("latest").$("timezone").on("click",function(){ 
         		if(showLocal==0){ showLocal=1; getFixtures(); }else{ showLocal=0;getFixtures(); } sym.getSymbol("latest").$("timezoneTxt").html(timetxt[showLocal]); });
         sym.getSymbol("latest").$("timezone").on("mouseover",function(){ 
         	if (showLocal==0){  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[1]);  }else{  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]);  }});
         sym.getSymbol("latest").$("timezone").on("mouseout",function(){ 
         	if (showLocal==0){  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]);  }else{  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[1]);  }});
         sym.getSymbol("latest").$("timezone").css({'cursor':'pointer'});	
         //DATE FUNCTIONS --------------------------------------------
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     //var thisDate = new Date(parseInt(dateTxt, 10));
                     var thisDate = new Date(parseInt((dateTxt), 10)+localOffset);
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var matchDate=thisDate.getTime() +localOffset;
         	var matchTime=new Date(matchDate);
         	var mm = matchTime.getMonth();
         	var dd = matchTime.getDate();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         } 
         function getDateLocal(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         }
         function getMatchTime(thisDateStr,braziltime){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var thisTime = thisDate.getTime()+localOffset-braziltime;//localOffset to UTC - offset to venue
         	var matchTime = new Date(thisTime);
         	var hh = matchTime.getHours();
         	var mm = parseInt(matchTime.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         function getMatchLocal(thisDateStr){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var hh = thisDate.getHours();
         	var mm = parseInt(thisDate.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	//var dDate = parseInt(matchRndDate,10);
         	var dDate = parseInt(matchRndDate,10)+localOffset;
         	return dDate;
         } 
         
         //LIVE DATA --------------------------------------
         var firstGroup=74362;var lastGroup=74365;//basketball id numbers back to front!
         function getDetails(groupIndex) {
                  	var group = groupIndex - 1;
                  	//var id = firstGroup + group;
                  	var id=lastGroup-group;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gn+"&yr="+gnYear+"&sport=basketball&phaseID=" + id,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		error: function () {
                  			console.log("Error retrieving Group[" + groupIndex + "]");
                  		},
                  		success: function (groupDetails) {
                  			loadDetails(groupDetails, group);
                  		}
                  	});
         }
         function loadDetails(groupDetails, group) {
         	var imgHTML;
         	for (var i = 0; i < 6; i++) {
         		for(var c=0;c<24;c++){
         			if (groupDetails[i].n_TeamID==countryId[c]){
         				var countryName=countryArr[c];
         			}
               }
         		$('#t' + group + 'n' + i).text(countryName);
         		$('#t' + group + 'p' + i).text(groupDetails[i].n_Matches);
         		$('#t' + group + 'w' + i).text(groupDetails[i].n_MatchesWon);
         		$('#t' + group + 'd' + i).text(groupDetails[i].n_MatchesDrawn);
         		$('#t' + group + 'l' + i).text(groupDetails[i].n_MatchesLost);
         		$('#t' + group + 'f' + i).text(groupDetails[i].n_Points2For);
         		$('#t' + group + 'a' + i).text(groupDetails[i].n_Points2Against);
         		$('#t' + group + 'pts' + i).text(groupDetails[i].c_Points);
         		imgHTML='<img src="flags/'+(groupDetails[i].c_TeamNatioShort) +'.png" height="12px" width="22px">';
         		$('#t' + group + 'flag' + i).html(imgHTML);
         	}
         } 
         var resultsData;
         function getGroupResults() {
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&sport=basketball&editionID=74374",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			resultsData = data;
         			for (var group = 1; group <= 4; group++) {
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).empty();
         //				var tableTxt= "<div id='gt" + group + "' style='display:none; position:absolute; bottom:3px; width:100%'></div>";  
         				var tableTxt= "<div id='gt" + groupArray[group-1] + "' style='display:none; position:absolute; bottom:3px; width:100%'></div>";  
         				tableTxt += "<div id='grptable"+group+"'>";
         				tableTxt += "<table style='width:100%; position:absolute; background-color:rgb(215,230,245); font-family:pragmatica-web, sans-serif; border:none; border-collapse:collapse; font-size:12px'>";
         				tableTxt += "<tr class='qual'><td width='7%' id='t" + (group - 1) + "flag0'></td><td width='38%' ><span id='t" + (group - 1) + "n0'></td><td width='7%'><center id='t" + (group - 1) + "w0'></center></td><td width='7%'><center id='t" + (group - 1) + "d0'></center></td><td width='7%'><center id='t" + (group - 1) + "l0'></center></td><td width='8%'><center id='t" + (group - 1) + "f0'></center></td><td width='8%'><center id='t" + (group - 1) + "a0'></center></td><td width='11%'><center id='t" + (group - 1) + "pts0'></td></tr>";
         				tableTxt +="<tr class='qual'><td id='t" + (group - 1) + "flag1'></td><td><span id='t" + (group - 1) + "n1'></td><td><center id='t" + (group - 1) + "w1'></center></td><td><center id='t" + (group - 1) + "d1'></center></td><td><center id='t" + (group - 1) + "l1'></center></td><td><center id='t" + (group - 1) + "f1'></center></td><td><center id='t" + (group - 1) + "a1'></center></td><td><center id='t" + (group - 1) + "pts1'></td></tr>";
         				tableTxt += "<tr class='qual'><td id='t" + (group - 1) + "flag2'></td><td><span id='t" + (group - 1) + "n2'></td><td><center id='t" + (group - 1) + "w2'></center></td><td><center id='t" + (group - 1) + "d2'></center></td><td><center id='t" + (group - 1) + "l2'></center></td><td><center id='t" + (group - 1) + "f2'></center></td><td><center id='t" + (group - 1) + "a2'></center></td><td><center id='t" + (group - 1) + "pts2'></td></tr>";
         				tableTxt += "<tr class='qual'><td id='t" + (group - 1) + "flag3'></td><td><span id='t" + (group - 1) + "n3'></td><td><center id='t" + (group - 1) + "w3'></center></td><td><center id='t" + (group - 1) + "d3'></center></td><td><center id='t" + (group - 1) + "l3'></center></td><td><center id='t" + (group - 1) + "f3'></center></td><td><center id='t" + (group - 1) + "a3'></center></td><td><center id='t" + (group - 1) + "pts3'></td></tr>";
         				tableTxt += "<tr><td id='t" + (group - 1) + "flag4'></td><td><span id='t" + (group - 1) + "n4'></td><td><center id='t" + (group - 1) + "w4'></center></td><td><center id='t" + (group - 1) + "d4'></center></td><td><center id='t" + (group - 1) + "l4'></center></td><td><center id='t" + (group - 1) + "f4'></center></td><td><center id='t" + (group - 1) + "a4'></center></td><td><center id='t" + (group - 1) + "pts4'></td></tr>";
         				tableTxt += "<tr><td id='t" + (group - 1) + "flag5'></td><td><span id='t" + (group - 1) + "n5'></td><td><center id='t" + (group - 1) + "w5'></center></td><td><center id='t" + (group - 1) + "d5'></center></td><td><center id='t" + (group - 1) + "l5'></center></td><td><center id='t" + (group - 1) + "f5'></center></td><td><center id='t" + (group - 1) + "a5'></center></td><td><center id='t" + (group - 1) + "pts5'></td></tr></table>";
         				tableTxt += "<table style='position:absolute; top:0px; width:165px; background-color:rgb(215,230,245); border:none; border-collapse:collapse; font-family:pragmatica-web, sans-serif; font-size:12px'>";
         				tableTxt += "</div>";			
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).append(tableTxt);
         				getDetails(group);
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).on('click', showMatches(group));
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).css({'cursor':'pointer'});
         			} 
         			$(".qual").css({'background-color':'rgb(235,240,250)'});
         		}
         	});
         }
         var fixtureData;   
         function getFixtures() { 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&sport=basketball&editionID=74374",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			fixtureData = data;
         			$("#gt1").empty();
         			$("#gt2").empty();
         			$("#gt3").empty();
         			$("#gt4").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-1").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-2").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-3").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-4").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-5").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-6").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-7").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-8").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf1").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf2").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf3").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf4").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("sf1").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("sf2").empty();	
         			sym.getSymbol("overview").getSymbol("knockout").$("ru").empty();	
         			sym.getSymbol("overview").getSymbol("knockout").$("final").empty();
         			sym.getSymbol("latest").$('table').empty();
         			for (var i = 0; i < fixtureData.length; i++) {
         				var matchesRnd = parsedDate(fixtureData[i].d_DateUTC);
         				var matchDay = fixtureData[i].n_PhaseID;
         				var phaseLevel = fixtureData[i].n_PhaseLevel;
         				var matchNo = fixtureData[i].n_MatchNr;
         				var countryHome;var countryAway;
         				var string1=fixtureData[i].c_Team1;
         				var string2=fixtureData[i].c_Team2;
         				var winArr=["Winner","Loser"];
         				countryHome=string1.replace(winArr[0],winner[0]);
         				countryHome=countryHome.replace(winArr[1],winner[1]);
         				countryAway=string2.replace(winArr[0],winner[0]);
         				countryAway=countryAway.replace(winArr[1],winner[1]);
         				for(var c=0;c<24;c++){
         					if (fixtureData[i].n_Team1ID==countryId[c]){
         							countryHome=countryArr[c];
         					}
         					if (fixtureData[i].n_Team2ID==countryId[c]){
         							countryAway=countryArr[c];
         					}
         				}
         				//n_CityGeoID
         				for (var v=0; v<venueID.length; v++){
         					if(fixtureData[i].n_CityGeoID==venueID[v]){
         						var city=venues[v];
         					}
         				}
         
         			//SHOW LATEST MATCHES
         				if((todayTime<startWC&&matchesRnd<=startWC+oneDay)||(matchesRnd>todayTime-(oneDay*0.5)&&matchesRnd<todayTime+(oneDay*2))||todayTime>endWC&&matchesRnd>endWC-(oneDay*2)){
         					var fixtureTxt="<div class='fixDiv' id='matchf"+i+"'>";
         					fixtureTxt+="<table><tr>";
         					fixtureTxt += "<td class='crestf' style='crest' id='homecrestf" + i + "'></td>";
         					fixtureTxt += "<td class='teamf' style='padding-left:3px' id='homef" + i + "'></td>";
         					fixtureTxt += "<td style='width:40%;text-align:center' id='scoref" + i + "'></td>";
         					fixtureTxt += "<td class='teamf away' style='text-align:right' id ='awayf" + i + "'></td>";
         					fixtureTxt += "<td class='crestf away' id='awaycrestf" + i + "'></td>";
         					fixtureTxt += "</tr></table>";
         					fixtureTxt +="</div>";
                  	} //closes if parsedate	
                  	sym.getSymbol("latest").$('table').append(fixtureTxt);
         				var tableTxt = "<table class='grpmatch' id='match"+i+"'><tr>";
         				tableTxt +="<td class='flag' id='flagh" + i + "'></td>";
         				tableTxt +="<td class='grpteamh' id='teamh" + i + "'></td>";
         				tableTxt +="<td class='grpscore' id ='score" + i + "'></td>";
         				tableTxt +="<td class='grpteama' id='teama" + i + "' ></td>";
         				tableTxt +="<td class='flag' id='flaga" + i + "' ></td>";
         				tableTxt +="<td id='result" + i + "' ></td></tr></table>";
         
         				var overviewTxt = "<table class='match' id='match"+i+"'>";
         				overviewTxt += "<tr>";
         				overviewTxt += "<td class='flag' id='flagh"+i+"'></td>";
         				overviewTxt += "<td class='team' id='hometeam"+i+"'></td>";
         				overviewTxt += "<td id='scoreh"+i+"'></td>";
         				overviewTxt += "<td id='penh"+i+"'></td>";
         				overviewTxt += "</tr>";
         				overviewTxt += "<tr>";
         				overviewTxt += "<td class='flag' id='flaga"+i+"'></td>";
         				overviewTxt += "<td class='team' id='awayteam"+i+"'></td>";
         				overviewTxt += "<td id='scorea"+i+"'></td>";
         				overviewTxt += "<td id='pena"+i+"'></td>";
         				overviewTxt += "</tr>";
         				overviewTxt += "</table>";				
         				var groupPhase=[];
         				for (var p=0;p<4;p++){
         					groupPhase[p]=firstGroup+p;
         					if(fixtureData[i].n_PhaseID==groupPhase[p]){
         						var groupOv="<div class='gstage'>"+tableTxt+"</div>";
         						$('#gt'+(p+1)).append(groupOv);
         					}
         				}
         				var r16match=[];
         				if (phaseLevel==9){//Round of 16
         					for (var r=0;r<8;r++){
         						r16match[r]=61+r;
         						if(matchNo==r16match[r]){
         							var r16Ov="<div class='kstage'>"+overviewTxt+"</div>";
         							sym.getSymbol("overview").getSymbol("knockout").$('r16-'+(r+1)).append(r16Ov);
         						}
         					}
         				}
         
         				var qmatch=[];
         				if (phaseLevel==5){//Quarter-finals
         					for (var q=0;q<4;q++){
         						qmatch[q]=69+q;
         						if(matchNo==qmatch[q]){
         							var qfOv="<div class='kstage'>"+overviewTxt+"</div>";
         							sym.getSymbol("overview").getSymbol("knockout").$('qf'+(q+1)).append(qfOv);
         						}
         					}
         				}
         				var smatch=[];
         				if (phaseLevel==3){//Semi-finals
         					for (var s=0;s<2;s++){
         						smatch[s]=73+s;
         						if(matchNo==smatch[s]){
         							var sfOv="<div class='kstage'>"+overviewTxt+"</div>";
         							sym.getSymbol("overview").getSymbol("knockout").$('sf'+(s+1)).append(sfOv);
         						}
         					}
         				}
         				var finTxt;
         				if (phaseLevel==4){//Third place
         					var ruOv="<div class='kstage'>"+overviewTxt+"</div>";
         					sym.getSymbol("overview").getSymbol("knockout").$('ru').append(ruOv);
         				}
         				if (phaseLevel==2){//Final
         					var finalOv="<div class='kstage'>"+overviewTxt+"</div>";
         					sym.getSymbol("overview").getSymbol("knockout").$('final').append(finalOv);
         				}
         
         				var matchID = fixtureData[i].n_MatchID;
         				var homeTeamID=fixtureData[i].n_Team1ID;
         				var awayTeamID=fixtureData[i].n_Team2ID;
         				var nation1=fixtureData[i].n_Team1NatioGeoID;
         				var nation2=fixtureData[i].n_Team2NatioGeoID
         				var matchDate = getDDmonthYY(fixtureData[i].d_DateUTC);
         				var offsetBrazil = (fixtureData[i].n_CityGeoID==10645)?-3600000:-7200000;
         				if(showLocal==0){
         					var matchTime = getDDmonthYY(fixtureData[i].d_DateUTC)+", "+getMatchTime(fixtureData[i].d_Date,offsetBrazil);
         				}else{
         					var matchTime = getDateLocal(fixtureData[i].d_Date)+", "+getMatchLocal(fixtureData[i].d_Date);
         				}
         				$('.even').css({'background-color':'rgba(215,230,245,0.5)'});
         				$('.fixDiv').css({'font-size':'13px', 'font-family':'pragmatica-web,sans-serif', 'width':'49.2%', 'background-color':'rgb(255,255,255)','float':'left', 'height':'60px','margin':'2px 2px'});
         				$('.fixDiv table').css({'height':'60px','vertical-align':'middle'});
         				$('.teamf').css({'width':'25%','font-weight':700});
         				$(".crestf").css({'width':'5%'});
         				$(".away").css({'text-align':'right'});
         				var crestH = ((fixtureData[i].n_Team1ID)<=0)?'<img src="crests/null.png">':'<img src="crests/'+ fixtureData[i].c_Team1NatioShort +'.png">';
         				var crestA = ((fixtureData[i].n_Team2ID)<=0)?'<img src="crests/null.png">':'<img src="crests/'+ fixtureData[i].c_Team2NatioShort +'.png">';
         				$('#homecrestf' + i).html(crestH);
         				$('#awaycrestf' + i).html(crestA);
         				$(".crestf img").css({'border':'none','width':'30px','height':'30px'});
         				$('.match').css({'margin-left':'2px','cursor':'pointer','height':'32px','font-size':'12px', 'font-family':'pragmatica-web,sans-serif','border-collapse':'collapse', 'width':'100%'});
         				$('.grpmatch').css({'cursor':'pointer','height':'12px','font-size':'12px', 'font-family':'pragmatica-web,sans-serif','border-collapse':'collapse', 'width':'100%'});
         				if(nation1>0||nation2>0){
         					$("#match"+i).on('click',showMatch(matchID,homeTeamID,awayTeamID));
         					$("#matchf"+i).on('click',showMatch(matchID,homeTeamID,awayTeamID));
         				}
         				$("#match"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)','font-weight':700});});
         				$("#match"+i).on('mouseout',function(){ $(this).css({'background-color':'rgba(255,255,255,0)','font-weight':400});});
         				$("#matchf"+i).css({'cursor':'pointer'});
         				$("#matchf"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)'});});
         				$("#matchf"+i).on('mouseout',function(){ 
         						if(this.className=="fixtxt even"){ 
         							$(this).css({'background-color':'rgba(215,230,245,0.5)','font-weight':400});
         						}else{
         							$(this).css({'background-color':'rgba(255,255,255,1.0)','font-weight':400});
         						}
         					});
         				var imgH = ((fixtureData[i].n_Team1ID)<=0)?'<img src="flags/null.png">':'<img src="flags/'+ fixtureData[i].c_Team1NatioShort +'.png">';
         				var imgA = ((fixtureData[i].n_Team2ID)<=0)?'<img src="flags/null.png">':'<img src="flags/'+ fixtureData[i].c_Team2NatioShort +'.png">';
         				$('#flagh' + i).html(imgH);
         				$('#flaga' + i).html(imgA);
         				$(".team").css({'padding-bottom':'1px'});
         				$(".flag").css({'width':'22px','padding':'0 2px 0 2px'});
         				$(".flag img").css({'border':'none','width':'22px','height':'12px'});
         				$('#teamh' + i).text(countryHome);
         				$('#teama' + i).text(countryAway);
         				$('#hometeam' + i).text(countryHome);
         				$('#awayteam' + i).text(countryAway);
         				$('#homef' + i).text(countryHome);
         				$('#awayf' + i).text(countryAway);
         				$('.grpteamh').css({'text-align':'left', 'width':'35%','padding':'0px'});
         				$('.grpteama').css({'text-align':'right', 'width':'35%','padding':'0px'});
         				$('.grpscore').css({'padding':'0px'});
         				var pena=(fixtureData[i].n_Result2Shootout!=null||fixtureData[i].n_Result2Shootout!=undefined)?'<i> ('  + fixtureData[i].n_Result2Shootout + ')</i>':'';    
         				var penh=(fixtureData[i].n_Result1Shootout!=null||fixtureData[i].n_Result1Shootout!=undefined)?'<i> (' + fixtureData[i].n_Result1Shootout + ')</i>':'';               
         				$('#penh' + i).html(penh);
         				$('#pena' + i).html(pena);
         				var scoreH = (fixtureData[i].n_Result1!=null||fixtureData[i].n_Result1!=undefined)?'<b>' + (fixtureData[i].n_Result1)+ '</b>':'';
         				$('#scoreh' + i).html(scoreH);
         				var scoreA = (fixtureData[i].n_Result2!=null||fixtureData[i].n_Result2!=undefined)?'<b>' + (fixtureData[i].n_Result2)+ '</b>':'';
         				$('#scorea' + i).html(scoreA);
         				var score =(fixtureData[i].n_Result1!=null||fixtureData[i].n_Result1!=undefined)?'<b>' + (fixtureData[i].n_Result1)+ '-' + (fixtureData[i].n_Result2)+'</b>':'<i>'+matchDate+'</i>';
         				var scoref =(fixtureData[i].n_Result1!=null||fixtureData[i].n_Result1!=undefined)?'<b>' + (fixtureData[i].n_Result1)+ '-' + (fixtureData[i].n_Result2)+'</b>':'<i>'+matchTime+'</i>'+"<br/><i>"+city+"</i>";
         				$('#score' + i).html(score);
         				$('#scoref' + i).html(scoref);
         				var matchNo= fixtureData[i].n_MatchNr;
         				matchResult=(fixtureData[i].n_MatchStatusCode>4)&&(fixtureData[i].n_MatchStatusCode<128)?'<img src="images/ball.png" height="13px" width="13px">':'';
         				$('#result'+i).html(matchResult);
         				if (phaseLevel<=9){
         					sym.getSymbol("overview").getSymbol("knockout").$("dateTxt"+matchNo).text(matchDate);
         				}
         				if (showstage==0){
         					$(".kstage").fadeOut(0); 
         				}
         			} //close for                                 
         		} //close success                                                    	           
         	}); //close ajax
          }//close function
         getGroupResults();
         setTimeout(getFixtures,1000);
         if(todayTime>startWC-(oneDay*3)&&todayTime<endWC+(oneDay*3)){
         groupInterval = setInterval(getGroupResults,600000);
         fixtureInterval = setInterval(getFixtures,120000);
         }
         // LIVE MATCH 			
         function getMatchInfo(matchID){
         	var infoData;
         	sym.getSymbol("matchtracker").$("penaltiesTxt").fadeOut(0);
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&match="+matchID+"&sport=basketball&q=info",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			infoData = data;
         			var matchteam1;
         			var matchteam2;
         				var string1=infoData[0].c_Team1;
         				var string2=infoData[0].c_Team2;
         				var winArr=["Winner","Loser"];
         				matchteam1=string1.replace(winArr[0],winner[0]);
         				matchteam1=matchteam1.replace(winArr[1],winner[1]);
         				matchteam2=string2.replace(winArr[0],winner[0]);
         				matchteam2=matchteam2.replace(winArr[1],winner[1]);
         			for(var c=0;c<24;c++){
         					if (infoData[0].n_Team1ID==countryId[c]){
         							matchteam1=countryArr[c];
         					}
         					if (infoData[0].n_Team2ID==countryId[c]){
         							matchteam2=countryArr[c];
         					}
         				}
         			var score1;
         			var score2;
         			if(infoData[0].b_Started==false){
         				score1="0";
         				score2="0";
         			}else{
         				score1=infoData[0].n_Result1;
         				score2=infoData[0].n_Result2;
         			}
         			for (var v=0; v<venueID.length; v++){
         				if(infoData[0].n_CityGeoID==venueID[v]){
         					var city=venues[v];
         				}
         			}
         			var offsetBrazil = (fixtureData[i].n_CityGeoID==10645)?-3600000:-7200000;
         			if(infoData[0].b_Finished==true){
         				clearInterval(teamInterval);
         				var matchTime = getDDmonthYY(infoData[0].d_DateUTC);
         			}else{
         				if(showLocal==0){
         					var matchTime = getMatchTime(infoData[0].d_Date,offsetBrazil)+" "+getDDmonthYY(infoData[0].d_DateUTC);
         				}else{
         					var matchTime = getMatchLocal(infoData[0].d_Date)+" "+getDateLocal(infoData[0].d_Date);
         				}				
         			}
         			var matchscore = score1 + "-" + score2;
         			var imgH = "crests/"+ infoData[0].c_Team1NatioShort + ".png";
         			var imgA = "crests/"+ infoData[0].c_Team2NatioShort + ".png";
         			var matchDate = getDDmonthYY(infoData[0].d_DateUTC);
         			var matchInfo = infoData[0].c_Stadium + ", " + city + "<br />" + matchTime + ", 2014" ;
         			sym.getSymbol("matchtracker").$("matchcrest1").attr("src",imgH);				
         			sym.getSymbol("matchtracker").$("matchcrest2").attr("src",imgA);				
         			sym.getSymbol("matchtracker").$("matchteam1Txt").text(matchteam1);
         			sym.getSymbol("matchtracker").$("matchteam2Txt").text(matchteam2);
         			sym.getSymbol("matchtracker").$("matchscoreTxt").text(matchscore);
         			sym.getSymbol("matchtracker").$("matchinfoTxt").html(matchInfo);
         			// SHOOTOUT ONLY
         				if (infoData[0].n_Result1Shootout!=null&&(infoData[0].n_Result1Shootout>=0||infoData[0].n_Result2Shootout>=0)){
         						console.log(infoData[0].n_Result1Shootout+" "+infoData[0].n_Result2Shootout);
         						var pensH=(infoData[0].n_Result1Shootout>=0)?infoData[0].n_Result1Shootout:"";
         						var pensA=(infoData[0].n_Result2Shootout>=0)?infoData[0].n_Result2Shootout:"";
         						var penalties= txtArr[20]+" (" +pensH+ "-" +pensA+ ")";
         						sym.getSymbol("matchtracker").$("penaltiesTxt").html(penalties);
         						sym.getSymbol("matchtracker").$("penaltiesTxt").fadeIn(0);
         					}              							
         		}
         	});
         }
         
         function getSquad(team,homeOrAway){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&sport=basketball&squad="+team,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			squadData=data;
         			if(squadData.length>0){		
         				var hORa=(homeOrAway=="home")?"h":"a";
         				for (var i = 0; i <squadData.length; i++) {
         					var shirtNr = (squadData[i].c_ShirtNr!=null)?squadData[i].c_ShirtNr:"";
         					var player = squadData[i].c_Person;
         					var squadlist = "<div id='"+hORa+"player"+i+"'>";
         					squadlist += "<div class='squadCol1' id='"+hORa+"sqdshirt"+i+"'></div>";
         					squadlist += "<div class='squadCol2' id='"+hORa+"sqdplayerName"+i+"'></div>";
         					squadlist += "</div>";
         					sym.getSymbol("matchtracker").$("matchSquad"+hORa).append(squadlist);  
         					$('#'+hORa+'player'+i).css({'width':'100%','font-size':'13px','font-family':'pragmatica-web, sans-serif', 'display':'inline-table'});
         					$('.squadCol1').css({'width':'10%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell','font-weight':700});
         					$('.squadCol2').css({'width':'90%', 'color':'rgb(255,255,255)','padding-left':'3%','display':'table-cell'});
         					$('#'+hORa+'sqdplayerName'+i).css({'font-weight':400});
         					$('#'+hORa+'sqdshirt'+i).text(shirtNr);
         					$('#'+hORa+'sqdplayerName'+i).text(player);
         				}
         			}else{
         				sym.getSymbol("matchtracker").$("matchSquadh").html("<span class='white'>"+txtArr[21]+"</span>");
         				sym.getSymbol("matchtracker").$("matchSquada").html("<span class='white'>"+txtArr[21]+"</span>");
         				$(".white").css({'color':'rgb(255,255,255)','padding':'3px','font-size':'13px','font-family':'pragmatica-web, sans-serif'});
         			}
         		}
         	});
         }
         
         
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'Match'
   (function(symbolName) {   
   
   })("Match");
   //Edge symbol end:'Match'

   //=========================================================
   
   //Edge symbol: 'Overview'
   (function(symbolName) {   
   
   })("Overview");
   //Edge symbol end:'Overview'

   //=========================================================
   
   //Edge symbol: 'Knockout'
   (function(symbolName) {   
   
   })("Knockout");
   //Edge symbol end:'Knockout'

   //=========================================================
   
   //Edge symbol: 'GroupStage'
   (function(symbolName) {   
   
   })("GroupStage");
   //Edge symbol end:'GroupStage'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtns'
   (function(symbolName) {   
   
   })("MenuBtns");
   //Edge symbol end:'MenuBtns'

   //=========================================================
   
   //Edge symbol: 'Latest'
   (function(symbolName) {   
   
   })("Latest");
   //Edge symbol end:'Latest'

   //=========================================================
   
   //Edge symbol: 'TableHead'
   (function(symbolName) {   
   
   })("TableHead");
   //Edge symbol end:'TableHead'

   //=========================================================
   
   //Edge symbol: 'BarGraph'
   (function(symbolName) {   
   
   })("BarGraph");
   //Edge symbol end:'BarGraph'

   //=========================================================
   
   //Edge symbol: 'MatchStats'
   (function(symbolName) {   
   
   })("MatchStats");
   //Edge symbol end:'MatchStats'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(jQuery, AdobeEdge, "GraphicNews32094");