/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "${_Stage}", "scroll", function(sym, e) {
         var myCalc = e.currentTarget.scrollTop/(e.currentTarget.scrollHeight-e.currentTarget.clientHeight);
         var pos = Math.round( myCalc * sym.getDuration() );
         sym.stop(pos);

      });
      //Edge binding end

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         	
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none",});
         	txt[1] = sym.getSymbol("mapMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("mapMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("mapMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("mapMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("mapMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("mapMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("mapMc").$("txt7").css({"pointer-events":"none", "background-color":"rgba(251,174,23,1)", "border-radius":"5px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"});
         	txt[8] = sym.getSymbol("mapMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("mapMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("mapMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("mapMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("mapMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("mapMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("launcherMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("launcherMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("siteBigTxtMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("siteBigTxtMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("siteBigTxtMc").$("txt18").css({"pointer-events":"none", "background-color":"rgba(251,174,23,1)", "border-radius":"5px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"});
         	txt[19] = sym.getSymbol("siteBigTxtMc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("siteBigTxtMc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("siteBigTxtMc").$("txt21").css({"pointer-events":"none", "background-color":"rgba(251,174,23,1)", "border-radius":"5px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"});
         	txt[22] = sym.getSymbol("siteBigTxtMc").$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.getSymbol("siteBigTxtMc").$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol("siteBigTxtMc").$("txt25").css({"pointer-events":"none", "background-color":"rgba(251,174,23,1)", "border-radius":"5px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"});
         	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32069.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			for (var i=0; i<31; i++){
         			txtArr[i]=$(xml).find('txt'+i).text();
         			txt[i].html(txtArr[i]);
         			}
         		}
         	}); // END XML

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos >= 10) {
         	sym.$("downBtn").fadeOut(200);
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'launcherMc'
   (function(symbolName) {   
   
   })("launcherMc");
   //Edge symbol end:'launcherMc'

   //=========================================================
   
   //Edge symbol: 'siteBigTxtMc'
   (function(symbolName) {   
   
   })("siteBigTxtMc");
   //Edge symbol end:'siteBigTxtMc'

})(jQuery, AdobeEdge, "GNews32069");