/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var xmlNo = "GN31883.xml";
	var stgMove = 0;
	var gpNo = 10;
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.getSymbol("panelsMc").getSymbol("panel0").$("txt0").css({"pointer-events":"none",});
	txt[1] = sym.getSymbol("panelsMc").getSymbol("panel0").$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.getSymbol("panelsMc").getSymbol("panel1").$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.getSymbol("panelsMc").getSymbol("panel1").$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.getSymbol("panelsMc").getSymbol("panel2").$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.getSymbol("panelsMc").getSymbol("panel3").$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.getSymbol("panelsMc").getSymbol("panel3").$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.getSymbol("panelsMc").getSymbol("panel3").$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("panelsMc").getSymbol("panel4").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.getSymbol("panelsMc").getSymbol("panel4").$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.getSymbol("panelsMc").getSymbol("panel4").$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.getSymbol("panelsMc").getSymbol("panel4").$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.getSymbol("panelsMc").getSymbol("panel5").$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.getSymbol("panelsMc").getSymbol("panel5").$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.getSymbol("panelsMc").getSymbol("panel6").$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.getSymbol("panelsMc").getSymbol("panel6").$("txt15").css({"pointer-events":"none"});
	txt[16] = sym.getSymbol("panelsMc").getSymbol("panel7").$("txt16").css({"pointer-events":"none"});
	txt[17] = sym.getSymbol("panelsMc").getSymbol("panel7").$("txt17").css({"pointer-events":"none"});
	txt[18] = sym.getSymbol("panelsMc").getSymbol("panel7").$("txt18").css({"pointer-events":"none"});
	txt[19] = sym.getSymbol("panelsMc").getSymbol("panel7").$("txt19").css({"pointer-events":"none"});
	txt[20] = sym.getSymbol("panelsMc").getSymbol("panel7").$("txt20").css({"pointer-events":"none"});
	txt[21] = sym.getSymbol("panelsMc").getSymbol("panel7").$("txt21").css({"pointer-events":"none"});
	txt[22] = sym.getSymbol("panelsMc").getSymbol("panel7").$("txt22").css({"pointer-events":"none"});
	txt[23] = sym.getSymbol("panelsMc").getSymbol("panel7").$("txt23").css({"pointer-events":"none"});
	txt[24] = sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn7").$("txt").css({"pointer-events":"none"});
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: xmlNo,
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			//create array from xml, put it into array of text elements
			for (var i=0; i<25; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			}
	
			sym.getSymbol("panelsMc").getSymbol("panel3").$("txt5").animate({top:265 - sym.getSymbol("panelsMc").getSymbol("panel3").$("txt5").height()+14});
			sym.getSymbol("panelsMc").getSymbol("panel4").$("txt9").animate({top:275 - sym.getSymbol("panelsMc").getSymbol("panel4").$("txt9").height()+4});
			sym.getSymbol("panelsMc").getSymbol("panel4").$("txt10").animate({top:265 - sym.getSymbol("panelsMc").getSymbol("panel4").$("txt10").height()+14});
			sym.getSymbol("panelsMc").getSymbol("panel5").$("txt13").animate({top:275 - sym.getSymbol("panelsMc").getSymbol("panel5").$("txt13").height()+4});
	
		}
	}); // END XML
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.
	
	for (var h = 0; h < 8; h++){
		var menuBtnSymbols = sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}
	
	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.bind ("click", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("touchstart", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
	})
	
	function resetmenu(){
		for (var h=0; h<menuArray.length; h++){
         menuArray[h].$("btnClick").fadeOut(0);
         menuArray[h].$("btnOver").fadeOut(0);
         menuArray[h].$("txt").css("color","rgba(0,0,0,1)");
         sym.getSymbol("panelsMc").getSymbol("panel"+h).$("fade").stop().animate ({opacity:0.7}, 200);
		}
	}
	resetmenu();

	function menuBtnClick (e){
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		stgMove = menuMenu_id;
		panelSwap()
	}

	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeIn(0);
		btnNo = menuMenu_id;
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
		sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeOut(0);
	}

// MAKE MENU 0 VISIBLE
	sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn0").$("btnClick").fadeIn(0);
	sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn0").$("txt").css("color","rgba(254,255,255,1)");

var dateArray = ["1930-50","1954-66","1970","1974-86","1990-98","2002","2006-14"];
for (var i=0;i<dateArray.length;i++){ sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn"+i).$("txt").html(dateArray[i]); }


// NAV BUTTONS
sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("nextBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	stgMove++;
	panelSwap();
	});
sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("nextBtn").mouseover(function(){
	sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("nextBtn").$("btnOut").fadeOut(0);
	});
sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("nextBtn").mouseout(function(){
	sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("nextBtn").$("btnOut").fadeIn(0);
	});

sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("backBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	stgMove--;
	panelSwap();
	});
sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("backBtn").mouseover(function(){
	sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("backBtn").$("btnOut").fadeOut(0);
	});
sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("backBtn").mouseout(function(){
	sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("backBtn").$("btnOut").fadeIn(0);
	});

function panelSwap() {
		sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("nextBtn").fadeIn(0);
		sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("backBtn").fadeIn(0);
		if (stgMove <= 0){
			sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("backBtn").fadeOut(0);
		}
		if (stgMove >= 7){
			sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").$("nextBtn").fadeOut(0);
		}
		resetmenu(); //set them all back to normal state
		sym.getSymbol("panelsMc").getSymbol("panel"+stgMove).$("fade").stop().animate ({opacity:0}, 200);
		sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn" + stgMove).$("btnClick").fadeIn(0);
		sym.getSymbol("menuBtnsMc").getSymbol("btnSlideMc").getSymbol("menuBtn" + stgMove).$("txt").css("color","rgba(254,255,255,1)");
		for (var k=0;k<stgMove; k++){
			sym.getSymbol("panelsMc").$("panel"+k).stop().delay(stgMove+(k*5)).animate ({opacity:0, top:0+(10*(k-stgMove)), left:0+(30*(k-stgMove)), width:720-(60*(k-stgMove)) , height:295  }, 600, 'easeOutCubic');
		}
		for (var h=stgMove;h<20; h++){
			sym.getSymbol("panelsMc").$("panel"+h).stop().delay(stgMove+(h*5)).animate ({opacity:1, top:0+(12*(h-stgMove)), left:0+(30*(h-stgMove)), width:720-(60*(h-stgMove)) , height:295  }, 600, 'easeOutCubic');
		}
		sym.getSymbol('menuBtnsMc').$('btnSlideMc').stop().animate({scrollTop:stgMove*-30+'px'},400);
	}
	panelSwap();

// AUX BUTTONS --------------------------------------------	
	auxArray = []; //the array that will hold references to the buttons.

	for (var a = 0; a < 8; a++){
		var auxBtnSymbols = sym.getSymbol("panelsMc").getSymbol("panel" +a); // Create an instance element of a symbol as a child of the given parent element
		auxBtnSymbols.setVariable("auxId", a); //set the value of a Symbol variable
		auxArray.push(auxBtnSymbols); //push it into the array
	}

	$.each(auxArray, function( count, auxInTheArray ){ //a 'for each' loop through the newly populated array
		var auxBtnItem = $(auxInTheArray); //create jQuery reference to the item
		var auxBtnElement = auxInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		auxBtnElement.bind ("click", {auxId:count}, auxBtnClick);
		auxBtnElement.bind ("touchstart", {auxId:count}, auxBtnClick);
	})

	function auxBtnClick (e){
		var auxAux_id = (e.data.auxId); //get the id of the clicked item
		stgMove = auxAux_id;
		panelSwap();
	}

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'panel0'
   (function(symbolName) {   
   
   })("panel0");
   //Edge symbol end:'panel0'

   //=========================================================
   
   //Edge symbol: 'btnSlideMc'
   (function(symbolName) {   
   
   })("btnSlideMc");
   //Edge symbol end:'btnSlideMc'

   //=========================================================
   
   //Edge symbol: 'panel0_1'
   (function(symbolName) {   
   
      })("panel1");
   //Edge symbol end:'panel1'

   //=========================================================
   
   //Edge symbol: 'panel0_1'
   (function(symbolName) {   
   
      })("panel2");
   //Edge symbol end:'panel2'

   //=========================================================
   
   //Edge symbol: 'panel2_1'
   (function(symbolName) {   
   
      })("panel3");
   //Edge symbol end:'panel3'

   //=========================================================
   
   //Edge symbol: 'panel0_1'
   (function(symbolName) {   
   
      })("panel4");
   //Edge symbol end:'panel4'

   //=========================================================
   
   //Edge symbol: 'panel0_1'
   (function(symbolName) {   
   
      })("panel5");
   //Edge symbol end:'panel5'

   //=========================================================
   
   //Edge symbol: 'panel0_1'
   (function(symbolName) {   
   
      })("panel6");
   //Edge symbol end:'panel6'

   //=========================================================
   
   //Edge symbol: 'panel0_1'
   (function(symbolName) {   
   
      })("panel7");
   //Edge symbol end:'panel7'

   //=========================================================
   
   //Edge symbol: 'panelsMc'
   (function(symbolName) {   
   
   })("panelsMc");
   //Edge symbol end:'panelsMc'

   //=========================================================
   
   //Edge symbol: 'nextBtn'
   (function(symbolName) {   
   
   })("nextBtn");
   //Edge symbol end:'nextBtn'

   //=========================================================
   
   //Edge symbol: 'backBtn'
   (function(symbolName) {   
   
   })("backBtn");
   //Edge symbol end:'backBtn'

})(jQuery, AdobeEdge, "GraphicNews31883");