/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none",});
	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN31783.xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			//create array from xml, put it into array of text elements
			for (var i=0; i<90; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			}	
		}
	}); // END XML
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.
	
	for (var h = 0; h < 7; h++){
		var menuBtnSymbols = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}
	
	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.bind ("click", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("touchstart", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
	})
	
	function menuBtnClick (e){
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnClick").fadeIn(0);
		btnNo = menuMenu_id;
		loadData();
		sym.$("head0").stop().animate ({opacity:0}, 0);
		sym.$("head0").attr("src", "images/head" + btnNo + ".png");
		sym.$("head0").stop().animate ({opacity:1}, 200, 'easeOutCubic');
		// CHANGE TEXT
		sym.$("txt0").empty();
		sym.$("txt0").append(txtArr[menuMenu_id*2]);
		sym.$("txt1").empty();
		sym.$("txt1").append(txtArr[menuMenu_id*2+1]);
		toggle = 1;
		btnClick();
	}
	
	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		btnNo = menuMenu_id;
		loadData();
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
	}
	
	// LOAD MENU TXT
	function loadData() {
	sym.$('overBtn').stop().animate({  borderSpacing: 38.5*btnNo }, {
    step: function(now,fx) {
      $(this).css('-webkit-transform','rotate('+now+'deg)'); 
      $(this).css('-moz-transform','rotate('+now+'deg)');
      $(this).css('transform','rotate('+now+'deg)');
    },
    duration:'fast'},'easeOut');
	}

// BUTTONS TOGGLE
	var toggle = 1;
sym.$("btnRnd").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	btnClick();
	});
sym.$("btnRnd").mouseover(function(){
	sym.getSymbol("btnRnd").$("btnRndOut").stop().fadeIn(200);
	});
sym.$("btnRnd").mouseout(function(){
	sym.getSymbol("btnRnd").$("btnRndOut").stop().fadeOut(200);
	});

function btnClick(){
	if (toggle == 0) {
		sym.getSymbol("btnRnd").$("btnPlus").stop().fadeOut(200);
		sym.$("txt0").stop().fadeOut(200);
		sym.$("txt1").stop().fadeOut(200);
		sym.$("txt14").stop().fadeIn(200);
		sym.$("txt15").stop().fadeIn(200);
		sym.$("txt16").stop().fadeIn(200);
		toggle = 1;
	}else{
		sym.getSymbol("btnRnd").$("btnPlus").stop().fadeIn(200);
		sym.$("txt0").stop().fadeIn(200);
		sym.$("txt1").stop().fadeIn(200);
		sym.$("txt14").stop().fadeOut(200);
		sym.$("txt15").stop().fadeOut(200);
		sym.$("txt16").stop().fadeOut(200);
		toggle = 0;
	}
}
btnClick();

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'btnRnd'
   (function(symbolName) {   
   
   })("btnRnd");
   //Edge symbol end:'btnRnd'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

})(jQuery, AdobeEdge, "GraphicNews31783");