/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gnYear=2014;
         var gn=31780;
         var startWC= Date.parse("June 12, 2014, 20:00 UTC");
         var startR2= Date.parse("June 27, 2014, 23:59 UTC");
         var endWC = Date.parse("July 13, 2014, 23:59 UTC");
         var oneDay = 86400000;
         var todayDate = new Date();
         var todayTime = todayDate.getTime();
         var localOffset=todayDate.getTimezoneOffset()*60000;//June 2
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var dateFormat;//May 16 - for different date formats
         var showLocal=0;//June 17
         
         //REFRESH RATES
         var fixtureInterval;
         var groupInterval;
         var matchInterval;
         var teamInterval;
         var playInterval;
         
         var screenArr=['latest','overview','matchtracker'];
         for (var i=0; i<2; i++){
         	sym.getSymbol("menuBtns").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         }
         var menuTxtArr=[];
         var headlinetext=sym.getSymbol("styleMc").$("headlinetxt").css("pointer-events","none");
         var sourcetxt=sym.getSymbol("styleMc").getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         var menuTxt=sym.getSymbol("styleMc").$("menuTxt").css("pointer-events","none");
         var text=[];
         	text[0]=sym.getSymbol("overview").$("txt0").css("pointer-events","none");
         	text[1]=sym.getSymbol("overview").$("txt1").css("pointer-events","none");
         	for (var t=2;t<15;t++){
         		text[t]=sym.getSymbol("overview").getSymbol("knockout").$("txt"+t).css("pointer-events","none");
         	}
         	text[15]=sym.getSymbol("overview").$("txt15").css("pointer-events","none");
         var txtArr=[];
         var countryArr=[];
         var tableCaps=[];
         var months=[];
         var key=[];
         var timetxt=[];//June 17
         
         var showstage=0;
         sym.getSymbol("overview").$("knockout").on('click',showStages);
         sym.getSymbol("overview").$("knockout").css({'cursor':'pointer'});
         $(".knockoutCaps").fadeOut(0);
         function showStages(){
         	e.preventDefault();
         	e.stopPropagation();
         	if(showstage==0){
         		$(".knockoutCaps").fadeIn(500);//show ko captions
         		$(".groupCaps").fadeOut(500);//hide grp captions
         		$(".kstage").fadeIn(500);
         		sym.getSymbol("overview").$("up").fadeOut(0);
         		sym.getSymbol("overview").$("down").delay(400).fadeIn(300);
         		for (var i=1; i<=8; i++){
         			var moveIt=Math.floor((i-1)/2);
         			sym.getSymbol("overview").getSymbol("groupStage").$("group"+(i)).animate({'height':'35px','top':19+(moveIt*42)},500);
         		}
         		sym.getSymbol("overview").$("groupStage").animate({'height':'190px'},500);	
         		sym.getSymbol("overview").$("knockout").off('click');
         		sym.getSymbol("overview").$("groupStage").on('click',showStages);
         		sym.getSymbol("overview").$("groupStage").css({'cursor':'pointer'});
         		sym.getSymbol("overview").$("knockout").css({'cursor':'auto'});
         		sym.getSymbol("overview").play();
         		showstage=1;
         	}else if(showstage==1){
         		$(".knockoutCaps").fadeOut(500);//show ko captions
         		$(".groupCaps").fadeIn(500);//hide grp captions
         		$(".kstage").fadeOut(500);
         		sym.getSymbol("overview").$("up").delay(400).fadeIn(300);
         		sym.getSymbol("overview").$("down").fadeOut(0);
         		for (var i=1; i<=8; i++){
         			var moveIt=Math.floor((i-1)/2);
         			sym.getSymbol("overview").getSymbol("groupStage").$("group"+(i)).animate({'height':'81px','top':19+(moveIt*105)},500, 'easeInQuad');
         		}
         		sym.getSymbol("overview").$("groupStage").animate({'height':'415px'},500);	
         		sym.getSymbol("overview").$("knockout").on('click',showStages);
         		sym.getSymbol("overview").$("groupStage").off('click');
         		sym.getSymbol("overview").$("knockout").css({'cursor':'pointer'});
         		sym.getSymbol("overview").$("groupStage").css({'cursor':'auto'});
         		sym.getSymbol("overview").playReverse();
         		showstage=0;
         	}
         }
         if(todayTime<startR2){
         	sym.getSymbol("overview").$("down").fadeOut(0);
         }else{
         	showStages();
         }
         var showMatch = function(match,home,away){ //to handle lexical scope
         	return function (e) {
         		resetmenu();
         		sym.getSymbol("matchtracker").$("stadium").attr('src','images/venue.png');
         		clearInterval(matchInterval);
         		clearInterval(teamInterval);
         		clearInterval(playInterval);
         		matchInterval = setInterval(function() { getMatchInfo(match); }, 60000);
         		teamInterval = setInterval(function() { getTeams(match,home,away); }, 60000);
         		playInterval = setInterval(function() { getMatch(match); }, 60000);
         		getMatchInfo(match);
         		getMatch(match);
         		getTeams(match,home,away);
         		sym.$("matchtracker").fadeIn(400);
         		sym.$("overview").fadeOut(400);
         		sym.$("latest").fadeOut(400);
         		sym.getSymbol("matchtracker").$("preloaderh").fadeIn(0);
         		sym.getSymbol("matchtracker").$("preloadera").fadeIn(0);
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         
         //TOGGLE SHOWMATCHES
         var groupShow;
         var showMatches = function(group){ //to handle lexical scope
         	return function (e) {
         		if(showstage==0){		
         			if(groupShow==group){
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).animate({'height':'81px'},300);
         				$("#gt"+group).css({'display':'none'});
         				groupShow="";
         			}else{			
         				for (var i=1;i<=8;i++){
         					if (group==i){
         						$("#gt"+group).css({'display':'block'});
         						sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).animate({'height':'185px'},300);
         					}else{
         						sym.getSymbol("overview").getSymbol("groupStage").$("group"+i).animate({'height':'81px'},300);
         						$("#gt"+i).css({'display':'none'});
         					}
         				}
         				groupShow=group;
         			}
         		}
         		e.preventDefault();
         	};
         };
         var countryId=[1035,523,3010,3075,413,411,3015,3059,3037,3012,3038,3062,3024,3090,436,445,408,3065,461,3048,3029,3100,3033,3084,1500,450,3025,3019,3004,3041,1063,3068];//ordered by group
         var venueID=[10438,15899,26737,35238,35239,36882,37425,49670,49671,49672,49673,49674];
         
         //AJAX gets data from xml source  --------------------------------------------
         $.ajax({	
         	type: "GET",
         	url: "GN"+gn+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		var headline=$(xml).find('headline').text();
         		headlinetext.html(headline);
         		var source=$(xml).find('source').text();
         		sourcetxt.html(source);
         		dateFormat=$(xml).find('dateformat').text();//May 16 - for different date formats
         		for (var m=0;m<2;m++){
         			menuTxtArr[m]= $(xml).find('menuTxt'+m).text();
         		}
         		for  (var i=0;i<33;i++){//May 30
         			txtArr[i]= $(xml).find('txt'+i).text(); //fixed text captions
         			if(i<text.length){
         				text[i].html(txtArr[i]);
         			}
         		}	
         		sym.getSymbol("overview").getSymbol("knockout").$("txt15").html(txtArr[10]);
         		sym.getSymbol("overview").getSymbol("knockout").$("txt16").html(txtArr[11]);
         		sym.getSymbol("overview").getSymbol("knockout").$("txt17").html(txtArr[12]);
         		sym.getSymbol("matchtracker").$("h2hTxt0").html(txtArr[24]);
         		sym.getSymbol("matchtracker").$("txt16").html(txtArr[17]);
         		sym.getSymbol("matchtracker").$("txt17").html(txtArr[17]);
         		sym.getSymbol("matchtracker").getSymbol("matchStats").$("txt18").html(txtArr[20]);
         		sym.getSymbol("latest").$("txt0").html(menuTxtArr[0]);
         		var tableHeadCaps = $(xml).find('table0').text();
               tableCaps=tableHeadCaps.split(";");
               var tableHead = "<table style='width:60%; position:left; margin-left:40%; font-family:pragmatica-web, sans-serif; font-weight:700; border:none; border-collapse:collapse; font-size:12px'>";
         		tableHead += "<tr><td width='13%'><center id='tp'></center></td><td width='13%'><center id='tw'></center></td><td width='13%'><center id='td'></center></td><td width='13%'><center id='tl'></center></td><td width='14%'><center id='tf'></center></td><td width='14%'><center id='ta'></center></td><td width='20%'><center id='tpts'></td></tr>";
         		tableHead += "</table>";
               sym.getSymbol("overview").$("tableHead").append(tableHead);
               $("#tw").text(tableCaps[0]);
               $("#td").text(tableCaps[1]);
               $("#tl").text(tableCaps[2]);
               $("#tf").text(tableCaps[3]);
               $("#ta").text(tableCaps[4]);
               $("#tpts").text(tableCaps[5]);
               var tooltipCaps = $(xml).find('table1').text();//May 16 - tool tip for group table
         		sym.getSymbol("overview").$("tooltip0").html(tooltipCaps);
         		sym.getSymbol("overview").$("tooltip0").css({'background-color':'rgb(255,235,165)','border':'solid 1px rgb(0,0,0)','border-radius':'2px','display':'none'});
               var monthsArr = $(xml).find('months').text();
                  months=monthsArr.split(";");
               var keyArr = $(xml).find('key').text();
                  key=keyArr.split(";");
               var timeArr = $(xml).find('time').text();//June 17
                  timetxt=timeArr.split(";");
               sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]); 
         		for (var c=0; c<32; c++){
                 countryArr[c]= $(xml).find("country"+c).text();
               }
         	}
         });
         sym.getSymbol("overview").$("tipBtn0").on('click',showTip); //May 16 - to show tool tip for group table
         var showtip=0;
         function showTip(){
         	if (showtip==0){
         		sym.getSymbol("overview").$("tooltip0").fadeIn(0);
         		showtip=1;
         	}else{
         		sym.getSymbol("overview").$("tooltip0").fadeOut(0);
         		showtip=0	
         	}
         }
         // MENU BUTTONS --------------------------------------------	
                  menuArray = []; //the array that will hold references to the buttons.
                  for (var m = 0; m < 2; m++){
                  		var menuBtnSymbols = sym.getSymbol("menuBtns").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
                  		menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
                  		menuArray.push(menuBtnSymbols); //push it into the array
                  	}
                  $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
                  		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
                  		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
                  		menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("touchstart click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("mouseover", {menuId:count}, menuShow);
                  		menuBtnElement.on ("mouseout", {menuId:count}, menuHide);
                  		menuBtnElement.css({"cursor":"pointer"});
                  })
                  function resetmenu(){
                  		for (var m=0; m<menuArray.length; m++){	
                           menuArray[m].$("menuBg").fadeOut(0);
                  		}
                  		menuTxt.fadeOut(0);
                  }
                  resetmenu();
                  function menuBtnClick (e){
                  		e.preventDefault();
                  		e.stopPropagation();
                  		resetmenu(); //set them all back to normal state
                  		clearInterval(matchInterval);
         					clearInterval(teamInterval);
         					clearInterval(playInterval);
                  		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         					for (var i=0;i<3;i++){
         						if (menuMenu_id==i){
         							sym.$(screenArr[i]).fadeIn(400);
         							sym.getSymbol("menuBtns").getSymbol("menuBtn" + i).$("menuBg").fadeIn(0);
         							menuTxt.html(menuTxtArr[i]);
         							menuTxt.fadeIn(0);
         						}else{
         							sym.$(screenArr[i]).fadeOut(400);
         						}						 
         					}
                  }
                  function menuShow (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the over button
                  		//sym.$('handMc').hide();
                  		menuTxt.html(menuTxtArr[menuMenu_id]);
         					menuTxt.fadeIn(0);
                  }
                  function menuHide (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the out button
                  		menuTxt.fadeOut(0);
                  }
         sym.getSymbol("menuBtns").getSymbol("menuBtn0").$("menuBg").fadeIn(0);
         
         sym.getSymbol("matchtracker").$("statsBtn").on('click',matchStats);
         sym.getSymbol("matchtracker").$("statsBtn").on('mouseover',statsOver);//May 30
         sym.getSymbol("matchtracker").$("statsBtn").on('mouseout',statsOut);//May 30
         sym.getSymbol("matchtracker").$("statsBtn").css({'cursor':'pointer'});
         var showStats=0;
         sym.getSymbol("matchtracker").$("statTxt").fadeOut(0);
         sym.getSymbol("matchtracker").$("statsBtn").fadeIn(0);
         function matchStats(){
         	if (showStats==0){
         		sym.getSymbol("matchtracker").$("timer").animate({'width':0,'left':'397px','opacity':0},200);
         		sym.getSymbol("matchtracker").$("statsBtn").attr('src','images/clockbtn.png');
         		sym.getSymbol("matchtracker").$("statTxt").html(txtArr[31]);//May 30
         		sym.getSymbol("matchtracker").$("statTxt").fadeIn(0);
         		showStats=1;
         	}else{
         		sym.getSymbol("matchtracker").$("timer").animate({'width':391,'left':'201px','opacity':1.0},200);
         		sym.getSymbol("matchtracker").$("statsBtn").attr('src','images/menuIcon2.png');
         		sym.getSymbol("matchtracker").$("statTxt").html(txtArr[32]);//May 30		
         		sym.getSymbol("matchtracker").$("statTxt").fadeIn(0);
         		showStats=0	
         	}
         }
         function statsOver(){//May 30
         	if (showStats==0){
         		sym.getSymbol("matchtracker").$("statTxt").html(txtArr[32]);
         		sym.getSymbol("matchtracker").$("statTxt").fadeIn(0);
         	}else{
         		sym.getSymbol("matchtracker").$("statTxt").html(txtArr[31]);		
         		sym.getSymbol("matchtracker").$("statTxt").fadeIn(0);
         	}
         }
         function statsOut(){//May 30	
         		sym.getSymbol("matchtracker").$("statTxt").fadeOut(0);
         }
         
         sym.getSymbol("latest").$("timezone").on("click",function(){ //June 17
         		if(showLocal==0){ showLocal=1; getFixtures(); }else{ showLocal=0;getFixtures(); } sym.getSymbol("latest").$("timezoneTxt").html(timetxt[showLocal]); });
         sym.getSymbol("latest").$("timezone").on("mouseover",function(){ 
         	if (showLocal==0){  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[1]);  }else{  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]);  }});
         sym.getSymbol("latest").$("timezone").on("mouseout",function(){ 
         	if (showLocal==0){  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]);  }else{  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[1]);  }});
         sym.getSymbol("latest").$("timezone").css({'cursor':'pointer'});	
         //DATE FUNCTIONS --------------------------------------------
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     //var thisDate = new Date(parseInt(dateTxt, 10));
                     var thisDate = new Date(parseInt((dateTxt+localOffset), 10));
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var matchDate=thisDate.getTime() +localOffset;//June 2
         	var matchTime=new Date(matchDate);
         	//var mm = matchTime.getUTCMonth();
         	var mm = matchTime.getMonth();//Jun 23
         	//var dd = matchTime.getUTCDate();
         	var dd = matchTime.getDate();//Jun 23
         	//return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         	if (dateFormat=="dayMonth"){ //May 16 - allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         } 
         function getDateLocal(thisDateStr) {//June 17
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	//return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         	if (dateFormat=="dayMonth"){ //May 16 - allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         }
         function getMatchTime(thisDateStr,braziltime){//June 17
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var thisTime = thisDate.getTime()+localOffset-braziltime;//localOffset to UTC - offset to Brazil
         	var matchTime = new Date(thisTime);
         	var hh = matchTime.getHours();
         	return hh+":00";	
         }
         function getMatchLocal(thisDateStr){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var hh = thisDate.getHours();
         	var mm = parseInt(thisDate.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	//var dDate = parseInt(matchRndDate,10);
         	var dDate = parseInt(matchRndDate,10)+localOffset;//June 2
         	return dDate;
         } 
         
         //LIVE DATA --------------------------------------
         function getDetails(groupIndex) {
                  	var group = groupIndex - 1;
                  	var id = 95402 + group;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gn+"&yr="+gnYear+"&phaseID=" + id,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		error: function () {
                  			console.log("Error retrieving Group[" + groupIndex + "]");
                  		},
                  		success: function (groupDetails) {
                  			loadDetails(groupDetails, group);
                  		}
                  	});
         }
         function loadDetails(groupDetails, group) {
         	var imgHTML;
         	for (var i = 0; i < 4; i++) {
         		for(var c=0;c<32;c++){
         			if (groupDetails[i].n_TeamID==countryId[c]){
         				var countryName=countryArr[c];
         			}
               }
         		$('#t' + group + 'n' + i).text(countryName);
         		$('#t' + group + 'p' + i).text(groupDetails[i].n_Matches);
         		$('#t' + group + 'w' + i).text(groupDetails[i].n_MatchesWon);
         		$('#t' + group + 'd' + i).text(groupDetails[i].n_MatchesDrawn);
         		$('#t' + group + 'l' + i).text(groupDetails[i].n_MatchesLost);
         		$('#t' + group + 'f' + i).text(groupDetails[i].n_GoalsFor);
         		$('#t' + group + 'a' + i).text(groupDetails[i].n_GoalsAgainst);
         		$('#t' + group + 'pts' + i).text(groupDetails[i].n_Points);
         		imgHTML='<img src="flags/'+(groupDetails[i].c_TeamNatioShort) +'.png" height="12px" width="22px">';
         		$('#t' + group + 'flag' + i).html(imgHTML);
         	}
         } 
         var resultsData;
         function getGroupResults() {
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&editionID=17694",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			resultsData = data;
         			for (var group = 1; group <= 8; group++) {
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).empty();
         				var tableTxt= "<div id='gt" + group + "' style='display:none; position:absolute; bottom:3px; width:100%'></div>";  
         				tableTxt += "<div id='grptable"+group+"'>";
         				tableTxt += "<table style='width:100%; position:absolute; background-color:rgb(215,230,245); font-family:pragmatica-web, sans-serif; border:none; border-collapse:collapse; font-size:12px'>";
         				tableTxt += "<tr style='background-color:rgb(235,240,250);'><td width='7%' id='t" + (group - 1) + "flag0'></td><td width='38%' ><span id='t" + (group - 1) + "n0'></td><td width='7%'><center id='t" + (group - 1) + "w0'></center></td><td width='7%'><center id='t" + (group - 1) + "d0'></center></td><td width='7%'><center id='t" + (group - 1) + "l0'></center></td><td width='8%'><center id='t" + (group - 1) + "f0'></center></td><td width='8%'><center id='t" + (group - 1) + "a0'></center></td><td width='11%'><center id='t" + (group - 1) + "pts0'></td></tr>";
         				tableTxt +="<tr style='background-color:rgb(235,240,250);'><td id='t" + (group - 1) + "flag1'></td><td><span id='t" + (group - 1) + "n1'></td><td><center id='t" + (group - 1) + "w1'></center></td><td><center id='t" + (group - 1) + "d1'></center></td><td><center id='t" + (group - 1) + "l1'></center></td><td><center id='t" + (group - 1) + "f1'></center></td><td><center id='t" + (group - 1) + "a1'></center></td><td><center id='t" + (group - 1) + "pts1'></td></tr>";
         				tableTxt += "<tr><td id='t" + (group - 1) + "flag2'></td><td><span id='t" + (group - 1) + "n2'></td><td><center id='t" + (group - 1) + "w2'></center></td><td><center id='t" + (group - 1) + "d2'></center></td><td><center id='t" + (group - 1) + "l2'></center></td><td><center id='t" + (group - 1) + "f2'></center></td><td><center id='t" + (group - 1) + "a2'></center></td><td><center id='t" + (group - 1) + "pts2'></td></tr>";
         				tableTxt += "<tr><td id='t" + (group - 1) + "flag3'></td><td><span id='t" + (group - 1) + "n3'></td><td><center id='t" + (group - 1) + "w3'></center></td><td><center id='t" + (group - 1) + "d3'></center></td><td><center id='t" + (group - 1) + "l3'></center></td><td><center id='t" + (group - 1) + "f3'></center></td><td><center id='t" + (group - 1) + "a3'></center></td><td><center id='t" + (group - 1) + "pts3'></td></tr></table>";
         				tableTxt += "<table style='position:absolute; top:0px; width:165px; background-color:rgb(215,230,245); border:none; border-collapse:collapse; font-family:pragmatica-web, sans-serif; font-size:12px'>";
         				tableTxt += "</div>";			
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).append(tableTxt);
         				getDetails(group);
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).on('click', showMatches(group));
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).css({'cursor':'pointer'});
         			} 
         		}
         	});
         }
         var fixtureData;   
         function getFixtures() { 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&editionID=17694",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			fixtureData = data;
         			$("#gt1").empty();
         			$("#gt2").empty();
         			$("#gt3").empty();
         			$("#gt4").empty();
         			$("#gt5").empty();
         			$("#gt6").empty();
         			$("#gt7").empty();
         			$("#gt8").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-1").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-2").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-3").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-4").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-5").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-6").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-7").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("r16-8").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf1").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf2").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf3").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf4").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("sf1").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("sf2").empty();	
         			sym.getSymbol("overview").getSymbol("knockout").$("ru").empty();	
         			sym.getSymbol("overview").getSymbol("knockout").$("final").empty();
         			sym.getSymbol("latest").$('table').empty();//June 12
         			for (var i = 0; i < fixtureData.length; i++) {
         				var matchesRnd = parsedDate(fixtureData[i].d_DateUTC);//June 23
         				var matchDay = fixtureData[i].n_PhaseID;
         				var phaseLevel = fixtureData[i].n_PhaseLevel;
         				var matchNo = fixtureData[i].n_MatchNr;
         				var countryHome;var countryAway;
         				var city=fixtureData[i].c_City
         				for(var c=0;c<32;c++){
         					if (fixtureData[i].n_HomeTeamID>0){
         						if (fixtureData[i].n_HomeTeamID==countryId[c]){
         							countryHome=countryArr[c];
         						}
         					}else{
         						countryHome=fixtureData[i].c_HomeTeamShort;
         					}
         					if (fixtureData[i].n_AwayTeamID>0){
         						if (fixtureData[i].n_AwayTeamID==countryId[c]){
         							countryAway=countryArr[c];
         						}
         					}else{
         						countryAway=fixtureData[i].c_AwayTeamShort;
         					}
         				}
         			//SHOW LATEST MATCHES -JUNE 12 added extra 0.5 days mathces displayed
         				if((todayTime<startWC&&matchesRnd<=startWC+(oneDay*2))||(matchesRnd>todayTime-(oneDay*0.75)&&matchesRnd<todayTime+(oneDay*3))||todayTime>endWC&&matchesRnd<endWC-(oneDay*2)){
         					if (i%2 == 0){
         						var fixtureTxt = "<table class='fixtxt even' id='matchf" + i + "'>";
         					}else{
         						var fixtureTxt = "<table class='fixtxt' id='matchf" + i + "'>";
         					}
         					fixtureTxt += "<tr>";
         					fixtureTxt += "<td class='crestf' style='crest' id='homecrestf" + i + "'></td>";
         					fixtureTxt += "<td class='teamf' style='padding-left:3px' id='homef" + i + "'></td>";
         					fixtureTxt += "<td style='width:20%;text-align:center' id='scoref" + i + "'></td>";
         					fixtureTxt += "<td class='teamf away' style='text-align:right' id ='awayf" + i + "'></td>";
         					fixtureTxt += "<td class='crestf away' id='awaycrestf" + i + "'></td>";
         					fixtureTxt += "</tr></table>";
                  	} //closes if parsedate	
                  	sym.getSymbol("latest").$('table').append(fixtureTxt);
         
         				var tableTxt = "<table class='grpmatch' id='match"+i+"'><tr>";
         				tableTxt +="<td class='flag' id='flagh" + i + "'></td>";
         				tableTxt +="<td class='grpteamh' id='teamh" + i + "'></td>";
         				tableTxt +="<td class='grpscore' id ='score" + i + "'></td>";
         				tableTxt +="<td class='grpteama' id='teama" + i + "' ></td>";
         				tableTxt +="<td class='flag' id='flaga" + i + "' ></td>";
         				tableTxt +="<td id='result" + i + "' ></td></tr></table>";
         
         				var overviewTxt = "<table class='match' id='match"+i+"'>";
         				overviewTxt += "<tr>";
         				overviewTxt += "<td class='flag' id='flagh"+i+"'></td>";
         				overviewTxt += "<td class='team' id='hometeam"+i+"'></td>";
         				overviewTxt += "<td id='scoreh"+i+"'></td>";
         				overviewTxt += "<td id='penh"+i+"'></td>";
         				overviewTxt += "</tr>";
         				overviewTxt += "<tr>";
         				overviewTxt += "<td class='flag' id='flaga"+i+"'></td>";
         				overviewTxt += "<td class='team' id='awayteam"+i+"'></td>";
         				overviewTxt += "<td id='scorea"+i+"'></td>";
         				overviewTxt += "<td id='pena"+i+"'></td>";
         				overviewTxt += "</tr>";
         				overviewTxt += "</table>";				
         				var groupPhase=[];
         				for (var p=0;p<8;p++){
         					groupPhase[p]=95402+p;
         					if(fixtureData[i].n_PhaseID==groupPhase[p]){
         						var groupOv="<div class='gstage'>"+tableTxt+"</div>";
         						$('#gt'+(p+1)).append(groupOv);
         					}
         				}
         				var r16match=[];
         				if (phaseLevel==9){//Round of 16
         					for (var r=0;r<8;r++){
         						r16match[r]=49+r;
         						if(matchNo==r16match[r]){
         							var r16Ov="<div class='kstage'>"+overviewTxt+"</div>";
         							sym.getSymbol("overview").getSymbol("knockout").$('r16-'+(r+1)).append(r16Ov);
         						}
         					}
         				}
         				var qmatch=[];
         				if (phaseLevel==5){//Quarter-finals
         					for (var q=0;q<4;q++){
         						qmatch[q]=57+q;
         						if(matchNo==qmatch[q]){
         							var qfOv="<div class='kstage'>"+overviewTxt+"</div>";
         							sym.getSymbol("overview").getSymbol("knockout").$('qf'+(q+1)).append(qfOv);
         						}
         					}
         				}
         				var smatch=[];
         				if (phaseLevel==3){//Semi-finals
         					for (var s=0;s<2;s++){
         						smatch[s]=61+s;
         						if(matchNo==smatch[s]){
         							var sfOv="<div class='kstage'>"+overviewTxt+"</div>";
         							sym.getSymbol("overview").getSymbol("knockout").$('sf'+(s+1)).append(sfOv);
         						}
         					}
         				}
         				var finTxt;
         				if (phaseLevel==4){//Third place
         					var ruOv="<div class='kstage'>"+overviewTxt+"</div>";
         					sym.getSymbol("overview").getSymbol("knockout").$('ru').append(ruOv);
         				}
         				if (phaseLevel==2){//Final
         					var finalOv="<div class='kstage'>"+overviewTxt+"</div>";
         					sym.getSymbol("overview").getSymbol("knockout").$('final').append(finalOv);
         				}
         				var matchID = fixtureData[i].n_MatchID;
         				var homeTeamID=fixtureData[i].n_HomeTeamID;
         				var awayTeamID=fixtureData[i].n_AwayTeamID;
         				var matchDate = getDDmonthYY(fixtureData[i].d_DateUTC);//June 2
         				var offsetBrazil = (fixtureData[i].n_CityGeoID==25762||fixtureData[i].n_CityGeoID==25766)?14400000:10800000;//June 17
         				if(showLocal==0){
         					var matchTime = getDDmonthYY(fixtureData[i].d_DateUTC)+", "+getMatchTime(fixtureData[i].d_Date,offsetBrazil);
         				}else{
         					var matchTime = getDateLocal(fixtureData[i].d_Date)+", "+getMatchLocal(fixtureData[i].d_Date);
         				}
         				$('.even').css({'background-color':'rgba(215,230,245,0.5)'});
         				$('.fixtxt').css({'font-size':'14px', 'font-family':'pragmatica-web,sans-serif', 'width':'100%'});
         				$('.teamf').css({'width':'25%','font-weight':700});
         				$(".crestf").css({'width':'15%'});
         				$(".away").css({'text-align':'right'});
         				var crestH = ((fixtureData[i].n_HomeTeamID)<=0)?'<img src="crests/null.png">':'<img src="crests/'+ fixtureData[i].n_HomeTeamID +'.png">';
         				var crestA = ((fixtureData[i].n_HomeTeamID)<=0)?'<img src="crests/null.png">':'<img src="crests/'+ fixtureData[i].n_AwayTeamID +'.png">';
         				$('#homecrestf' + i).html(crestH);
         				$('#awaycrestf' + i).html(crestA);
         				$(".crestf img").css({'border':'none','width':'50px','height':'50px'});
         				$('.match').css({'margin-left':'2px','cursor':'pointer','height':'32px','font-size':'12px', 'font-family':'pragmatica-web,sans-serif','border-collapse':'collapse', 'width':'100%'});
         				$('.grpmatch').css({'cursor':'pointer','height':'12px','font-size':'12px', 'font-family':'pragmatica-web,sans-serif','border-collapse':'collapse', 'width':'100%'});
         				$("#match"+i).on('click',showMatch(matchID,homeTeamID,awayTeamID));
         				$("#match"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)','font-weight':700});});
         				$("#match"+i).on('mouseout',function(){ $(this).css({'background-color':'rgba(255,255,255,0)','font-weight':400});});
         				$("#matchf"+i).css({'cursor':'pointer'});
         				$("#matchf"+i).on('click',showMatch(matchID,homeTeamID,awayTeamID));
         				$("#matchf"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)','font-weight':700});});
         				$("#matchf"+i).on('mouseout',function(){ 
         						if(this.className=="fixtxt even"){ 
         							$(this).css({'background-color':'rgba(215,230,245,0.5)','font-weight':400});
         						}else{
         							$(this).css({'background-color':'rgba(255,255,255,0)','font-weight':400});
         						}
         					});
         				var imgH = ((fixtureData[i].n_HomeTeamID)<=0)?'<img src="flags/null.png">':'<img src="flags/'+ fixtureData[i].c_HomeTeamNatioShort +'.png">';
         				var imgA = ((fixtureData[i].n_HomeTeamID)<=0)?'<img src="flags/null.png">':'<img src="flags/'+ fixtureData[i].c_AwayTeamNatioShort +'.png">';
         				$('#flagh' + i).html(imgH);
         				$('#flaga' + i).html(imgA);
         				$(".team").css({'padding-bottom':'1px'});
         				$(".flag").css({'width':'22px','padding':'0 2px 0 2px'});
         				$(".flag img").css({'border':'none','width':'22px','height':'12px'});
         				$('#teamh' + i).text(countryHome);
         				$('#teama' + i).text(countryAway);
         				$('#hometeam' + i).text(countryHome);
         				$('#awayteam' + i).text(countryAway);
         				$('#homef' + i).text(countryHome);
         				$('#awayf' + i).text(countryAway);
         				$('.grpteamh').css({'text-align':'left', 'width':'35%','padding':'0px'});
         				$('.grpteama').css({'text-align':'right', 'width':'35%','padding':'0px'});
         				$('.grpscore').css({'padding':'0px'});
         				var pena=(fixtureData[i].n_AwayGoalsShootout!=null||fixtureData[i].n_AwayGoalsShootout!=undefined)?'<i> ('  + fixtureData[i].n_AwayGoalsShootout + ')</i>':'';    
         				var penh=(fixtureData[i].n_HomeGoalsShootout!=null||fixtureData[i].n_HomeGoalsShootout!=undefined)?'<i> (' + fixtureData[i].n_HomeGoalsShootout + ')</i>':'';               
         				$('#penh' + i).html(penh);
         				$('#pena' + i).html(pena);
         				var scoreH = (fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?'<b>' + (fixtureData[i].n_HomeGoals)+ '</b>':'';
         				$('#scoreh' + i).html(scoreH);
         				var scoreA = (fixtureData[i].n_AwayGoals!=null||fixtureData[i].n_AwayGoals!=undefined)?'<b>' + (fixtureData[i].n_AwayGoals)+ '</b>':'';
         				$('#scorea' + i).html(scoreA);
         				var score =(fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?'<b>' + (fixtureData[i].n_HomeGoals)+ '-' + (fixtureData[i].n_AwayGoals)+'</b>':'<i>'+matchDate+'</i>';
         				var scoref =(fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?'<b>' + (fixtureData[i].n_HomeGoals)+ '-' + (fixtureData[i].n_AwayGoals)+'</b>':'<i>'+matchTime+'</i>';//June 17
         				$('#score' + i).html(score);
         				$('#scoref' + i).html(scoref+"<br/><i>"+city+"</i>");//June 17
         				var matchNo= fixtureData[i].n_MatchNr;
         				matchResult=(fixtureData[i].n_MatchStatusCode>4)&&(fixtureData[i].n_MatchStatusCode<128)?'<img src="images/ball.png" height="13px" width="13px">':'';
         				$('#result'+i).html(matchResult);
         				if (phaseLevel<=9){
         					sym.getSymbol("overview").getSymbol("knockout").$("dateTxt"+matchNo).text(matchDate);
         				}
         				if (showstage==0){
         					$(".kstage").fadeOut(0); 
         				}
         			} //close for                                 
         		} //close success                                                    	           
         	}); //close ajax
          }//close function
         getGroupResults();
         setTimeout(getFixtures,1000);
         if(todayTime>startWC-(oneDay*3)&&todayTime<endWC+(oneDay*3)){
         groupInterval = setInterval(getGroupResults,600000);
         fixtureInterval = setInterval(getFixtures,120000);
         }
         // LIVE MATCH 			
         function getMatchInfo(matchID){
         	var infoData;
         	sym.getSymbol("matchtracker").$("penaltiesTxt").fadeOut(0);
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&match="+matchID+"&q=info",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			infoData = data;
         			var matchteam1;
         			var matchteam2;
         			for(var c=0;c<32;c++){
         				if (infoData[0].n_HomeTeamID>0){
         					if (infoData[0].n_HomeTeamID==countryId[c]){
         						matchteam1=countryArr[c];
         					}
         				}else{
         					matchteam1=infoData[0].c_HomeTeamShort;
         				}
         				if (infoData[0].n_AwayTeamID>0){
         					if (infoData[0].n_AwayTeamID==countryId[c]){
         						matchteam2=countryArr[c];
         					}
         				}else{
         					matchteam2=infoData[0].c_AwayTeamShort;
         				}
         			}
         			var stadiumImg=(infoData[0].n_StadiumGeoID>0)?infoData[0].n_StadiumGeoID:null;
         			sym.getSymbol("matchtracker").$("stadium").attr('src','venues/'+stadiumImg+'.png');
         			//sym.getSymbol("matchtracker").$("statsBtn").fadeOut(0);
         			var score1;
         			var score2;
         			var notStarted=['stadium','h2hmatch','h2h'];
         			//var notStarted=['stadium','h2hmatch','tableHeadh','tableHeada','h2h'];
         			var showStarted=['matchStats','timer','timeTxt','clock'];
         			if(infoData[0].b_Started==false){
         				score1="0";
         				score2="0";
         				for(var n=0;n<notStarted.length;n++){
         					sym.getSymbol("matchtracker").$(notStarted[n]).fadeIn(600);//May 16 - slower fadeIn
         				}
         				for(var m=0;m<showStarted.length;m++){
         					sym.getSymbol("matchtracker").$(showStarted[m]).fadeOut(0);
         				}
         				getH2H(matchID);	
         			}else{
         				score1=infoData[0].n_HomeGoals;
         				score2=infoData[0].n_AwayGoals;
         				for(var n=0;n<notStarted.length;n++){
         					sym.getSymbol("matchtracker").$(notStarted[n]).fadeOut(0);
         				}
         				for(var m=0;m<showStarted.length;m++){
         					sym.getSymbol("matchtracker").$(showStarted[m]).fadeIn(600);//May 16 - slower fadeIn
         				}
         				getmatchStats(matchID);
         			}
         			var offsetBrazil = (infoData[0].n_CityGeoID==25762||infoData[0].n_CityGeoID==25766)?14400000:10800000;//June 17
         			if(infoData[0].b_Finished==true){
         				clearInterval(teamInterval);
         				clearInterval(playInterval);
         				var matchTime = getDDmonthYY(infoData[0].d_DateUTC);
         			}else{
         				if(showLocal==0){
         					var matchTime = getMatchTime(infoData[0].d_Date,offsetBrazil)+" "+getDDmonthYY(infoData[0].d_DateUTC);
         				}else{
         					var matchTime = getMatchLocal(infoData[0].d_Date)+" "+getDateLocal(infoData[0].d_Date);
         				}
         			}
         			var matchRef=(infoData[0].c_Referee==null)?"":txtArr[18] + infoData[0].c_Referee + " <i>" + infoData[0].c_RefereeNatioShort+"</i>";
         			var spectators=(infoData[0].n_Spectators==null)?"":txtArr[19] + infoData[0].n_Spectators;
         			var matchscore = score1 + "-" + score2;
         			var imgH = "crests/"+ infoData[0].n_HomeTeamID + ".png";
         			var imgA = "crests/"+ infoData[0].n_AwayTeamID + ".png";
         			var matchStatus = infoData[0].n_MatchStatusCode;
         			var tacticsH =(infoData[0].c_HomeTactics==null)?"":infoData[0].c_HomeTactics;
         			var tacticsA = (infoData[0].c_AwayTactics==null)?"":infoData[0].c_AwayTactics;
         			var matchDate = getDDmonthYY(infoData[0].d_DateUTC);//June 2
         			//var matchInfo = infoData[0].c_Stadium + ", " + infoData[0].c_City + "<br />" + matchDate + ", 2014<br />" + matchRef + "<br />" + spectators ;
         			var matchInfo = infoData[0].c_Stadium + ", " + infoData[0].c_City + "<br />" + matchTime + ", 2014<br />" + matchRef + "<br />" + spectators ;//June 17
         			sym.getSymbol("matchtracker").$("matchcrest1").attr("src",imgH);				
         			sym.getSymbol("matchtracker").$("matchcrest2").attr("src",imgA);				
         			sym.getSymbol("matchtracker").$("matchteam1Txt").text(matchteam1);
         			sym.getSymbol("matchtracker").$("matchteam2Txt").text(matchteam2);
         			sym.getSymbol("matchtracker").$("matchscoreTxt").text(matchscore);
         			sym.getSymbol("matchtracker").$("matchinfoTxt").html(matchInfo);
         			//matchStatus 8 (in progress), 128 (finished)
         			//PENALTY SHOOTOUT ONLY
         			if (infoData[0].n_PeriodSort>=10&&infoData[0].n_HomeGoalsShootout!=null){
         				//if (lastPeriod==10){	
         				var pensH=(infoData[0].n_HomeGoalsShootout>=0)?infoData[0].n_HomeGoalsShootout:"";
         				var pensA=(infoData[0].n_AwayGoalsShootout>=0)?infoData[0].n_AwayGoalsShootout:"";
         				var penalties= txtArr[30]+" (" +pensH+ "-" +pensA+ ")";
         				if (infoData[0].n_HomeGoalsShootout>=0||infoData[0].n_AwayGoalsShootout>=0){
         						sym.getSymbol("matchtracker").$("penaltiesTxt").html(penalties);
         						sym.getSymbol("matchtracker").$("penaltiesTxt").fadeIn(0);
         					}
         			}	               							
         		}
         	});
         }
         
         var matchData;
         var lastAction;
         var lastTime;
         var lastPeriod;
         function getMatch(matchID) { 
         	var minutes = sym.getSymbol("matchtracker").$("timeTxt");
         	minutes.text("0"); 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			matchData = data;
         				if(matchData){
         					lastAction = matchData[0].n_ActionTime;
         					lastPeriod = matchData[0].n_PeriodSort;
         					var lastTimetxt;
         					var minutes = sym.getSymbol("matchtracker").$("timeTxt");
         					sym.getSymbol("matchtracker").$("timer").empty();
         					//create display for each action	
         					var actionTxt;
         					var penTxt;
         					var HorA;
         					var actionSet;
         					var actionType;
         					var action;
         					var actionTime;
         					var actionMs;
         					var actionPeriod;
         					var keyTxt="<div class='action'>";//June 17
         					keyTxt+="<div class='key'><img src='images/goal.png' style='width:15px'> "+key[0]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/pen.png' style='width:15px'> "+key[1]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/sub.png' style='width:15px'> "+key[2]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/yellow.png' style='width:15px'> "+key[3]+"</div>";
         					keyTxt+="</div>";
         					sym.getSymbol("matchtracker").$("timer").append(keyTxt);//June 17
         					for (var i = 0; i <= matchData.length; i++) {
         						if (matchData[i].n_ActionTime>lastAction){
         							lastAction=matchData[i].n_ActionTime;
         						}
         						if (matchData[i].n_PeriodSort>lastPeriod){
         							lastPeriod=matchData[i].n_PeriodSort;
         						}         		        
         						actionSet = matchData[i].n_ActionSet;
         						actionType = matchData[i].n_ActionCode;
         						actionTime = (matchData[i].c_ActionMinute==null)?"":matchData[i].c_ActionMinute;//June 30
         						var HorA = (matchData[i].n_HomeOrAway==1)?"h":"a";
         						if (actionSet==1||actionSet==2||actionSet==3||actionSet==5){
         							actionMs = matchData[i].n_ActionTime;
         							actionPeriod = matchData[i].n_PeriodSort;
         							var actionTxt="<div class='action period"+actionPeriod+"' id=action"+i+"'>";//May 30 - style by period
         							actionTxt+="<div class='personh' id='person"+i+"h'></div>";
         							actionTxt+="<div class='type' id='type"+i+"h'></div>";	
         							actionTxt+="<div class='actiontime' id='actionMins"+i+"'></div>";
         							actionTxt+="<div class='type' id='type"+i+"a'></div>";
         							actionTxt+="<div class='persona' id='person"+i+"a'></div>";
         							actionTxt+="</div>";
         							//then append each action (latest at top)
         							sym.getSymbol("matchtracker").$("timer").prepend(actionTxt);
         							var player=matchData[i].c_PersonShort;     
         							if (matchData[i].n_ActionSet==5){
         								var sub=" (" + matchData[i].c_SubPersonShort + ")";
         							}else{
         								var sub="";
         							}
         							$('#person' + i + HorA).text(player+sub);
         							//$('#actionMins' + i).text(matchData[i].c_ActionMinute);
         							$('#actionMins' + i).text(actionTime);//June 30
         							//create icons for each action
         							switch (actionSet){
         								case 1:
         								if(actionType==12){//June 16
         									action= "pen";
         								}else{//June 16
         									action= "goal";
         								}
         								break;
         								case 2:
         								if (actionType==12){
         									action="pen";
         								}else{
         									action="miss";
         								}
         								break;
         								case 3:
         								if (actionType==2048){
         									action="yellow";
         								}else{
         									action="red";
         								}
         								break;
         								case 5:
         								action="sub";
         								break;
         							}
         							var imgHTML="<img src='images/"+action +".png' height='20px' width='20px'>";
         							$('#type' + i + HorA).html(imgHTML);
         							//May 30
         							$('.key').css({'display':'table-cell','font-style':'italic','padding-left':'5px'});//June 17
         							$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
         							$(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
         							$(".period6, .period8").css({'background-color':'rgba(255,0,0,0.1)'});
         							$(".period10").css({'background-color':'rgba(255,40,0,0.3)'});
         							$('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
         							$('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
         							$('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
         							$('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
                  			} //close if
         						if (lastAction>7200000){					//if after 120 mins but before penalties
         							lastTime=7200000;
         						}else if ((lastAction>6300000)&&(lastPeriod<7)){					//if after 105 mins but before second period
         							lastTime=6300000;
         						}else if ((lastAction>5400000)&&(lastPeriod==11)){					//if after 90 mins match has finished
         							lastTime=5400000;
         						}else if ((lastAction>5400000)&&(lastPeriod<5)){					//if after 90 mins but before extra time
         							lastTime=5400000;
         						}else if((lastAction>2700000)&&(lastPeriod<4)){ 		// if match is in 1st half but > 45 mins
         							lastTime=2700000;
         						}else{
         							lastTime=lastAction;
         						}
         						//display latest time
         						if (lastPeriod==11){
         							lastTimetxt=Math.round(lastTime/60000);
         						}else if (lastPeriod<9){ //before penalty shootout
         							if(lastAction > 0){	
         								lastTimetxt=Math.round(lastAction/60000);
         							}
         						}else{
         							lastTimetxt="120";
         						}
                  			minutes.text(lastTimetxt); //SHOW LATEST TIME
         					} //close for 
         					if (lastPeriod>5){ //extra time draw line at ht/ft
         					}
         				}
         		},//close success 
         		error: function(){ 
         			console.log("Match not started");
         		}  	                                                  	           
         	}); //close ajax
         }
         function getTeams(matchID,home,away) {           
                  	sym.getSymbol("matchtracker").$("matchSquadh").empty(); //PASS teamIDs to teamInterval
                  	sym.getSymbol("matchtracker").$("matchSquada").empty();
                     var teamData;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gn+"&yr="+gnYear+"&q=teams&match="+matchID,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		success: function (data) {
                  			teamData = data;
                  			if (!teamData){
         							getSquad(home,"home");
         							getSquad(away,"away");
         							sym.getSymbol("matchtracker").$("txt16").html(txtArr[17]);
         							sym.getSymbol("matchtracker").$("txt17").html(txtArr[17]);
         							sym.getSymbol("matchtracker").$("tableHeadh").fadeIn(0);//June 13
         							sym.getSymbol("matchtracker").$("tableHeada").fadeIn(0);//June 13
         							clearInterval(teamInterval);
         							teamInterval = setInterval(function() { getTeams(match,home,away); }, 600000);
                  			}else{
         							var coach;
         							var teamlist;
         							var team;
         							var hORa;
         							sym.getSymbol("matchtracker").$("txt16").html(txtArr[16]);
         							sym.getSymbol("matchtracker").$("txt17").html(txtArr[16]);
         							sym.getSymbol("matchtracker").$("preloaderh").fadeOut(0);
         							sym.getSymbol("matchtracker").$("preloadera").fadeOut(0);
         							sym.getSymbol("matchtracker").$("tableHeadh").fadeOut(0);//June 13
         							sym.getSymbol("matchtracker").$("tableHeada").fadeOut(0);//June 13
         							for (var i = 0; i < teamData.length; i++) {		
         								if (teamData[i].n_HomeOrAway==1){
         									teamlist = "matchSquadh";
         									hORa='h';
         								}else if (teamData[i].n_HomeOrAway==-1){
         									teamlist = "matchSquada";
         									hORa='a';
         								}
         
         								if (teamData[i].n_ActionSet<8){
         									if (teamData[i].n_ActionSet==4){
         										var lineupTxt = "<div class='lineup' id='lineup" + i + "'>";
         									} else if (teamData[i].n_ActionSet==5||teamData[i].n_ActionSet==6){
         										var lineupTxt = "<div class='substitute' id='lineup" + i + "'>";
         									}	
         										lineupTxt += "<div class='shirtNr' id='teamShirt" + i + "'></div>";
         										lineupTxt += "<div class='playerNm' id='teamPerson" + i + "'></div>";
         										lineupTxt += "</div>";
         										sym.getSymbol("matchtracker").$("matchSquad"+hORa).append(lineupTxt);
         								}
         								//}else if (teamData[i].n_ActionSet==8){//June 13
         								if (teamData[i].n_FunctionType==16){
         									coach = "<div style='padding-left:3px'><b>" + teamData[i].c_Person + "</b> <span style='text-align:right; font-style:oblique; font-size:12px'>" + teamData[i].c_PersonNatioShort + "</span></div>";
         									sym.getSymbol("matchtracker").$("matchSquad"+hORa).prepend(coach);
         								}
         								sym.getSymbol("matchtracker").$("matchSquad"+hORa).css({'font-family':'pragmatica-web,sans-serif','font-size':'13px'}); 
         								$('.lineup').css({'width':'100%','display':'inline-table'});
         								$('.substitute').css({'width':'100%','display':'inline-table','font-style':'oblique'});
         								$('.shirtNr').css({'width':'10%','display':'table-cell','text-align':'left','padding-left':'3px'});  
         								$('.playerNm').css({'width':'90%','display':'table-cell','text-align':'left','padding-left':'5px'});                        
         								var actionMins;	                
         								if (teamData[i].c_ActionMinute==null){
         									actionMins="";
         								}else{
         									actionMins=" ("+ teamData[i].c_ActionMinute + ")";
         								}			
         								$('#teamShirt' + i).text(teamData[i].n_ShirtNr);
         								$('#teamPerson' + i).html(teamData[i].c_Person + actionMins);
         								$('#subPerson' + i).text(teamData[i].c_SubPersonShort);
         								var posn = teamData[i].n_Position;			
         							}
         						}
         
                  		}
                  	});
         }
         function getSquad(team,homeOrAway){
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gn+"&yr="+gnYear+"&squad="+team,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		success: function (data) {
                  			squadData=data;
                  			var hORa=(homeOrAway=="home")?"h":"a";
                  			for (var i = 0; i <squadData.length; i++) {
                  				var shirtNr = (squadData[i].n_ShirtNr!=null)?squadData[i].n_ShirtNr:"";
                  				var player = squadData[i].c_Person;
                  				var ycards = squadData[i].n_CardsYellow;
                  				var rcards = squadData[i].n_CardsRed;
                  				var cards = ycards + "/" + rcards;
                  				var goals = squadData[i].n_Goals;
                  				var position=squadData[i].n_FunctionCode;
                  					if (position>0&&position<16){
                  						var squadlist = "<div id='"+hORa+"player"+i+"'>";
                  						squadlist += "<div class='squadCol1' id='"+hORa+"sqdshirt"+i+"'></div>";
                  						squadlist += "<div class='squadCol2' id='"+hORa+"sqdplayerName"+i+"'></div>";
                  						squadlist += "<div class='squadCol3' id='"+hORa+"sqdcards"+i+"'></div>";
                  						squadlist += "<div class='squadCol4' id='"+hORa+"sqdgls"+i+"'></div>";
                  						squadlist += "</div>";
                  					}
                  					sym.getSymbol("matchtracker").$("matchSquad"+hORa).append(squadlist);  
                  					sym.getSymbol("matchtracker").$("preloader"+hORa).fadeOut(0);              
                  					$('#'+hORa+'player'+i).css({'width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif', 'display':'inline-table'});
                  					$('.squadCol1').css({'width':'8%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
                  					$('.squadCol2').css({'width':'72%', 'padding-left':'3%','display':'table-cell'});
                  					$('#'+hORa+'sqdplayerName'+i).css({'font-weight':400});
                  					$('.squadCol3').css({'width':'10%', 'display':'table-cell', 'text-align':'center'});
                  					$('.squadCol4').css({'width':'10%', 'display':'table-cell', 'text-align':'right'});
                  					$('#'+hORa+'sqdshirt'+i).text(shirtNr);
                  					$('#'+hORa+'sqdplayerName'+i).text(player);
                  					$('#'+hORa+'sqdcards'+i).text(cards);
                  					$('#'+hORa+'sqdgls'+i).text(goals);
         
                  				}
                  			}
                  		});
                  }
         //PIE CHART
         function pieChart(hwins,awins,draws,placeHolder){			
              var canvasWidth = 145, //width
               canvasHeight = 90,   //height
               outerRadius = 45,   //radius
               //color = d3.scale.category20(); //builtin range of colors
         		color = d3.scale.ordinal().range(["#006666","#4e9799","#33c5cc","#FF6666"]);
             var dataSet = [
               {"legendLabel":"Won", "magnitude":awins},  
               {"legendLabel":"Drawn", "magnitude":draws}, 
               {"legendLabel":"Won", "magnitude":hwins}];
             var vis = d3.select(placeHolder)
               .append("svg:svg") //create the SVG element inside the <body>
                 .data([dataSet]) //associate our data with the document
                 .attr("width", canvasWidth) //set the width of the canvas
                 .attr("height", canvasHeight) //set the height of the canvas
                 .append("svg:g") //make a group to hold our pie chart
         			.attr("transform", "translate("+canvasWidth/2+","+canvasHeight/2+")") //move centre of pie chart from 0, 0 to middle of placeholder
         			//	.attr("viewBox", +canvasWidth/2+"px",+canvasHeight/2+"px",90,90)
         
         				.style("-webkit-transform", "translate("+canvasWidth/2+"px,"+canvasHeight/2+"px)");
             // This will create <path> elements for us using arc data...
             var arc = d3.svg.arc()
               .outerRadius(outerRadius)
         		.innerRadius(outerRadius-30); //donut chart
             var pie = d3.layout.pie() //this will create arc data for us given a list of values
               .value(function(d) { return d.magnitude; }) // Binding each value to the pie
               .sort( function(d) { return null; } );
             // Select all <g> elements with class slice (there aren't any yet)
             var arcs = vis.selectAll("g.slice")  // Associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
               .data(pie) // This will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
               .enter() // Create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
               .append("svg:g")
               .attr("class", "slice");    //allow us to style things in the slices (like text)
             arcs.append("svg:path")
               //set the color for each slice to be chosen from the color function defined above
               .attr("fill", function(d, i) { return color(i); } ) //this creates the actual SVG path using the associated data (pie) with the arc drawing function
               .attr("d", arc);
         }
         function getH2H(match){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=h2hsum&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchtracker").$("h2hmatch").empty();
         			sym.getSymbol("matchtracker").$("h2hgoals").empty();
         			sym.getSymbol("matchtracker").$("h2hTxt1").empty();
         			sym.getSymbol("matchtracker").$("h2hTxt2").empty();
         			sym.getSymbol("matchtracker").$("h2hTxt3").empty();
         			sym.getSymbol("matchtracker").$("h2hTxt4").fadeIn(0);
         			h2hData = data;
         			if(h2hData.length>0){			
         				var hwins=h2hData[0].n_MatchesWonHome;
         				var awins=h2hData[0].n_MatchesWonAway;
         				var draws=h2hData[0].n_MatchesDrawn;
         				var hgoals=h2hData[0].n_GoalsForHome;
         				var agoals=h2hData[0].n_GoalsForAway;
         				var placeHolder="#Stage_matchtracker_h2hmatch";
         				pieChart(hwins,awins,draws,placeHolder);
         				sym.getSymbol("matchtracker").$("h2hTxt1").html(txtArr[25]+": <b>"+hwins+"</b>")
         				sym.getSymbol("matchtracker").$("h2hTxt2").html(txtArr[26]+": <b>"+awins+"</b>")
         				sym.getSymbol("matchtracker").$("h2hTxt3").html(txtArr[27]+": <b>"+draws+"</b>")
         				var barTxt="<div class='barGraph'>";
         					barTxt+="<div id='capGoals'></div>";
         				barTxt+="<div id='hbarGoals'></div>";
         				barTxt+="<div id='abarGoals'></div>";
         				barTxt+="</div>";
         				sym.getSymbol("matchtracker").$("h2hgoals").append(barTxt);
         				var hwidth=(hgoals/(hgoals+agoals)*100)+"%";
         				var awidth=(agoals/(hgoals+agoals)*100)+"%";
         				$("#hbarGoals").text(hgoals);
         				$("#abarGoals").text(agoals);
         				var acolor=(agoals==0)?'#33c5cc':'#006666';
         				var hcolor=(hgoals==0)?'#006666':'#33c5cc';
         				$("#capGoals").html(txtArr[28]);
         				$(".barGraph").css({'font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px','font-weight':700, 'display':'inline-table'});
         				$("#capGoals").css({'text-align':'center','width':'100%','display':'table-caption'});
         				$("#hbarGoals").css({'background-color':hcolor,'color':'#ffffff','padding-left':'5px','text-align':'left', 'display':'table-cell','width':hwidth});
         				$("#abarGoals").css({'background-color':acolor,'color':'#ffffff','padding-right':'5px','text-align':'right','width':awidth,'display':'table-cell'});
         			}else{
         				sym.getSymbol("matchtracker").$("h2hTxt4").fadeOut(0);
         				sym.getSymbol("matchtracker").$("h2hmatch").append("<div style='font-family:pragmatica-web;text-align:center;font-size:14px'>"+txtArr[29]+"</div>");
         			}
         		}
         	});
         }
         function getmatchStats(match){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=stats&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("chartHolder").empty();
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").empty();//May 26
         			matchData = data;
         			var bar;
         			var placeHolder="#Stage_matchtracker_matchStats_chartHolder";
         			if (matchData.length>0){
         				//sym.getSymbol("matchtracker").$("statsBtn").fadeIn(0);//May 30
         				function drawBar(){//June 12
                  			var barTxt="<div class='barGraph'>";
                  			barTxt+="<div id='cap"+bar+"'></div>";
                  			barTxt+="<div id='hbar"+bar+"'></div>";
                  			barTxt+="<div id='abar"+bar+"'></div>";
                  			barTxt+="</div>";
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").append(barTxt);
                  	}
         				for (var i = 0; i < matchData.length; i++) {
         					if(matchData[i].n_ActionSet==13&&matchData[i].c_ActionShort=="BP"){//possession - June 12
         						var hPoss=matchData[i].n_HomePoints;
         						var aPoss=matchData[i].n_AwayPoints;
         						pieChart(hPoss,aPoss,0,placeHolder);
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("hpiTxt").html(hPoss+"%"); //June 12
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("apiTxt").html(aPoss+"%"); //June 12
         					}else if(matchData[i].n_ActionSet==12){
         						if(matchData[i].n_ActionSort==104){//on target
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="shots";
         							drawBar();
         						}
         						if(matchData[i].n_ActionSort==106){//saves
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="saves";
         							drawBar();
         						}
         						if(matchData[i].n_ActionSort==112){//fouls against
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="fouls";
         							drawBar();
         						}
         						/*June 12
         						var barTxt="<div class='barGraph'>";
         						barTxt+="<div id='cap"+bar+"'></div>";
         						barTxt+="<div id='hbar"+bar+"'></div>";
         						barTxt+="<div id='abar"+bar+"'></div>";
         						barTxt+="</div>";
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").append(barTxt);//May 26
         						*/
         						var hwidth=(hPts/(hPts+aPts)*100)+"%";
         						var awidth=(aPts/(hPts+aPts)*100)+"%";
         						$("#hbar"+bar).text(hPts);
         						$("#abar"+bar).text(aPts);
         						$(".barGraph").css({'margin':'10px 0px','font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px', 'display':'inline-table'});
         						$("#cap"+bar).css({'text-align':'center','width':'100%','display':'table-caption','font-weight':700});
         						$("#hbar"+bar).css({'background-color':'#33c5cc','color':'#ffffff','padding-left':'5px','text-align':'left', 'display':'table-cell','width':hwidth});
         						$("#abar"+bar).css({'background-color':'#006666','color':'#ffffff','padding-right':'5px','text-align':'right','width':awidth,'display':'table-cell'});
         					}
         						$("#capshots").html(txtArr[21]);
         						$("#capsaves").html(txtArr[22]);
         						$("#capfouls").html(txtArr[23]);
         				}
         			//}else{ //May 30
         			//	sym.getSymbol("matchtracker").$("statsBtn").fadeOut(0);
         			}
         		}
         	});
         }
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'Match'
   (function(symbolName) {   
   
   })("Match");
   //Edge symbol end:'Match'

   //=========================================================
   
   //Edge symbol: 'Overview'
   (function(symbolName) {   
   
   })("Overview");
   //Edge symbol end:'Overview'

   //=========================================================
   
   //Edge symbol: 'Knockout'
   (function(symbolName) {   
   
   })("Knockout");
   //Edge symbol end:'Knockout'

   //=========================================================
   
   //Edge symbol: 'GroupStage'
   (function(symbolName) {   
   
   })("GroupStage");
   //Edge symbol end:'GroupStage'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtns'
   (function(symbolName) {   
   
   })("MenuBtns");
   //Edge symbol end:'MenuBtns'

   //=========================================================
   
   //Edge symbol: 'Latest'
   (function(symbolName) {   
   
   })("Latest");
   //Edge symbol end:'Latest'

   //=========================================================
   
   //Edge symbol: 'TableHead'
   (function(symbolName) {   
   
   })("TableHead");
   //Edge symbol end:'TableHead'

   //=========================================================
   
   //Edge symbol: 'BarGraph'
   (function(symbolName) {   
   
   })("BarGraph");
   //Edge symbol end:'BarGraph'

   //=========================================================
   
   //Edge symbol: 'MatchStats'
   (function(symbolName) {   
   
   })("MatchStats");
   //Edge symbol end:'MatchStats'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(jQuery, AdobeEdge, "GraphicNews31780");