/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	for (var b=0;b<3; b++){
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuIcon" + b + ".png");
	}
	var btnNo = 0;
	
	var xmlNo = "GN31666.xml";
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	var bodyTxt;
	var bodyTxttxt = sym.$("bodyTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.$("txt0").css({"pointer-events":"none",});
	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.getSymbol("capMc").$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.getSymbol("capMc").$("txt3").css({"pointer-events":"none"});
	txt[4] = sym.getSymbol("capMc").$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.getSymbol("capMc").$("txt5").css({"pointer-events":"none"});
	txt[6] = sym.getSymbol("capMc").$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.getSymbol("bodyMc").$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("bodyMc").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.getSymbol("bodyMc").$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.getSymbol("bodyMc").getSymbol("body4Mc").$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.getSymbol("bodyMc").getSymbol("body4Mc").$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.getSymbol("bodyMc").getSymbol("body4Mc").$("txt12").css({"pointer-events":"none"});
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: xmlNo,
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
			bodyTxt = $(xml).find('txt7').text();
			bodyTxttxt.html(bodyTxt);
	
			//create array from xml, put it into array of text elements
			for (var i=0; i<13; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			}
	
			sym.getSymbol("bodyMc").$("body4Mc").animate({top:0 + sym.getSymbol("bodyMc").$("txt9").height()+15}, 0);
		}
	}); // END XML
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.
	
	for (var h = 0; h < 3; h++){
		var menuBtnSymbols = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}
	
	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.bind ("click", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("touchstart", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
	})
	
	function resetmenu(){
		for (var s=0;s<3; s++){
			sym.getSymbol("bodyMc").$("body" + s).fadeOut(0);
			sym.getSymbol("bodyMc").$("txt" + (s + 7)).fadeOut(0);
		}
	
		for (var h=0; h<menuArray.length; h++){
         menuArray[h].$("btnClick").fadeOut(0);
         menuArray[h].$("btnOver").fadeOut(0);
		}
	}
	resetmenu();
	sym.getSymbol("bodyMc").$("body0").fadeIn(100);
	sym.getSymbol("bodyMc").$("txt7").fadeIn(100);
	sym.getSymbol("bodyMc").$("body4Mc").fadeOut(200);

	function menuBtnClick (e){
		resetmenu(); //set them all back to normal state
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnClick").fadeIn(0);
		sym.getSymbol("bodyMc").$("body" + menuMenu_id).fadeIn(100);
		sym.getSymbol("bodyMc").$("txt" + (menuMenu_id + 7)).fadeIn(100);
		if (menuMenu_id==2) {
			sym.getSymbol("bodyMc").$("body4Mc").fadeIn(300);
		}else{
			sym.getSymbol("bodyMc").$("body4Mc").fadeOut(200);
		}
	}

	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeIn(0);
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeOut(0);
	}

// MAKE MENU 0 VISIBLE
sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("btnClick").fadeIn(0);

// REPLAY BTN
sym.getSymbol("capMc").$("replayBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	sym.getSymbol("capMc").play(1);
	});
sym.getSymbol("capMc").$("replayBtn").mouseover(function(){
	sym.getSymbol("capMc").getSymbol("replayBtn").$("btnIcon").animate({opacity:1}, 0);
	});
sym.getSymbol("capMc").$("replayBtn").mouseout(function(){
	sym.getSymbol("capMc").getSymbol("replayBtn").$("btnIcon").animate({opacity:0.5}, 0);
	});


         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'capMc'
   (function(symbolName) {   
   
   })("capMc");
   //Edge symbol end:'capMc'

   //=========================================================
   
   //Edge symbol: 'bodymc'
   (function(symbolName) {   
   
   })("bodymc");
   //Edge symbol end:'bodymc'

   //=========================================================
   
   //Edge symbol: 'body4Mc'
   (function(symbolName) {   
   
   })("body4Mc");
   //Edge symbol end:'body4Mc'

})(jQuery, AdobeEdge, "GNews31666");