/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	for (var i=0;i<2; i++){
		sym.getSymbol("styleHead").getSymbol("menuBtn"+i).$("menuIcon").attr("src", "images/menuIcon" + i + ".png");
	}
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	var txt=[];
	txt[0] = sym.$("txt0").css("pointer-events","none");
	txt[1] = sym.$("txt1").css("pointer-events","none");
	txt[2] = sym.$("txt2").css("pointer-events","none");
	txt[3] = sym.$("txt3").css("pointer-events","none");
	txt[4] = sym.$("txt4").css("pointer-events","none");
	txt[5] = sym.$("txt5").css("pointer-events","none");
	txt[6] = sym.$("txt6").css("pointer-events","none");
	txt[7] = sym.$("txt7").css({"background-color":"rgba(255,255,255,.5)","padding":"0px"});
	txt[8] = sym.$("txt8").css("pointer-events","none");
	txt[9] = sym.$("txt9").css("pointer-events","none");
	txt[10] = sym.getSymbol("pointersMc").$("txt10").css("pointer-events","none");
	txt[11] = sym.$("txt11").css("pointer-events","none");
	txt[12] = sym.$("txt12").css("pointer-events","none");
	txt[13] = sym.$("txt13").css("pointer-events","none");
	txt[14] = sym.getSymbol("pointersMc").$("txt14").css("pointer-events","none");
	txt[15] = sym.getSymbol("pointersMc").$("txt15").css("pointer-events","none");
	txt[16] = sym.getSymbol("pointersMc").$("txt16").css("pointer-events","none");
	txt[17] = sym.$("txt17").css("pointer-events","none");
	txt[18] = sym.$("txt18").css("pointer-events","none");
	txt[19] = sym.$("txt19").css("pointer-events","none");
	txt[20] = sym.getSymbol("graphMc").$("txt20").css("pointer-events","none");
	txt[21] = sym.getSymbol("graphMc").$("txt21").css("pointer-events","none");
	txt[22] = sym.getSymbol("graphMc").$("txt22").css("pointer-events","none");
	txt[23] = sym.getSymbol("graphMc").$("txt23").css("pointer-events","none");
	txt[24] = sym.getSymbol("graphMc").$("txt24").css("pointer-events","none");
	txt[25] = sym.getSymbol("graphMc").$("txt25").css({"background-color":"rgba(255,255,255,1)","padding":"5px"});
	txt[26] = sym.getSymbol("graphMc").$("txt26").css({"background-color":"rgba(255,255,255,1)","padding":"5px"});
	txt[27] = sym.getSymbol("graphMc").$("txt27").css("pointer-events","none");
	txt[28] = sym.getSymbol("graphMc").$("txt28").css("pointer-events","none");
	txt[29] = sym.getSymbol("graphMc").$("txt29").css("pointer-events","none");
	txt[30] = sym.getSymbol("graphMc").$("txt30").css("pointer-events","none");
	txt[31] = sym.getSymbol("graphMc").$("txt31").css("pointer-events","none");
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN31583.xml",
		dataType: "xml",
		success: function(xml) {
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			stand = $(xml).find('stand').text();
			standtxt.html(stand);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			//create array from xml, put it into array of text elements
			for (var i=0; i<32; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			}	
		}
	}); // END XML
	
	sym.$("graphMc").fadeOut(0);
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.
	
	for (var h = 0; h < 2; h++){
		var menuBtnSymbols = sym.getSymbol("styleHead").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}
	
	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.bind ("click", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("touchstart", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
	})
	
	function resetmenu(){
		for (var h=0; h<menuArray.length; h++){
			var resetmenu_arr = ["menuTxt0","menuTxt1"];
			$.each(resetmenu_arr, function(index, value) {
			sym.getSymbol("styleHead").$(value).fadeOut(0);
			});
         menuArray[h].$("btnClick").fadeOut(0);
         menuArray[h].$("btnOver").fadeOut(0);
		}
	}
	resetmenu();

	function menuBtnClick (e){
		resetmenu(); //set them all back to normal state
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("styleHead").getSymbol("menuBtn" + menuMenu_id).$("btnClick").fadeIn(0);
		sym.getSymbol("styleHead").$("menuTxt" + menuMenu_id).fadeIn(0);
		if (menuMenu_id==0) {
			sym.$("graphMc").fadeOut(500);
		}
		if (menuMenu_id==1) {
			sym.getSymbol("graphMc").play(1);
			sym.$("graphMc").fadeIn(500);
		}
	}
	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		sym.getSymbol("styleHead").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeIn(0);
		sym.getSymbol("styleHead").$("menuTxt" + menuMenu_id).fadeIn(0);
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
		sym.getSymbol("styleHead").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeOut(0);
		sym.getSymbol("styleHead").$("menuTxt" + menuMenu_id).fadeOut(0);
	}

// MAKE MENU 0 VISIBLE
	sym.getSymbol("styleHead").getSymbol("menuBtn0").$("btnClick").fadeIn(0);

	sym.getSymbol("btnGreen").$("btnRndOut").fadeOut(0);
	sym.getSymbol("btnRed").$("btnRndOutGreen").fadeOut(0);
	sym.$("redZone").fadeOut(0);
	sym.$("greenZone").fadeOut(0);


	var red = 0;
	sym.$("btnRed").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	if (red == 0){
		sym.$("redZone").stop().fadeIn(500);
		sym.getSymbol("btnRed").$("btnPlus").fadeOut(200);
		red = 1;
	}else{
		sym.$("redZone").stop().fadeOut(500);
		sym.getSymbol("btnRed").$("btnPlus").fadeIn(200);
		red = 0;
	}
	});
sym.$("btnRed").mouseover(function(){
	sym.getSymbol("btnRed").$("btnRndOut").fadeOut(200);
	});
sym.$("btnRed").mouseout(function(){
	sym.getSymbol("btnRed").$("btnRndOut").fadeIn(200);
	});

	var Green = 0;
	sym.$("btnGreen").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	if (Green == 0){
		sym.$("greenZone").stop().fadeIn(500);
		sym.getSymbol("btnGreen").$("btnPlus").fadeOut(200);
		Green = 1;
	}else{
		sym.$("greenZone").stop().fadeOut(500);
		sym.getSymbol("btnGreen").$("btnPlus").fadeIn(200);
		Green = 0;
	}
	});
sym.$("btnGreen").mouseover(function(){
	sym.getSymbol("btnGreen").$("btnRndOutGreen").fadeOut(200);
	});
sym.$("btnGreen").mouseout(function(){
	sym.getSymbol("btnGreen").$("btnRndOutGreen").fadeIn(200);
	});

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'btnRnd'
   (function(symbolName) {   
   
   })("btnRnd");
   //Edge symbol end:'btnRnd'

   //=========================================================
   
   //Edge symbol: 'btnRect'
   (function(symbolName) {   
   
   })("btnRect");
   //Edge symbol end:'btnRect'

   //=========================================================
   
   //Edge symbol: 'btn'
   (function(symbolName) {   
   
   })("btn");
   //Edge symbol end:'btn'

   //=========================================================
   
   //Edge symbol: 'pointersMc'
   (function(symbolName) {   
   
   })("pointersMc");
   //Edge symbol end:'pointersMc'

   //=========================================================
   
   //Edge symbol: 'graphMc'
   (function(symbolName) {   
   
   })("graphMc");
   //Edge symbol end:'graphMc'

})(jQuery, AdobeEdge, "GraphicNews31583");