/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var btnGrey = "#5a5a5a";
	var btnRed = "#da0000";
	var mainPic = sym.$("imageMain");
	
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	//Array of menu text objects
	var menuTxt=[];
	for (var m=0; m<4; m++){
	menuTxt[m] = sym.getSymbol("btns").getSymbol("menuBtn"+m).$("txt").css("pointer-events","none");
	}
	var menuTxtArr=[];		
	//Array of other text objects
	var txt=[];
	for (var i=0; i<8; i++){
	txt[i] = sym.$("txt"+i).css("pointer-events","none");
	}
	txt[8] = sym.$("txt8").css({"background-color":"rgba(220,220,220,1)","border-radius":"3px","padding":"3px"});
	for (var j=9; j<18; j++){
	txt[j] = sym.getSymbol("pieMc").$("txt"+j).css("pointer-events","none");
	}
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN31575.xml",
		dataType: "xml",
		success: function(xml) {
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
			//create array from xml, put it into array of text elements
			for (var m=0; m<4; m++){
			menuTxtArr[m]=$(xml).find('menuTxt'+m).text();
			menuTxt[m].html(menuTxtArr[m]);
			}
			//create array from xml, put it into array of text elements
			for (var i=0; i<18; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
	
			sym.$("txt0").empty();
			var st1 = "<div style='float:left; background-color:rgba(255,255,255,1); padding-left:6px; padding-right:6px; padding-top:2px; padding-bottom:8px'>"+txtArr[0] + 
			"</div><div style='float:left; background-color:rgba(204,214,234,1); padding-left:6px; padding-right:6px; padding-top:6px; padding-bottom:2px'>" + txtArr[4]+"</div>";
			sym.$("txt0").append(st1);
			}
		}
	}); // END XML
	
	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.
	
	for (var h = 0; h < 4; h++){
		var menuBtnSymbols = sym.getSymbol("btns").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}
	
	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.bind ("click", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("touchstart", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
	})
	
	function resetmenu(){
		for (var h=0; h<menuArray.length; h++){
         menuArray[h].$("btnClick").fadeOut(0);
		}
	}
	resetmenu();

	function menuBtnClick (e){
		resetmenu(); //set them all back to normal state
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("btns").getSymbol("menuBtn" + menuMenu_id).$("btnClick").fadeIn(0);
		mainPic.attr("src", "images/headShot" + menuMenu_id + ".jpg");
		sym.$("txt0").empty();
	if (menuMenu_id == 2) {
		sym.$("imageMain").css("width","210");
		var st1 = "<div style='float:left; background-color:rgba(204,214,234,1); padding-left:6px; padding-right:6px; padding-top:6px; padding-bottom:2px'>" + txtArr[menuMenu_id+4]+"</div>";
		sym.$("txt0").append(st1);
		sym.$("txt0").animate ({left:405, top:50, width:190, height:160}, 0);
	}else{
		var st1 = "<div style='float:left; background-color:rgba(255,255,255,1); padding-left:6px; padding-right:6px; padding-top:2px; padding-bottom:8px'>"+txtArr[menuMenu_id] + 
		"</div><div style='float:left; background-color:rgba(204,214,234,1); padding-left:6px; padding-right:6px; padding-top:6px; padding-bottom:2px'>" + txtArr[menuMenu_id+4]+"</div>";
		sym.$("txt0").append(st1);
		sym.$("imageMain").css("width","130");
		sym.$("txt0").animate ({left:325, top:47, width:270, height:160}, 0);
	}
	}
	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		sym.getSymbol("btns").getSymbol("menuBtn" + menuMenu_id).$("btnOver").css("backgroundColor",btnRed);
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
		sym.getSymbol("btns").getSymbol("menuBtn" + menuMenu_id).$("btnOver").css("backgroundColor",btnGrey);
	}

// MAKE MENU 0 VISIBLE
	sym.getSymbol("btns").getSymbol("menuBtn0").$("btnClick").fadeIn(0);


         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'btnRnd'
   (function(symbolName) {   
   
   })("btnRnd");
   //Edge symbol end:'btnRnd'

   //=========================================================
   
   //Edge symbol: 'btnRect'
   (function(symbolName) {   
   
   })("btnRect");
   //Edge symbol end:'btnRect'

   //=========================================================
   
   //Edge symbol: 'btn'
   (function(symbolName) {   
   
   })("btn");
   //Edge symbol end:'btn'

   //=========================================================
   
   //Edge symbol: 'btns'
   (function(symbolName) {   
   
   })("btns");
   //Edge symbol end:'btns'

   //=========================================================
   
   //Edge symbol: 'pieMc'
   (function(symbolName) {   
   
   })("pieMc");
   //Edge symbol end:'pieMc'

})(jQuery, AdobeEdge, "GraphicNews31575");