/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var stand;
	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	
	//create array of text elements
	var txt=[];
	txt[0] = sym.getSymbol("textLayer").$("txt0").css("pointer-events","none");
	txt[1] = sym.getSymbol("textLayer").$("txt1").css("pointer-events","none");
	txt[2] = sym.getSymbol("textLayer").$("txt2").css("pointer-events","none");
	txt[3] = sym.getSymbol("textLayer").$("txt3").css("pointer-events","none");
	txt[4] = sym.getSymbol("textLayer").$("txt4").css("pointer-events","none");
	txt[5] = sym.getSymbol("textLayer").$("txt5").css("pointer-events","none");
	txt[6] = sym.getSymbol("textLayer").$("txt6").css({"border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)","background-color":"rgba(0,0,0,1)","border-radius":"8px","padding":"6px"});
	txt[7] = sym.getSymbol("textLayer").$("txt7").css("pointer-events","none");
	txt[8] = sym.$("txt8").css("pointer-events","none");
	txt[9] = sym.getSymbol("textLayer").$("txt9").css("pointer-events","none");
	txt[10] = sym.getSymbol("textLayer").$("txt10").css("pointer-events","none");
	txt[11] = sym.getSymbol("textLayer").$("txt11").css("pointer-events","none");
	txt[12] = sym.getSymbol("textLayer").$("txt12").css("pointer-events","none");
	txt[13] = sym.getSymbol("textLayer").$("txt13").css("pointer-events","none");
	txt[14] = sym.getSymbol("textLayer").$("txt14").css("pointer-events","none");
	txt[15] = sym.getSymbol("textLayer").$("txt15").css("pointer-events","none");
	txt[16] = sym.getSymbol("textLayer").$("txt16").css("pointer-events","none");
	txt[17] = sym.getSymbol("textLayer").$("txt17").css("pointer-events","none");
	txt[18] = sym.getSymbol("textLayer").$("txt18").css("pointer-events","none");
	txt[19] = sym.getSymbol("textLayer").$("txt19").css("pointer-events","none");
	txt[20] = sym.getSymbol("textLayer").$("txt20").css("pointer-events","none");
	txt[21] = sym.getSymbol("textLayer").$("txt21").css("pointer-events","none");
	txt[22] = sym.$("txt22").css("pointer-events","none");
	txt[23] = sym.$("txt23").css("pointer-events","none");
	txt[24] = sym.getSymbol("finishMc").$("txt24").css({"border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)","background-color":"rgba(0,0,0,1)","border-radius":"8px","padding":"6px"});
	txt[25] = sym.getSymbol("textLayer").$("txt25").css({"border-width":"1px","border-style":"solid","border-color":"rgba(0,0,0,1)","background-color":"rgba(255,255,255,1)","border-radius":"1px","padding":"6px","padding-right":"28px"});
	txt[26] = sym.getSymbol("startMc").$("txt26").css({"border-width":"1px","border-style":"solid","border-color":"rgba(255,255,255,1)","background-color":"rgba(0,0,0,1)","border-radius":"8px","padding":"20px"});
	txt[27] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt27").css("pointer-events","none");
	txt[28] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt28").css("pointer-events","none");
	txt[29] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt29").css("pointer-events","none");
	txt[30] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt30").css("pointer-events","none");
	txt[31] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt31").css("pointer-events","none");
	txt[32] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt32").css("pointer-events","none");
	txt[33] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt33").css("pointer-events","none");
	txt[34] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt34").css("pointer-events","none");
	txt[35] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt35").css("pointer-events","none");
	txt[36] = sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("txt36").css("pointer-events","none");
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN31459.xml",
		dataType: "xml",
		success: function(xml) {
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
	
			//create array from xml, put it into array of text elements
			for (var i=0; i<37; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			}
			sym.getSymbol("textLayer").$("txt3").animate({left:380 - sym.getSymbol("textLayer").$("txt3").width()+6}, 0);
			sym.getSymbol("textLayer").$("txt10").animate({left:174 - sym.getSymbol("textLayer").$("txt10").width()+6}, 0);
			sym.getSymbol("textLayer").$("txt12").animate({left:174 - sym.getSymbol("textLayer").$("txt12").width()+6}, 0);
			sym.getSymbol("finishMc").$("txt24").animate({left:25 - sym.getSymbol("finishMc").$("txt24").width()/2+2}, 0);
			sym.getSymbol("finishMc").$("txt25").animate({width:1 + sym.getSymbol("finishMc").$("txt25").width()+100}, 0);
		}
	}); // END XML
	
	// BUTTONS TIME
	sym.getSymbol("timeBtn").$("btnClick").fadeOut(0);
	var btnClicked = 0;
	
	sym.$("timeBtn").on('touchstart click', function(e){
		e.stopPropagation(); e.preventDefault();
		btnClick();
		});
	sym.$("timeBtn").mouseover(function(){
		sym.getSymbol("timeBtn").$("btnOver").fadeOut(200);
		});
	sym.$("timeBtn").mouseout(function(){
		sym.getSymbol("timeBtn").$("btnOver").fadeIn(200);
		});
	
	// BUTTON UP
	var upClicked = 0;
	
	sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("upBtn").on('touchstart click', function(e){
		e.stopPropagation(); e.preventDefault();
		btnClick();
		});
	sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("upBtn").mouseover(function(){
		sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("upBtn").$("btnOver").fadeOut(200);
		});
	sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("upBtn").mouseout(function(){
		sym.getSymbol("winnersMc").getSymbol("winnersCrop").$("upBtn").$("btnOver").fadeIn(200);
		});
	
	sym.$("winnersMc").stop().animate ({top:-600}, 0);
	
	function btnClick(){
		if (btnClicked == 0){
			sym.$("winnersMc").stop().animate ({top:1}, 1000, 'easeOutCubic');
			btnClicked = 1;
		}else{
			sym.$("winnersMc").stop().animate ({top:-600}, 2000, 'easeOutCubic');
			btnClicked = 0;
		}
	}
	
	
	
	
	
	
	

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      

      

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         sym.$("km").text((pos / 1000).toFixed(2));

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 42360, function(sym, e) {
         sym.$("startMc").hide();

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleMc'
   (function(symbolName) {   
   
   })("styleMc");
   //Edge symbol end:'styleMc'

//=========================================================
   //Edge symbol: 'TimelineControler'
   (function(symbolName) {

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // flag of use keyboard event.
         
         var useKeyBoardEvent = true;

         // key code of right/left key

         var KEY_RIGHT = 39;

         var KEY_LEFT =  37;

         // params

         var power = 1.5;

         var declineRate = 0.5;

         var speedWidth = 30;

         
         // try to hide the location bar at Safari,if need, comment out it. 

         // setTimeout(function() { window.scrollTo(0, 0); }, 250);

         
         var fps = 60;

         var interval = (1000/fps)|0;

         var speed = 0;

         var isKeyPress = false, isMousePress = false;

         
         var centerX,target,v;

         
         if(useKeyBoardEvent)$(window).bind("keydown",onStartControll).bind("keyup",onStopControll);  

         
         var el = $(sym.getSymbolElement());

         el.mousedown(onStartControll)

           .mouseup(onStopControll)

           .mouseout(onStopControll)

           .mousemove(onMouseMove)

           .bind("touchstart",onStartControll)

           .bind("touchmove",onMouseMove)

           .bind("touchend",onStopControll);

         
         function onStartControll(evt){
         
           evt.preventDefault();

           target = sym.getParentSymbol();

           centerX = el.offset().left+el.width()/2;

           if(evt.type=="keydown" && isKeyPress===false){

             speed = 

               (evt.which==KEY_RIGHT)*interval*power

                  + (evt.which==KEY_LEFT)*interval*-1*power;

             speed|=0;

             isKeyPress = true;
           }else if(evt.type=="mousedown" || evt.type=="touchstart"){

             isMousePress = true;
           }

           if(v===undefined)v=setInterval(onControll,interval);
         }

         function onStopControll(evt){
     
           if(evt.type=="keyup"){

             isKeyPress = false;
           }else{

             isMousePress = false;
           }
         }

         function onControll(){

           if(isKeyPress===false && isMousePress===false){

             speed = (speed*declineRate)|0;

             if(-1<speed && speed<1){

               clearInterval(v);

               v = undefined;

             }

           }

           var n = target.getPosition()+speed;

           if(-1<n && n<=target.getDuration())target.stop(n);
         }

         function onMouseMove(evt){

           evt.preventDefault();

           evt = (evt.originalEvent.touches && evt.originalEvent.touches[0]) || evt;

           if(isMousePress===true){

             speed = (((evt.clientX - centerX)/speedWidth)*power*interval)|0;

           }
         }

         

      });
      //Edge binding end

   })("TimelineController");
   //Edge symbol end:'TimelineController'

   //=========================================================
   
   //Edge symbol: 'textLayer'
   (function(symbolName) {   
   
   })("textLayer");
   //Edge symbol end:'textLayer'

   //=========================================================
   
   //Edge symbol: 'finishMc'
   (function(symbolName) {   
   
   })("finishMc");
   //Edge symbol end:'finishMc'

   //=========================================================
   
   //Edge symbol: 'startMc'
   (function(symbolName) {   
   
   })("startMc");
   //Edge symbol end:'startMc'

   //=========================================================
   
   //Edge symbol: 'courseMc'
   (function(symbolName) {   
   
   })("courseMc");
   //Edge symbol end:'courseMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================
   
   //Edge symbol: 'winnersMc'
   (function(symbolName) {   
   
   })("winnersMc");
   //Edge symbol end:'winnersMc'

   //=========================================================
   
   //Edge symbol: 'downBtn'
   (function(symbolName) {   
   
   })("downBtn");
   //Edge symbol end:'downBtn'

   //=========================================================
   
   //Edge symbol: 'winnersCrop'
   (function(symbolName) {   
   
   })("winnersCrop");
   //Edge symbol end:'winnersCrop'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(jQuery, AdobeEdge, "GraphicNews31459");