/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //Text & other variables
         var headline;
         var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt");
         var source;
         var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt");
         var menutxt= sym.getSymbol("styleHead").$("menuTxt");
         
         //UNCOMMENT THE FOLLOWING TO USE MULTIPLE CAPTIONS IN AN ARRAY.  
         var captionArr=[];  
         captionArr[0]=sym.getSymbol("schedule").$("capTxt0");
         captionArr[1]=sym.getSymbol("schedule").$("capTxt1");
         captionArr[2]=sym.getSymbol("schedule").$("capTxt2");
         captionArr[3]=sym.getSymbol("medalMc").$("capTxt3");
         captionArr[4]=sym.getSymbol("medalMc").getSymbol("medalspin").$("capTxt4");
         captionArr[5]=sym.getSymbol("medalMc").getSymbol("medalspin").$("capTxt5");
         captionArr[6]=sym.getSymbol("medalMc").getSymbol("medalspin").$("capTxt6");
         captionArr[7]=sym.getSymbol("medalMc").getSymbol("medalspin").$("capTxt7");
         captionArr[8]=sym.getSymbol("medaltable").$("capTxt8");
         captionArr[9]=sym.getSymbol("medaltable").$("capTxt9");
         captionArr[10]=sym.getSymbol("medaltable").$("capTxt10");
         captionArr[11]=sym.getSymbol("schedKey").$("capTxt11");
         captionArr[12]=sym.getSymbol("schedKey").$("capTxt12");
         var medalalert;
         var cap12;
         var cap13;
         var xmlCaptions=[]; //to create array of xml captions
         var eventCaps=[];
         var menuCaps = [];
         var months=[];
         var countryCaps=[];
         //array for each sport
         var alpineCaps=[];
         var skijumpCaps=[];
         var nordicCaps=[];
         var biathlonCaps=[];
         var xcountryCaps=[];
         var freestyleCaps=[];
         var boardCaps=[];
         var hockeyCaps=[];
         var speedCaps=[];
         var shortCaps=[];
         var figureCaps=[];
         var curlingCaps=[];
         var bobCaps=[];
         var skelCaps=[];
         var lugeCaps=[];
         
         function setCaps(){
         $.ajax({	
         	type: "GET",
         	url: "GN31160.xml",
         	dataType: "xml",
         	success: function(xml) {
         		headline=$(xml).find("headline").text();
         		headlinetxt.html(headline);
         		source=$(xml).find("sources").text();
         		sourcetxt.html(source);
         		menuCaps[0]=$(xml).find("menu0").text();
         		menuCaps[1]=$(xml).find("menu1").text();
         		menutxt.html(menuCaps[0]);
         		var monthstring = $(xml).find('months').text();
         		months=monthstring.split(";");
         	//TO PLACE XML CAPTIONS WITHIN TEXT BOXES FROM CAPTION ARRAY
         	for (var i=0; i<captionArr.length; i++){
         		xmlCaptions[i]= $(xml).find("cap"+i).text();
              	captionArr[i].html(xmlCaptions[i]);
         		}
         		medalalert=$(xml).find("caption11").text();
         		cap12=$(xml).find("caption12").text();
         		cap13=$(xml).find("caption13").text();
         	for (var e=0; e<23; e++){
         		eventCaps[e]= $(xml).find("event"+e).text();
         		}
         	for (var c=0; c<95; c++){
         		countryCaps[c]= $(xml).find("country"+c).text();
         		}
         		var alpineString= $(xml).find('alpine').text();
         		alpineCaps=alpineString.split(";");
         		var skijumpString= $(xml).find('skijump').text();
         		skijumpCaps=skijumpString.split(";");
         		var nordicString= $(xml).find('nordic').text();
         		nordicCaps=nordicString.split(";");
         		var biathlonString= $(xml).find('biathlon').text();
         		biathlonCaps=biathlonString.split(";");
         		var xcountryString= $(xml).find('xcountry').text();
         		xcountryCaps=xcountryString.split(";");
         		var freestyleString= $(xml).find('freestyle').text();
         		freestyleCaps=freestyleString.split(";");
         		var boardString= $(xml).find('snowboard').text();
         		boardCaps=boardString.split(";");
         		var hockeyString= $(xml).find('hockey').text();
         		hockeyCaps=hockeyString.split(";");
         		var speedString= $(xml).find('speed').text();
         		speedCaps=speedString.split(";");
         		var shortString= $(xml).find('short').text();
         		shortCaps=shortString.split(";");
         		var figureString= $(xml).find('figure').text();
         		figureCaps=figureString.split(";");
         		var curlingString= $(xml).find('curling').text();
         		curlingCaps=curlingString.split(";");
         		var bobString= $(xml).find('bob').text();
         		bobCaps=bobString.split(";");
         		var skelString= $(xml).find('skeleton').text();
         		skelCaps=skelString.split(";");
         		var lugeString= $(xml).find('luge').text();
         		lugeCaps=lugeString.split(";");
         		}
         	});
         }
         setCaps();
         //DATE FUNCTIONS ----------------------
         
         var d=new Date();
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     var thisDate = new Date(parseInt(dateTxt, 10));
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         }
         
         var oneday = 1000*60*60*24;
         //var startDate = new Date("February 6, 2014");
         var startDate = new Date("February 8 2014 13:55:00 GMT+0000 (GMT)"); //first medals awarded Sat Feb 8 2014 13:55:00 GMT+0000 (GMT)
         var olyDate = new Date();
         var endDate = new Date("February 23, 2014");
         var endTime = endDate.getTime();
         var startTime = startDate.getTime();
         var olyTime = olyDate.getTime();
         
         function schedLines(){
         	for(var i=0;i<12;i++){
         		sym.getSymbol("schedule").$("lines"+i).css({"border-width":"1px 0px"});
         	}
         }
         schedLines();
         sym.getSymbol("medalMc").$("medalspin").on("click",spinMedal);
         sym.getSymbol("medalMc").$("medalspin").css({'cursor':'pointer'});
         function spinMedal(){
         	sym.getSymbol("medalMc").getSymbol("medalspin").play();
         }
         
         // LIVE MEDAL TABLE DATA FUNCTIONS
         var countries=[74,20,155,24,213,157,151,214,116,103,147,260,78,16,148,159,119,219,26,31,12,168,89,80,17,152,8,222,161,144,163,2,83,211,171,38,28,226,227,87,19,29,6,248,18,160,229,124,9,90,167,7,231,156,23,22,173,3679,172,274,1,158,94,153,236,174,130,150,10,164,146,175,165,239,107,14,30,178,106,145,154,149,132,33,13,5,15,162,241,72,73,197,242,11,3]
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         function getMedals(medalPeriod) { 
         var alltimeData;
         $.ajax({ type: "GET", url: dataURL,
                         data: "type=olympics&yr=2014&gn=31160&q="+medalPeriod,
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
                        alltimeData = data;
                        if (alltimeData.length==0){
                          sym.getSymbol("medaltable").$("table").empty();
                          sym.getSymbol("medaltable").$('table').append(medalalert);
                        }else{
                        sym.getSymbol("medaltable").$("table").empty();
         					var imgHTML;
                        for (var i = 0; i < alltimeData.length; i++) {
         						if (i%2 == 0){
         							var tableTxt = "<div class='medalrow even'>";
         						}else{
         							var tableTxt = "<div class='medalrow odd'>";
         						}
         						tableTxt += "<div class='rank' id='rank_a" + i + "'></div><div class='flag' width='25px' id='flag_a" + i + "'></div><div class='country' id='country_a" + i + "'></div>";
         						tableTxt += "<div class='gold' id ='gold_a" + i + "'></div><div class='silver' id='silver_a" + i + "'></div><div class='bronze' id='bronze_a" + i + "'></div>";
         						tableTxt += "<div class='medaltotal' id='total_a" + i + "'></div></div>";
         						sym.getSymbol("medaltable").$("table").append(tableTxt);
         						var NOCID=alltimeData[i].n_NOCID;
         						var countryName;
         						for(var c=0;c<95;c++){
         							if (NOCID==countries[c]){
         								countryName=countryCaps[c];
         							}
         						}
         						$('#rank_a' + i).text(alltimeData[i].n_RankGold);
         						$('#country_a' + i).text(countryName);
         						$('#gold_a' + i).text(alltimeData[i].n_Gold);
         						$('#silver_a' + i).text(alltimeData[i].n_Silver);
         						$('#bronze_a' + i).text(alltimeData[i].n_Bronze);
         						$('#total_a' + i).text(alltimeData[i].n_Total);
         						imgHTML='<img src="flags/'+(alltimeData[i].n_NOCID)+'.png" height="14px" width="24px">';
         						$('#flag_a' + i).html(imgHTML);
         						$(".medalrow").css({'display':'table','width':'100%', 'height':'16px', 'border-top':'1px solid rgb(255,255,255)', 'border-bottom':'1px solid rgb(200,200,200)'});
         						$(".even").css({'font-size':'14px','font-family':'pragmatica-web, sans-serif', 'background':'rgba(114,206,255,0.15)'});
         						$(".odd").css({'font-size':'14px','font-family':'pragmatica-web, sans-serif'});
         						$(".rank").css({'display':'table-cell', 'text-align':'right', 'padding-right':'5px','width':'5%'});
         						$(".gold,.silver,.bronze").css({'display':'table-cell', 'font-size':'12px','text-align':'right','width':'9%','font-style':'oblique'});
         						$(".gold").css({'font-weight':700});
         						$(".flag").css({'display':'table-cell','width':'10%', 'padding-left':'10px', 'padding-top':'3px'});
         						$(".country").css({'display':'table-cell','width':'40%'});
         						$(".medaltotal").css({'display':'table-cell', 'font-weight':'bold', 'text-align':'right', 'padding-right':'18px','width':'18%'});
                           }
                           } 
                        }
         
         	});
         }
         
         // MENU BUTTONS --------------------------------------------	
         var menuArray = []; //the array that will hold references to the buttons.
         var btnImg;
         for (var m = 0; m < 2; m++){
         	btnImg=sym.getSymbol("styleHead").getSymbol("menuBtn"+m).$("btnimg");
         	btnImg.attr('src',"images/btn"+m+".png");
            var menuBtnSymbols = sym.getSymbol("styleHead").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
            menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
            menuArray.push(menuBtnSymbols); //push it into the array
         }
         $.each(menuArray, function( count, menuInTheArray ){ //loop through the newly populated array
            var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
            var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         	menuBtnElement.on("click", {menuId:count}, menuBtnClick);
            menuBtnElement.on("mouseover", {menuId:count}, menuShow);
            menuBtnElement.on("mouseout", {menuId:count}, menuHide);
            menuBtnElement.css({'cursor':'pointer'});
         });
         function resetmenu(){
         	sym.getSymbol('styleHead').$('menuTxt').fadeOut(0);
         	for (var m = 0; m < 2; m++){		
         		menuArray[m].$("btnOn").fadeOut(0);
         	}
         }
         resetmenu();
         function menuBtnClick (e){
         	resetmenu(); //set them all back to normal state
         	var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         	sym.getSymbol('styleHead').getSymbol("menuBtn" + menuMenu_id).$("btnOn").fadeIn(0);
         	for (var m = 0; m < 2; m++){
         		if(m==menuMenu_id){
         			menutxt.html(menuCaps[m]);
         			if(m==0){
         				sym.$('schedule').fadeIn(400);
         				sym.$('schedKey').fadeIn(400);
         				sym.$('medaltable').fadeOut(400);
         				sym.$('eventtable').fadeOut(400);
         				sym.getSymbol('schedule').getSymbol('sportmenu').play();
         			}
         			if(m==1){
         				sym.$('schedule').fadeOut(400);
         				sym.$('schedKey').fadeOut(400);
         				sym.$('medaltable').fadeIn(400);
         				sym.$('eventtable').fadeOut(400);
         				intervalmedalData = setInterval(refreshData,600000);
         				if (olyTime<=startTime){
         					sym.getSymbol('medaltable').$('capTxt9').html(cap12);
         				}
         			}
         		}
         	}
         	sym.$("menuTxt" + menuMenu_id).fadeIn(0);
         }
         function menuShow (e){
                  	var menuMenu_id = (e.data.menuId); //get the id of the over button
                  	sym.$('handMc').hide();
         				sym.getSymbol('styleHead').getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeIn(0);
         				for (var m = 0; m < 2; m++){
         					if(m==menuMenu_id){
         						menutxt.html(menuCaps[m]);
         						}
         				}
         				sym.getSymbol('styleHead').$('menuTxt').fadeIn(0);		
         	}
         function menuHide (e){
                  	var menuMenu_id = (e.data.menuId); //get the id of the out button
         				sym.getSymbol('styleHead').getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeOut(0);
         				sym.getSymbol('styleHead').$('menuTxt').fadeOut(0);		
         	}
         setTimeout(function(){sym.getSymbol('schedule').getSymbol('sportmenu').play();},3000);
         //-----------------------------------------------------------------------
         // MEDAL BUTTONS	
         var medaltab=1;
         var periodArr=['medals','alltime'];
         var clickMedalPeriod = function(x){ //to handle lexical scope
                  	return function (e) {
                  		for (var i=0; i<2; i++){
                  				if (i==x){  
         								getMedals(periodArr[i]);
         								sym.getSymbol('medaltable').$('medalBtn'+i).css({'box-shadow':'2px 12px 2px rgba(0,0,0,0.0)'});
         								sym.getSymbol('medaltable').$('capTxt'+(8+i)).css({'color':'rgb(0,0,0)'});
         								medaltab=i;
                  				}else{
         								sym.getSymbol('medaltable').$('medalBtn'+i).css({'box-shadow':'2px 2px 2px rgba(0,0,0,0.5)'});
         								sym.getSymbol('medaltable').$('capTxt'+(8+i)).css({'color':'rgb(150,150,150)'});
         							}         					
                  		}
                  		e.preventDefault();
                  		e.stopPropagation();
                  	};
         };
         var onMedals = function(x){ //to handle lexical scope
                  	return function (e) {
                  		for (var i=0; i<2; i++){
                  				if (i==x){        				
         								sym.getSymbol('medaltable').$('capTxt'+(8+i)).css({'color':'rgb(0,0,0)'});
                  				}        					
                  		}
                  		e.preventDefault();
                  		e.stopPropagation();
                  	};
         };
         var offMedals = function(x){ //to handle lexical scope
                  	return function (e) {
                  		for (var i=0; i<2; i++){
                  				if (i==x&&i!=medaltab){        				
         								sym.getSymbol('medaltable').$('capTxt'+(8+i)).css({'color':'rgb(150,150,150)'});
                  				}        					
                  		}
                  		e.preventDefault();
                  		e.stopPropagation();
                  	};
         };
         for (var m=0; m<3; m++){
                  	sym.getSymbol('medaltable').$('medalBtn'+m).css({'cursor':'pointer'});
                  	sym.getSymbol('medaltable').$('medalBtn'+m).on('click', clickMedalPeriod(m));
                  	sym.getSymbol('medaltable').$('medalBtn'+m).on('mouseenter', onMedals(m));
                  	sym.getSymbol('medaltable').$('medalBtn'+m).on('mouseleave', offMedals(m));
         }
         //---------------------------------------------------------------
         //Calendar buttons
         var eventIDs =[0,115,215,216,218,220,221,221,221,221,221,222,222,222,222,113,103,302,217,212,213,307,214];
         var eventnames=['ceremony','alpine','skijump','nordic','biathlon','xcountry','aerials','hp','moguls','ss','skix','sbx','sbhp','sbgs','sbss','hockey','speed','short','figure','curling','bob','skeleton','luge'];
         function getEventResults(event){
         	sym.getSymbol('eventtable').$('eventImg').attr('src','sports/'+eventnames[event]+'.png');
         	sym.$('eventtable').fadeIn(400);
         	sym.$('schedule').fadeOut(400);
         	var sportData;
         	//show all-time for each sport and if available Sochi medals
         	if (olyTime>=startTime){
         	 var q="sport";
         	 sym.getSymbol('eventtable').$('eventTxt').html(eventCaps[event]);
         	}else{
         	var q="alltime";
         	sym.getSymbol('eventtable').$('eventTxt').html(cap13+eventCaps[event]);
         	}
         	$.ajax({ type: "GET", url: dataURL,
         		data: "type=olympics&yr=2014&gn=31160&q="+q+eventIDs[event],
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
               crossDomain: true,
               success: function (data) {
               	sym.getSymbol("eventtable").$("table").empty();       
         			sportData=data;
         			if (sportData.length==0){
         				sym.getSymbol("eventtable").$('table').append(medalalert);
         				sym.getSymbol("eventtable").$('medalHd').fadeOut(0);
         			}else{
         				for (var i = 0; i < sportData.length; i++) {
         						if (i%2 == 0){
         							var sportTxt = "<div class='sportrow even'>";
         						}else{
         							var sportTxt = "<div class='sportrow odd'>";
         						}
         						sportTxt += "<div class='rank' id='rank" + eventIDs[event] + "_"+ i + "'></div>";
         						sportTxt += "<div class='flag' id='flag" + eventIDs[event] + "_"+ i + "'></div>";
         						sportTxt += "<div class='country' id='country" + eventIDs[event] + "_"+ i + "'></div>";
         						sportTxt += "<div class='gold' id ='gold" + eventIDs[event] + "_"+ i + "'></div>";
         						sportTxt += "<div class='silver' id='silver" + eventIDs[event] + "_"+ i + "'></div>";
         						sportTxt += "<div class='bronze' id='bronze" + eventIDs[event] + "_"+ i + "'></div>";
         						sportTxt += "<div class='medaltotal' id='total" + eventIDs[event] + "_"+ i +"'></div></div>";
         						sym.getSymbol("eventtable").$("table").append(sportTxt);
         
         						var NOCID=sportData[i].n_NOCID;
         						var countryName;
         						for(var c=0;c<95;c++){
         							if (NOCID==countries[c]){
         								countryName=countryCaps[c];
         							}
         						}
         						$('#rank' + eventIDs[event] + '_' + i).text(sportData[i].n_RankGold);
                           $('#country' + eventIDs[event] + '_'  + i).text(countryName);
                           $('#gold' + eventIDs[event] + '_'  + i).text(sportData[i].n_Gold);
                           $('#silver' + eventIDs[event]+ '_'  + i).text(sportData[i].n_Silver);
                           $('#bronze' + eventIDs[event] + '_'  + i).text(sportData[i].n_Bronze);
                           $('#total' + eventIDs[event] + '_'  + i).text(sportData[i].n_Total);
                           imgHTML='<img src="flags/'+(sportData[i].n_NOCID)+'.png" height="14px" width="24px">';
                           $('#flag' + eventIDs[event] + '_' + i).html(imgHTML);
         
         						$(".sportrow").css({'display':'table','width':'100%', 'height':'16px', 'border-top':'1px solid rgb(255,255,255)', 'border-bottom':'1px solid rgb(200,200,200)'});
         						$(".even").css({'font-size':'14px','font-family':'pragmatica-web, sans-serif', 'background':'rgba(114,206,255,0.15)'});
         						$(".odd").css({'font-size':'14px','font-family':'pragmatica-web, sans-serif'});
         						$(".rank").css({'display':'table-cell', 'text-align':'right', 'padding-right':'5px','width':'5%'});
         						$(".gold,.silver,.bronze").css({'display':'table-cell', 'font-size':'12px','text-align':'right','width':'9%','font-style':'oblique'});
         						$(".gold").css({'font-weight':700});
         						$(".flag").css({'display':'table-cell','width':'10%', 'padding-left':'10px', 'padding-top':'3px'});
         						$(".country").css({'display':'table-cell','width':'40%'});
         						$(".medaltotal").css({'display':'table-cell', 'font-weight':'bold', 'text-align':'right', 'padding-right':'18px','width':'18%'});
         				}	
         				sym.getSymbol("eventtable").$('table').css({'overflow-y':'scroll'});	
         								getEvents(eventIDs[event]); //get results for each event	
         
         			}                           
         		}
            });
         }
         var alpineArr=[9662,9666,9663,9665,11560];
         var skijumpArr=[10055,10054,10059];
         var nordicArr=[12063,12119,11061];
         var biathlonArr=[10082,10076,10079,10081,10084,10080,10085,10075,10078,10784,11397];
         var xcountryArr=[12116,10099,10114,10862,10110,12117,12116,10095,10109,10861,10111];
         var freestyleArr=[10123,10125,12089,14041,14060];
         var boardArr=[10129,10128,10127,10130,12150];
         var hockeyArr=[0,68183,68184];//
         var speedArr=[11184,2,3,5,6,10856,4,11148];
         var shortArr=[10136,10131,10132,10135,10134];
         var figureArr=[10072,10071,10070,12319];
         var curlingArr=[0,68186,68187];
         var bobArr=[10045,10046];
         var skelArr=[10776];
         var lugeArr=[10049,10048,11516];
         
         function getEvents(sport){
         	var sportCaps;
         	var sportarr;
         	if (sport==115){sportCaps=alpineCaps; sportarr=alpineArr;}
         	else if(sport==215){sportCaps=skijumpCaps; sportarr=skijumpArr;}
         	else if(sport==216){sportCaps=nordicCaps; sportarr=nordicArr;}
         	else if(sport==218){sportCaps=biathlonCaps; sportarr=biathlonArr;}
         	else if(sport==220){sportCaps=xcountryCaps; sportarr=xcountryArr;}
         	else if(sport==221){sportCaps=freestyleCaps; sportarr=freestyleArr;}
         	else if(sport==222){sportCaps=boardCaps; sportarr=boardArr;}
         	else if(sport==113){sportCaps=hockeyCaps; sportarr=hockeyArr;}
         	else if(sport==103){sportCaps=speedCaps; sportarr=speedArr;}
         	else if(sport==302){sportCaps=shortCaps; sportarr=shortArr;}
         	else if(sport==217){sportCaps=figureCaps; sportarr=figureArr;}
         	else if(sport==212){sportCaps=curlingCaps; sportarr=curlingArr;}
         	else if(sport==213){sportCaps=bobCaps; sportarr=bobArr;}
         	else if(sport==307){sportCaps=skelCaps; sportarr=skelArr;}
         	else if(sport==214){sportCaps=lugeCaps; sportarr=lugeArr;}
         	$.ajax({ type: "GET", url: dataURL,
         		data: "type=olympics&yr=2014&gn=31160&q=events"+sport,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
               crossDomain: true,
               success: function (data) {
         				eventData=data;
         				for (var i = 0; i < eventData.length; i++) {
         					var phaseData=eventData[i].n_EventPhaseID;
         					if (eventData[i].b_Finished==true){
         						var eventTxt = "<div class='eventtab' id='event" +sport + "_"+ i + "'>";
         						eventTxt += "<div><span class='eventtitle' id='eventtitle"+sport + "_"+ i + "'></span>"
         						eventTxt += "<span class='date' id='date"+sport + "_"+ i + "'></span></div>";
         						eventTxt += "<div class='table'>";
         						eventTxt += "<div class='medalwinners' id='results"+phaseData+"'></div>";
         						eventTxt += "<div class='gender' id='gender" + sport + "_"+ i + "'></div>";
         						eventTxt += "</div></div>";
         						sym.getSymbol("eventtable").$("table").append(eventTxt);
         						getPhase(phaseData);
         					}else{
         						var eventTxt = "<div class='eventtab' id='event" +sport + "_"+ i + "'>";
         						eventTxt += "<div><span class='eventtitle' id='eventtitle"+sport + "_"+ i + "'></span>"
         						eventTxt += "<span class='date' id='date"+sport + "_"+ i + "'></span></div>";
         						eventTxt += "<div class='gender' id='gender" + sport + "_"+ i + "'></div></div>";
         						sym.getSymbol("eventtable").$("table").append(eventTxt);		
         					}
         
         						var eventID=eventData[i].n_EventID;
         						var eventName;
         						for(var c=0;c<sportarr.length;c++){
         							if (eventID==sportarr[c]){
         								eventName=sportCaps[c];
         							}
         						}
         
         					$('#date' + sport + '_' + i).text(getDDmonthYY(eventData[i].d_DateEndLocal));
                        if (eventData[i].b_Finished==true){
         							var imgGender='<img src="images/'+(eventData[i].n_GenderID)+'.png">';
         							$('.date').css({'float':'right'});
         							$('.gender').css({'opacity':'0.4','width':'8%'});
         						}else{
         							var imgGender='<img src="images/'+(eventData[i].n_GenderID)+'.png" height="18px">';
         							$('.date').css({'float':'right', 'padding-right':'14%'});
         							$('.gender').css({'width':'3.5%'});
         					}
         				$('#gender' + sport + '_' + i).html(imgGender);
                     //$('#eventtitle' + sport + '_'  + i).text(eventData[i].c_Event);
         				$('#eventtitle' + sport + '_'  + i).text(eventName);
         				$(".eventtab").css({'display':'table','width':'96%', 'font-size':'13px','font-family':'pragmatica-web, sans-serif', 'border-radius':'8px','border':'1px solid rgb(114,206,255)','background-color':'rgb(228,246,255)', 'margin':'3px 5px','padding':'3px 5px 0px'});	
         				$('.eventtitle').css({'float':'left','font-weight':700});
         				$('.table').css({'display':'table','clear':'both', 'width':'100%'});
         				$(".medalwinners").css({'display':'table-cell','float':'left','width':'100%'});
         				$('.date').css({'float':'right'});
         				$('.gender').css({'display':'table-cell'});
         				//$(".even").css({'background-color':'rgba(114,206,255,0.15)'});
         				}
         		}
         });
         }
         function getPhase(phase){
         $.ajax({ type: "GET", url: dataURL,
         		data: "type=olympics&yr=2014&gn=31160&q=result"+phase,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
               crossDomain: true,
               success: function (data) {
         				phaseData=data;
         				var medalNo=0;
         				var medal=[' ','gold','silver','bronze'];
         				for (var i = 0; i < phaseData.length; i++) {
         					if (phaseData[i].b_MedalGold==true){
         						medalNo=1;					
         					}
         					if(phaseData[i].b_MedalSilver==true){
         						medalNo=2;
         					}
         					if (phaseData[i].b_MedalBronze==true){
         						medalNo=3;
         					}
         					if (phaseData[i].b_MedalGold==true||phaseData[i].b_MedalSilver==true||phaseData[i].b_MedalBronze==true){
         					var resultTxt = "<div class='medalwinner' id='"+medal[medalNo]+phase+"_"+i+"'>";
         					resultTxt +="<div class='resultrank' id='resultrank"+phase+"_"+i+"'></div><div class='resultflag' id='resultflag" + phase + "_"+ i + "'></div>";
         					resultTxt +="<div class='resultname' id='resultname" + phase + "_"+ i + "'></div>";
         					resultTxt +="<div class='resultnation' id ='resultnation" + phase + "_"+ i + "'></div>";
         					resultTxt +="<div class='medal' id='medalimg" + phase + "_"+ i + "'></div></div>";
         					}else{
         					var resultTxt = "";
         					}
         					$('#results'+phase).append(resultTxt);
         					var medalHTML='<img src="images/'+medal[medalNo]+'2.png">';
         					var imgHTML='<img src="flags/'+(phaseData[i].n_NOCID)+'.png" height="14px" width="24px">';
         					$('#resultrank' + phase + '_'  + i).text(phaseData[i].c_Rank);
         					$('#resultname' + phase + '_'  + i).text(phaseData[i].c_Participant);
                        $('#resultnation' + phase + '_'  + i).text(phaseData[i].c_NOCShort);
                        $('#resultflag' + phase + '_' + i).html(imgHTML);
                        $('#medalimg' + phase + '_' + i).html(medalHTML);
         					$(".medalwinner").css({'display':'table','width':'100%', 'padding':'0 0 0 3px', 'height':'18px','border-top':'1px solid rgb(114,206,255)'});
         					$(".medal img").css({'height':'18px'});
                        $(".resultflag").css({'display':'table-cell','width':'10%','padding-left':'15px','padding-top':'3px'});
         					$(".resultnation").css({'display':'table-cell','font-style':'oblique','width':'20%'});
         					$(".resultname").css({'display':'table-cell','width':'65%'});
         					$(".resultrank").css({'display':'table-cell','width':'2%'});
         					$(".medal").css({'display':'table-cell','width':'3%'});
         				}
         		}
         });
         }
         
         sym.getSymbol('eventtable').$('back').on('click',function(){
         	sym.$('eventtable').fadeOut(400);
         	sym.$('schedule').fadeIn(400);
         	});
         var clickEventResults = function(event){ //to handle lexical scope
                  	return function (e) {
                  		getEventResults(event);
                  		clearInterval(intervalmedalData);
                  		for (var i=1; i<23; i++){
         							if (i==event){ 
         								sym.getSymbol('schedule').getSymbol('sportmenu').$('event'+i).attr('src','images/eventsred.png');
                  				}else{
         								sym.getSymbol('schedule').getSymbol('sportmenu').$('event'+i).attr('src','images/eventsbl.png');
         							}         					
                  		}
                  		e.preventDefault();
                  		e.stopPropagation();
                  	};
         };
         var overEvents = function(event){ //to handle lexical scope
                  	return function (e) {
                  		for (var i=1; i<23; i++){
                  				if (eventIDs[i]==event){        				
         								sym.getSymbol('schedule').getSymbol('sportmenu').$('event'+i).attr('src','images/eventsred.png');
                  				}       					
                  		}
                  	};
         };
         var offEvents = function(event){ //to handle lexical scope
                  	return function (e) {
                  		for (var i=1; i<23; i++){
                  				if (eventIDs[i]==event){        				
         								sym.getSymbol('schedule').getSymbol('sportmenu').$('event'+i).attr('src','images/eventsbl.png');
         							}         					
                  		}
                  	};
         };
         for (var c=1; c<23; c++){
                  	sym.getSymbol('schedule').getSymbol('sportmenu').$('event'+c).css({'cursor':'pointer'});
                  	sym.getSymbol('schedule').getSymbol('sportmenu').$('event'+c).on('click', clickEventResults(c));
                  	sym.getSymbol('schedule').getSymbol('sportmenu').$('event'+c).on('mouseenter', overEvents(eventIDs[c]));
                  	sym.getSymbol('schedule').getSymbol('sportmenu').$('event'+c).on('mouseleave', offEvents(eventIDs[c]));
         }
         
         //CONDITIONAL DATES-----------------------------------------------------------------------
         function refreshData(){
         	if (olyTime>endTime){
         	todayTime = endTime;
         	}else{
         	todayTime = olyTime;
         	}
         	if (olyTime>=startTime){
         		getMedals('medals');
         		sym.getSymbol('styleHead').getSymbol("menuBtn1").$("btnOn").fadeIn(0); // MAKE MENU 1 VISIBLE
         		sym.getSymbol('styleHead').getSymbol("menuBtn0").$("btnOn").fadeOut(0); // MAKE MENU 0 INVISIBLE
         		sym.$('schedule').fadeOut(0);
         		sym.$('schedKey').fadeOut(0);
         		sym.$('medaltable').fadeIn(0);  // MEDAL TABLE = DEFAULT VIEW
         		sym.getSymbol('medaltable').$('capTxt8').css({'color':'rgb(0,0,0)'});
         		sym.getSymbol('medaltable').$('capTxt9').css({'color':'rgb(150,150,150)'});
         				sym.$('schedule').fadeOut(400);
         				sym.$('schedKey').fadeOut(400);
         				sym.$('medaltable').fadeIn(400);
         				sym.$('eventtable').fadeOut(400);
         		medaltab=0;
         	}else{
         		getMedals('alltime');
         		sym.getSymbol('styleHead').getSymbol("menuBtn0").$("btnOn").fadeIn(0); // MAKE MENU 0 VISIBLE
         		sym.getSymbol('styleHead').getSymbol("menuBtn1").$("btnOn").fadeOut(0); // MAKE MENU 1 VISIBLE
         		sym.$('schedule').fadeIn(0);  // SCHEDULE = DEFAULT VIEW
         		sym.$('medaltable').fadeOut(0);
         		sym.getSymbol('medaltable').$('capTxt8').hide(); //HIDE SOCHI MEDAL BUTTONS, MOVE ALL-TIME INTO PLACE
         		sym.getSymbol('medaltable').$('medalBtn0').hide();
         		sym.getSymbol('medaltable').$('medalBtn1').css({'left':'0px'}); 
         		sym.getSymbol('medaltable').$('capTxt9').css({'left':'63px','color':'rgb(0,0,0)', 'width':'200px'});
         		medaltab=1;
         	}
         }
         refreshData();
         var intervalmedalData = setInterval(refreshData,600000);
         sym.$('eventtable').fadeOut(0);
         //-----------------------------------------------------------------------
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'medalMc'
   (function(symbolName) {   
   
   })("MedalMc");
   //Edge symbol end:'MedalMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("StyleHead");
   //Edge symbol end:'StyleHead'

   //=========================================================
   
   //Edge symbol: 'Medaltable'
   (function(symbolName) {   
   
   })("Schedule");
   //Edge symbol end:'Schedule'

   //=========================================================
   
   //Edge symbol: 'sportmenu'
   (function(symbolName) {   
   
   })("sportmenu");
   //Edge symbol end:'sportmenu'

   //=========================================================
   
   //Edge symbol: 'MedalSpin'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 450, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 900, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         var medalBg = sym.getParentSymbol().$("goldlg");
         medalBg.animate({width:"0px", left:"122px"},225);
         medalBg.delay(225).fadeOut(0);
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 675, function(sym, e) {
         var medalBg = sym.getParentSymbol().$("goldlg");
         medalBg.fadeIn(100);
         medalBg.animate({width:"245px", left:"0px"},225);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 225, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("MedalSpin");
   //Edge symbol end:'MedalSpin'

   //=========================================================
   
   //Edge symbol: 'MedalTable'
   (function(symbolName) {   
   
   })("MedalTable");
   //Edge symbol end:'MedalTable'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MedalTable_1'
   (function(symbolName) {   
   
      })("EventTable");
   //Edge symbol end:'EventTable'

   //=========================================================
   
   //Edge symbol: 'schedKey'
   (function(symbolName) {   
   
   })("SchedKey");
   //Edge symbol end:'SchedKey'

})(jQuery, AdobeEdge, "GraphicNews31160");