/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	var source2;
	var source2txt = sym.getSymbol("styleBase").$("sourceTxt2").css("pointer-events","none");
	
	//create array of text elements
	var txt=[];
	txt[0] = sym.getSymbol("sliderMc").getSymbol("slideMc0").$("txt0").css("pointer-events","none");
	txt[1] = sym.getSymbol("sliderMc").getSymbol("slideMc1").$("txt1").css("pointer-events","none");
	txt[2] = sym.getSymbol("sliderMc").getSymbol("slideMc1").$("txt2").css("pointer-events","none");
	txt[3] = sym.getSymbol("sliderMc").getSymbol("slideMc2").$("txt3").css("pointer-events","none");
	txt[4] = sym.getSymbol("sliderMc").getSymbol("slideMc3").$("txt4").css("pointer-events","none");
	
	var txtArr=[];
	
	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN30926.xml",
		dataType: "xml",
		success: function(xml) {
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
			source2 = $(xml).find('source2').text();
			source2txt.html(source2);
	
			//create array from xml, put it into array of text elements
			for (var i=0; i<5; i++){
			txtArr[i]=$(xml).find('txt'+i).text();
			txt[i].html(txtArr[i]);
			}
		}
	}); // END XML
	
	var slide = 0; // NUMBER FOR SCENES
	var move = -600; // AMOUNT SCENES SLIDE
	
	// MAKE ELEMENTS INVISIBLE
	sym.$("btnNextMc").animate({opacity: 0}, 0);
	sym.$("btnNextMc").delay(1000).animate({opacity: 1}, 500);
	sym.$("btnBackMc").animate({opacity: 0}, 0);
	
	// POSITION SLIDES
	for (var s=0; s<4; s++){
		sym.getSymbol("sliderMc").$("slideMc" + s).animate({left: -move*s}, 0);
	}
	
	sym.$("btnBackMc").fadeOut(0);
	
	function hideDots() {
		var dot_arr = ["dot0","dot1","dot2","dot3","dot4"];
		$.each(dot_arr, function(index, value) {
		sym.$(value).fadeOut(0);
		});
		sym.$("dot"+slide).fadeIn(0);
	}
	hideDots();	
	
	function showSlides() {
		sym.$("sliderMc").stop().animate ({left:move*slide}, 700, 'easeOutCubic');
		if (slide == 0) {
			sym.$("btnBackMc").fadeOut(0);
		}else{
			sym.$("btnBackMc").fadeIn(0);
		}
		if (slide == 3) {
			sym.$("btnNextMc").fadeOut(0);
		}else{
			sym.$("btnNextMc").fadeIn(0);
		}
		hideDots();
		resetmenu();
		sym.getSymbol("btnsMc").getSymbol("dot"+slide).$("btnClick").fadeIn(0);
		}
	
	// GLASS BUTTON
	sym.$("btnNextMc").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	slide++;
	showSlides();
	});
	sym.$("btnNextMc").mouseover(function(){
	sym.$("btnNextMc").stop().animate({opacity: 1}, 200);
	});
	sym.$("btnNextMc").mouseout(function(){
	sym.$("btnNextMc").stop().animate({opacity: 0}, 0);
	});
	
	sym.$("btnBackMc").on('touchstart click', function(e){
	slide--;
	showSlides();
	});
	sym.$("btnBackMc").mouseover(function(){
	sym.$("btnBackMc").stop().animate({opacity: 1}, 200);
	});
	sym.$("btnBackMc").mouseout(function(){
	sym.$("btnBackMc").stop().animate({opacity: 0}, 0);
	});
	
	
	// MENU BUTTONS --------------------------------------------	
         menuArray = []; //the array that will hold references to the buttons.

         for (var h = 0; h < 4; h++){
         	 // Create an instance element of a symbol as a child of the given parent element
         	 var menuBtnSymbols = sym.getSymbol("btnsMc").getSymbol("dot" +h);
         	 //set the value of a Symbol variable
         	 menuBtnSymbols.setVariable("menuId", h);
         	 //push it into the array
         	 menuArray.push(menuBtnSymbols);
         }

         //a 'for each' loop through the newly populated array.
         $.each(menuArray, function( count, menuInTheArray ){
         	 //create jQuery reference to the item.
         	 var menuBtnItem = $(menuInTheArray); 
         	 //create a jQuery reference to the DIV element inside the symbol.
         	 var menuBtnElement = menuInTheArray.getSymbolElement();
         	 //now you can bind interactivity to the menu items' DIVs
         	 menuBtnElement.bind ("click", {menuId:count}, menuBtnClick);
         	 menuBtnElement.bind ("touchstart", {menuId:count}, menuBtnClick);
         	 menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
         	 menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
         	}
         )

	function resetmenu(){
		for (var h=0; h<menuArray.length; h++){
         	menuArray[h].$("btnClick").fadeOut(0);
         	menuArray[h].$("btnOver").fadeOut(0);
		}
	}
	resetmenu();

	function menuBtnClick (e){
		sym.$("btnNextMc").stop().animate({opacity: 0}, 200);
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("btnsMc").getSymbol("dot" + menuMenu_id).$("btnClick").fadeIn(0);
		slide = menuMenu_id;
		showSlides();
		sym.$("sliderMc").stop().animate ({left:move*menuMenu_id}, 700, function() {
		sym.getSymbol("btnsMc").getSymbol("dot"+menuMenu_id).$("btnClick").fadeIn(0);
	});
	}

	function menuShow (e){
         	var menuMenu_id = (e.data.menuId); //get the id of the over button
         	sym.$("btnNextMc").stop().animate({opacity: 0}, 200);
				sym.getSymbol("btnsMc").getSymbol("dot" + menuMenu_id).$("btnOver").fadeIn(0);
	}
	function menuHide (e){
         	var menuMenu_id = (e.data.menuId); //get the id of the out button
				sym.getSymbol("btnsMc").getSymbol("dot" + menuMenu_id).$("btnOver").fadeOut(0);
	}

// MAKE MENU 0 VISIBLE
	sym.getSymbol("btnsMc").getSymbol("dot0").$("btnClick").fadeIn(0);

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


   })("stage");
   //Edge symbol end:'stage'

//=========================================================
   //Edge symbol: 'handMc'
   (function(symbolName) {

   })("handMc");
   //Edge symbol end:'handMc'

   //=========================================================
   
   //Edge symbol: 'styleMc'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'dot0'
   (function(symbolName) {   
   
   })("dot0");
   //Edge symbol end:'dot0'

   //=========================================================
   
   //Edge symbol: 'btnBackMc'
   (function(symbolName) {   
   
   })("btnBackMc");
   //Edge symbol end:'btnBackMc'

   //=========================================================
   
   //Edge symbol: 'btnNextMc'
   (function(symbolName) {   
   
   })("btnNextMc");
   //Edge symbol end:'btnNextMc'

   //=========================================================
   
   //Edge symbol: 'sliderMc'
   (function(symbolName) {   
   
   })("sliderMc");
   //Edge symbol end:'sliderMc'

   //=========================================================
   
   //Edge symbol: 'slideMc0'
   (function(symbolName) {   
   
   })("slideMc0");
   //Edge symbol end:'slideMc0'

   //=========================================================
   
   //Edge symbol: 'slideMc1'
   (function(symbolName) {   
   
   })("slideMc1");
   //Edge symbol end:'slideMc1'

   //=========================================================
   
   //Edge symbol: 'slimeMc2'
   (function(symbolName) {   
   
   })("slimeMc2");
   //Edge symbol end:'slimeMc2'

   //=========================================================
   
   //Edge symbol: 'slideMc3'
   (function(symbolName) {   
   
   })("slideMc3");
   //Edge symbol end:'slideMc3'

   //=========================================================
   
   //Edge symbol: 'slideMc4'
   (function(symbolName) {   
   
   })("slideMc4");
   //Edge symbol end:'slideMc4'

})(jQuery, AdobeEdge, "GNews30926");