/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         
         // Load Edge Commons 
         yepnope({
         	load:	"http://cdn.edgecommons.org/an/1.0.0/js/min/EdgeCommons.js",
         	complete: function() {
         
         		// Enable SVG access
         		// Watch extended tutorial on YouTube: http://www.youtube.com/watch?v=4UEB6gaLKuw
         		EC.SVG.accessSVG(sym.$("eu")).done(
         			function(svgDocument){
         
         				// add event listener
         				svgDocument.addEventListener("select", function(event) {
         
         					// Remember selected part
         					sym.setVariable("selectedPart", event.target);
         
         					// show the id of the selected part in the textfield
         					sym.$("captionTxt").html( event.target.id );
         				});
         
         		});
         
         	}
         });
         
         //EDIT THE FOLLOWING	NUMBERS
         var thumbWidth=83; //distance between origin of thumbnail images
         var n=40; //number of images
         var thumbs = 9; //number of thumbnails visible at same time
         var space = 83; //pixels offset at beginning of buttonstrip
         var ttime= 500; //transition time in milliseconds
         var RTL="false"; //change true/false to change direction
         //For RTL, the order of the images must also be reversed and the button strip moved so that it starts on the RH side of the graphic
         //END CHANGES
         
         // DON'T EDIT BELOW UNLESS INDICATED
         //TOUCH / DRAG SLIDER Declare variables for use in touch functions
         	var rail = sym.$("slider");
         	var railWidth = rail.width(); //width of the slder
         	var railX = rail.offset().left; //distance from left hand side at which slider starts
         	var railRightX = railX + railWidth;
         	var startX=0;
         	var moveIt=0
         	var startPos=railX;
         
         rail.bind("touchstart", touchStartX); //binds touch function to slider
         rail.bind("touchmove", moveMe); //binds touch function to slider
         rail.bind("mousedown", mouseMoveMe); //binds mouse function to slider
         //strip details
         var stripShow = sym.getSymbol("slider").$("buttonstrip");
         var stripWidth = stripShow.width();
         var moveStrip = stripWidth-railWidth;
         function touchStartX(e){ //handle mousedown event
         	startX = e.touches[0].pageX;
         }	
         function moveMe(e) {
         		e.preventDefault(); //prevents it firing a click when touched
              var orig = e.originalEvent;
         		var pos = 0;
         		pos = orig.touches[0].pageX;
         		var moveDistance=startX-pos;
         		moveIt=startPos-moveDistance;   
         		if(pos>=railX&&pos<=railRightX){
         			if(moveIt<=0&&moveIt>=-moveStrip){
                  	stripShow.css({'left':moveIt});
                  	}
         	}
         };
         function mouseMoveMe(e){ //handle mousedown event
         	startX = e.pageX;
         sym.getComposition().getStage().getSymbolElement().mousemove(handleMouseMove); //bind mousemove functions to stage in case cursor goes oustide the thumb
         sym.getComposition().getStage().getSymbolElement().mouseup(handleMouseUp); //bind mouseup functions to stage 
         }	
         function handleMouseMove(jqEvent){
         		e.preventDefault(); //prevents it firing a mouse click when mousedown
         	var pos = 0;
         		pos = jqEvent.pageX;
         		var moveDistance=startX-pos;
         		moveIt=startPos-moveDistance;         	
         		if(pos>=railX&&pos<=railRightX){
         			if(moveIt<=0&&moveIt>=-moveStrip){
                  	stripShow.css({'left':moveIt});
                  	}
         	}
         }
         function handleMouseUp(jqEvent){ // handle mouseup event
         sym.getComposition().getStage().getSymbolElement().unbind("mousemove");
         sym.getComposition().getStage().getSymbolElement().unbind("mouseup");
         startPos=moveIt;
         }
         function handleTouchUp(jqEvent){ // handle touchup event
         sym.getComposition().getStage().getSymbolElement().unbind("touchmove");
         sym.getComposition().getStage().getSymbolElement().unbind("touchend");
         }
         
         //Text & other variables
         sym.$("captionTxt").css('line-height', '120%');
         var headline;
         var headlinetxt = sym.$("headlineTxt");
         var order;
         var caption;
         var drag;
         var pictures;
         var mainPic = sym.$("main_pic");
         //UNCOMMENT THE FOLLOWING TO USE MULTIPLE CAPTIONS IN AN ARRAY. The array can only contain captions within the same Symbol 
         /*
         var captionArr=[];  //array of text boxes - EDIT TO MATCH THE NUMBER OF TEXT BOXES
         for (var i = 0; i < 3; i++) {
         				captionArr.push(sym.getSymbol("stageMc").$("captiontxt"+i));
         }
         */
         //end captions
         
         
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         function resetCaps(){
         $.ajax({	
         	type: "GET",
         	url: "GN30776.xml",
         	dataType: "xml",
         	success: function(xml) {
         
         		headline = $(xml).find('headline').text();
         		sym.$("headlineTxt").html(headline);
         
         		order = $(xml).find('order0').text();
         		sym.$("orderTxt").html(order);
         
         		caption = $(xml).find('caption0').text();
         		sym.$("captionTxt").html(caption);
         
         		sources = $(xml).find('sources').text();
         		sym.$("sourcesTxt").html(sources);
         
         		pictures = $(xml).find('picture0').text();
         		sym.$("pictureTxt").html(pictures);
         
         	//TO PLACE XML CAPTIONS WITHIN TEXT BOXES FROM CAPTION ARRAY
              	//captionArr[0].html("caption1");
               //captionArr[1].html("caption2");
               //captionArr[2].html("caption3");
         
         		}
         	});
         }
         resetCaps();
         
         
         //Right to left functions
         
         var igmeasure=sym.$("Stage").width(); //width of whole graphic
         var buttonstrip=sym.getSymbol("slider").$("buttonstrip");
         var stripw=buttonstrip.width();
         //var rtloff=igmeasure-stripw;//width of iGraphic - needed for RTL conversion
         var offset=buttonstrip.offset();
         //var rtloff=offset.left;
         var rtloff=30;
         
         var fwd;
         var back;
         fwd=(RTL=="true")?0:1; 
         back=(RTL=="true")?1:0;
         
         //set variables for image gallery
         sym.setVariable("number", 0);
         sym.setVariable("strip", 0);
         
         //CREATE MAIN FORWARD-BACK BUTTONS
         var mainbtnArray = ["mainBtn0","mainBtn1"]; // back and forward buttons
         		for (var m=0; m<mainbtnArray.length; m++){
         		sym.$("mainBtn"+m).bind('click', mainbtnClick);
         		//sym.$("mainBtn"+i).bind('mouseover', btnShow);
         		//sym.$("mainBtn"+i).bind('mouseout', btnHide);
         		}
         function mainbtnClick() {
         			var selected_id = $(this).attr("id");
         			$.ajax({    
             		type: "GET",
             		url: "GN30776.xml",
             		dataType: "xml",
             		success: function(xml) { 
          			var id = sym.getVariable("number");
         			var next;
         			if(selected_id == "Stage_mainBtn"+back){
         				next = id-1;
          				if(next<1){
         				sym.$("mainBtn"+back).hide();
         				sym.$("stripBtn"+back).hide();
         				}
         				if(next<n-thumbs){
         				sym.$("stripBtn"+fwd).show();
         				}
         				if(next>n-thumbs){
         				sym.$("stripBtn"+fwd).hide();
         				}
         				if(next<n-1){
         				sym.$("mainBtn"+fwd).show();
         				}
         				if (id>n-thumbs){
         					if (RTL=="true"){
         							ttime=0;
         							moveIt=rtloff+((n-thumbs)*(thumbWidth))-space;
         					}else{
         							ttime=0;
         							//moveIt=((n-thumbs)*-(thumbWidth))+space;
         							moveIt=((n-thumbs)*-(thumbWidth));
         
         					}
         
         				}else{
         					if (RTL=="true"){
         							moveIt=rtloff+(next*(thumbWidth))-space;
         					}else{
         							//moveIt=(next*-(thumbWidth))+space;
         							moveIt=next*-(thumbWidth);
         
         					}
         				}
         			}else{  
         			//forward button
         			next = id+1;
         				if(next>0){
         				sym.$("mainBtn"+back).show();
         				sym.$("stripBtn"+fwd).show();
         				}
         				if(next<n-thumbs-1){
         				sym.$("stripBtn"+back).show();
         				}
         				if(next>n-thumbs-1){
         				sym.$("stripBtn"+fwd).hide();
         				}
         				if(next>n-2){
         				sym.$("mainBtn"+fwd).hide();
         				}
         				if (id<n-thumbs){
         					if (RTL=="true"){
         							moveIt=rtloff+(next*(thumbWidth))-space;
         					}else{
         							//moveIt=(next*-(thumbWidth))+space;
         							moveIt=next*-(thumbWidth);
         
         					}
         				}
         			}
         			   sym.getSymbol("slider").$("buttonstrip").animate ({left: moveIt}, ttime);
         			 	startPos=moveIt;
         				pictures = $(xml).find('picture'+next).text();
                 		sym.$("pictureTxt").html(pictures);
                 		caption = $(xml).find('caption'+next).text();
                 		sym.$("captionTxt").html(caption);
                 		order = $(xml).find('order'+next).text();
                 		sym.$("orderTxt").html(order);
         
         			for (var i=0; i<n; i++){
         				if (i==next){
         				mainPic.attr("src","images/pic_"+next+".jpg");
           				sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).css({"border-width":"3px","border-style":"solid","border-color":"rgb(255,0,0)"});
         				}else{
           				sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).css({"border-width":"3px","border-style":"solid","border-color":"rgba(100,0,0,0)"});
         				}
         			}
         				sym.setVariable("number", next);
                        }
             		});
         			e.preventDefault()
         }
         
         
         //CREATE BACK AND FORWARD BUTTONS on BUTTONSTRIP - TO USE THESE BUTTONS BRING THEM TO THE FRONT
         var btnArray = ["stripBtn0","stripBtn1"]; // back and forward buttons
         		for (var b=0; b<btnArray.length; b++){
         		sym.$("stripBtn"+b).bind('click', stripbtnClick);
         		}
         
         
         
         function stripbtnClick() {
         			var selected_id = $(this).attr("id");
         			var s = sym.getVariable("strip");
         		if(selected_id == "Stage_stripBtn"+back){ //back button
         			if (s>0){ 
         				if (s<=1){ 
         					sym.$("stripBtn"+back).hide(); 
         				}else{
         					sym.$("stripBtn"+back).show(); 
         					} 
         				s=s-1;
         			}else{
         				 s=0; 	
         				 sym.$("stripBtn"+back).hide(); 
         				 }
         					if(RTL=="true"){
         					moveIt=rtloff+(thumbs*s*(thumbWidth))-space;
         					}else{
         //					moveIt=(thumbs*s*-(thumbWidth))+space;
         					moveIt=thumbs*s*-(thumbWidth);
         					}
         			sym.$("stripBtn"+fwd).show(); 
         		}else{  //forward button
         			if (s>=(n/thumbs)-2){ 
         					if ((n/thumbs)-2==0){
         						s= 1;
         						}else{
         						s= Math.floor(n/thumbs);
         						}
         					if(RTL=="true"){
         					moveIt= rtloff+((n-thumbs)*(thumbWidth))-space;
         					}else{
         //					moveIt=((n-thumbs)*-(thumbWidth))+space;
         					moveIt=(n-thumbs)*-(thumbWidth);
         					}
         				sym.$("stripBtn"+fwd).hide();
         			}else{ 
         				s=s+1;
         					if(RTL=="true"){
         					moveIt= rtloff+(thumbs*s*(thumbWidth))-space;
         					}else{
         //					moveIt=(thumbs*s*-(thumbWidth))+space;					
         					moveIt=(thumbs*s*-(thumbWidth));					
         					}
         				sym.$("stripBtn"+fwd).show();
         			}
         			sym.$("stripBtn"+back).show(); 
         
         		}
         		sym.getSymbol("slider").$("buttonstrip").animate ({left: moveIt}, ttime);					
         		startPos=moveIt;
         		sym.setVariable("strip", s);
         		e.preventDefault()
         	}
         
         
         //CREATE THUMBNAIL IMAGE BUTTONS
         for (var j=0; j<n; j++){
         		sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+j).bind('click', thClick);
           		sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+j).css({"border-width":"3px","border-style":"solid","border-color":"rgba(100,100,100,0)"});
         		}
         
         function thClick() {
         			var selected_id = $(this).attr("id");
         			$.ajax({    
             				type: "GET",
             				url: "GN30776.xml",
             				dataType: "xml",
             				success: function(xml) {
         					for (var i=0; i<n; i++){
         						if(selected_id == "Stage_slider_buttonstrip_btn" + i){
         						pictures = $(xml).find('picture' + i).text();
                 				sym.$("pictureTxt").html(pictures);    
                 				caption = $(xml).find('caption' + i).text();
                 				sym.$("captionTxt").html(caption);
                 				order = $(xml).find('order' + i).text();
                 				sym.$("orderTxt").html(order);
           						sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).css({"border-width":"3px","border-style":"solid","border-color":"rgb(255,0,0)"});
         						mainPic.attr("src","images/pic_"+i+".jpg");
         							if(i>0){ sym.$("mainBtn"+back).show(); sym.$("stripBtn"+back).show(); }//show back button once selected image is past the first
         							if(i<1){ sym.$("mainBtn"+back).hide(); sym.$("stripBtn0"+back).hide(); }//hide back button if first image is selected
         							if(i<n-thumbs-1){ sym.$("stripBtn"+fwd).show(); }	//hide forward button if last image is selected
         							if(i>n-thumbs-1){ sym.$("stripBtn"+fwd).hide(); }	//hide forward button if last image is selected	
         							if(i>n-2){ sym.$("mainBtn"+fwd).hide(); }	//hide forward button if last image is selected	
         							if(i<n-1){ sym.$("mainBtn"+fwd).show(); }	//show forward button if selected image is before the last
         							//move strip horizontally
         
         							if (i<n-thumbs+1){
         								if(RTL=="true"){
         								moveIt=rtloff+(i*(thumbWidth))-space; 
         								}else{
         //								moveIt=(i*-(thumbWidth))+space; 
         								moveIt=(i*-(thumbWidth)); 
         								}
         							}else{ 
         								if(RTL=="true"){
         								moveIt=rtloff+((n-thumbs)*(thumbWidth))-space;
         								}else{
         //								moveIt=((n-thumbs)*-(thumbWidth))+space;
         								moveIt=((n-thumbs)*-(thumbWidth));
         								}
         							}
         						sym.getSymbol("slider").$("buttonstrip").animate ({left: moveIt}, ttime);
         						startPos=moveIt;					
         						sym.setVariable("strip", Math.floor(i/thumbs));
         						sym.setVariable("number", i);
         						}else{				
           		            sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).css({"border-width":"3px","border-style":"solid","border-color":"rgba(100,100,100,0)"});
         					}
         			}
                         }
             			});
         		e.preventDefault()
         		}
         
         sym.$("mainBtn"+back).hide();
         sym.$("stripBtn"+back).hide();
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

   })("stage");
   //Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'backBtn'
(function(symbolName) {

















})("back_butt");
   //Edge symbol end:'back_butt'

//=========================================================

//Edge symbol: 'forwardBtn'
(function(symbolName) {

















})("forward_butt");
   //Edge symbol end:'forward_butt'

   //=========================================================
   
   //Edge symbol: 'button_strip'
   (function(symbolName) {   
   
      

   })("button_strip");
   //Edge symbol end:'button_strip'

   //=========================================================
   
   //Edge symbol: 'strip'
   (function(symbolName) {   
   
   })("strip");
   //Edge symbol end:'strip'

})(jQuery, AdobeEdge, "GraphicNews30776");