/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var headline;
         var sources;
         var teamstring;
         var teamnames;
         var monthstring;
         var months;
         var buttonTxt0;
         var buttonTxt1;
         var latest;
         var team1;
         var team2;
         var score;
         var match;
         var cap1;
         var cap2;
         var cap3;
         var caption;
         var tableArr=[];
         
         
         var d=new Date();
         var teamIDs =[4007,4010,4491,4034,100094,4047,102785,102813,4075,4222,4080,4087,4760,4874,4286,4906,4908,4129,4972,4144];
         
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         $.ajax({	
         	type: "GET",
         	url: "GN30756.xml",
         	dataType: "xml",
         	success: function(xml) {
         
         		headline = $(xml).find('headline').text();
         		sym.$("headlineTxt").html(headline);				
         		sources = $(xml).find('sources').text();
         		sym.$("sourcesTxt").html(sources);		
         		buttonTxt0 = $(xml).find('button0').text();
         		buttonTxt1 = $(xml).find('button1').text();
         		sym.getSymbol("menuBtn0").$("menuTxt").html(buttonTxt0);
         		sym.getSymbol("menuBtn1").$("menuTxt").html(buttonTxt1);
         
         	for (var i=0;i<10;i++){
         		tableArr[i]= $(xml).find('table'+i).text();
         		}
         		sym.getSymbol("panel01").$("table1Txt").html(tableArr[1]);
         		sym.getSymbol("panel01").$("table2Txt").html(tableArr[2]);
         		sym.getSymbol("panel01").$("table3Txt").html(tableArr[3]);
         		sym.getSymbol("panel01").$("table4Txt").html(tableArr[4]);
         		sym.getSymbol("panel01").$("table5Txt").html(tableArr[5]);
         		sym.getSymbol("panel01").$("table6Txt").html(tableArr[6]);
         		sym.getSymbol("panel01").$("table7Txt").html(tableArr[7]);
         		sym.getSymbol("panel01").$("matches").append(tableArr[8]);
         		sym.getSymbol("panel01").$("table").append(tableArr[9]);
         		teamstring = $(xml).find('teamnames').text();
         		teamnames=teamstring.split(",");
         		monthstring = $(xml).find('months').text();
         		months=monthstring.split(",");
         
         		cap1 = $(xml).find('cap1').text();
         		cap2 = $(xml).find('cap2').text();
         
         		btn1 = $(xml).find('btn1').text();
         		sym.getSymbol("matchtracker").$("tabBtn1").html(btn1);
         		btn2 = $(xml).find('btn2').text();
         		sym.getSymbol("matchtracker").$("tabBtn2").html(btn2);
         		ko = $(xml).find('ko').text();
         		sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("timeline").$("koTxt").html(ko);
         		cap1 = $(xml).find('cap1').text();
         		sym.getSymbol("matchtracker").getSymbol("teams").$("cap1Txt").html(cap1);
         		sym.getSymbol("matchtracker").getSymbol("teams").$("cap2Txt").html(cap1);
               cap2 = $(xml).find('cap2').text();	
               sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("penalties").$("pensTxt").html(cap2);	     
         		}
         	});
         //BUTTONS
         // MENU BUTTONS	
         menuArray = []; //the array that will hold references to the buttons.
         for (var i = 0; i < 2; i++){
         	var menuBtnSymbols = sym.getSymbol("menuBtn" +i); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", i); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         	sym.$("menuBtn" +i).css({"cursor":"pointer"});
         	sym.getSymbol("menuBtn" +i).$("menuBtnimg").attr('src','images/menu'+i+'.png');
         }
         $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
         	var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         	menuBtnElement.bind ("click", {menuId:count}, menuBtnClick);
         });
         
         function menuBtnClick (e){
         		var menuMenu_id = (e.data.menuId);
         		sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("penalties").getSymbol("pensDiv").$("homePens").empty();
         		sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("penalties").getSymbol("pensDiv").$("awayPens").empty();
         		sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("timeline").$("home").empty();
         		sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("timeline").$("away").empty();
         		sym.getSymbol("matchtracker").getSymbol("teams").$("hometeam").empty();
         		sym.getSymbol("matchtracker").getSymbol("teams").$("awayteam").empty();
         		for (i=0;i<2;i++){
         			if (menuMenu_id==i){
         				sym.getSymbol("menuBtn" +i).$("btnBg").css({'box-shadow':'none','background-color':'rgb(9,9,82)'});			
         				if (menuMenu_id==0){
         					sym.$('panel01').fadeIn(400);
         					sym.$('panel03').fadeOut(400);
         					sym.$('matchtracker').fadeOut(400);
         					clearInterval(matchInterval);
         					clearInterval(teamInterval);
         					clearInterval(playInterval);
         				}else{
         					sym.$('panel01').fadeOut(400);
         					sym.$('panel03').fadeIn(400);
         					sym.$('matchtracker').fadeOut(400);
         					clearInterval(matchInterval);
         					clearInterval(teamInterval);
         					clearInterval(playInterval);				}
         			}else{
         				sym.getSymbol("menuBtn" +i).$("btnBg").css({'box-shadow':'3px 3px 4px rgba(100,100,100,0.5)','background-color':'rgb(64,133,181)'});			
         			}
         		}
         	}
         sym.getSymbol("menuBtn1").$("btnBg").css({'box-shadow':'3px 3px 4px rgba(100,100,100,0.5)','background-color':'rgb(64,133,181)'});
         
         var tableUp=0;
         sym.getSymbol('panel01').$('xpand1').css({'cursor':'pointer'});
         sym.getSymbol('panel01').$('xpand1').click(function(){
         	if (tableUp==0){
         		sym.getSymbol('panel01').getSymbol('xpand1').$('expand').fadeOut(400);
         		sym.getSymbol('panel01').getSymbol('xpand1').$('reduce').fadeIn(400);
         		sym.getSymbol('panel01').$('table').animate({'top':'119px','height':'440px'},400);
         		sym.getSymbol('panel01').$('matches').animate({'height':'55px'},400);
         		sym.getSymbol('panel01').$('xpand1').animate({'top':'94px'},400);
         		sym.getSymbol('panel01').$('tablecaps').animate({'top':'102px'},400);
         		sym.getSymbol('panel01').$('cup').fadeOut(400);
         		sym.getSymbol('panel01').$('topteam').fadeIn(400);
         		sym.getSymbol('panel01').$('table').delay(400).css({'overflow':'hidden'});
         		tableUp=1;
         	}else{
         		sym.getSymbol('panel01').getSymbol('xpand1').$('expand').fadeIn(400);
         		sym.getSymbol('panel01').getSymbol('xpand1').$('reduce').fadeOut(400);
         		sym.getSymbol('panel01').$('table').animate({'top':'310px','height':'245px'},400);
         		sym.getSymbol('panel01').$('matches').animate({'height':'240px'},400);
         		sym.getSymbol('panel01').$('xpand1').animate({'top':'285px'},400);
         		sym.getSymbol('panel01').$('tablecaps').animate({'top':'293px'},400);
         		sym.getSymbol('panel01').$('cup').fadeIn(400);
         		sym.getSymbol('panel01').$('topteam').fadeOut(400);
         		sym.getSymbol('panel01').$('table').delay(400).css({'overflow':'auto'});
         		tableUp=0;
         	}
         });
         
         
         //LIVE DATA
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         
         function doTable() {           
          var tableData;
          $.ajax({ type: "GET", url: dataURL,
                         data: "gn=30756&phaseID=104203&yr=2013",
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
                             tableData = data;
                             for (var i = 0; i < tableData.length; i++) {
                            		if (i==0){
         		sym.getSymbol("panel01").$("table").empty();
         		sym.getSymbol('panel01').$('topteam').attr('src','crests/'+tableData[0].n_TeamID+'.png');
         		}			
         
         				if (i==0){
         				var tableTxt = "<table width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif; background:rgba(245,230,140,0.5);'><tr><td width='5%' id='rank" + i + "'></td><td width='38%' id='team" + i + "'></td><td width='7%' style='text-align:right' id='p" + i + "'></td><td width='7%' style='text-align:right' id ='w" + i + "'></td><td width='7%' style='text-align:right' id ='d" + i + "'></td><td width='7%' style='text-align:right' id ='l" + i + "'></td><td width='10%' style='text-align:right' id ='f" + i + "'></td><td width='10%' style='text-align:right' id ='a" + i + "'></td><td width='9%' style='text-align:right; font-weight:bold' id ='pts" + i + "'></td></tr></table>";
         				}else if (i< 5){
         				if (i%2 == 0){
                       var tableTxt = "<table width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif; background:rgba(230,230,190,0.5);'><tr><td width='5%' id='rank" + i + "'></td><td width='38%' id='team" + i + "'></td><td width='7%' style='text-align:right' id='p" + i + "'></td><td width='7%' style='text-align:right' id ='w" + i + "'></td><td width='7%' style='text-align:right' id ='d" + i + "'></td><td width='7%' style='text-align:right' id ='l" + i + "'></td><td width='10%' style='text-align:right' id ='f" + i + "'></td><td width='10%' style='text-align:right' id ='a" + i + "'></td><td width='9%' style='text-align:right; font-weight:bold' id ='pts" + i + "'></td></tr></table>";
         				}else{
                       var tableTxt = "<table width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif; background:rgba(250,250,220,0.5);'><tr><td width='5%' id='rank" + i + "'></td><td width='38%' id='team" + i + "'></td><td width='7%' style='text-align:right' id='p" + i + "'></td><td width='7%' style='text-align:right' id ='w" + i + "'></td><td width='7%' style='text-align:right' id ='d" + i + "'></td><td width='7%' style='text-align:right' id ='l" + i + "'></td><td width='10%' style='text-align:right' id ='f" + i + "'></td><td width='10%' style='text-align:right' id ='a" + i + "'></td><td width='9%' style='text-align:right; font-weight:bold' id ='pts" + i + "'></td></tr></table>";
         				}
         				}else if (i>16){
         				if (i%2 == 0){
                       var tableTxt = "<table width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif; background:rgba(255,190,160,0.5);'><tr><td width='5%' id='rank" + i + "'></td><td width='38%' id='team" + i + "'></td><td width='7%' style='text-align:right' id='p" + i + "'></td><td width='7%' style='text-align:right' id ='w" + i + "'></td><td width='7%' style='text-align:right' id ='d" + i + "'></td><td width='7%' style='text-align:right' id ='l" + i + "'></td><td width='10%' style='text-align:right' id ='f" + i + "'></td><td width='10%' style='text-align:right' id ='a" + i + "'></td><td width='9%' style='text-align:right; font-weight:bold' id ='pts" + i + "'></td></tr></table>";
         				}else{
                       var tableTxt = "<table width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif; background:rgba(255,220,205,0.5);'><tr><td width='5%' id='rank" + i + "'></td><td width='38%' id='team" + i + "'></td><td width='7%' style='text-align:right' id='p" + i + "'></td><td width='7%' style='text-align:right' id ='w" + i + "'></td><td width='7%' style='text-align:right' id ='d" + i + "'></td><td width='7%' style='text-align:right' id ='l" + i + "'></td><td width='10%' style='text-align:right' id ='f" + i + "'></td><td width='10%' style='text-align:right' id ='a" + i + "'></td><td width='9%' style='text-align:right; font-weight:bold' id ='pts" + i + "'></td></tr></table>";
         				}
         				}else{
         				if (i%2 == 0){
                       var tableTxt = "<table width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif; background:rgba(215,230,245,0.5);'><tr><td width='5%' id='rank" + i + "'></td><td width='38%' id='team" + i + "'></td><td width='7%' style='text-align:right' id='p" + i + "'></td><td width='7%' style='text-align:right' id ='w" + i + "'></td><td width='7%' style='text-align:right' id ='d" + i + "'></td><td width='7%' style='text-align:right' id ='l" + i + "'></td><td width='10%' style='text-align:right' id ='f" + i + "'></td><td width='10%' style='text-align:right' id ='a" + i + "'></td><td width='9%' style='text-align:right; font-weight:bold' id ='pts" + i + "'></td></tr></table>";
         				}else{
                       var tableTxt = "<table width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif;'><tr><td width='5%' id='rank" + i + "'></td><td width='38%' id='team" + i + "'></td><td width='7%' style='text-align:right' id='p" + i + "'></td><td width='7%' style='text-align:right' id ='w" + i + "'></td><td width='7%' style='text-align:right' id ='d" + i + "'></td><td width='7%' style='text-align:right' id ='l" + i + "'></td><td width='10%' style='text-align:right' id ='f" + i + "'></td><td width='10%' style='text-align:right' id ='a" + i + "'></td><td width='9%' style='text-align:right; font-weight:bold' id ='pts" + i + "'></td></tr></table>";
         				}
         				}
         
                       sym.getSymbol("panel01").$("table").append(tableTxt);
                         $('#team' + i).text(tableData[i].c_Team);
                         $('#rank' + i).text(i+1);
                         $('#p' + i).text(tableData[i].n_Matches);
                         $('#w' + i).text(tableData[i].n_MatchesWon);
                         $('#d' + i).text(tableData[i].n_MatchesDrawn);
                         $('#l' + i).text(tableData[i].n_MatchesLost);
                         $('#f' + i).text(tableData[i].n_GoalsFor);
                         $('#a' + i).text(tableData[i].n_GoalsAgainst);
                         $('#pts' + i).text(tableData[i].n_Points);
                             } 
                         }
                     });
         }
         doTable();
         intervalId = setInterval(doTable,300000);
         
         
         function getDDMMYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth() + 1;
         	var dd = thisDate.getDate();
         	mm = ((mm < 10) ? '0' : "") + mm;
         	dd = ((dd < 10) ? '0' : "") + dd;
         	return dd + "-" + mm + "-" + (thisDate.getFullYear()).toString();
         }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         }
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var dDate = parseInt(matchRndDate,10);
         	return dDate;
         }      
         
         var startSeason= Date.parse("August 17, 2013");
         var endSeason = Date.parse("May 11, 2014");
         var oneDay = 86400000;
         var todayDate = new Date();
         var todayTime = todayDate.getTime();
         
         var matchID;
         var matchteam1;
         var matchteam2;
         var matchscore;
         var matchDetails;
         var matchStatus;
         var homeTeam = sym.getSymbol("matchtracker").$("team1Txt");
         var awayTeam = sym.getSymbol("matchtracker").$("team2Txt");
         var score = sym.getSymbol("matchtracker").$("scoreTxt");
         var crestH = sym.getSymbol("matchtracker").$("crest1");
         var crestA = sym.getSymbol("matchtracker").$("crest2");
         
         
         
         var fixtureData;
         var fullFixtures;
         var fixtureTxt;
         var teamID;
         
         
         var showTeamFixtures = function(team){ //to handle lexical scope
         	return function (e) {
         		getTeamFixtures(team);
         		sym.$('panel01').fadeOut(400);
         		sym.$('panel03').fadeIn(400);
         		sym.getSymbol("menuBtn1").$("btnBg").css({'box-shadow':'3px 3px 4px rgba(100,100,100,0.5)','background-color':'rgb(64,133,181)'});
         		teamID=team;
         			for (var i=0; i<n; i++){
         				if (teamIDs[i]==teamID){
         					sym.getSymbol("panel03").getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).stop().animate({"height":"63px","width":"63px"},400);
         					if(i<Math.round(thumbs/2)){
         						if(RTL=="true"){
         							moveIt=rtloff+(i*(thumbWidth))-space; 
         						}else{
         							moveIt=0; 
         						}
         					}else	if(i>=Math.round(thumbs/2)&&(i<n-Math.round(thumbs/2)+1)){
         						if(RTL=="true"){
         							moveIt=rtloff+(i*(thumbWidth))-space; 
         						}else{
         						moveIt=((i-Math.floor(thumbs/2))*-(thumbWidth)); 
         						}
         					}else{ 
         						if(RTL=="true"){
         							moveIt=rtloff+((n-thumbs)*(thumbWidth))-space;
         						}else{
         							moveIt=((n-thumbs)*-(thumbWidth));
         							}
         					}
         					sym.getSymbol("panel03").getSymbol("slider").$("buttonstrip").stop().animate ({left: moveIt}, ttime);
         					startPos=moveIt;					
         					sym.setVariable("strip", Math.floor(i/thumbs));
         					sym.setVariable("number", i);
         				}else{				
         					sym.getSymbol("panel03").getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).stop().animate({"height":"53px","width":"53px"},400);
         				}
         			}
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         
         var matchInterval;
         var teamInterval;
         var playInterval;
         var showMatch = function(match){ //to handle lexical scope
         	return function (e) {
         		getMatchInfo(match);
         		getMatch(match);
         		getTeams(match);
         		matchInterval = setInterval(function() { getMatchInfo(match); }, 60000);
         		teamInterval = setInterval(function() { getTeams(match); }, 60000);
         		playInterval = setInterval(function() { getMatch(match); }, 60000);
         		playInterval
         		e.preventDefault();
         		e.stopPropagation();
         
         	};
         };
         var clearFixtures = function(){ //to handle lexical scope
         	return function (e) {
         		for (var i=0; i<n; i++){
         			sym.getSymbol("panel03").getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).stop().animate({"height":"53px","width":"53px"},400);
         		}
         		sym.getSymbol("menuBtn1").$("btnBg").css({'box-shadow':'none','background-color':'rgb(9,9,82)'});
         		getTeamFixtures();
         		e.preventDefault();
         
         	};
         };
         function getTeamFixtures(teamID){
         $.ajax({ type: "GET", url: dataURL,
                         data: "gn=30756&editionID=20597&yr=2013",
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
                              fixtureData = data;
                              if (typeof teamID!="undefined"){
                              sym.$("menuBtn1").on('click', clearFixtures());
         							}else{
         							sym.$("menuBtn1").off('click', clearFixtures());
         							}
                  for (var i = 0; i < fixtureData.length; i++) {				
         			if (typeof teamID!="undefined"){
         				if (i==0){
         					sym.getSymbol("panel03").$("fixtures").empty();
         				}	
         				if (fixtureData[i].n_HomeTeamID==teamID||fixtureData[i].n_AwayTeamID==teamID){
         					fullFixtures = "<table style='font-size:12px;font-family:pragmatica-web, sans-serif;background-color:rgba(215,230,245,0.5);border-top:solid 1px rgb(255,255,255);border-bottom:solid 1px rgb(215,230,245)' id='matchf" + i + "'><tr><td width='5%' id='cresth"+i+"'></td><td width='35%' style='padding-left:3px' id='teamfh" + i + "'></td><td width='20%' style='text-align:center' id='scoref" + i + "'></td><td width='35%' style='text-align:right' id ='teamfa" + i + "'></td><td width='5%' id='cresta"+i+"'></td></tr></table>";					
         					sym.getSymbol("panel03").$("fixtures").append(fullFixtures);
         					for (var n=0;n<20;n++){
         						if (teamIDs[n]==teamID){
         							sym.getSymbol('panel03').$('teamTxt').html(teamnames[n]);
         						}
         					}
         				}
         			}else{
         				if (i==0){
         					sym.getSymbol("panel01").$("matches").empty();
         					sym.getSymbol("panel03").$("fixtures").empty();
         					sym.getSymbol("panel03").$("teamTxt").html("");
         				}
         				var matchesRnd = parsedDate(fixtureData[i].d_Date);
         				if (i%2 == 0){
         					fixtureTxt = "<table height='13px' width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif;background-color:rgba(215,230,245,0.5);border-top:solid 1px rgb(255,255,255);border-bottom:solid 1px rgb(215,230,245)' id='match" + i + "'><tr><td width='45%' style='padding-left:3px' id='teamh" + i + "'></td><td width='10%' style='text-align:center' id='score" + i + "'></td><td width='45%' style='text-align:right' id ='teama" + i + "'></td></tr></table>";
         					fullFixtures = "<table height='13px' width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif;background-color:rgba(215,230,245,0.5);border-top:solid 1px rgb(255,255,255);border-bottom:solid 1px rgb(215,230,245)' id='matchf" + i + "'><tr><td width='5%' id='cresth"+i+"'></td><td width='35%' style='padding-left:3px' id='teamfh" + i + "'></td><td width='20%' style='text-align:center' id='scoref" + i + "'></td><td width='35%' style='text-align:right' id ='teamfa" + i + "'></td><td width='5%' id='cresta"+i+"'></td></tr></table>";
         				}else{
         					fixtureTxt = "<table height='13px' width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif;border-top:solid 1px rgb(255,255,255);border-bottom:solid 1px rgb(215,230,245)' id='match" + i + "'><tr><td width='45%' style='padding-left:3px' id='teamh" + i + "'></td><td width='10%' style='text-align:center' id='score" + i + "'></td><td width='45%' style='text-align:right' id ='teama" + i + "'></td></tr></table>";
         					fullFixtures = "<table height='13px' width='100%' style='font-size:12px;font-family:pragmatica-web, sans-serif;border-top:solid 1px rgb(255,255,255);border-bottom:solid 1px rgb(215,230,245)' id='matchf" + i + "'><tr><td width='5%' id='cresth"+i+"'></td><td width='35%' style='padding-left:3px' id='teamfh" + i + "'></td><td width='20%' style='text-align:center' id='scoref" + i + "'></td><td width='35%' style='text-align:right' id ='teamfa" + i + "'></td><td width='5%' id='cresta"+i+"'></td></tr></table>";
         				}
         				sym.getSymbol("panel03").$("fixtures").append(fullFixtures);
         				if (((todayTime<startSeason)&&(i<10))||((todayTime>endSeason)&&(i>fixtureData.length-10))||((matchesRnd>todayTime-(oneDay*2))&&(matchesRnd<todayTime+(oneDay*12)))){
         					sym.getSymbol("panel01").$("matches").append(fixtureTxt);
         					}    
         			}
         			$('#teamfh' + i).text(fixtureData[i].c_HomeTeam);
         			$('#teamfa' + i).text(fixtureData[i].c_AwayTeam);
         			$('#teamh' + i).text(fixtureData[i].c_HomeTeam);
         			$('#teama' + i).text(fixtureData[i].c_AwayTeam);
         			if (fixtureData[i].n_HomeGoals!==null||undefined){
         				$('#score' + i).html('<b>' + (fixtureData[i].n_HomeGoals)+ '-' +(fixtureData[i].n_AwayGoals) + '</b>');
         				$('#score' + i).css({'height':'10px','font-size':'11px','padding':'0px','cursor':'pointer','background-color':'rgb(100,100,100)','color':'rgb(255,255,255)','border-bottom':'solid 1px rgb(0,0,0)','border-right':'solid 1px rgb(0,0,0)','border-left':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgb(200,200,200)',});
         				$('#scoref' + i).html('<b>' + (fixtureData[i].n_HomeGoals)+ '-' +(fixtureData[i].n_AwayGoals) + '</b>');
         				$('#scoref' + i).css({'height':'10px','font-size':'11px','padding':'0px','cursor':'pointer','background-color':'rgb(100,100,100)','color':'rgb(255,255,255)','border-bottom':'solid 1px rgb(0,0,0)','border-right':'solid 1px rgb(0,0,0)','border-left':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgb(200,200,200)',});
         			}else{
         				$('#score' + i).html('');
         				$('#scoref' + i).html('<i>' + getDDMMYY(fixtureData[i].d_Date) + '</i>');               
         			}
         			if ((fixtureData[i].n_HomeTeamID)<=0){
         				crestH='';
         			}else{
         				crestH='<img src="crests/'+(fixtureData[i].n_HomeTeamID) +'.png" height="18px" width="18px">';
         			}
         			$('#cresth' + i).html(crestH);
         			if ((fixtureData[i].n_AwayTeamID)<=0){
         				crestA='';
         			}else{
         				crestA='<img src="crests/'+(fixtureData[i].n_AwayTeamID) +'.png" height="18px" width="18px" align="right">';
         			}
         			$('#cresta' + i).html(crestA);
         			$('#cresth' + i).css('cursor', 'pointer');				
         			$('#cresta' + i).css('cursor', 'pointer');	
         			$("#match"+i).css('cursor','pointer');
         			$("#matchf"+i).css('cursor','pointer');
         			$("#cresth"+i).click(showTeamFixtures(fixtureData[i].n_HomeTeamID));	
         			$("#cresta"+i).click(showTeamFixtures(fixtureData[i].n_AwayTeamID));
         			$("#match"+i).on('click',showMatch(fixtureData[i].n_MatchID));
         			$("#match"+i).on('mouseover',function(){ $(this).css({'font-weight':700});});
         			$("#match"+i).on('mouseout',function(){ $(this).css({'font-weight':400});});
         			$("#matchf"+i).on('click',showMatch(fixtureData[i].n_MatchID));
         			$("#matchf"+i).on('mouseover',function(){ $(this).css({'font-weight':700});});
         			$("#matchf"+i).on('mouseout',function(){ $(this).css({'font-weight':400});});
         			}//end for
         		}//end success
         	});
         }
         getTeamFixtures();
         intervalId = setInterval(getTeamFixtures,300000);
         
         
         //EDIT THE FOLLOWING	NUMBERS
         var thumbWidth=53; //distance between origin of thumbnail images
         var n=20; //number of images
         var thumbs = 7; //number of thumbnails visible at same time
         var space = 0; //pixels offset at beginning of buttonstrip
         var ttime= 500; //transition time in milliseconds
         var RTL="false"; //change true/false to change direction
         //For RTL, the order of the images must also be reversed and the button strip moved so that it starts on the RH side of the graphic
         //END CHANGES
         
         // DON'T EDIT BELOW UNLESS INDICATED
         //TOUCH / DRAG SLIDER Declare variables for use in touch functions
         	var rail = sym.getSymbol("panel03").$("slider");
         	var railWidth = rail.width(); //width of the slder
         	var railX = rail.offset().left; //distance from left hand side at which slider starts
         	var railRightX = railX + railWidth;
         	var startX=0;
         	var moveIt=0
         	var startPos=railX;
         
         rail.on("touchstart", touchStartX); //binds touch function to slider
         rail.on("touchmove", moveMe); //binds touch function to slider
         rail.on("mousedown", mouseMoveMe); //binds mouse function to slider
         //strip details
         var stripShow = sym.getSymbol("panel03").getSymbol("slider").$("buttonstrip");
         var stripWidth = stripShow.width();
         var moveStrip = stripWidth-railWidth;
         function touchStartX(e){ //handle touch event
         	startX = e.touches[0].pageX;
         }	
         function moveMe(e) {
         		e.preventDefault(); //prevents it firing a click when touched
              var orig = e.originalEvent;
         		var pos = 0;
         		pos = orig.touches[0].pageX;
         		var moveDistance=startX-pos;
         		moveIt=startPos-moveDistance;   
         		if(pos>=railX&&pos<=railRightX){
         			if(moveIt<=0&&moveIt>=-moveStrip){
                  	stripShow.css({'left':moveIt});
                  	}
         	}
         };
         function mouseMoveMe(e){ //handle mousedown event
         e.preventDefault();
         	startX = e.pageX;
         sym.getComposition().getStage().getSymbolElement().mousemove(handleMouseMove); //bind mousemove functions to stage in case cursor goes oustide the thumb
         sym.getComposition().getStage().getSymbolElement().mouseup(handleMouseUp); //bind mouseup functions to stage 
         }	
         function handleMouseMove(jqEvent){
         		e.preventDefault(); //prevents it firing a mouse click when mousedown
         	var pos = 0;
         		pos = jqEvent.pageX;
         		var moveDistance=startX-pos;
         		moveIt=startPos-moveDistance;         	
         		if(pos>=railX&&pos<=railRightX){
         			if(moveIt<=0&&moveIt>=-moveStrip){
                  	stripShow.css({'left':moveIt});
                  	}
         	}
         }
         function handleMouseUp(jqEvent){ // handle mouseup event
         sym.getComposition().getStage().getSymbolElement().unbind("mousemove");
         sym.getComposition().getStage().getSymbolElement().unbind("mouseup");
         startPos=moveIt;
         }
         function handleTouchUp(jqEvent){ // handle touchup event
         sym.getComposition().getStage().getSymbolElement().unbind("touchmove");
         sym.getComposition().getStage().getSymbolElement().unbind("touchend");
         }
         
         //THUMBNAIL IMAGE BUTTONS
         for (var j=0; j<n; j++){
         		sym.getSymbol("panel03").getSymbol("slider").getSymbol("buttonstrip").$("btn"+j).click(showTeamFixtures(teamIDs[j]));
           		sym.getSymbol("panel03").getSymbol("slider").getSymbol("buttonstrip").$("btn"+j).css({"cursor":"pointer"});
         		}
         //MATCHTRACKER
         var swivelstate="lineups";       
         for (var m=0; m<3; m++){
         sym.getSymbol("matchtracker").$("tabBtn" + m).on('click', changeState);
         }
         function changeState (){
         			if (swivelstate=="tracker"){
         				sym.getSymbol("matchtracker").play();
         				sym.getSymbol("matchtracker").$("timeTxt").fadeOut(200);
         				sym.getSymbol("matchtracker").$("tabBtn0").attr("src","images/team.png");
         				sym.getSymbol("matchtracker").$("tabBtn1").css({'color':'rgba(255,255,255,1.0)','box-shadow':'none','background-color':'rgb(9,9,82)'});
         				sym.getSymbol("matchtracker").$("tabBtn2").css({'color':'rgba(255,255,255,1.0)','box-shadow':'3px 3px 4px rgba(100,100,100,0.5)','background-color':'rgb(64,133,181)'});
         
         				swivelstate="lineups";
         			}else if (swivelstate=="lineups"){
         				sym.getSymbol("matchtracker").playReverse();
         				sym.getSymbol("matchtracker").$("timeTxt").fadeIn(200);
         				sym.getSymbol("matchtracker").$("tabBtn0").attr("src","images/clock.png");
         				sym.getSymbol("matchtracker").$("tabBtn2").css({'color':'rgba(255,255,255,1.0)','box-shadow':'none','background-color':'rgb(9,9,82)'});
         				sym.getSymbol("matchtracker").$("tabBtn1").css({'color':'rgba(255,255,255,1.0)','box-shadow':'3px 3px 4px rgba(100,100,100,0.5)','background-color':'rgb(64,133,181)'});
         				swivelstate="tracker";
         			}
         			e.preventDefault()
         }
         changeState();
         
         function getMatchInfo(matchID){
         	var infoData;
         	sym.$("matchtracker").fadeIn(400);
         	sym.$("panel01").fadeOut(400);
         	sym.$("panel03").fadeOut(400);
         	sym.getSymbol("menuBtn0").$("btnBg").css({'box-shadow':'2px 2px 2px rgba(100,100,100,0.5)','background-color':'rgba(64,133,181,0.5)'});
         	sym.getSymbol("menuBtn1").$("btnBg").css({'box-shadow':'2px 2px 2px rgba(100,100,100,0.5)','background-color':'rgba(64,133,181,0.5)'});
         
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn=30756&yr=2013&match="+matchID+"&q=info",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			infoData = data;
         			var matchteam1=infoData[0].c_HomeTeam;
         			var matchteam2=infoData[0].c_AwayTeam;
         			var score1;
         			var score2;
         			if (infoData[0].n_MatchStatusCode<8){
         				score1="0";
         				score2="0";
         			}else{
         				score1=infoData[0].n_HomeGoals;
         				score2=infoData[0].n_AwayGoals;
         			}
         			var matchRef;
         			if (infoData[0].c_Referee==null){
         				matchRef="";
         			}else{
         				matchRef="Referee: " + infoData[0].c_Referee;
         			}
         			var spectators;
         			if (infoData[0].n_Spectators==null){
         				spectators="";
         			}else{
         				spectators="Attendance: " + infoData[0].n_Spectators;
         			}
         			var matchscore = score1 + "-" + score2;
         			var imgH = "crests/"+ infoData[0].n_HomeTeamID + ".png";
         			var imgA = "crests/"+ infoData[0].n_AwayTeamID + ".png";
         			var matchStatus = infoData[0].n_MatchStatusCode;
         			var tacticsH =  infoData[0].c_HomeTactics;
         			var tacticsA =  infoData[0].c_AwayTactics;
         			var matchDate = getDDmonthYY(infoData[0].d_Date);
         			var matchInfo = infoData[0].c_Stadium + ", " + infoData[0].c_City + "<br />" + matchDate + "<br />" + matchRef + "<br />" + spectators ;
         			sym.getSymbol("matchtracker").$("crest1").attr("src",imgH);				
         			sym.getSymbol("matchtracker").$("crest2").attr("src",imgA);				
         			sym.getSymbol("matchtracker").$("team1Txt").text(matchteam1);
         			sym.getSymbol("matchtracker").$("team2Txt").text(matchteam2);
         			sym.getSymbol("matchtracker").$("scoreTxt").text(matchscore);
         			sym.getSymbol("matchtracker").$("matchTxt").html(matchInfo);
                  //matchStatus 8 (in progress), 128 (finished)                
         			if (matchStatus>=8){
         				//getMatch();
         //				showMatchDetail(matchID);
         			} 							
         		}
         	});
         }
         
         var showMatchDetail = function(match){ //to handle lexical scope
         	return function (e) {
         		getMatch(match);
         		getTeams(match);
         	};
         };
         
                  var matchData;
                  var diff1;
                  var diff2;
                  var vAlign;
                  var posY;
                  var lastAction;
                  var lastTime;
                  var offset = 300000;
         			var homePenHeight;
                  var awayPenHeight;
                  var penHeight;
         			var penShow;
         
         function getMatch(matchID) { 
         	var minutes = sym.getSymbol("matchtracker").$("timeTxt");
         	minutes.text("0");
         	var myTimer = sym.getSymbol("matchtracker").getSymbol("timer");
         	myTimer.stop(0);
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn=30756&yr=2013&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			matchData = data;
         			//actionsHomeArr.length=0;
         			//actionsAwayArr.length=0;
         			//play from last action
         			lastAction = matchData[matchData.length-1].n_ActionTime;
         			var lastPeriod = matchData[matchData.length-1].n_PeriodSort;
         			var offset = 300000;
         			if (lastAction>7200000){					//if after 120 mins but before penalties
         				lastTime=7200000+offset;
         			}else if ((lastAction>6300000)&&(lastPeriod<7)){					//if after 105 mins but before second period
         				lastTime=6300000+offset;
         			}else if ((lastAction>5400000)&&(lastPeriod<5)){					//if after 90 mins but before extra time
         				lastTime=5400000+offset;
         			}else if((lastAction>2700000)&&(lastPeriod<4)){ 		// if match is in 1st half but > 45 mins
         				lastTime=2700000+offset;
         			}else{
         				lastTime=lastAction+offset;
         			}
         			myTimer.play(lastTime);
         			//if penalty shootout Knockout competetions only
         			if (lastPeriod>5){
         				sym.getSymbol("matchtracker").getSymbol("timer").$("timeline").css({'cursor':'ns-resize'});
         				sym.getSymbol("matchtracker").$("timer").on("touchstart",touchStartY);
         				sym.getSymbol("matchtracker").$("timer").on("touchmove", moveMeTimer); //bind touch function
         				sym.getSymbol("matchtracker").$("timer").on("mousedown", mouseMoveTimer); //bind mouse function
                  }
         			//if (lastPeriod>=10){
         			if (lastPeriod==10){
         				sym.getSymbol("matchtracker").getSymbol("timer").$("penalties").unbind("click");
         				sym.getSymbol("matchtracker").getSymbol("timer").$("penalties").show();
         				sym.getSymbol("matchtracker").getSymbol("timer").$("penalties").css({'cursor':'pointer'});
         				penShow="show";
         				sym.getSymbol("matchtracker").getSymbol("timer").$("penalties").click(showPenalties);
         			}
                  //display latest time
                  var minutes = sym.getSymbol("matchtracker").$("timeTxt");
                  if (lastPeriod<9){ //before penalty shootout
         				if(lastAction > 0){		    
         					if (sym.isPlaying ("timer")){
         						minutes.text(Math.round(sym.getSymbol("matchtracker").getSymbol("timer").getPosition()/60000)-5);
         					}else{
         						minutes.text(Math.round(lastAction/60000));
         					}
         				}
         			}else{
         				minutes.text("120");
         			}
         
                  //create display for each action	
                  var actionTxt;
                  var penTxt;
                  var HorA;
                  var actionSet;
                  var actionType;
                  var action;
                  var actionTime;
         			var actionMs;
                  var actionPeriod;
                  var player;
                  var sub;			
                  for (var i = 0; i <= matchData.length; i++) {		        
                  	actionSet = matchData[i].n_ActionSet;
                  	actionType = matchData[i].n_ActionCode;
                  	actionTime = matchData[i].c_ActionMinute;
         				if (actionSet==1||actionSet==2||actionSet==3||actionSet==5){
         					actionMs = matchData[i].n_ActionTime;
         					actionPeriod = matchData[i].n_PeriodSort;
         					player = matchData[i].c_PersonShort;
         					sub = matchData[i].c_SubPersonShort;
         					var obj=	{number:i, time:actionMs};					
         						if (matchData[i].n_HomeOrAway==1){
         							actionTxt = "<div id='action" + i + "' class='actionhome'><div class='whitebg'><div class='tablecell' style='width:75%'><span id='person" + i + "'></span><span id='subperson" + i + "'><span></div><div class='tablecell' id='actionMins" + i + "'></div></div><div id='type" + i + "'></div></div>";
         							penTxt = "<div class='penalty'><table width='100%' style='border:none; border-collapse:collapse'><tr><td id='person" + i + "' width='90%' style='text-align:right'></td><td width='10%' id='type" + i + "'></td></tr></table></div>";
         							HorA = "home";
         							//actionsHomeArr.push(obj);
         						}else if (matchData[i].n_HomeOrAway==-1){
         							//actionsAwayArr.push(obj);
         							HorA = "away";
         							actionTxt = "<div id='action" + i + "' class='actionaway'><div id='type" + i + "'></div><div class='whitebg'><div class='tablecell' id='actionMins" + i + "'></div><div class='tablecell' style='width:75%'><span id='person" + i + "'></span><span id='subperson" + i + "'><span></div></div></div>";
         							penTxt = "<div class='penalty'><table width='100%' style='border:none; border-collapse:collapse'><tr><td width='10%' id='type" + i + "'></td><td id='person" + i + "' width='90%' style='text-align:left'></td></tr></table></div>";
         						}
         					//then append each action (latest at top)
         						if(matchData[i].n_PeriodSort<10){
         							sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("timeline").$(HorA).append(actionTxt);
         						}else{
         							sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("penalties").getSymbol("pensDiv").$(HorA+"Pens").prepend(penTxt);
         						}
         						$('#person' + i).text(matchData[i].c_PersonShort);
                           $('#actionMins' + i).text(matchData[i].c_ActionMinute);     
         						if (matchData[i].n_ActionSet==5){
         							$('#subperson' + i).text(" (" + matchData[i].c_SubPersonShort + ")");
         						}else{
         							$('#subperson' + i).text("");
         						} 
         						//create icons for each action
         						switch (actionSet){
         							case 1:
         							action= "goal";
         							break;
         							case 2:
         							if (actionType==12){
         								action="pen";
         							}else{
         								action="miss";
         							}
         							break;
         							case 3:
         							if (actionType==2048){
         								action="yellow";
         							}else{
         								action="red";
         							}
         							break;
         							case 5:
         							action="sub";
         							break;
         						}
         						var imgHTML="<img src='images/"+action +".png' height='25px' width='25px'>";
         						$('#type' + i).html(imgHTML);
         
         						$('.whitebg').css({'width':'83%','background-color':'rgba(255,255,255,0.6)','pointer-events':'none','vertical-align':'top', 'float':'left','border-radius':'5px', 'padding':'1px 3px', 'display':'inline-table'});		
         						$('.actionaway .whitebg').css({'float':'right'});		
         						$('.actionhome, .actionaway').css({'width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif','text-align':'left'});
         						$('.tablecell').css({'display':'table-cell'});
         						$('#action' + i).css({'cursor':'pointer','border-radius':'7px', 'height':'20px', 'overflow':'hidden', 'padding':'0'});
         						$('#action' + i).on('mouseover touchstart',function(i){ $(this).css({'z-index':'1000', 'background-color':'rgba(255,255,255,0.8)','box-shadow':'2px 2px 2px rgba(100,100,100,0.5)', 'overflow':'visible','height':'auto' });  });
         						$('#action' + i).on('mouseout touchend',function(){ $(this).css({'z-index':'100', 'background-color':'rgba(255,255,255,0)','box-shadow':'none', 'overflow':'hidden','height':'20px'}); });
         						$('#type' + i).css({'display':'inline'});
         						$('.actionhome #actionMins'+i).css({'text-align':'right'});
         						$('.actionaway #actionMins'+i).css({'text-align':'left'});
         						$('.penalty').css({"background-color":"rgb(255,255,255)","height":"25px","box-shadow":"1px 3px 3px rgba(100,100,100,0.5)","font-size":"12px","font-family":"pragmatica-web, sans-serif", "text-align":"left"});
         							//move actions that are too close together
         							//TRY LOOPING THROUGH actionsHomeArr, COMPARE i==actionsHomeArr[x].number AND TIME WITH actionsHomeArr[x-1].time
         
         							if (i+1 < matchData.length){
         								diff1 = matchData[i+1].n_ActionTime-matchData[i].n_ActionTime;
         								//if (diff1<120000){
         								if (diff1<150000){
         									posoffset=12;
         									//posoffset=18;				
         								}else{
         									//posoffset=0;
         									posoffset=3;
         								}
         							}
         							else{
         								//posoffset=0;
         								posoffset=3;
         							}
         							if ((matchData[i].n_ActionTime>=7200000)&&(lastPeriod<9)){
         								posY="-12px";
         							}else if ((matchData[i].n_ActionTime>=5400000)&&(lastPeriod<5)){
         								posY="-134px";
         							}else{
         							//90minute match
         								posY = 515-Math.round(405/90 * (matchData[i].n_ActionTime/60000)) + posoffset + "px";
         							}
         						$('#action' + i).css({'position':'absolute', 'top':posY});
         				} //close if
         				else if (actionSet==16){
         					lastTime=matchData[i].n_ActionTime;
         					myTimer.stop(lastTime);
         					minutes.text(Math.round(lastTime/60000));
         				}
         			} //close for 
         			homePenHeight=sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("penalties").getSymbol("pensDiv").$("homePens").height();
         			awayPenHeight=sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("penalties").getSymbol("pensDiv").$("awayPens").height();
         			penHeight = (homePenHeight>awayPenHeight)?homePenHeight:awayPenHeight;
         		} //close success  	                                                  	           
         	}); //close ajax
         }
         
         
         
         function showPenalties(){
         	if(penShow=="show"){
         		penShow="hide";
         		sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("penalties").$("pensDiv").hide();
         		sym.getSymbol("matchtracker").getSymbol("timer").$("timeline").css({'top':0}); //move timeline down
         	}else{
         		penShow="show";
         		sym.getSymbol("matchtracker").getSymbol("timer").getSymbol("penalties").$("pensDiv").show();
         		sym.getSymbol("matchtracker").getSymbol("timer").$("timeline").css({'top':penHeight}); //move timeline down
         	}
         }
         
         function getTeams(matchID) {           
         	var teamData;
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn=30756&yr=2013&q=teams&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			teamData = data;
         			for (var i = 0; i < teamData.length; i++) {		
         				if (teamData[i].n_HomeOrAway==1){
         					var teamlist = "hometeam";
         				}else if (teamData[i].n_HomeOrAway==-1){
                  		var teamlist = "awayteam";
         				}
                  //		if (teamData[i].n_ActionSet!==6){			
         				if (teamData[i].n_ActionSet==4){
         					var lineupTxt = "<table width='100%' style='font-size:13px;font-family:pragmatica-web, sans-serif; border-collapse:collapse' id='lineup" + i + "'><tr><td width='10%' style='text-align:right;' id='teamShirt" + i + "'></td><td width='75%' style='padding-left:5px' id='teamPerson" + i + "'></td><td width='15%' style='font-style:oblique; font-size:11px; text-align:right' id='teamNat" + i + "'></td></tr></table>";
         				} else if (teamData[i].n_ActionSet==5){
         					var lineupTxt = "<table width='100%' style='font-size:13px;font-family:pragmatica-web, sans-serif; border-collapse:collapse' id='substitute" + i + "'><tr><td width='10%' style='text-align:right; font-style:oblique' id='teamShirt" + i + "'></td><td width='75%' style='font-style:oblique; padding-left:5px' id='teamPerson" + i + "'></td><td width='15%' style='font-style:oblique; font-size:11px; text-align:right' id='teamNat" + i + "'></td></tr></table>";
         				} else if (teamData[i].n_ActionSet==8){
         					var coach = "<b>" + teamData[i].c_Person + "</b> <span style='text-align:right; font-style:oblique; font-size:12px'>" + teamData[i].c_PersonNatioShort + "</span>";
         				}
         				sym.getSymbol("matchtracker").getSymbol("teams").$(teamlist).append(lineupTxt);                
         				sym.getSymbol("matchtracker").getSymbol("teams").$(teamlist + "Txt").html(coach);
         				var actionMins;	                
         				if (teamData[i].c_ActionMinute==null){
         					actionMins="";
         				}else{
         					actionMins=" ("+ teamData[i].c_ActionMinute + ")";
         				}			
         				$('#teamShirt' + i).text(teamData[i].n_ShirtNr);
         				$('#teamPerson' + i).html(teamData[i].c_Person + actionMins);
         				$('#teamNat' + i).text(teamData[i].c_PersonNatioShort);
         				$('#subPerson' + i).text(teamData[i].c_SubPersonShort);
         				$('#actionMins' + i).text(teamData[i].c_ActionMinute); 
         				var posn = teamData[i].n_Position;			
         			}
                  //			}  
         		}
         	});
         }
         
         //SCROLL TIMELINE
         	var timer = sym.$("timer");
         	var timeHeight = timer.height();
         	var timerY = timer.offset().top;
         	var timerBottomY = timerY + timeHeight;
         	var startY=0;
         	var moveTimer=0
         var startTimer=timerY;
         var timeLine = sym.getSymbol("matchtracker").getSymbol("timer").$("timeline");
         var timeLineHeight = timeLine.height();
         var moveTimerStrip = timeLineHeight-timeHeight;
         	timer.bind("touchstart touchmove", moveMeTimer); //bind touch function
         	timer.bind("mousedown", mouseMoveTimer); //bind mouse function
         
         function touchStartY(e){ //handle touch event
         	startY = e.touches[0].pageY;
         }
         //
         function moveMeTimer(e) {
         		e.preventDefault(); //prevents it firing a mouse click when touched
         		var orig = e.originalEvent;
         		var pos = 0;
         		pos = orig.touches[0].pageY;
         var moveDistance=startY-pos;
         moveTimer=startTimer-moveDistance;   
         	if(pos>=timerY&&pos<=timerBottomY){
         		if(moveTimer<=0){
                  sym.getSymbol("timer").$("timeline").css({'top':moveTimer});
                 }
         	}
         };
         //
         function mouseMoveTimer(e){ //handle mousedown event
         startY = e.pageY;
         sym.getComposition().getStage().getSymbolElement().mousemove(handleMouseMoveTimer); //bind mousemove functions to stage in case cursor goes oustide the thumb
         sym.getComposition().getStage().getSymbolElement().mouseup(handleMouseUpTimer); //bind mouseup functions to stage 
         }	
         
         function handleMouseMoveTimer(jqEvent){
         	var pos = 0;
         		pos = jqEvent.pageY;
         	var moveDistance=startY-pos;
         	moveTimer=startTimer-moveDistance;
         			if(pos>=timerY&&pos<=timerBottomY){
         			if(moveTimer<=0){
                  	sym.getSymbol("timer").$("timeline").css({'top':moveTimer});
                  }
         		}
         }
         
         
         function handleMouseUpTimer(jqEvent){ // handle mouseup event
         sym.getComposition().getStage().getSymbolElement().unbind("mousemove");
         sym.getComposition().getStage().getSymbolElement().unbind("mouseup");
         startTimer=moveTimer;
         }
         
         function handleTouchUpTimer(jqEvent){ // handle touchup event
         sym.getComposition().getStage().getSymbolElement().unbind("touchmove");
         sym.getComposition().getStage().getSymbolElement().unbind("touchend");
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

//=========================================================
   //Edge symbol: 'panel01'
   (function(symbolName) {

   })("panel01");
   //Edge symbol end:'panel01'

//=========================================================
   //Edge symbol: 'matchtracker'
   (function(symbolName) {

      

      

   })("matchtracker");
   //Edge symbol end:'matchtracker'

   //=========================================================
   
   //Edge symbol: 'UpButton'
   (function(symbolName) {   
   
   })("UpButton");
   //Edge symbol end:'UpButton'

   //=========================================================
   
   //Edge symbol: 'panel03'
   (function(symbolName) {   
   
   })("panel03");
   //Edge symbol end:'panel03'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'button_strip'
   (function(symbolName) {   
   
   })("button_strip");
   //Edge symbol end:'button_strip'

   //=========================================================
   
   //Edge symbol: 'strip'
   (function(symbolName) {   
   
   })("strip");
   //Edge symbol end:'strip'

   //=========================================================
   
   //Edge symbol: 'xpand1'
   (function(symbolName) {   
   
   })("xpand1");
   //Edge symbol end:'xpand1'

   //=========================================================
   
   //Edge symbol: 'Teams'
   (function(symbolName) {   
   
   })("Teams");
   //Edge symbol end:'Teams'

   //=========================================================
   
   //Edge symbol: 'Timer'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000000, function(sym, e) {
         sym.stop();
         // insert code here

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5700500, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6600000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("Timer");
   //Edge symbol end:'Timer'

   //=========================================================
   
   //Edge symbol: 'Penalties'
   (function(symbolName) {   
   
   })("Penalties");
   //Edge symbol end:'Penalties'

   //=========================================================
   
   //Edge symbol: 'PensDiv'
   (function(symbolName) {   
   
   })("PensDiv");
   //Edge symbol end:'PensDiv'

   //=========================================================
   
   //Edge symbol: 'Timeline'
   (function(symbolName) {   
   
   })("Timeline");
   //Edge symbol end:'Timeline'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

})(jQuery, AdobeEdge, "GraphicNews30756");