/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         //Text & other variables
         sym.$("captionTxt").css('line-height', '145%');
         sym.$("pictureTxt").css({'padding-left': '7px','padding-right':'6px', 'padding-top':'1px', 'padding-bottom':'3px','width':'176px'});
         var boxHeight=sym.$("white_keyline").height();
         var cap2Height;
         var headline;
         var headlinetxt = sym.$("headlineTxt");
         var order;
         var caption;
         var captionArr=[];
         var caption2Arr=[];
         var countryString;
         var countryArr;
         var source;
         var drag;
         var keya;
         var keyb;
         var keyc;
         var pictures;
         var mainPic = sym.$("main_pic");
         //UNCOMMENT THE FOLLOWING TO USE MULTIPLE CAPTIONS IN AN ARRAY. The array can only contain captions within the same Symbol 
         /*
         var captionArr=[];  //array of text boxes - EDIT TO MATCH THE NUMBER OF TEXT BOXES
         for (var i = 0; i < 3; i++) {
         				captionArr.push(sym.getSymbol("stageMc").$("captiontxt"+i));
         }
         */
         //end captions
         
         
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         function resetCaps(){
         $.ajax({	
         	type: "GET",
         	url: "GN30742.xml",
         	dataType: "xml",
         	success: function(xml) {
         
         		headline = $(xml).find('headline').text();
         		sym.$("headlineTxt").html(headline);
         
         		order = $(xml).find('order0').text();
         		sym.$("orderTxt").html(order);
         
         		countryString= $(xml).find('countries').text();
         		countryArr=countryString.split(",");
         
         		for (var i=0;i<36;i++){
         		captionArr[i]= $(xml).find('caption'+i).text();
         		caption2Arr[i]= $(xml).find('picture'+i).text();
         		}
         		sym.$("captionTxt").html(captionArr[0]);
         		sym.$("pictureTxt").html(caption2Arr[0]);
         		cap2Height=sym.$("pictureTxt").height();
         		sym.$("white_keyline").height(boxHeight+cap2Height+6);
         
         
         		keya = $(xml).find('keya').text();
         		sym.$("keyaTxt").html(keya);
         
         		keyb = $(xml).find('keyb').text();
         		sym.$("keybTxt").html(keyb);
         
         		keyc = $(xml).find('keyc').text();
         		sym.$("keycTxt").html(keyc);
         
         		source = $(xml).find('source').text();
         		sym.$("sourceTxt").html(source);
         
         
         	//TO PLACE XML CAPTIONS WITHIN TEXT BOXES FROM CAPTION ARRAY
              	//captionArr[0].html("caption1");
               //captionArr[1].html("caption2");
               //captionArr[2].html("caption3");
         
         		}
         	});
         }
         resetCaps();
         
         
         // Load Edge Commons 
         yepnope({
         	load:	"http://cdn.edgecommons.org/an/1.0.0/js/min/EdgeCommons.js",
         	complete: function() {
         
         		// Enable SVG access
         		// Watch extended tutorial on YouTube: http://www.youtube.com/watch?v=4UEB6gaLKuw
         		EC.SVG.accessSVG(sym.$("eu")).done(
         			function(svgDocument){
         
         				// add event listener
         				svgDocument.addEventListener("select", function(event) {
         
         					// Remember selected part
         					sym.setVariable("selectedPart", event.target);
         
         					//get the value of a Symbol variable
         					var countrySelect = sym.getVariable("selectedPart");
         					// show the id of the selected part in the textfield
         						for (var i=0; i<36; i++){
         							if (event.target.id==countryArr[i]){
         								sym.$("captionTxt").html( captionArr[i] );
         								sym.$("pictureTxt").html( caption2Arr[i] );
         								sym.$("flag").attr("src","flags/"+countryArr[i]+".png");
         								cap2Height=sym.$("pictureTxt").height();
         								sym.$("white_keyline").height(boxHeight+cap2Height+6);
         
         							}
         						}
         				});
         
         //------------------------------------------------------				
         				svgDocument.addEventListener("over", function(event) {
         
         					// Remember selected part
         					sym.setVariable("overPart", event.target);
         
         					//get the value of a Symbol variable
         					var countryOver = sym.getVariable("overPart");
         					// show the id of the selected part in the textfield
         					//$(countryOver).css("fill", "rgb(0,0,0)");
         					countryOver.style.fill="#333333";
         
         				});
         //----------------------------------------------
         				//------------------------------------------------------				
         				svgDocument.addEventListener("out", function(event) {
         
         					// Remember selected part
         					sym.setVariable("outPart", event.target);
         
         					//get the value of a Symbol variable
         					var countryOut = sym.getVariable("outPart");
         					// show the id of the selected part in the textfield
         					countryOut.style.fill="";
         
         				});
         
         //----------------------------------------------
         		});
         
         	}
         });
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'capBox'
   (function(symbolName) {   
   
   })("capBox");
   //Edge symbol end:'capBox'

})(jQuery, AdobeEdge, "GraphicNews30742");