/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         sym.$("captionTxt").css('line-height', '120%');
         var headline;
         var headlinetxt = sym.$("headlineTxt");
         var order;
         var caption;
         var sources;
         var pictures;
         var mainPic = sym.$("main_pic");
         
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         function resetCaps(){
         $.ajax({	
         	type: "GET",
         	url: "GN30171.xml",
         	dataType: "xml",
         	success: function(xml) {
         
         		headline = $(xml).find('headline').text();
         		sym.$("headlineTxt").html(headline);
         
         		order = $(xml).find('order0').text();
         		sym.$("orderTxt").html(order);
         
         		caption = $(xml).find('caption0').text();
         		sym.$("captionTxt").html(caption);
         
         		sources = $(xml).find('sources').text();
         		sym.$("sourcesTxt").html(sources);
         
         		pictures = $(xml).find('picture0').text();
         		sym.$("pictureTxt").html(pictures);
         
         		}
         	});
         }
         resetCaps();
         
         
         //CHANGE THE FOLLOWING	
         var thumbWidth=83; //distance between origin of thumbnail images
         var n=44; //number of images
         var thumbs = 9; //number of thumbnails per screen
         var space = 31; //pixels offset at beginning of buttonstrip
         var ttime= 500; //transition time in milliseconds
         var stripw=3641; //width of button strip symbol
         var RTL="false"; //change true/false to change direction
         var igmeasure=800; //width of whole graphic
         //For RTL, the order of the images must also be reversed and the button strip moved so that it starts on the RH side of the graphic
         //END CHANGES
         
         var rtloff=igmeasure-stripw;//width of iGraphic - needed for RTL conversion
         var fwd;
         var back;
         fwd=(RTL=="true")?0:1; 
         back=(RTL=="true")?1:0;
         
         //set variables for image gallery
         sym.setVariable("number", 0);
         sym.setVariable("strip", 0);
         
         //CREATE MAIN FORWARD-BACK BUTTONS
         var mainbtnArray = ["mainBtn0","mainBtn1"]; // back and forward buttons
         		for (var m=0; m<mainbtnArray.length; m++){
         		sym.$("mainBtn"+m).bind('click', mainbtnClick);
         		//sym.$("mainBtn"+i).bind('mouseover', btnShow);
         		//sym.$("mainBtn"+i).bind('mouseout', btnHide);
         		}
         function mainbtnClick() {
         			var selected_id = $(this).attr("id");
         			$.ajax({    
             		type: "GET",
             		url: "GN30171.xml",
             		dataType: "xml",
             		success: function(xml) { 
          			var id = sym.getVariable("number");
         			var next;
         			if(selected_id == "Stage_mainBtn"+back){
         				next = id-1;
          				if(next<1){
         				sym.$("mainBtn"+back).hide();
         				sym.$("stripBtn"+back).hide();
         				}
         				if(next<n-thumbs){
         				sym.$("stripBtn"+fwd).show();
         				}
         				if(next>n-thumbs){
         				sym.$("stripBtn"+fwd).hide();
         				}
         				if(next<n-1){
         				sym.$("mainBtn"+fwd).show();
         				}
         				if (id>n-thumbs){
         					if (RTL=="true"){
         							sym.getSymbol("slider").$("buttonstrip").animate ({left: rtloff+((n-thumbs)*(thumbWidth))-space}, 0);
         					}else{
         							sym.getSymbol("slider").$("buttonstrip").animate ({left: ((n-thumbs)*-(thumbWidth))+space}, 0);
         					}
         
         				}else{
         					if (RTL=="true"){
         							sym.getSymbol("slider").$("buttonstrip").animate ({left: rtloff+(next*(thumbWidth))-space}, ttime);
         					}else{
         							sym.getSymbol("slider").$("buttonstrip").animate ({left: (next*-(thumbWidth))+space}, ttime);
         					}
         				}
         			}else{  
         			//forward button
         			next = id+1;
         				if(next>0){
         				sym.$("mainBtn"+back).show();
         				sym.$("stripBtn"+fwd).show();
         				}
         				if(next<n-thumbs-1){
         				sym.$("stripBtn"+back).show();
         				}
         				if(next>n-thumbs-1){
         				sym.$("stripBtn"+back).hide();
         				}
         				if(next>n-2){
         				sym.$("mainBtn"+fwd).hide();
         				}
         				if (id<n-thumbs){
         					if (RTL=="true"){
         							sym.getSymbol("slider").$("buttonstrip").animate ({left: rtloff+(next*(thumbWidth))-space}, ttime);
         					}else{
         							sym.getSymbol("slider").$("buttonstrip").animate ({left: (next*-(thumbWidth))+space}, ttime);
         					}
         				}
         			}
         			    pictures = $(xml).find('picture'+next).text();
                 		sym.$("pictureTxt").html(pictures);
                 		caption = $(xml).find('caption'+next).text();
                 		sym.$("captionTxt").html(caption);
                 		order = $(xml).find('order'+next).text();
                 		sym.$("orderTxt").html(order);
         
         			for (var i=0; i<n; i++){
         				if (i==next){
         				mainPic.attr("src","images/pic_"+next+".jpg");
         				sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+next).css({"border-width":"3px","border-style":"solid","border-color":"rgba(100,100,100,0.75)"});
         				}else{
         				sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).css({"border-width":"3px","border-style":"solid","border-color":"rgba(100,100,100,0)"});
         				}
         			}
         				sym.setVariable("number", next);
         				//sym.getSymbol("slider").$("buttonstrip").animate ({left: (thumbs*s*-(thumbWidth))+space}, ttime);		
                        }
             		});
         			e.preventDefault()
         }
         
         
         
         //CREATE BACK AND FORWARD BUTTONS on BUTTONSTRIP
         var btnArray = ["stripBtn0","stripBtn1"]; // back and forward buttons
         		for (var b=0; b<btnArray.length; b++){
         		sym.$("stripBtn"+b).bind('click', stripbtnClick);
         		//sym.$("stripBtn"+i).bind('mouseover', btnShow);
         		//sym.$("stripBtn"+i).bind('mouseout', btnHide);
         		}
         
         function stripbtnClickOld() {
         			var selected_id = $(this).attr("id");
         			var s = sym.getVariable("strip");
         		if(selected_id == "Stage_stripBtn0"){ //back button
         			if (s>0){ if (s<=i){ sym.$("stripBtn0").hide(); }else{ sym.$("stripBtn0").show(); } 
         			s=s-1;
         			}else{ s=0; 	sym.$("stripBtn0").hide(); }
         			sym.getSymbol("slider").$("buttonstrip").animate ({left: (thumbs*s*-(thumbWidth))+space}, ttime);
         			sym.$("stripBtn1").show(); 
         		}else{  //forward button
         			if (s>(n/thumbs)-2){ s= Math.floor(n/thumbs); 
         			sym.getSymbol("slider").$("buttonstrip").animate ({left: ((n-thumbs)*-(thumbWidth))+space}, ttime);
         			sym.$("stripBtn1").hide();
         			}else{ 
         			s=s+1;
         			sym.getSymbol("slider").$("buttonstrip").animate ({left: (thumbs*s*-(thumbWidth))+space}, ttime);
         			sym.$("stripBtn1").show();
         			}
         			sym.$("stripBtn0").show(); 
         
         		}
         		sym.setVariable("strip", s);
         		e.preventDefault()
         		}
         
         
         function stripbtnClick() {
         			var selected_id = $(this).attr("id");
         			var s = sym.getVariable("strip");
         		if(selected_id == "Stage_stripBtn"+back){ //back button
         			if (s>0){ 
         				if (s<=i){ 
         					sym.$("stripBtn"+back).hide(); 
         				}else{
         					sym.$("stripBtn"+back).show(); 
         					} 
         				s=s-1;
         			}else{
         				 s=0; 	
         				 sym.$("stripBtn"+back).hide(); 
         				 }
         					if(RTL=="true"){
         					sym.getSymbol("slider").$("buttonstrip").animate ({left: rtloff+(thumbs*s*(thumbWidth))-space}, ttime);
         					}else{
         					sym.getSymbol("slider").$("buttonstrip").animate ({left: (thumbs*s*-(thumbWidth))+space}, ttime);
         					}
         			sym.$("stripBtn"+fwd).show(); 
         		}else{  //forward button
         			if (s>(n/thumbs)-2){ s= Math.floor(n/thumbs);
         					if(RTL=="true"){
         					sym.getSymbol("slider").$("buttonstrip").animate ({left: rtloff+((n-thumbs)*(thumbWidth))-space}, ttime);
         					}else{
         					sym.getSymbol("slider").$("buttonstrip").animate ({left: ((n-thumbs)*-(thumbWidth))+space}, ttime);					
         					}
         				sym.$("stripBtn"+fwd).hide();
         			}else{ 
         				s=s+1;
         					if(RTL=="true"){
         					sym.getSymbol("slider").$("buttonstrip").animate ({left: rtloff+(thumbs*s*(thumbWidth))-space}, ttime);
         					}else{
         					sym.getSymbol("slider").$("buttonstrip").animate ({left: (thumbs*s*-(thumbWidth))+space}, ttime);					
         					}
         				sym.$("stripBtn"+fwd).show();
         			}
         			sym.$("stripBtn"+back).show(); 
         
         		}
         		sym.setVariable("strip", s);
         		e.preventDefault()
         	}
         
         
         //CREATE THUMBNAIL IMAGE BUTTONS
         for (var j=0; j<n; j++){
         		sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+j).bind('click', thClick);
         		sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+j).css({"border-width":"3px","border-style":"solid","border-color":"rgba(100,100,100,0)"});
         		}
         
         function thClick() {
         			var selected_id = $(this).attr("id");
         			$.ajax({    
             				type: "GET",
             				url: "GN30171.xml",
             				dataType: "xml",
             				success: function(xml) {
         					for (var i=0; i<n; i++){
         						if(selected_id == "Stage_slider_buttonstrip_btn" + i){
         						pictures = $(xml).find('picture' + i).text();
                 				sym.$("pictureTxt").html(pictures);    
                 				caption = $(xml).find('caption' + i).text();
                 				sym.$("captionTxt").html(caption);
                 				order = $(xml).find('order' + i).text();
                 				sym.$("orderTxt").html(order);
         						sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).css({"border-width":"3px","border-style":"solid","border-color":"rgba(100,100,100,0.75)"});
         						mainPic.attr("src","images/pic_"+i+".jpg");
         							if(i>0){ sym.$("mainBtn"+back).show(); sym.$("stripBtn"+back).show(); }//show back button once selected image is past the first
         							if(i<1){ sym.$("mainBtn"+back).hide(); sym.$("stripBtn0"+back).hide(); }//hide back button if first image is selected
         							if(i<n-thumbs-1){ sym.$("stripBtn"+fwd).show(); }	//hide forward button if last image is selected
         							if(i>n-thumbs-1){ sym.$("stripBtn"+fwd).hide(); }	//hide forward button if last image is selected	
         							if(i>n-2){ sym.$("mainBtn"+fwd).hide(); }	//hide forward button if last image is selected	
         							if(i<n-1){ sym.$("mainBtn"+fwd).show(); }	//show forward button if selected image is before the last
         							//move strip horizontally
         
         							if (i<n-thumbs+1){
         								if(RTL=="true"){
         								sym.getSymbol("slider").$("buttonstrip").animate ({left: rtloff+(i*(thumbWidth))-space}, ttime); 
         								}else{
         								sym.getSymbol("slider").$("buttonstrip").animate ({left: (i*-(thumbWidth))+space}, ttime); 
         								}
         							}else{ 
         								if(RTL=="true"){
         								sym.getSymbol("slider").$("buttonstrip").animate ({left: rtloff+((n-thumbs)*(thumbWidth))-space}, ttime);
         								}else{
         								sym.getSymbol("slider").$("buttonstrip").animate ({left: ((n-thumbs)*-(thumbWidth))+space}, ttime);
         								}
         							}
         
         						sym.setVariable("strip", Math.floor(i/thumbs));
         						sym.setVariable("number", i);
         						}else{				
         					sym.getSymbol("slider").getSymbol("buttonstrip").$("btn"+i).css({"border-width":"3px","border-style":"solid","border-color":"rgba(100,100,100,0)"});
         					}
         			}
                         }
             			});
         		e.preventDefault()
         		}
         
         sym.$("mainBtn"+back).hide();
         sym.$("stripBtn"+back).hide();

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

   })("stage");
   //Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'backBtn'
(function(symbolName) {

















})("back_butt");
   //Edge symbol end:'back_butt'

//=========================================================

//Edge symbol: 'forwardBtn'
(function(symbolName) {

















})("forward_butt");
   //Edge symbol end:'forward_butt'

   //=========================================================
   
   //Edge symbol: 'button_strip'
   (function(symbolName) {   
   
      

   })("button_strip");
   //Edge symbol end:'button_strip'

   //=========================================================
   
   //Edge symbol: 'strip'
   (function(symbolName) {   
   
   })("strip");
   //Edge symbol end:'strip'

})(jQuery, AdobeEdge, "GraphicNews30171");