/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // insert code for compositionReady event here
         
         var headline;
         var pictures;
         var copyright;
         var lineup;
         var d62;
         var d70;
         var d80;
         var d90;
         var d00;
         var d10;
         var albums;
         var a01alb;
         var a04alb;
         var a08alb;
         var a09alb;
         var a11alb;
         var a12alb;
         var a13alb;
         var a14alb;
         var a15alb;
         var a16alb;
         var a17alb;
         var a18alb;
         var a19alb;
         var a20alb;
         var a21alb;
         var a22alb;
         var a23alb;
         var a24alb;
         var a25alb;
         var a26alb;
         var a27alb;
         var hotlicks;
         var photo_01_cap;
         var photo_02_cap;
         var photo_03_cap;
         var photo_04_cap;
         var photo_05_cap;
         var photo_06_cap;
         var taylor_d_cap;
         var chapman_cap;
         var stewart_cap;
         var jones_cap;
         var taylor_m_cap;
         var wyman_cap;
         
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         
         $.ajax({	
         	type: "GET",
         	url: "GN29965.xml",
         	dataType: "xml",
         	success: function(xml) {
         
         		headline = $(xml).find('headlineTxt').text();
         		sym.$("headlineTxt").html(headline);
         
         		pictures = $(xml).find('picturesTxt').text();
         		sym.$("picturesTxt").html(pictures);
         
         		copyright = $(xml).find('copyrightTxt').text();
         		sym.$("copyrightTxt").html(copyright);
         
         		lineup = $(xml).find('lineupTxt').text();
         		sym.getSymbol("timeline_sheet_sym").$("lineupTxt").html(lineup);
         
         		d62 = $(xml).find('d62Txt').text();
         		sym.getSymbol("timeline_sheet_sym").$("d62Txt").html(d62);
         
         		d70 = $(xml).find('d70Txt').text();
         		sym.getSymbol("timeline_sheet_sym").$("d70Txt").html(d70);
         
         		d80 = $(xml).find('d80Txt').text();
         		sym.getSymbol("timeline_sheet_sym").$("d80Txt").html(d80);
         
         		d90 = $(xml).find('d90Txt').text();
         		sym.getSymbol("timeline_sheet_sym").$("d90Txt").html(d90);
         
         		d00 = $(xml).find('d00Txt').text();
         		sym.getSymbol("timeline_sheet_sym").$("d00Txt").html(d00);
         
         		d10 = $(xml).find('d10Txt').text();
         		sym.getSymbol("timeline_sheet_sym").$("d10Txt").html(d10);
         
         		albums = $(xml).find('albumsTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("albumsTxt").html(albums);
         
         		hotlicks = $(xml).find('hotlicksTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("hotlicksTxt").html(hotlicks);
         
         		a01alb = $(xml).find('a01albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a01albTxt").html(a01alb);
         
         		a04alb = $(xml).find('a04albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a04albTxt").html(a04alb);
         
         		a08alb = $(xml).find('a08albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a08albTxt").html(a08alb);
         
         		a09alb = $(xml).find('a09albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a09albTxt").html(a09alb);
         
         		a11alb = $(xml).find('a11albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a11albTxt").html(a11alb);
         
         		a12alb = $(xml).find('a12albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a12albTxt").html(a12alb);
         
         		a13alb = $(xml).find('a13albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a13albTxt").html(a13alb);
         
         		a14alb = $(xml).find('a14albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a14albTxt").html(a14alb);
         
         		a15alb = $(xml).find('a15albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a15albTxt").html(a15alb);
         
         		a16alb = $(xml).find('a16albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a16albTxt").html(a16alb);
         
         		a17alb = $(xml).find('a17albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a17albTxt").html(a17alb);
         
         		a18alb = $(xml).find('a18albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a18albTxt").html(a18alb);
         
         		a19alb = $(xml).find('a19albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a19albTxt").html(a19alb);
         
         		a20alb = $(xml).find('a20albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a20albTxt").html(a20alb);
         
         		a21alb = $(xml).find('a21albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a21albTxt").html(a21alb);
         
         		a22alb = $(xml).find('a22albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a22albTxt").html(a22alb);
         
         		a23alb = $(xml).find('a23albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a23albTxt").html(a23alb);
         
         		a24alb = $(xml).find('a24albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a24albTxt").html(a24alb);
         
         		a25alb = $(xml).find('a25albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a25albTxt").html(a25alb);
         
         		a26alb = $(xml).find('a26albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a26albTxt").html(a26alb);
         
         		a27alb = $(xml).find('a27albTxt').text();
         		sym.getSymbol("album_sheet_move").getSymbol("albums_sheet_sym").$("a27albTxt").html(a27alb);
         
         		photo_01_cap = $(xml).find('photo_01_capTxt').text();
         		sym.getSymbol("photo_gallery_move").$("photo_01_capTxt").html(photo_01_cap);
         
         		photo_02_cap = $(xml).find('photo_02_capTxt').text();
         		sym.getSymbol("photo_gallery_move").$("photo_02_capTxt").html(photo_02_cap);
         
         		photo_03_cap = $(xml).find('photo_03_capTxt').text();
         		sym.getSymbol("photo_gallery_move").$("photo_03_capTxt").html(photo_03_cap);
         
         		photo_04_cap = $(xml).find('photo_04_capTxt').text();
         		sym.getSymbol("photo_gallery_move").$("photo_04_capTxt").html(photo_04_cap);
         
         		photo_05_cap = $(xml).find('photo_05_capTxt').text();
         		sym.getSymbol("photo_gallery_move").$("photo_05_capTxt").html(photo_05_cap);
         
         		photo_06_cap = $(xml).find('photo_06_capTxt').text();
         		sym.getSymbol("photo_gallery_move").$("photo_06_capTxt").html(photo_06_cap);
         
         		taylor_d_cap = $(xml).find('taylor_d_capTxt').text();
         		sym.getSymbol("bubbles_move").getSymbol("bubble_taylor_d").$("taylor_d_capTxt").html(taylor_d_cap);
         
         		chapman_cap = $(xml).find('chapman_capTxt').text();
         		sym.getSymbol("bubbles_move").getSymbol("bubble_chapman").$("chapman_capTxt").html(chapman_cap);
         
         		stewart_cap = $(xml).find('stewart_capTxt').text();
         		sym.getSymbol("bubbles_move").getSymbol("bubble_stewart").$("stewart_capTxt").html(stewart_cap);
         
         		jones_cap = $(xml).find('jones_capTxt').text();
         		sym.getSymbol("bubbles_move").getSymbol("bubble_jones").$("jones_capTxt").html(jones_cap);
         
         		taylor_m_cap = $(xml).find('taylor_m_capTxt').text();
         		sym.getSymbol("bubbles_move").getSymbol("bubble_taylor_m").$("taylor_m_capTxt").html(taylor_m_cap);
         
         		wyman_cap = $(xml).find('wyman_capTxt').text();
         		sym.getSymbol("bubbles_move").getSymbol("bubble_wyman").$("wyman_capTxt").html(wyman_cap);
         
          }
         
         	});
         
         
         
         // INSERT AUDIO 
         var trac = $("<audio id='track1'>" +
            "<source src='media/stones_medley.mp3' type='audio/mp3' />" +
            "<source src='media/stones_medley.ogg' type='audio/ogg' />" +
            "This browser is not compatible with HTML 5" +
         "</audio>");
         sym.$("audio_button_sym").append(trac);
         trac.attr('preload','auto');
         
         
         
         
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Stage}", "mousemove", function(sym, e) {
         
         // check if being dragged
         //get the value of a Symbol variable
         
         var dragged = sym.getVariable("thumbDragged");
         
         if(dragged) {
         
         	// get thumb values
         
         	var thumbWidth = parseFloat( sym.$("slider_button_sym").css("width") );
         
         	// get track values
         
         	var leftMargin  = parseFloat( sym.$("slider_slot").css("left") ) + 2;
         	var trackWidth  = parseFloat( sym.$("slider_slot").css("width") );
         	var rightMargin = parseFloat( leftMargin + trackWidth ); 
         
         	//get the value of a Symbol variable
         
         	var symbolName01 = sym.getVariable("symbolName01");
         	var symbolName02 = sym.getVariable("symbolName02");
         	var symbolName03 = sym.getVariable("symbolName03");
         	var symbolName04 = sym.getVariable("symbolName04");
         
         	if(e.pageX >= leftMargin &&
         		e.pageX <= rightMargin &&
         		symbolName) {
         		// get the new position of the thumb
         
         		var newPos = e.pageX-thumbWidth/2;
         
         		// move the thumb
         
         		sym.$("slider_button_sym").css("left", newPos);
         		sym.$("slider_button_shadow").css("left", newPos - 36);
         
         		// calculate percentage of rail
         
         		var percent = (e.pageX-leftMargin) / trackWidth;
         
         		// grab hold of three movies
         		// Lookup the Edge Animate Symbol Javascript Object from an element that is
         		// an instance of a symbol. The symbol object can be used to invoke
         		// symbol functions like play, stop etc.
         
         		var album_sheet_move = sym.getSymbol(symbolName01);
         		var photo_gallery_move = sym.getSymbol(symbolName02);
         		var bubbles_move = sym.getSymbol(symbolName03);
         		var aged_edges_fader = sym.getSymbol(symbolName04);
         
         		// get the symbol duration
         
         		var duration01 = album_sheet_move.getDuration();
         		var duration02 = photo_gallery_move.getDuration();
         		var duration03 = bubbles_move.getDuration();
         		var duration04 = aged_edges_fader.getDuration();
         
         		// move the arrow playhead
         
         		album_sheet_move.stop(duration01 * percent);
         		photo_gallery_move.stop(duration02 * percent);
         		bubbles_move.stop(duration03 * percent);
         		aged_edges_fader.stop(duration04 * percent);
         
         	}
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //set the value of a Symbol variable
         
         sym.setVariable("symbolName01", "album_sheet_move");
         
         sym.setVariable("symbolName02", "photo_gallery_move");
         
         sym.setVariable("symbolName03", "bubbles_move");
         
         sym.setVariable("symbolName04", "aged_edges_fader");

      });
      //Edge binding end

      

      

      Symbol.bindElementAction(compId, symbolName, "${_slider_button_sym}", "mousedown", function(sym, e) {
         //set the value of a Symbol variable
         sym.setVariable("thumbDragged", true);
         // add listener to the stage
         sym.$("Stage").bind("mouseup", function() { 
         	//set the value of a Symbol variable
         	sym.setVariable("thumbDragged", false);
         	// unbind the mouseup
         	sym.$("Stage").unbind("mouseup");
         });
         sym.getSymbol("slider_button_sym").$("slider_button_down").show();
         sym.getSymbol("slider_button_sym").$("slider_button_up").hide();
         sym.$("slider_button_pulse").hide();
         e.preventDefault();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_slider_button_sym}", "mouseup", function(sym, e) {
         //set the value of a Symbol variable
         sym.setVariable("thumbDragged", false);
         // unbind the mouseup
         sym.$("Stage").unbind("mouseup");
         
         sym.getSymbol("slider_button_sym").$("slider_button_up").show();
         
         sym.getSymbol("slider_button_sym").$("slider_button_down").hide();
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Stage}", "touchmove", function(sym, e) {
         
         // check if being dragged
         var dragged = sym.getVariable("thumbDragged");
         
         if(dragged) {
         	// get thumb values
         	var thumbWidth = parseFloat( sym.$("slider_button_sym").css("width") );
         
         	// get track values
         	var leftMargin  = parseFloat( sym.$("slider_slot").css("left") ) + 2;
         	var trackWidth  = parseFloat( sym.$("slider_slot").css("width") );
         	var rightMargin = parseFloat( leftMargin + trackWidth ); 
         
         	//get the value of a Symbol variable
         
         	var symbolName01 = sym.getVariable("symbolName01");
         	var symbolName02 = sym.getVariable("symbolName02");
         	var symbolName03 = sym.getVariable("symbolName03");
         	var symbolName04 = sym.getVariable("symbolName04");
         
         	if(e.pageX >= leftMargin &&
         		e.pageX <= rightMargin &&
         		symbolName) {
         		// get the new position of the thumb
         
         		var newPos = e.pageX-thumbWidth/2;
         
         		// move the thumb
         
         		sym.$("slider_button_sym").css("left", newPos);
         		sym.$("slider_button_shadow").css("left", newPos - 36);
         
         		// calculate percentage of rail
         		var percent = (e.pageX-leftMargin) / trackWidth;
         
         		// grab hold of three movies
         		var album_sheet_move = sym.getSymbol(symbolName01);
         		var photo_gallery_move = sym.getSymbol(symbolName02);
         		var bubbles_move = sym.getSymbol(symbolName03);
         		var aged_edges_fader = sym.getSymbol(symbolName04);
         
         		// get the symbol duration
         		var duration01 = album_sheet_move.getDuration();
         		var duration02 = photo_gallery_move.getDuration();
         		var duration03 = bubbles_move.getDuration();
         		var duration04 = aged_edges_fader.getDuration();
         
         		// move the playhead
         		album_sheet_move.stop(duration01 * percent);
         		photo_gallery_move.stop(duration02 * percent);
         		bubbles_move.stop(duration03 * percent);
         		aged_edges_fader.stop(duration04 * percent);
         
         	}
         }
         

      });
      //Edge binding end

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${_slider_button_sym}", "touchend", function(sym, e) {
         //set the value of a Symbol variable
         
         sym.setVariable("thumbDragged", false);
         
         // unbind the mouseup
         sym.$("Stage").unbind("touchend");
         
         sym.getSymbol("slider_button_sym").$("slider_button_up").show();
         
         sym.getSymbol("slider_button_sym").$("slider_button_down").hide();
         
         
         

      });
      //Edge binding end

      

      

      Symbol.bindElementAction(compId, symbolName, "${_slider_button_sym}", "touchmove", function(sym, e) {
         //set the value of a Symbol variable
         sym.setVariable("thumbDragged", true);
         // add listener to the stage
         sym.$("Stage").bind("touchend", function() { 
         	//set the value of a Symbol variable
         	sym.setVariable("thumbDragged", false);
         	// unbind the mouseup
         	sym.$("Stage").unbind("touchend");
         });
         sym.getSymbol("slider_button_sym").$("slider_button_down").show();
         sym.getSymbol("slider_button_sym").$("slider_button_up").hide();
         sym.$("slider_button_pulse").hide();
         e.preventDefault();
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'timeline_sheet_sym'
   (function(symbolName) {   
   
      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("timeline_sheet_sym");
   //Edge symbol end:'timeline_sheet_sym'

   //=========================================================
   
   //Edge symbol: 'albums_sheet_sym'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("albums_sheet_sym");
   //Edge symbol end:'albums_sheet_sym'

   //=========================================================
   
   //Edge symbol: 'album_sheet_move'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4040, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("album_sheet_move");
   //Edge symbol end:'album_sheet_move'

   //=========================================================
   
   //Edge symbol: 'a1_rolling_stones_sym'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10500, function(sym, e) {
         // play the timeline from the given position (ms or label)
         sym.play(0);

      });
      //Edge binding end

   })("a1_rolling_stones_sym");
   //Edge symbol end:'a1_rolling_stones_sym'

   //=========================================================
   
   //Edge symbol: 'a04_stones_no_2_sym'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         // play the timeline from the given position (ms or label)
         sym.play(0);

      });
      //Edge binding end

   })("a04_stones_no_2_sym");
   //Edge symbol end:'a04_stones_no_2_sym'

   //=========================================================
   
   //Edge symbol: 'a09_between_button_sym'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         // play the timeline from the given position (ms or label)
         sym.play(0);

      });
      //Edge binding end

   })("a09_between_button_sym");
   //Edge symbol end:'a09_between_button_sym'

   //=========================================================
   
   //Edge symbol: 'photo_gallery_sym'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("photo_gallery_move");
   //Edge symbol end:'photo_gallery_move'

   //=========================================================
   
   //Edge symbol: 'slider_button_pulse'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("slider_button_pulse");
   //Edge symbol end:'slider_button_pulse'

   //=========================================================
   
   //Edge symbol: 'slider_button_glow_radial_sym'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("slider_button_glow_radial_sym");
   //Edge symbol end:'slider_button_glow_radial_sym'

   //=========================================================
   
   //Edge symbol: 'slider_button_sym'
   (function(symbolName) {   
   
   })("slider_button_sym");
   //Edge symbol end:'slider_button_sym'

   //=========================================================
   
   //Edge symbol: 'picture_01'
   (function(symbolName) {   
   
   })("photo_01");
   //Edge symbol end:'photo_01'

   //=========================================================
   
   //Edge symbol: 'photo_1'
   (function(symbolName) {   
   
      })("photo_02");
   //Edge symbol end:'photo_02'

   //=========================================================
   
   //Edge symbol: 'photo_1'
   (function(symbolName) {   
   
      })("photo_03");
   //Edge symbol end:'photo_03'

   //=========================================================
   
   //Edge symbol: 'photo_1'
   (function(symbolName) {   
   
      })("photo_04");
   //Edge symbol end:'photo_04'

   //=========================================================
   
   //Edge symbol: 'photo_1'
   (function(symbolName) {   
   
      })("photo_05");
   //Edge symbol end:'photo_05'

   //=========================================================
   
   //Edge symbol: 'photo_1'
   (function(symbolName) {   
   
      })("photo_06");
   //Edge symbol end:'photo_06'

   //=========================================================
   
   //Edge symbol: 'taylor_d_bubble'
   (function(symbolName) {   
   
   })("bubble_taylor_d");
   //Edge symbol end:'bubble_taylor_d'

   //=========================================================
   
   //Edge symbol: 'buubles_move'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5298, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("bubbles_move");
   //Edge symbol end:'bubbles_move'

   //=========================================================
   
   //Edge symbol: 'taylor_d_bubble_1'
   (function(symbolName) {   
   
   })("bubble_chapman");
   //Edge symbol end:'bubble_chapman'

   //=========================================================
   
   //Edge symbol: 'bubble_chapman_1'
   (function(symbolName) {   
   
   })("bubble_stewart");
   //Edge symbol end:'bubble_stewart'

   //=========================================================
   
   //Edge symbol: 'bubble_stewart_1'
   (function(symbolName) {   
   
   })("bubble_jones");
   //Edge symbol end:'bubble_jones'

   //=========================================================
   
   //Edge symbol: 'bubble_jones_1'
   (function(symbolName) {   
   
   })("bubble_taylor_m");
   //Edge symbol end:'bubble_taylor_m'

   //=========================================================
   
   //Edge symbol: 'bubble_wyman'
   (function(symbolName) {   
   
   })("bubble_wyman");
   //Edge symbol end:'bubble_wyman'

   //=========================================================
   
   //Edge symbol: 'n01'
   (function(symbolName) {   
   
   })("n01");
   //Edge symbol end:'n01'

   //=========================================================
   
   //Edge symbol: 'n01_1'
   (function(symbolName) {   
   
   })("n02");
   //Edge symbol end:'n02'

   //=========================================================
   
   //Edge symbol: 'n02_1'
   (function(symbolName) {   
   
   })("n03");
   //Edge symbol end:'n03'

   //=========================================================
   
   //Edge symbol: 'n03_1'
   (function(symbolName) {   
   
   })("n04");
   //Edge symbol end:'n04'

   //=========================================================
   
   //Edge symbol: 'n04_1'
   (function(symbolName) {   
   
   })("n05");
   //Edge symbol end:'n05'

   //=========================================================
   
   //Edge symbol: 'n05_1'
   (function(symbolName) {   
   
   })("n06");
   //Edge symbol end:'n06'

   //=========================================================
   
   //Edge symbol: 'n06_1'
   (function(symbolName) {   
   
   })("n07");
   //Edge symbol end:'n07'

   //=========================================================
   
   //Edge symbol: 'n07_1'
   (function(symbolName) {   
   
   })("n08");
   //Edge symbol end:'n08'

   //=========================================================
   
   //Edge symbol: 'n08_1'
   (function(symbolName) {   
   
   })("n09");
   //Edge symbol end:'n09'

   //=========================================================
   
   //Edge symbol: 'n09_1'
   (function(symbolName) {   
   
   })("n10");
   //Edge symbol end:'n10'

   //=========================================================
   
   //Edge symbol: 'n10_1'
   (function(symbolName) {   
   
   })("n11");
   //Edge symbol end:'n11'

   //=========================================================
   
   //Edge symbol: 'n11_1'
   (function(symbolName) {   
   
   })("n12");
   //Edge symbol end:'n12'

   //=========================================================
   
   //Edge symbol: 'n12_1'
   (function(symbolName) {   
   
   })("n13");
   //Edge symbol end:'n13'

   //=========================================================
   
   //Edge symbol: 'n13_1'
   (function(symbolName) {   
   
   })("n14");
   //Edge symbol end:'n14'

   //=========================================================
   
   //Edge symbol: 'n14_1'
   (function(symbolName) {   
   
   })("n15");
   //Edge symbol end:'n15'

   //=========================================================
   
   //Edge symbol: 'n15_1'
   (function(symbolName) {   
   
   })("n16");
   //Edge symbol end:'n16'

   //=========================================================
   
   //Edge symbol: 'n16_1'
   (function(symbolName) {   
   
   })("n17");
   //Edge symbol end:'n17'

   //=========================================================
   
   //Edge symbol: 'n17_1'
   (function(symbolName) {   
   
   })("n18");
   //Edge symbol end:'n18'

   //=========================================================
   
   //Edge symbol: 'n18_1'
   (function(symbolName) {   
   
   })("n19");
   //Edge symbol end:'n19'

   //=========================================================
   
   //Edge symbol: 'n19_1'
   (function(symbolName) {   
   
   })("n20");
   //Edge symbol end:'n20'

   //=========================================================
   
   //Edge symbol: 'n20_1'
   (function(symbolName) {   
   
   })("n21");
   //Edge symbol end:'n21'

   //=========================================================
   
   //Edge symbol: 'n21_1'
   (function(symbolName) {   
   
   })("n22");
   //Edge symbol end:'n22'

   //=========================================================
   
   //Edge symbol: 'n22_1'
   (function(symbolName) {   
   
   })("n23");
   //Edge symbol end:'n23'

   //=========================================================
   
   //Edge symbol: 'n23_1'
   (function(symbolName) {   
   
   })("n24");
   //Edge symbol end:'n24'

   //=========================================================
   
   //Edge symbol: 'n24_1'
   (function(symbolName) {   
   
   })("n25");
   //Edge symbol end:'n25'

   //=========================================================
   
   //Edge symbol: 'n25_1'
   (function(symbolName) {   
   
   })("n26");
   //Edge symbol end:'n26'

   //=========================================================
   
   //Edge symbol: 'n26_1'
   (function(symbolName) {   
   
   })("n27");
   //Edge symbol end:'n27'

   //=========================================================
   
   //Edge symbol: 'aged_edges_fader'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("aged_edges_fader");
   //Edge symbol end:'aged_edges_fader'

   //=========================================================
   
   //Edge symbol: 'audio_button_sym'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_off_to_on_button}", "click", function(sym, e) {
          sym.play("off");
          document.getElementById('track1').play();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_on_to_off_button}", "click", function(sym, e) {
         // play the timeline from the given position (ms or label)
         sym.play("off");
         document.getElementById('track1').pause();
         

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41000, function(sym, e) {
         // play the timeline from the given position (ms or label)
         sym.play(0);

      });
      //Edge binding end

   })("audio_button_sym");
   //Edge symbol end:'audio_button_sym'

   //=========================================================
   
   //Edge symbol: 'sonic_boom_sym'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         // play the timeline from the given position (ms or label)
         sym.play(0);

      });
      //Edge binding end

   })("sonic_boom_sym");
   //Edge symbol end:'sonic_boom_sym'

})(jQuery, AdobeEdge, "GraphicNews29965");