/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
                  var headline;
                  var headlinetxt = sym.$("headlineTxt").css("pointer-events","none");
                  var source;
                  var sourcetxt = sym.$("sourceTxt").css("pointer-events","none");
                  
                  var cap1;
                  var cap1txt = sym.$("cap1Txt").css("pointer-events","none");
                  var cap2;
                  var cap2txt = sym.$("cap2Txt").css("pointer-events","none");         
                  var key0;
                  var key0txt = sym.$("key0Txt").css("pointer-events","none");
                  var key1;
                  var key1txt = sym.$("key1Txt").css("pointer-events","none");
                  var key2;
                  var key2txt = sym.$("key2Txt").css("pointer-events","none");
                  var key3;
                  var key3txt = sym.$("key3Txt").css("pointer-events","none");
                  var key4;
                  var key4txt = sym.$("key4Txt").css("pointer-events","none");
                  var menu0;
                  var menu0txt = sym.$("menuTxt0").css("pointer-events","none");
                  var menu1;
                  var menu1txt = sym.$("menuTxt1").css("pointer-events","none");
                  var map0;
                  var maptxt = sym.$("mapTxt").css("pointer-events","none");
                  var map1;
                  var map1txt = sym.$("map1Txt").css("pointer-events","none");
                  var map2;
                  var map2txt = sym.$("map2Txt").css("pointer-events","none");
                  
                  var strap0;
                  var strap0txt = sym.getSymbol("systems").$("strap0Txt").css("pointer-events","none");
                  var strap1;
                  var strap1txt = sym.getSymbol("systems").$("strap1Txt").css("pointer-events","none");
                  var strap2;
                  var strap2txt = sym.getSymbol("systems").$("strap2Txt").css("pointer-events","none");
                  var strap3;
                  var strap3txt = sym.getSymbol("systems").$("strap3Txt").css("pointer-events","none");
                  
                  var ballot1;
                  var ballot1txt = sym.getSymbol("systems").$("ballot1Txt").css("pointer-events","none");
                  var ballot2;
                  var ballot2txt = sym.getSymbol("systems").$("ballot2Txt").css("pointer-events","none");
                  var ballot3;
                  var ballot3txt = sym.getSymbol("systems").$("ballot3Txt").css("pointer-events","none");
                  var ballot4;
                  var ballot4txt = sym.getSymbol("systems").getSymbol("optical").$("ballot4Txt").css("pointer-events","none");
                  var over0;
                  var over0txt = sym.getSymbol("systems").$("overTxt0").css("pointer-events","none");
                  var over1;
                  var over1txt = sym.getSymbol("systems").$("overTxt1").css("pointer-events","none");
                  var over2;
                  var over2txt = sym.getSymbol("systems").$("overTxt2").css("pointer-events","none");
                  var over3;
                  var over3txt = sym.getSymbol("systems").$("overTxt3").css("pointer-events","none");
                  
                    //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
                    $.ajax({	
                  	type: "GET",
                  	url: "GN29879.xml",
                  	dataType: "xml",
                  	success: function(xml) {
         			headline = $(xml).find('headline').text();
                  		headlinetxt.html(headline);
                  		source = $(xml).find('source').text();
                  		sourcetxt.html(source);
                  		cap1 = $(xml).find('cap1').text();
                  		cap1txt.html(cap1);
                  		cap2 = $(xml).find('cap2').text();
                  		cap2txt.html(cap2);
                  		key0 = $(xml).find('key0').text();
                  		key0txt.html(key0);
                  		key1 = $(xml).find('key1').text();
                  		key1txt.html(key1);
                  		key2 = $(xml).find('key2').text();
                  		key2txt.html(key2);
                  		key3 = $(xml).find('key3').text();
                  		key3txt.html(key3);
                  		key4 = $(xml).find('key4').text();
                  		key4txt.html(key4);
                  		menu0 = $(xml).find('menu0').text();
                  		menu0txt.html(menu0);
                  		menu1 = $(xml).find('menu1').text();
                  		menu1txt.html(menu1);
                  		map0 = $(xml).find('map0').text();
                  		maptxt.html(map0);
                  		map1 = $(xml).find('map1').text();
                  		map1txt.html(map1);
                  		map2 = $(xml).find('map2').text();
                  		map2txt.html(map2);
                  		strap0 = $(xml).find('strap0').text();
                  		strap0txt.html(strap0);
                  		strap1 = $(xml).find('strap1').text();
                  		strap1txt.html(strap1);
                  		strap2 = $(xml).find('strap2').text();
                  		strap2txt.html(strap2);
                  		strap3 = $(xml).find('strap3').text();
                  		strap3txt.html(strap3);
         
                  		ballot1 = $(xml).find('ballot1').text();
                  		ballot1txt.html(ballot1);
                  		ballot2 = $(xml).find('ballot2').text();
                  		ballot2txt.html(ballot2);
                  		ballot3 = $(xml).find('ballot3').text();
                  		ballot3txt.html(ballot3);
                  		ballot4 = $(xml).find('ballot4').text();
                  		ballot4txt.html(ballot4);
         
                  		over0 = $(xml).find('over0').text();
                  		over0txt.html(over0);
                  		over1 = $(xml).find('over1').text();
                  		over1txt.html(over1);
                  		over2 = $(xml).find('over2').text();
                  		over2txt.html(over2);
                  		over3 = $(xml).find('over3').text();
                  		over3txt.html(over3);
                  		}
                  	}); // END XML
         // STOP ELEMENTS INTERACTING WITH MOUSE
         	sym.$("hand").css("pointer-events","none");
         
         // MAKE ELEMENTS INVISIBLE
         	sym.$("hand").animate({opacity: 0}, 0);
         // MOVE HAND
         	sym.$("hand").delay(500).animate ({opacity:1, left:34, top:350}, 1000);
         	sym.$("hand").delay(200).animate ({left:700, top:450}, 1000);
         	sym.$("hand").delay(200).animate ({left:771, top:17}, 1000);         	
         
                  menuArray = [];
         
                  for (var m = 0; m < 2; m++){
                  	 var menuBtnSymbols = sym.getSymbol("menuBtn" +m);
         
                  	 menuBtnSymbols.setVariable("menuId", m);
                  	 menuArray.push(menuBtnSymbols);
                  }
         
                  //a 'for each' loop through the newly populated array.
                  $.each(menuArray, function( count, btnInTheArray ){
                  	 var menuBtnItem = $(btnInTheArray);
                  	 var menuBtnElement = btnInTheArray.getSymbolElement();
                  	 menuBtnElement.bind ("click", {menuId:count}, menuBtnClick);
                  	 menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
                  	 menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
                  	}
                  );
         
                  function resetMenu (){
         		for (var m=0; m<menuArray.length; m++){ //showhide Navigation text
         			var menu_arr = ["menuTxt0","menuTxt1"];
         			$.each(menu_arr, function(index, value) {
         			sym.$(value).css('opacity', '0');
         			});
                  	menuArray[m].$("menuBtnOverClick").animate ({opacity: 0}, 0);
                  	menuArray[m].$("menuBtnOver").animate ({opacity: 1}, 0);
                  	menuArray[m].$("menuBtnOver").css ("box-shadow","3px 3px 3px rgba(100,100,100,0.5)");
         
         		}
                  }
         	resetMenu();
         
         	sym.getSymbol("menuBtn0").$("menuBtnOverClick"). animate ({opacity: 1}, 0); // Make button 0 visible
            sym.getSymbol("menuBtn0").$("menuBtnOver").animate ({opacity: 0}, 0); // Drop shadow
            sym.getSymbol("menuBtn0").$("menuBtnOver").css ("box-shadow","3px 3px 3px rgba(100,100,100,0)"); // Drop shadow
         
                 function menuBtnClick (e){
         
                  	resetMenu(); //set them all back to normal state
                  	var selectedMenu_id = (e.data.menuId); //get the id of the clicked item
                  	sym.getSymbol("menuBtn"+ selectedMenu_id).$("menuBtnOverClick"). animate ({opacity: 1}, 0);
                  	sym.$("menuTxt"+ selectedMenu_id). animate ({opacity: 1}, 0);
                  	sym.getSymbol("menuBtn"+ selectedMenu_id).$("menuBtnOver").animate ({opacity: 0}, 0);
                  	sym.getSymbol("menuBtn"+ selectedMenu_id).$("menuBtnOver").css ("box-shadow","3px 3px 3px rgba(100,100,100,0)"); // Drop shadow
         
         
         		if (selectedMenu_id == 0){
         		sym.$("map").hide();
         		sym.$("mapCaps").hide();
         		sym.$("cap2Txt").hide();
         		sym.$("systems").show();
         		}
         		if (selectedMenu_id == 1){
         		sym.$("map").show();
         		sym.$("mapCaps").show();
         		sym.$("cap2Txt").show();
         		sym.$("systems").hide();
         		}
         
                  }
                  function menuShow (e){
                  	var selectedMenu_id = (e.data.menuId); //get the id of the over button
                  	sym.$('hand').hide();
         		//sym.getSymbol("menuBtn" + selectedMenu_id).$("menuBtnOver"). animate ({opacity: 0}, 0);
         		sym.getSymbol("menuBtn" + selectedMenu_id).$("menuBtnOver").css ("box-shadow","3px 3px 3px rgba(100,100,100,0)");
         		sym.$("menuTxt" + selectedMenu_id). animate ({opacity: 1}, 0);
                  }
                  function menuHide (e){
                  	var selectedMenu_id = (e.data.menuId); //get the id of the out button
         		//sym.getSymbol("menuBtn" + selectedMenu_id).$("menuBtnOver"). animate ({opacity: 1}, 0);
         		sym.getSymbol("menuBtn" + selectedMenu_id).$("menuBtnOver").css ("box-shadow","3px 3px 3px rgba(100,100,100,0.5)");
         		sym.$("menuTxt" + selectedMenu_id). animate ({opacity: 0}, 0);
                  }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'optical'
   (function(symbolName) {   
   
      Symbol.bindElementAction(compId, symbolName, "${_optscreen}", "click", function(sym, e) {
         // sym.$("name") resolves an Edge Animate element name to a DOM
         // element that can be used with jQuery
         var screen = sym.$("optscreen");
         screen.hide();

      });
      //Edge binding end

   })("optical");
   //Edge symbol end:'optical'

   //=========================================================
   
   //Edge symbol: 'ballot2'
   (function(symbolName) {   
   
      Symbol.bindElementAction(compId, symbolName, "${_tick0}", "click", function(sym, e) {
         var tick = sym.getSymbol("tick0");
         tick.play();
         var optscan = sym.getParentSymbol("optical");
         optscan.play();
         sym.getParentSymbol("optical").getSymbol("optscreen").$("voteTxt1").html("Obama (DEM)");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_tick1}", "click", function(sym, e) {
         var tick = sym.getSymbol("tick1");
         tick.play();
         var optscan = sym.getParentSymbol("optical");
         optscan.play();
         sym.getParentSymbol("optical").getSymbol("optscreen").$("voteTxt1").html("Romney (REP)");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_tick2}", "click", function(sym, e) {
         var tick = sym.getSymbol("tick2");
         tick.play();
         var optscan = sym.getParentSymbol("optical");
         optscan.play();
         sym.getParentSymbol("optical").getSymbol("optscreen").$("voteTxt1").html("Johnson (LIB)");

      });
      //Edge binding end

   })("ballot2");
   //Edge symbol end:'ballot2'

   //=========================================================
   
   //Edge symbol: 'tick_mc'
   (function(symbolName) {   
   
   })("tick_mc");
   //Edge symbol end:'tick_mc'

   //=========================================================
   
   //Edge symbol: 'systems'
   (function(symbolName) {   
   
      Symbol.bindElementAction(compId, symbolName, "${_alert0}", "click", function(sym, e) {
         // insert code for mouse click here
         // sym.$("name") resolves an Edge Animate element name to a DOM
         // element that can be used with jQuery
         var alert = sym.$("overTxt0");
         alert.show();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert0}", "mouseover", function(sym, e) {
         // insert code to be run when the mouse hovers over the object
         var alert = sym.$("overTxt0");
         alert.show();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert0}", "mouseout", function(sym, e) {
         var alert = sym.$("overTxt0");
         alert.hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert1}", "click", function(sym, e) {
         var alert = sym.$("overTxt1");
         alert.show();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert1}", "mouseover", function(sym, e) {
         var alert = sym.$("overTxt1");
         alert.show();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert1}", "mouseout", function(sym, e) {
         var alert = sym.$("overTxt1");
         alert.hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert2}", "click", function(sym, e) {
         var alert = sym.$("overTxt2");
         alert.show();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert2}", "mouseover", function(sym, e) {
         var alert = sym.$("overTxt2");
         alert.show();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert2}", "mouseout", function(sym, e) {
         var alert = sym.$("overTxt2");
         alert.hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert3}", "click", function(sym, e) {
         var alert = sym.$("overTxt3");
         alert.show();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert3}", "mouseover", function(sym, e) {
         var alert = sym.$("overTxt3");
         alert.show();
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_alert3}", "mouseout", function(sym, e) {
         var alert = sym.$("overTxt3");
         alert.hide();
         
         

      });
      //Edge binding end

   })("votesystems");
   //Edge symbol end:'votesystems'

   //=========================================================
   
   //Edge symbol: 'optscreen'
   (function(symbolName) {   
   
   })("optscreen");
   //Edge symbol end:'optscreen'

   //=========================================================
   
   //Edge symbol: 'scrollwheel'
   (function(symbolName) {   
   
      Symbol.bindElementAction(compId, symbolName, "${_left}", "mousedown", function(sym, e) {
         var evote = sym.getParentSymbol("systems").getSymbol("evote");
         var wheel = sym.getParentSymbol("systems");
         evote.play();
         wheel.playReverse("end");
         e.preventDefault()

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_left}", "mouseup", function(sym, e) {
         var evote = sym.getParentSymbol("systems").getSymbol("evote");
         var wheel = sym.getParentSymbol("systems");
         evote.stop();
         wheel.stop("start");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_right}", "mousedown", function(sym, e) {
         var evote = sym.getParentSymbol("systems").getSymbol("evote");
         var wheel = sym.getParentSymbol("systems");
         evote.playReverse();
         wheel.play("start");
         e.preventDefault()

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_right}", "mouseup", function(sym, e) {
         var evote = sym.getParentSymbol("systems").getSymbol("evote");
         var wheel = sym.getParentSymbol("systems");
         evote.stop();
         wheel.stop("start");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_right}", "touchstart", function(sym, e) {
         var evote = sym.getParentSymbol("systems").getSymbol("evote");
         var wheel = sym.getParentSymbol("systems");
         evote.playReverse();
         wheel.play("start");
         e.preventDefault()

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_right}", "touchend", function(sym, e) {
         var evote = sym.getParentSymbol("systems").getSymbol("evote");
         var wheel = sym.getParentSymbol("systems");
         evote.stop();
         wheel.stop("start");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_left}", "touchend", function(sym, e) {
         var evote = sym.getParentSymbol("systems").getSymbol("evote");
         var wheel = sym.getParentSymbol("systems");
         evote.stop();
         wheel.stop("start");
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_left}", "touchstart", function(sym, e) {
         var evote = sym.getParentSymbol("systems").getSymbol("evote");
         var wheel = sym.getParentSymbol("systems");
         evote.play();
         wheel.playReverse("end");
         e.preventDefault()

      });
      //Edge binding end

   })("scrollwheel");
   //Edge symbol end:'scrollwheel'

   //=========================================================
   
   //Edge symbol: 'evote'
   (function(symbolName) {   
   
      

      

      

      

      

      

      

      

      

      

      

      

   })("evote");
   //Edge symbol end:'evote'

})(jQuery, AdobeEdge, "GraphicNews29879");